﻿---
title: Modules
description: This section contains an overview of the Filebeat modules feature as well as details about each of the currently supported modules. Filebeat modules require...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-modules
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Modules
This section contains an [overview](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-modules-overview) of the Filebeat modules feature as well as details about each of the currently supported modules.
Filebeat modules require Elasticsearch 5.2 or later.
<note>
  While Filebeat modules are still supported, we recommend Elastic Agent integrations over Filebeat modules. Integrations provide a streamlined way to connect data from a variety of vendors to the Elastic Stack. Refer to the [full list of integrations](https://www.elastic.co/integrations/data-integrations). For more information, please refer to the [Beats vs Elastic Agent comparison documentation](https://www.elastic.co/docs/reference/fleet).
</note>

- [*Modules overview*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-modules-overview)
- [*ActiveMQ module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-activemq)
- [*Apache module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-apache)
- [*Auditd module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-auditd)
- [*AWS module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-aws)
- [*AWS Fargate module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-awsfargate) <applies-to>Elastic Stack: Beta</applies-to>
- [*Azure module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-azure)
- [*CEF module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-cef)
- [*Check Point module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-checkpoint)
- [*Cisco module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-cisco)
- [*CoreDNS module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-coredns)
- [*CrowdStrike module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-crowdstrike) <applies-to>Elastic Stack: Beta</applies-to>
- [*Cyberark PAS module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-cyberarkpas)
- [*Elasticsearch module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-elasticsearch)
- [*Envoyproxy module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-envoyproxy)
- [*Fortinet module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-fortinet)
- [*Google Cloud Platform (GCP) module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-gcp)
- [*Google Workspace module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-google_workspace)
- [*HAProxy module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-haproxy)
- [*IBM MQ module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-ibmmq)
- [*Icinga module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-icinga)
- [*IIS module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-iis)
- [*Iptables module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-iptables)
- [*Juniper JUNOS module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-juniper)
- [*Kafka module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-kafka)
- [*Kibana module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-kibana)
- [*Logstash module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-logstash)
- [*Microsoft module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-microsoft)
- [*MISP module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-misp)
- [*MongoDB module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-mongodb)
- [*MSSQL module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-mssql)
- [*MySQL module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-mysql)
- [*MySQL Enterprise module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-mysqlenterprise)
- [*NATS module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-nats) <applies-to>Elastic Stack: Beta</applies-to>
- [*NetFlow module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-netflow)
- [*Nginx module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-nginx)
- [*Office 365 module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-o365)
- [*Okta module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-okta)
- [*Oracle module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-oracle)
- [*Osquery module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-osquery)
- [*Palo Alto Networks module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-panw)
- [*Pensando module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-pensando)
- [*PostgreSQL module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-postgresql)
- [*RabbitMQ module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-rabbitmq)
- [*Redis module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-redis)
- [*Salesforce module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-salesforce)
- [*Google Santa module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-santa)
- [*Snyk module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-snyk)
- [*Sophos module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-sophos)
- [*Suricata module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-suricata)
- [*System module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-system)
- [*Threat Intel module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-threatintel)
- [*Traefik module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-traefik)
- [*Zeek (Bro) module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-zeek)
- [*ZooKeeper module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-zookeeper) <applies-to>Elastic Stack: Beta</applies-to>
- [*Zoom module*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-zoom)