﻿---
title: Modules
description: Filebeat modules simplify the collection, parsing, and visualization of common log formats. A typical module (say, for the Nginx logs) is composed of...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-modules-overview
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Modules
Filebeat modules simplify the collection, parsing, and visualization of common log formats.
A typical module (say, for the Nginx logs) is composed of one or more filesets (in the case of Nginx, `access` and `error`). A fileset contains the following:
- Filebeat input configurations, which contain the default paths where to look for the log files. These default paths depend on the operating system. The Filebeat configuration is also responsible with stitching together multiline events when needed.
- Elasticsearch [ingest pipeline](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines) definition, which is used to parse the log lines.
- Fields definitions, which are used to configure Elasticsearch with the correct types for each field. They also contain short descriptions for each of the fields.
- Sample Kibana dashboards, when available, that can be used to visualize the log files.

Filebeat automatically adjusts these configurations based on your environment and loads them to the respective Elastic Stack components.
If a module configuration is updated, the Elasticsearch ingest pipeline definition is not reloaded automatically. To reload the ingest pipeline, set `filebeat.overwrite_pipelines: true` and manually [load the ingest pipelines](https://www.elastic.co/docs/reference/beats/filebeat/load-ingest-pipelines).

## Get started

To learn how to configure and run Filebeat modules:
- Get started by reading [Quick start: installation and configuration](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration).
- Dive into the documentation for each [module](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-modules).