﻿---
title: Suricata module
description: This is a module to the Suricata IDS/IPS/NSM log. It parses logs that are in the  Suricata Eve JSON format. When you run the module, it performs a few...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-suricata
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Suricata module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/suricata).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

This is a module to the Suricata IDS/IPS/NSM log. It parses logs that are in the [ Suricata Eve JSON format](https://suricata.readthedocs.io/en/latest/output/eve/eve-json-format.html).
When you run the module, it performs a few tasks under the hood:
- Sets the default paths to the log files (but don’t worry, you can override the defaults)
- Makes sure each multiline log event gets sent as a single event
- Uses an Elasticsearch ingest pipeline to parse and process the log lines, shaping the data into a structure suitable for visualizing in Kibana
- Deploys dashboards for visualizing the log data

<tip>
  Read the [quick start](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration) to learn how to configure and run modules.
</tip>


## Compatibility

This module has been developed against Suricata v4.0.4, but is expected to work with other versions of Suricata.

## Configure the module

You can further refine the behavior of the `suricata` module by specifying [variable settings](#suricata-settings) in the `modules.d/suricata.yml` file, or overriding settings at the command line.
You must enable at least one fileset in the module. **Filesets are disabled by default.**
This is an example of how to overwrite the default log file path.
```yaml
- module: suricata
  eve:
    enabled: true
    var.paths: ["/my/path/suricata.json"]
```


### Variable settings

Each fileset has separate variable settings for configuring the behavior of the module. If you don’t specify variable settings, the `suricata` module uses the defaults.
For advanced use cases, you can also override input settings. See [Override input settings](https://www.elastic.co/docs/reference/beats/filebeat/advanced-settings).
<tip>
  When you specify a setting at the command line, remember to prefix the setting with the module name, for example, `suricata.eve.var.paths` instead of `eve.var.paths`.
</tip>


### `eve` log fileset settings

<definitions>
  <definition term="var.paths">
    An array of glob-based paths that specify where to look for the log files. All patterns supported by [Go Glob](https://golang.org/pkg/path/filepath/#Glob) are also supported here. For example, you can use wildcards to fetch all files from a predefined level of subdirectories: `/path/to/log/*/*.log`. This fetches all `.log` files from the subfolders of `/path/to/log`. It does not fetch log files from the `/path/to/log` folder itself. If this setting is left empty, Filebeat will choose log paths based on your operating system.
  </definition>
  <definition term="var.tags">
    A list of tags to include in events. Including `forwarded` indicates that the events did not originate on this host and causes `host.name` to not be added to events. Defaults to `[suricata]`.
  </definition>
  <definition term="var.internal_networks">
    A list of CIDR ranges describing the IP addresses that you consider internal. This is used in determining the value of `network.direction`. The values can be either a CIDR value or one of the named ranges supported by the [`network`](/docs/reference/beats/filebeat/defining-processors#condition-network) condition. The default value is `[private]` which classifies RFC 1918 (IPv4) and RFC 4193 (IPv6) addresses as internal.
  </definition>
</definitions>


## Example dashboard

This module comes with sample dashboards. For example:
![filebeat suricata events](https://www.elastic.co/docs/reference/beats/filebeat/images/filebeat-suricata-events.png)
![filebeat suricata alerts](https://www.elastic.co/docs/reference/beats/filebeat/images/filebeat-suricata-alerts.png)

## Fields

For a description of each field in the module, see the [exported fields](https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-suricata) section.