﻿---
title: Snyk module
description: This is a module for ingesting data from the different Snyk API Endpoints. Currently supports these filesets: vulnerabilities fileset: Collects all found...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-snyk
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Snyk module
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

This is a module for ingesting data from the different Snyk API Endpoints. Currently supports these filesets:
- `vulnerabilities` fileset: Collects all found vulnerabilities for the related organizations and projects
- `audit` fileset: Collects audit logging from Snyk, this can be actions like users, permissions, groups, api access and more.

When you run the module, it performs a few tasks under the hood:
- Sets the default paths to the log files (but don’t worry, you can override the defaults)
- Makes sure each multiline log event gets sent as a single event
- Uses an Elasticsearch ingest pipeline to parse and process the log lines, shaping the data into a structure suitable for visualizing in Kibana

<tip>
  Read the [quick start](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration) to learn how to configure and run modules.
</tip>


## Configure the module

You can further refine the behavior of the `snyk` module by specifying [variable settings](#snyk-settings) in the `modules.d/snyk.yml` file, or overriding settings at the command line.
You must enable at least one fileset in the module. **Filesets are disabled by default.**

### Variable settings

Each fileset has separate variable settings for configuring the behavior of the module. If you don’t specify variable settings, the `snyk` module uses the defaults.
For advanced use cases, you can also override input settings. See [Override input settings](https://www.elastic.co/docs/reference/beats/filebeat/advanced-settings).
<tip>
  When you specify a setting at the command line, remember to prefix the setting with the module name, for example, `snyk.audit.var.paths` instead of `audit.var.paths`.
</tip>


### `audit` fileset settings

<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

To configure access for Filebeat to the Snyk Audit Log API you will have to generate an API access token as described in the [Snyk Documentation](https://snyk.docs.apiary.io/#introduction/authorization)
Example config:
```yaml
- module: snyk
  audit:
    var.input: httpjson
    var.audit_type: organization
    var.audit_id: 1235432-asdfdf-2341234-asdgjhg
    var.interval: 1h
    var.api_token: 53453Sddf8-7fsf-414234gfd-9sdfb7-5asdfh9f8e342
```

There is also multiple optional configuration options that can be used to filter out unwanted content, an example below:
```yaml
- module: snyk
  audit:
    var.input: httpjson
    var.audit_type: organization
    var.audit_id: 1235432-asdfdf-2341234-asdgjhg
    var.interval: 1h
    var.api_token: 53453Sddf8-7fsf-414234gfd-9sdfb7-5asdfh9f8e342
    var.email_address: "test@example.com"
```

<definitions>
  <definition term="var.paths">
    An array of glob-based paths that specify where to look for the log files. All patterns supported by [Go Glob](https://golang.org/pkg/path/filepath/#Glob) are also supported here. For example, you can use wildcards to fetch all files from a predefined level of subdirectories: `/path/to/log/*/*.log`. This fetches all `.log` files from the subfolders of `/path/to/log`. It does not fetch log files from the `/path/to/log` folder itself. If this setting is left empty, Filebeat will choose log paths based on your operating system.
  </definition>
  <definition term="var.first_interval">
    How far to look back the first time the module starts, this supports values in full days (24h, 48h etc).
  </definition>
  <definition term="var.audit_type">
    What audit type to collect, can be either "group" or "organization".
  </definition>
  <definition term="var.audit_id">
    The ID related to the audit_type. If audit type is group, then this value should be the group ID, or if it is organization it should be the organization ID to collect from.
  </definition>
  <definition term="var.api_token">
    The API token that is created for a specific user, found in the Snyk management dashboard.
  </definition>
  <definition term="var.project_id">
    Optional field for filtering, will return only logs for this specific project.
  </definition>
  <definition term="var.user_id">
    Optional field for filtering, user public ID. Will fetch only audit logs originated from this user’s actions.
  </definition>
  <definition term="var.event">
    Optional field for filtering, will return only logs for this specific event.
  </definition>
  <definition term="var.email_address">
    Optional field for filtering, User email address. Will fetch only audit logs originated from this user’s actions.
  </definition>
</definitions>


### Snyk Audit Log ECS Fields

This is a list of Snyk Audit Log fields that are mapped to ECS.

| Snyk Audit log fields | ECS Fields    |
|-----------------------|---------------|
| groupId               | user.group.id |
| userId                | user.id       |
| event                 | event.action  |
| created               | @timestamp    |


### `vulnerabilities` fileset settings

<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

To configure access for Filebeat to the Snyk Vulnerabilities API you will have to generate an API access token as described in the [Snyk Documentation](https://snyk.docs.apiary.io/#introduction/authorization)
Example config:
```yaml
- module: snyk
  vulnerabilities:
    var.input: httpjson
    var.interval: 24h
    var.api_token: 53453Sddf8-7fsf-414234gfd-9sdfb7-5asdfh9f8e342
    var.orgs:
      - 12354-asdfdf-123543-asdsdfg
      - 76554-jhggfd-654342-hgrfasd
```

There is also multiple optional configuration options that can be used to filter out unwanted content, an example below:
```yaml
- module: snyk
  vulnerabilities:
    var.input: httpjson
    var.interval: 24h
    var.api_token: 53453Sddf8-7fsf-414234gfd-9sdfb7-5asdfh9f8e342
    var.orgs:
      - 12354-asdfdf-123543-asdsdfg
      - 76554-jhggfd-654342-hgrfasd
    var.included_severity:
      - medium
      - high
    var.types:
      - vuln
```

<definitions>
  <definition term="var.paths">
    An array of glob-based paths that specify where to look for the log files. All patterns supported by [Go Glob](https://golang.org/pkg/path/filepath/#Glob) are also supported here. For example, you can use wildcards to fetch all files from a predefined level of subdirectories: `/path/to/log/*/*.log`. This fetches all `.log` files from the subfolders of `/path/to/log`. It does not fetch log files from the `/path/to/log` folder itself. If this setting is left empty, Filebeat will choose log paths based on your operating system.
  </definition>
  <definition term="var.first_interval">
    How far to look back the first time the module starts, this supports values in full days (24h, 48h etc).
  </definition>
  <definition term="var.api_token">
    The API token that is created for a specific user, found in the Snyk management dashboard.
  </definition>
  <definition term="var.orgs">
    The list of org IDs to filter the results by. One organization ID per line, starting with a - sign
  </definition>
  <definition term="var.included_severity">
    Optional list of fields for filtering, the severity levels of issues to filter the results by.
  </definition>
  <definition term="var.exploit_maturit">
    Optional list of fields for filtering, the exploit maturity levels of issues to filter the results by.
  </definition>
  <definition term="var.types">
    Optional list of fields for filtering, the type of issues to filter the results by.
  </definition>
  <definition term="var.languages">
    Optional list of fields for filtering, the type of languages to filter the results by.
  </definition>
  <definition term="var.identifier">
    Optional field for filtering, search term to filter issue name by, or an exact CVE or CWE.
  </definition>
  <definition term="var.ignored">
    Optional field for filtering, If set to true, only include issues which are ignored, if set to false, only include issues which are not ignored.
  </definition>
  <definition term="var.patched">
    Optional field for filtering, If set to true, only include issues which are ignored, if set to false, only include issues which are not ignored.
  </definition>
  <definition term="var.fixable">
    Optional field for filtering, If set to true, only include issues which are ignored, if set to false, only include issues which are not ignored.
  </definition>
  <definition term="var.is_fixed">
    Optional field for filtering, If set to true, only include issues which are ignored, if set to false, only include issues which are not ignored.
  </definition>
  <definition term="var.is_patchable">
    Optional field for filtering, If set to true, only include issues which are ignored, if set to false, only include issues which are not ignored.
  </definition>
  <definition term="var.is_pinnable">
    Optional field for filtering, If set to true, only include issues which are ignored, if set to false, only include issues which are not ignored.
  </definition>
  <definition term="var.min_priority_score">
    Optional field for filtering, The minimum priority score ranging between 0-1000
  </definition>
  <definition term="var.max_priority_score">
    Optional field for filtering, The maximum priority score ranging between 0-1000
  </definition>
</definitions>


### Snyk Audit Log ECS Fields

This is a list of Snyk Vulnerability fields that are mapped to ECS.

| Snyk Fields                   | ECS Fields                |
|-------------------------------|---------------------------|
| issue.description             | vulnerability.description |
| issue.identifiers.CVE         | vulnerability.id          |
| issue.identifiers.ALTERNATIVE | vulnerability.id          |
| issue.cvssScore               | vulnerability.score.base  |
| issue.severity                | vulnerability.severity    |
| issue.url                     | vulnerability.reference   |


## Fields

For a description of each field in the module, see the [exported fields](https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-snyk) section.