﻿---
title: Office 365 module
description: This is a module for Office 365 logs received via one of the Office 365 API endpoints. It currently supports user, admin, system, and policy actions and...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-o365
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Office 365 module
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

<warning>
  This module is not available in FIPS-capable Filebeat.
</warning>

<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/o365).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

This is a module for Office 365 logs received via one of the Office 365 API endpoints. It currently supports user, admin, system, and policy actions and events from Office 365 and Azure AD activity logs exposed by the Office 365 Management Activity API.
The [ingest-geoip](https://www.elastic.co/docs/reference/enrich-processor/geoip-processor) and [ingest-user_agent](https://www.elastic.co/docs/reference/enrich-processor/user-agent-processor) Elasticsearch plugins are required to run this module.
<tip>
  Read the [quick start](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration) to learn how to configure and run modules.
</tip>


## Configure the module

You can further refine the behavior of the `o365` module by specifying [variable settings](#o365-settings) in the `modules.d/o365.yml` file, or overriding settings at the command line.
You must enable at least one fileset in the module. **Filesets are disabled by default.**

### Variable settings

Each fileset has separate variable settings for configuring the behavior of the module. If you don’t specify variable settings, the `o365` module uses the defaults.
For advanced use cases, you can also override input settings. See [Override input settings](https://www.elastic.co/docs/reference/beats/filebeat/advanced-settings).
<tip>
  When you specify a setting at the command line, remember to prefix the setting with the module name, for example, `o365.audit.var.paths` instead of `audit.var.paths`.
</tip>


### `audit` fileset settings

The `audit` fileset uses the Office 365 Management Activity API to retrieve audit messages from Office 365 and Azure AD activity logs. These are the same logs that are available under *Audit* *Log* *Search* in the *Security* *and* *Compliance* *Center.*

#### Setup

To use this fileset you need to [enable Audit Log Search](https://docs.microsoft.com/en-us/microsoft-365/compliance/turn-audit-log-search-on-or-off?view=o365-worldwide#turn-on-audit-log-search) and [register an application in Azure AD.](https://docs.microsoft.com/en-us/office/office-365-management-api/get-started-with-office-365-management-apis#register-your-application-in-azure-ad)
Once this application is registered note the *Application (client) ID* and the *Directory (tenant) ID.* Then configure the authentication in the *Certificates & Secrets* section.
Example configuration `o365.yml` using client-secret authentication:
```yaml
  audit:
    enabled: true
    var.application_id: "<My Azure AD Application ID>"
    var.tenants:
      - id: "<My Tenant ID>"
        name: "mytenant.onmicrosoft.com"
    var.client_secret: "<My client secret>"
```

Certificate-based authentication is specially useful when monitoring multiple tenants. Example configuration:
```yaml
  audit:
    enabled: true
    var.application_id: "<My Azure AD Application ID>"
    var.tenants:
      - id: "<Tenant A ID>"
        name: "tenantA.onmicrosoft.com"
      - id: "<Tenant B ID>"
        name: "tenantB.onmicrosoft.com"
    var.certificate: "/path/to/certificate.pem"
    var.key: "/path/to/private_key.pem"
    var.key_passphrase: "my_passphrase"
```

Finally you need to add permissions in the *API permissions* section and grant it admin consent. Click on *Add permission* and select *Office 365 Management APIs.* The needed permissions are:
- User.Read
- ActivityFeed.Read
- ActivityFeed.ReadDlp
- ServiceHealth.Read

![filebeat o365 azure permissions](https://www.elastic.co/docs/reference/beats/filebeat/images/filebeat-o365-azure-permissions.png)
Once the required permissions are added, click the *Grant admin consent* button. Note that it can take a while for the required permissions to be in effect, so it’s possible that you observe some permission errors when running Filebeat right away.

#### Alternative endpoints

This module supports custom endpoints for on-prem deployments as well as alternative endpoints (GCC High endponts, U.S. DoD, European Union, etc). In order to point the module to an alternative endpoint, you need to adjust the `authentication_endpoint` and `resource` variables accordingly. For example:
```yaml
    var.api:
      # default is https://login.microsoftonline.com/
      authentication_endpoint: https://login.microsoftonline.us/
      # default is https://manage.office.com
      resource: https://manage.office365.us
```


#### Configuration options

<definitions>
  <definition term="var.application_id">
    The Application ID (also known as client ID) of the Azure application.
  </definition>
  <definition term="var.tenants">
    A list of one or more tenant IDs and name pairs. Set the `id` field to the tenant ID (also known as Directory ID). Set the name to the host name for the tenant, that is, the Office 365 domain for your organization.
  </definition>
  <definition term="var.client_secret">
    The client-secret (api_key) used to authenticate your Azure AD application. This option cannot be specified at the same time as the `var.certificate` option.
  </definition>
  <definition term="var.certificate">
    Path to the certificate file used for client authentication. This option cannot be specified at the same time as the `var.client_secret` option.
  </definition>
  <definition term="var.key">
    Path to the private key file used for client authentication.
  </definition>
  <definition term="var.key_passphrase">
    The passphrase used to decrypt an encrypted key stored in the configured `var.key` file. Only set this option when the key is encrypted.
  </definition>
  <definition term="var.content_type">
    The list of content-types to subscribe to. By default, it subscribes to all known content-types:
    - Audit.AzureActiveDirectory
    - Audit.Exchange
    - Audit.SharePoint
    - Audit.General
    - DLP.All
  </definition>
</definitions>


#### Advanced configuration options

The following configuration options are only recomended in case of problems. They must be nested under a single `var.api` key, like this:
```yaml
    var.api:
      authentication_endpoint: https://login.microsoftonline.com/
      resource: https://manage.office.com
      max_retention: 168h
      poll_interval: 3m
      max_requests_per_minute: 2000
      max_query_size: 24h
```

<definitions>
  <definition term="var.api.authentication_endpoint">
    The authentication endpoint used to authorize the Azure app. This is `https://login.microsoftonline.com/` by default, and can be changed to access alternative endpoints.
  </definition>
  <definition term="var.api.resource">
    The API resource to retrieve information from. This is `https://manage.office.com` by default, and can be changed to access alternative endpoints.
  </definition>
  <definition term="var.api.max_retention">
    The maximum data retention period to support. `168h` by default. Filebeat will fetch all retained data for a tenant when run for the first time. The default is 7 days, which matches the standard period that Microsoft will keep the logs before deleting them. Only increase it if your tenant has a longer retention period.
  </definition>
  <definition term="var.api.poll_interval">
    The interval to wait before polling the API server for new events. Default `3m`.
  </definition>
  <definition term="var.api.max_requests_per_minute">
    The maximum number of requests to perform per minute, for each tenant. The default is `2000`, as this is the server-side limit per tenant.
  </definition>
  <definition term="var.api.max_query_size">
    The maximum time window that API allows in a single query. Defaults to `24h` to match Microsoft’s documented limit.
  </definition>
</definitions>


## Example dashboard

This module comes with a sample dashboard:
![filebeat o365 audit](https://www.elastic.co/docs/reference/beats/filebeat/images/filebeat-o365-audit.png)

## Fields

For a description of each field in the module, see the [exported fields](https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-o365) section.