﻿---
title: MISP module
description: This is a filebeat module for reading threat intel information from the MISP platform (https://www.circl.lu/doc/misp/). It uses the httpjson input to...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-misp
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# MISP module
<admonition title="Deprecated in 7.14.0.">
  This module is deprecated. Use the [Threat Intel module](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-threatintel) instead.
</admonition>

<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

This is a filebeat module for reading threat intel information from the MISP platform ([[https://www.circl.lu/doc/misp/](https://www.circl.lu/doc/misp/)](https://www.circl.lu/doc/misp/)). It uses the httpjson input to access the MISP REST API interface.
The configuration in the config.yml file uses the following format:
- var.api_key: specifies the API key to access MISP.
- var.http_request_body: an object containing any parameter that needs to be sent to the search API. Default: `limit: 1000`
- var.url: URL of the MISP REST API, e.g., "http://x.x.x.x/attributes/restSearch"

<tip>
  Read the [quick start](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration) to learn how to configure and run modules.
</tip>


## Example dashboard

This module comes with a sample dashboard. For example:
![kibana misp](https://www.elastic.co/docs/reference/beats/filebeat/images/kibana-misp.png)

## Fields

For a description of each field in the module, see the [exported fields](https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-misp) section.