﻿---
title: Icinga module
description: The icinga module parses the main, debug, and startup logs of Icinga. When you run the module, it performs a few tasks under the hood: Sets the default...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-icinga
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Icinga module
The `icinga` module parses the main, debug, and startup logs of [Icinga](https://www.icinga.com/products/icinga-2/).
When you run the module, it performs a few tasks under the hood:
- Sets the default paths to the log files (but don’t worry, you can override the defaults)
- Makes sure each multiline log event gets sent as a single event
- Uses an Elasticsearch ingest pipeline to parse and process the log lines, shaping the data into a structure suitable for visualizing in Kibana
- Deploys dashboards for visualizing the log data

<tip>
  Read the [quick start](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration) to learn how to configure and run modules.
</tip>


## Compatibility

The `icinga` module was tested with Icinga >= 2.x on various Linux and Windows systems.
This module is not available for macOS.

## Configure the module

You can further refine the behavior of the `icinga` module by specifying [variable settings](#icinga-settings) in the `modules.d/icinga.yml` file, or overriding settings at the command line.
You must enable at least one fileset in the module. **Filesets are disabled by default.**
The following example shows how to set paths in the `modules.d/icinga.yml` file to override the default paths for logs:
```yaml
- module: icinga
  main:
    enabled: true
    var.paths: ["/path/to/log/icinga2/icinga2.log*"]
  debug:
    enabled: true
    var.paths: ["/path/to/log/icinga2/debug.log*"]
  startup:
    enabled: true
    var.paths: ["/path/to/log/icinga2/startup.log"]
```

To specify the same settings at the command line, you use:
```sh
-M "icinga.main.var.paths=[/path/to/log/icinga2/icinga2.log*]" -M "icinga.debug.var.paths=[/path/to/log/icinga2/debug.log*]" -M "icinga.startup.var.paths=[/path/to/log/icinga2/startup.log]"
```


### Variable settings

Each fileset has separate variable settings for configuring the behavior of the module. If you don’t specify variable settings, the `icinga` module uses the defaults.
For advanced use cases, you can also override input settings. See [Override input settings](https://www.elastic.co/docs/reference/beats/filebeat/advanced-settings).
<tip>
  When you specify a setting at the command line, remember to prefix the setting with the module name, for example, `icinga.main.var.paths` instead of `main.var.paths`.
</tip>


### `main` log fileset settings

<definitions>
  <definition term="var.paths">
    An array of glob-based paths that specify where to look for the log files. All patterns supported by [Go Glob](https://golang.org/pkg/path/filepath/#Glob) are also supported here. For example, you can use wildcards to fetch all files from a predefined level of subdirectories: `/path/to/log/*/*.log`. This fetches all `.log` files from the subfolders of `/path/to/log`. It does not fetch log files from the `/path/to/log` folder itself. If this setting is left empty, Filebeat will choose log paths based on your operating system.
  </definition>
</definitions>


### `debug` log fileset settings

<definitions>
  <definition term="var.paths">
    An array of glob-based paths that specify where to look for the log files. All patterns supported by [Go Glob](https://golang.org/pkg/path/filepath/#Glob) are also supported here. For example, you can use wildcards to fetch all files from a predefined level of subdirectories: `/path/to/log/*/*.log`. This fetches all `.log` files from the subfolders of `/path/to/log`. It does not fetch log files from the `/path/to/log` folder itself. If this setting is left empty, Filebeat will choose log paths based on your operating system.
  </definition>
</definitions>


### `startup` log fileset settings

<definitions>
  <definition term="var.paths">
    An array of glob-based paths that specify where to look for the log files. All patterns supported by [Go Glob](https://golang.org/pkg/path/filepath/#Glob) are also supported here. For example, you can use wildcards to fetch all files from a predefined level of subdirectories: `/path/to/log/*/*.log`. This fetches all `.log` files from the subfolders of `/path/to/log`. It does not fetch log files from the `/path/to/log` folder itself. If this setting is left empty, Filebeat will choose log paths based on your operating system.
  </definition>
</definitions>


## Example dashboard

This module comes with sample dashboards. For example:
![kibana icinga main](https://www.elastic.co/docs/reference/beats/filebeat/images/kibana-icinga-main.png)

## Fields

For a description of each field in the module, see the [exported fields](https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-icinga) section.