﻿---
title: Google Cloud Platform (GCP) module
description: This is a module for Google Cloud logs. It supports reading audit, VPC flow, and firewall logs that have been exported from Stackdriver to a Google Pub/Sub...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-gcp
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Google Cloud Platform (GCP) module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/gcp).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

This is a module for Google Cloud logs. It supports reading audit, VPC flow, and firewall logs that have been exported from Stackdriver to a Google Pub/Sub topic sink.
When you run the module, it performs a few tasks under the hood:
- Sets the default paths to the log files (but don’t worry, you can override the defaults)
- Makes sure each multiline log event gets sent as a single event
- Uses an Elasticsearch ingest pipeline to parse and process the log lines, shaping the data into a structure suitable for visualizing in Kibana

<tip>
  Read the [quick start](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration) to learn how to configure and run modules.
</tip>


## Configure the module

You can further refine the behavior of the `gcp` module by specifying [variable settings](#gcp-settings) in the `modules.d/gcp.yml` file, or overriding settings at the command line.
You must enable at least one fileset in the module. **Filesets are disabled by default.**

### Variable settings

Each fileset has separate variable settings for configuring the behavior of the module. If you don’t specify variable settings, the `gcp` module uses the defaults.
For advanced use cases, you can also override input settings. See [Override input settings](https://www.elastic.co/docs/reference/beats/filebeat/advanced-settings).
<tip>
  When you specify a setting at the command line, remember to prefix the setting with the module name, for example, `gcp.audit.var.paths` instead of `audit.var.paths`.
</tip>


### `audit` fileset settings

![filebeat gcp audit](https://www.elastic.co/docs/reference/beats/filebeat/images/filebeat-gcp-audit.png)
Example config:
```yaml
- module: gcp
  audit:
    enabled: true
    var.project_id: my-gcp-project-id
    var.topic: gcp-vpc-audit
    var.subscription_name: filebeat-gcp-audit-sub
    var.credentials_file: ${path.config}/gcp-service-account-xyz.json
    var.keep_original_message: false
```

<definitions>
  <definition term="var.paths">
    An array of glob-based paths that specify where to look for the log files. All patterns supported by [Go Glob](https://golang.org/pkg/path/filepath/#Glob) are also supported here. For example, you can use wildcards to fetch all files from a predefined level of subdirectories: `/path/to/log/*/*.log`. This fetches all `.log` files from the subfolders of `/path/to/log`. It does not fetch log files from the `/path/to/log` folder itself. If this setting is left empty, Filebeat will choose log paths based on your operating system.
  </definition>
  <definition term="var.project_id">
    Google Cloud project ID.
  </definition>
  <definition term="var.topic">
    Google Cloud Pub/Sub topic name.
  </definition>
  <definition term="var.subscription_name">
    Google Cloud Pub/Sub topic subscription name. If the subscription does not exist it will be created.
  </definition>
  <definition term="var.credentials_file">
    Path to a JSON file containing the credentials and key used to subscribe.
  </definition>
  <definition term="var.keep_original_message">
    Flag to control whether the original message is stored in the `log.original` field. Defaults to `false`, meaning the original message is not saved.
  </definition>
</definitions>


### `vpcflow` fileset settings

Example config:
```yaml
- module: gcp
  vpcflow:
    enabled: true
    var.project_id: my-gcp-project-id
    var.topic: gcp-vpc-flowlogs
    var.subscription_name: filebeat-gcp-vpc-flowlogs-sub
    var.credentials_file: ${path.config}/gcp-service-account-xyz.json
    var.keep_original_message: false
```

<definitions>
  <definition term="var.paths">
    An array of glob-based paths that specify where to look for the log files. All patterns supported by [Go Glob](https://golang.org/pkg/path/filepath/#Glob) are also supported here. For example, you can use wildcards to fetch all files from a predefined level of subdirectories: `/path/to/log/*/*.log`. This fetches all `.log` files from the subfolders of `/path/to/log`. It does not fetch log files from the `/path/to/log` folder itself. If this setting is left empty, Filebeat will choose log paths based on your operating system.
  </definition>
  <definition term="var.project_id">
    Google Cloud project ID.
  </definition>
  <definition term="var.topic">
    Google Cloud Pub/Sub topic name.
  </definition>
  <definition term="var.subscription_name">
    Google Cloud Pub/Sub topic subscription name. If the subscription does not exist it will be created.
  </definition>
  <definition term="var.credentials_file">
    Path to a JSON file containing the credentials and key used to subscribe.
  </definition>
  <definition term="var.keep_original_message">
    Flag to control whether the original message is stored in the `log.original` field. Defaults to `false`, meaning the original message is not saved.
  </definition>
</definitions>


### `firewall` fileset settings

Example config:
```yaml
- module: gcp
  firewall:
    enabled: true
    var.project_id: my-gcp-project-id
    var.topic: gcp-vpc-firewall
    var.subscription_name: filebeat-gcp-vpc-firewall-sub
    var.credentials_file: ${path.config}/gcp-service-account-xyz.json
    var.keep_original_message: false
```

<definitions>
  <definition term="var.paths">
    An array of glob-based paths that specify where to look for the log files. All patterns supported by [Go Glob](https://golang.org/pkg/path/filepath/#Glob) are also supported here. For example, you can use wildcards to fetch all files from a predefined level of subdirectories: `/path/to/log/*/*.log`. This fetches all `.log` files from the subfolders of `/path/to/log`. It does not fetch log files from the `/path/to/log` folder itself. If this setting is left empty, Filebeat will choose log paths based on your operating system.
  </definition>
  <definition term="var.project_id">
    Google Cloud project ID.
  </definition>
  <definition term="var.topic">
    Google Cloud Pub/Sub topic name.
  </definition>
  <definition term="var.subscription_name">
    Google Cloud Pub/Sub topic subscription name. If the subscription does not exist it will be created.
  </definition>
  <definition term="var.credentials_file">
    Path to a JSON file containing the credentials and key used to subscribe.
  </definition>
  <definition term="var.keep_original_message">
    Flag to control whether the original message is stored in the `log.original` field. Defaults to `false`, meaning the original message is not saved.
  </definition>
</definitions>


## Fields

For a description of each field in the module, see the [exported fields](https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-gcp) section.