﻿---
title: CoreDNS module
description: This is a filebeat module for CoreDNS. It supports both standalone CoreDNS deployment and CoreDNS deployment in Kubernetes. Although this module has been...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-coredns
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# CoreDNS module
This is a filebeat module for CoreDNS. It supports both standalone CoreDNS deployment and CoreDNS deployment in Kubernetes.
<tip>
  Read the [quick start](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration) to learn how to configure and run modules.
</tip>


## Compatibility

Although this module has been developed against Kubernetes v1.13.x, it is expected to work with other versions of Kubernetes.

## Configure the module

You can further refine the behavior of the `coredns` module by specifying [variable settings](#coredns-settings) in the `modules.d/coredns.yml` file, or overriding settings at the command line.
You must enable at least one fileset in the module. **Filesets are disabled by default.**

### Variable settings

Each fileset has separate variable settings for configuring the behavior of the module. If you don’t specify variable settings, the `coredns` module uses the defaults.
For advanced use cases, you can also override input settings. See [Override input settings](https://www.elastic.co/docs/reference/beats/filebeat/advanced-settings).
<tip>
  When you specify a setting at the command line, remember to prefix the setting with the module name, for example, `coredns.log.var.paths` instead of `log.var.paths`.
</tip>


### `log` fileset settings

Example config:
```yaml
- module: coredns
  log:
    enabled: true
    var.paths: ["/var/log/coredns.log"]
    var.tags: ["coredns", "staging"]
```

<definitions>
  <definition term="var.paths">
    An array of glob-based paths that specify where to look for the log files. All patterns supported by [Go Glob](https://golang.org/pkg/path/filepath/#Glob) are also supported here. For example, you can use wildcards to fetch all files from a predefined level of subdirectories: `/path/to/log/*/*.log`. This fetches all `.log` files from the subfolders of `/path/to/log`. It does not fetch log files from the `/path/to/log` folder itself. If this setting is left empty, Filebeat will choose log paths based on your operating system.
  </definition>
  <definition term="var.tags">
    An array of tags describing the monitored CoreDNS setup.
  </definition>
</definitions>


## Example dashboard

This module comes with a sample dashboard.
![kibana coredns](https://www.elastic.co/docs/reference/beats/filebeat/images/kibana-coredns.jpg)

## Fields

For a description of each field in the module, see the [exported fields](https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-coredns) section.