﻿---
title: Filebeat quick start: installation and configuration
description: This guide describes how to get started quickly with log collection. You’ll learn how to: install Filebeat on each system you want to monitor, specify...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Filebeat quick start: installation and configuration
This guide describes how to get started quickly with log collection. You’ll learn how to:
- install Filebeat on each system you want to monitor
- specify the location of your log files
- parse log data into fields and send it to Elasticsearch
- visualize the log data in Kibana

![Filebeat System dashboard](https://www.elastic.co/docs/reference/beats/filebeat/images/kibana-system.png)

## Before you begin

You need Elasticsearch for storing and searching your data, and Kibana for visualizing and managing it.
<applies-switch>
  <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
    To get started quickly, spin up an [Elastic Cloud Hosted](https://www.elastic.co/cloud?page=docs&placement=docs-body) deployment. Elastic Cloud Hosted is available on AWS, GCP, and Azure. [Try it out for free](https://cloud.elastic.co/registration?page=docs&placement=docs-body).
  </applies-item>

  <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
    To install and run Elasticsearch and Kibana, see [Installing the Elastic Stack](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch).
  </applies-item>
</applies-switch>


## Step 1: Install Filebeat

Install Filebeat on all the servers you want to monitor.
To download and install Filebeat, use the commands that work with your system:
<tab-set>
  <tab-item title="DEB">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/filebeat/filebeat-9.3.0-amd64.deb
    sudo dpkg -i filebeat-9.3.0-amd64.deb
    ```
  </tab-item>

  <tab-item title="RPM">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/filebeat/filebeat-9.3.0-x86_64.rpm
    sudo rpm -vi filebeat-9.3.0-x86_64.rpm
    ```
  </tab-item>

  <tab-item title="MacOS">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/filebeat/filebeat-9.3.0-darwin-x86_64.tar.gz
    tar xzvf filebeat-9.3.0-darwin-x86_64.tar.gz
    ```
  </tab-item>

  <tab-item title="Linux">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/filebeat/filebeat-9.3.0-linux-x86_64.tar.gz
    tar xzvf filebeat-9.3.0-linux-x86_64.tar.gz
    ```
  </tab-item>

  <tab-item title="Windows">
    1. Download the [Filebeat Windows zip file](https://artifacts.elastic.co/downloads/beats/filebeat/filebeat-9.3.0-windows-x86_64.zip).
    2. Extract the contents of the zip file into `C:\Program Files`.
    3. Rename the `filebeat-[version]-windows-x86_64` directory to `Filebeat`.
    4. Open a PowerShell prompt as an Administrator (right-click the PowerShell icon and select *Run As Administrator*).
    5. From the PowerShell prompt, run the following commands to install Filebeat as a Windows service:

    ```shell
    PS > cd 'C:\Program Files\Filebeat'
    PS C:\Program Files\Filebeat> .\install-service-filebeat.ps1
    ```

    <note>
      If script execution is disabled on your system, you need to set the execution policy for the current session to allow the script to run. For example: `PowerShell.exe -ExecutionPolicy UnRestricted -File .\install-service-filebeat.ps1`.
    </note>

    <important applies-to="Elastic Stack: Generally available since 9.0.6">
      The base folder has changed from `C:\ProgramData\` to `C:\Program Files\`
      because the latter has stricter permissions. The home path (base for
      state and logs) is now `C:\Program Files\Filebeat-Data`.The install script (`install-service-filebeat.ps1`) will check whether
      `C:\ProgramData\Filebeat` exits and move it to `C:\Program Files\Filebeat-Data`.
      For more details on the installation script refer to: [install script](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-script).
    </important>
  </tab-item>
</tab-set>

The commands shown are for AMD platforms, but ARM packages are also available. Refer to the [download page](https://www.elastic.co/downloads/beats/filebeat) for the full list of available packages.

### Other installation options

- [APT or YUM](https://www.elastic.co/docs/reference/beats/filebeat/setup-repositories)
- [Download page](https://www.elastic.co/downloads/beats/filebeat)
- [Docker](https://www.elastic.co/docs/reference/beats/filebeat/running-on-docker)
- [Kubernetes](https://www.elastic.co/docs/reference/beats/filebeat/running-on-kubernetes)
- [Cloud Foundry](https://www.elastic.co/docs/reference/beats/filebeat/running-on-cloudfoundry)


## Step 2: Connect to the Elastic Stack

Connections to Elasticsearch and Kibana are required to set up Filebeat.
Set the connection information in `filebeat.yml`. To locate this configuration file, see [Directory layout](https://www.elastic.co/docs/reference/beats/filebeat/directory-layout).
<applies-switch>
  <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
    Specify the [cloud.id](https://www.elastic.co/docs/reference/beats/filebeat/configure-cloud-id) of your Elastic Cloud Hosted deployment, and set [cloud.auth](https://www.elastic.co/docs/reference/beats/filebeat/configure-cloud-id) to a user who is authorized to set up Filebeat. For example:
    ```yaml
    cloud.id: "staging:dXMtZWFzdC0xLmF3cy5mb3VuZC5pbyRjZWM2ZjI2MWE3NGJmMjRjZTMzYmI4ODExYjg0Mjk0ZiRjNmMyY2E2ZDA0MjI0OWFmMGNjN2Q3YTllOTYyNTc0Mw=="
    cloud.auth: "filebeat_setup:YOUR_PASSWORD" 
    ```
  </applies-item>

  <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
    1. Set the host and port where Filebeat can find the Elasticsearch installation, and set the username and password of a user who is authorized to set up Filebeat. For example:
       ```yaml
       output.elasticsearch:
         hosts: ["https://myEShost:9200"]
         username: "filebeat_internal"
         password: "YOUR_PASSWORD" 
         ssl:
           enabled: true
           ca_trusted_fingerprint: "b9a10bbe64ee9826abeda6546fc988c8bf798b41957c33d05db736716513dc9c" 
       ```
    2. If you plan to use our pre-built Kibana dashboards, configure the Kibana endpoint. Skip this step if Kibana is running on the same host as Elasticsearch.
       ```yaml
         setup.kibana:
           host: "mykibanahost:5601" 
           username: "my_kibana_user" 
           password: "YOUR_PASSWORD"
       ```
  </applies-item>
</applies-switch>

To learn more about required roles and privileges, see [*Grant users access to secured resources*](https://www.elastic.co/docs/reference/beats/filebeat/feature-roles).
<note>
  You can send data to other [outputs](https://www.elastic.co/docs/reference/beats/filebeat/configuring-output), such as Logstash, but that requires additional configuration and setup.
</note>


## Step 3: Collect log data

There are several ways to collect log data with Filebeat:
- Data collection modules — simplify the collection, parsing, and visualization of common log formats
- ECS loggers — structure and format application logs into ECS-compatible JSON
- Manual Filebeat configuration


### Enable and configure data collection modules

1. Identify the modules you need to enable. To see a list of available [modules](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-modules), run:
   <tab-set>
   <tab-item title="DEB">
   ```sh
   filebeat modules list
   ```
   </tab-item>

   <tab-item title="RPM">
   ```sh
   filebeat modules list
   ```
   </tab-item>

   <tab-item title="MacOS">
   ```sh
   ./filebeat modules list
   ```
   </tab-item>

   <tab-item title="Linux">
   ```sh
   ./filebeat modules list
   ```
   </tab-item>

   <tab-item title="Windows">
   ```sh
   PS > .\filebeat.exe modules list
   ```
   </tab-item>
   </tab-set>
2. From the installation directory, enable one or more modules. For example, the following command enables the `nginx` module config:
   <tab-set>
   <tab-item title="DEB">
   ```sh
   filebeat modules enable nginx
   ```
   </tab-item>

   <tab-item title="RPM">
   ```sh
   filebeat modules enable nginx
   ```
   </tab-item>

   <tab-item title="MacOS">
   ```sh
   ./filebeat modules enable nginx
   ```
   </tab-item>

   <tab-item title="Linux">
   ```sh
   ./filebeat modules enable nginx
   ```
   </tab-item>

   <tab-item title="Windows">
   ```sh
   PS > .\filebeat.exe modules enable nginx
   ```
   </tab-item>
   </tab-set>
3. In the module config under modules.d, change the module settings to match your environment. You must enable at least one fileset in the module. Filesets are disabled by default.
   For example, log locations are set based on the OS. If your logs aren’t in default locations, set the paths variable:
   ```yaml
   - module: nginx
     access:
       enabled: true
       var.paths: ["/var/log/nginx/access.log*"]
   ```

To see the full list of variables for a module, see the documentation under [Modules](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-modules).
<tip>
  To test your configuration file, change to the directory where the Filebeat binary is installed, and run Filebeat in the foreground with the following options specified: `./filebeat test config -e`. Make sure your config files are in the path expected by Filebeat (see [Directory layout](https://www.elastic.co/docs/reference/beats/filebeat/directory-layout)), or use the `-c` flag to specify the path to the config file.
</tip>

For more information about configuring Filebeat, also see:
- [Configure Filebeat](https://www.elastic.co/docs/reference/beats/filebeat/configuring-howto-filebeat)
- [Config file format](https://www.elastic.co/docs/reference/beats/libbeat/config-file-format)
- [`filebeat.reference.yml`](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-reference-yml): This reference configuration file shows all non-deprecated options. You'll find it in the same location as `filebeat.yml`.


### Enable and configure ECS loggers for application log collection

While Filebeat can be used to ingest raw, plain-text application logs,
we recommend structuring your logs at ingest time. This lets you extract fields,
like log level and exception stack traces.
Elastic simplifies this process by providing application log formatters in a variety
of popular programming languages. These plugins format your logs into ECS-compatible JSON,
which removes the need to manually parse logs.
See [ECS loggers](https://www.elastic.co/docs/reference/ecs/logging/intro) to get started.

### Configure Filebeat manually

If you're unable to find a module for your file type, or can't change your application's
log output, see [configure the input](https://www.elastic.co/docs/reference/beats/filebeat/configuration-filebeat-options) manually.

## Step 4: Set up assets

Filebeat comes with predefined assets for parsing, indexing, and
visualizing your data. To load these assets:
1. Make sure the user specified in `filebeat.yml` is [authorized to set up Filebeat](https://www.elastic.co/docs/reference/beats/filebeat/privileges-to-setup-beats).
2. From the installation directory, run:
   <tab-set>
   <tab-item title="DEB">
   ```sh
   filebeat setup -e
   ```
   </tab-item>

   <tab-item title="RPM">
   ```sh
   filebeat setup -e
   ```
   </tab-item>

   <tab-item title="MacOS">
   ```sh
   ./filebeat setup -e
   ```
   </tab-item>

   <tab-item title="Linux">
   ```sh
   ./filebeat setup -e
   ```
   </tab-item>

   <tab-item title="Windows">
   ```sh
   PS > .\filebeat.exe setup -e
   ```
   </tab-item>
   </tab-set>
   `-e` is optional and sends output to standard error instead of the configured log output.

By default Windows log files are stored in `C:\Program Files\Filebeat-Data\logs`.
<note>
  In versions before 9.0.6, the default location for Windows log files was `C:\ProgramData\filebeat\logs`.
</note>

This step loads the recommended [index template](https://www.elastic.co/docs/manage-data/data-store/templates) for writing to Elasticsearch and deploys the sample dashboards for visualizing the data in Kibana.
This step does not load the ingest pipelines used to parse log lines. By default, ingest pipelines are set up automatically the first time you run the module and connect to Elasticsearch.
<tip>
  A connection to Elasticsearch (or Elastic Cloud Hosted) is required to set up the initial environment. If you're using a different output, such as Logstash, see:
  - [Load the Elasticsearch index template > Load the index template manually](/docs/reference/beats/filebeat/filebeat-template#load-template-manually)
  - [Load Kibana dashboards](https://www.elastic.co/docs/reference/beats/filebeat/load-kibana-dashboards)
  - [Load ingest pipelines](https://www.elastic.co/docs/reference/beats/filebeat/load-ingest-pipelines)
</tip>

<note>
  Filebeat should not be used to ingest its own log as this may lead to an infinite loop.
</note>


## Step 5: Start Filebeat

Before starting Filebeat, modify the user credentials in `filebeat.yml` and specify a user who is [authorized to publish events](https://www.elastic.co/docs/reference/beats/filebeat/privileges-to-publish-events).
To start Filebeat, run:
<tab-set>
  <tab-item title="DEB">
    ```sh
    sudo service filebeat start
    ```

    <note>
      If you use an `init.d` script to start Filebeat, you can’t specify command line flags (see [Command reference](https://www.elastic.co/docs/reference/beats/filebeat/command-line-options)). To specify flags, start Filebeat in the foreground.
    </note>
    Also see [Filebeat and systemd](https://www.elastic.co/docs/reference/beats/filebeat/running-with-systemd).
  </tab-item>

  <tab-item title="RPM">
    ```sh
    sudo service filebeat start
    ```

    <note>
      If you use an `init.d` script to start Filebeat, you can’t specify command line flags (see [Command reference](https://www.elastic.co/docs/reference/beats/filebeat/command-line-options)). To specify flags, start Filebeat in the foreground.
    </note>
    Also see [Filebeat and systemd](https://www.elastic.co/docs/reference/beats/filebeat/running-with-systemd).
  </tab-item>

  <tab-item title="MacOS">
    ```sh
    sudo chown root filebeat.yml 
    sudo chown root modules.d/nginx.yml 
    sudo ./filebeat -e
    ```
  </tab-item>

  <tab-item title="Linux">
    ```sh
    sudo chown root filebeat.yml 
    sudo chown root modules.d/nginx.yml 
    sudo ./filebeat -e
    ```
  </tab-item>

  <tab-item title="Windows">
    ```sh
    PS C:\Program Files\filebeat> Start-Service filebeat
    ```
    By default Windows log files are stored in `C:\Program Files\Filebeat-Data\logs`.
    <note>
      In versions before 9.0.6, the default location for Windows log files was `C:\ProgramData\filebeat\logs`.
    </note>
  </tab-item>
</tab-set>

Filebeat should begin streaming events to Elasticsearch.

## Step 6: View your data in Kibana

Filebeat comes with pre-built Kibana dashboards and UIs for visualizing log data. You loaded the dashboards earlier when you ran the `setup` command.
To open the dashboards:
1. Launch Kibana:
   <applies-switch>
   <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
   1. [Log in](https://cloud.elastic.co/) to your Elastic Cloud account.
   2. Navigate to the Kibana endpoint in your deployment.
   </applies-item>

   <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
   Point your browser to [http://localhost:5601](http://localhost:5601), replacing `localhost` with the name of the Kibana host.
   </applies-item>
   </applies-switch>
2. In the side navigation, click **Discover**. To see Filebeat data, make sure the predefined `filebeat-*` data view is selected.
   <tip>
   If you don’t see data in Kibana, try changing the time filter to a larger range. By default, Kibana shows the last 15 minutes.
   </tip>
3. In the side navigation, click **Dashboard**, then select the dashboard that you want to open.

The dashboards are provided as examples. We recommend that you [customize](https://www.elastic.co/docs/explore-analyze/dashboards) them to meet your needs.

## What’s next?

Now that you have your logs streaming into Elasticsearch, learn how to unify your logs, metrics, uptime, and application performance data.
1. Ingest data from other sources by installing and configuring other Elastic Beats:
   | Elastic Beats                                                                                              | To capture                      |
   |------------------------------------------------------------------------------------------------------------|---------------------------------|
   | [Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-installation-configuration) | Infrastructure metrics          |
   | [Winlogbeat](https://www.elastic.co/docs/reference/beats/winlogbeat/winlogbeat-installation-configuration) | Windows event logs              |
   | [Heartbeat](https://www.elastic.co/docs/reference/beats/heartbeat/heartbeat-installation-configuration)    | Uptime information              |
   | [APM](https://www.elastic.co/docs/solutions/observability/apm)                                             | Application performance metrics |
   | [Auditbeat](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-installation-configuration)    | Audit events                    |
2. Use the Observability apps in Kibana to search across all your data:
   | Elastic apps                                                                                                           | Use to                                                           |
   |------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------|
   | [Metrics app](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics) | Explore metrics about systems and services across your ecosystem |
   | [Logs app](https://www.elastic.co/docs/solutions/observability/logs/explore-logs)                                      | Tail related log data in real time                               |
   | [Uptime app](https://www.elastic.co/docs/solutions/observability/synthetics#monitoring-uptime)                         | Monitor availability issues across your apps and services        |
   | [APM app](https://www.elastic.co/docs/solutions/observability/apm/overviews)                                           | Monitor application performance                                  |
   | [SIEM app](https://www.elastic.co/docs/solutions/security)                                                             | Analyze security events                                          |