﻿---
title: UDP input
description: Use the udp input to read events over UDP. Example configuration: The udp input supports the following configuration options plus the Common options described...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-udp
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# UDP input
Use the `udp` input to read events over UDP.
Example configuration:
```yaml
filebeat.inputs:
- type: udp
  max_message_size: 10KiB
  host: "localhost:8080"
```

<note>
  <applies-to>Elastic Stack: Generally available since 9.2</applies-to> Starting in 9.2.0 the UDP input reads
  the message in a different goroutine than the publishing of messages,
  which increases the performance of the input when running slow
  processors.
</note>


## Configuration options

The `udp` input supports the following configuration options plus the [Common options](#filebeat-input-udp-common-options) described later.

### `max_message_size`

The maximum size of the message received over UDP. The default is `10KiB`.

### `host`

The host and UDP port to listen on for event streams.

### `number_of_workers`

<applies-to>
  - Elastic Stack: Generally available since 9.2
</applies-to>

The number of pipeline workers. Default: 1. Increasing the number of
workers can increase performance when the bottleneck is the time the
processors take to run. The number of CPUs allocated to Filebeat is
usually the best value for the number of workers.

### `network`

The network type. Acceptable values are: "udp" (default), "udp4", "udp6"

### `read_buffer`

The size of the read buffer on the UDP socket. If not specified the default from the operating system will be used.

### `timeout`

The read and write timeout for socket operations. The default is `5m`.

## Metrics

This input exposes metrics under the [HTTP monitoring endpoint](https://www.elastic.co/docs/reference/beats/filebeat/http-endpoint). These metrics are exposed under the `/inputs` path. They can be used to observe the activity of the input.

| Metric                                                                                          | Description                                                                        |
|-------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------|
| `device`                                                                                        | Host/port of the UDP stream.                                                       |
| `udp_read_buffer_length_gauge`                                                                  | Size of the UDP socket buffer length in bytes (gauge).                             |
| `received_events_total`                                                                         | Total number of packets (events) that have been received.                          |
| `received_bytes_total`                                                                          | Total number of bytes received.                                                    |
| `published_events_total`  <applies-to>Elastic Stack: Generally available since 9.2</applies-to> | Total number of packets (events) published.                                        |
| `receive_queue_length`                                                                          | Aggregated size of the system receive queues (IPv4 and IPv6) (linux only) (gauge). |
| `system_packet_drops`                                                                           | Aggregated number of system packet drops (IPv4 and IPv6) (linux only) (gauge).     |
| `arrival_period`                                                                                | Histogram of the time between successive packets in nanoseconds.                   |
| `processing_time`                                                                               | Histogram of the time taken to process packets in nanoseconds.                     |


## Common options

The following configuration options are supported by all inputs.

#### `enabled`

Use the `enabled` option to enable and disable inputs. By default, enabled is set to true.

#### `tags`

A list of tags that Filebeat includes in the `tags` field of each published event. Tags make it easy to select specific events in Kibana or apply conditional filtering in Logstash. These tags will be appended to the list of tags specified in the general configuration.
Example:
```yaml
filebeat.inputs:
- type: udp
  . . .
  tags: ["json"]
```


#### `fields`

Optional fields that you can specify to add additional information to the output. For example, you might add fields that you can use for filtering log data. Fields can be scalar values, arrays, dictionaries, or any nested combination of these. By default, the fields that you specify here will be grouped under a `fields` sub-dictionary in the output document. To store the custom fields as top-level fields, set the `fields_under_root` option to true. If a duplicate field is declared in the general configuration, then its value will be overwritten by the value declared here.
```yaml
filebeat.inputs:
- type: udp
  . . .
  fields:
    app_id: query_engine_12
```


#### `fields_under_root`

If this option is set to true, the custom [fields](#filebeat-input-udp-fields) are stored as top-level fields in the output document instead of being grouped under a `fields` sub-dictionary. If the custom field names conflict with other field names added by Filebeat, then the custom fields overwrite the other fields.

#### `processors`

A list of processors to apply to the input data.
See [Processors](https://www.elastic.co/docs/reference/beats/filebeat/filtering-enhancing-data) for information about specifying processors in your config.

#### `pipeline`

The ingest pipeline ID to set for the events generated by this input.
<note>
  The pipeline ID can also be configured in the Elasticsearch output, but this option usually results in simpler configuration files. If the pipeline is configured both in the input and output, the option from the input is used.
</note>

<important>
  The `pipeline` is always lowercased. If `pipeline: Foo-Bar`, then the pipeline name in Elasticsearch needs to be defined as `foo-bar`.
</important>


#### `keep_null`

If this option is set to true, fields with `null` values will be published in the output document. By default, `keep_null` is set to `false`.

#### `index`

If present, this formatted string overrides the index for events from this input (for elasticsearch outputs), or sets the `raw_index` field of the event’s metadata (for other outputs). This string can only refer to the agent name and version and the event timestamp; for access to dynamic fields, use `output.elasticsearch.index` or a processor.
Example value: `"%{[agent.name]}-myindex-%{+yyyy.MM.dd}"` might expand to `"filebeat-myindex-2019.11.01"`.

#### `publisher_pipeline.disable_host`

By default, all events contain `host.name`. This option can be set to `true` to disable the addition of this field to all events. The default value is `false`.