﻿---
title: Redis input
description: Use the redis input to read entries from Redis slowlogs. Example configuration: The redis input supports the following configuration options plus the...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-redis
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Preview
---

# Redis input
<warning>
  This functionality is in technical preview and may be changed or removed in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.
</warning>

Use the `redis` input to read entries from Redis slowlogs.
Example configuration:
```yaml
filebeat.inputs:
- type: redis
  hosts: ["localhost:6379"]
  password: "${redis_pwd}"
```


## Configuration options

The `redis` input supports the following configuration options plus the [Common options](#filebeat-input-redis-common-options) described later.

#### `hosts`

The list of Redis hosts to connect to.

#### `password`

The password to use when connecting to Redis.

#### `username`

The username to use when connecting to Redis.

#### `scan_frequency`

How often Filebeat reads entries from Redis slowlogs. Specify `1s` to scan Redis as frequently as possible without causing Filebeat to scan too frequently. Do not set this value to less than `1s`.
The default is `10s`.
<important>
  Redis slowlogs are not permanent. To ensure that all slowlog entries are collected, set `scan_frequency` to a value that allows Filebeat sufficient time to connect to Redis, query the logs, and buffer them to the output within the specified interval.
</important>


#### `timeout`

How long to wait for a response from Redis before the input returns an error. The default is `1s`.

#### `network`

The network type to use for the Redis connection. Valid settings include: `tcp`, `tcp4`, `tcp6`, and `unix`. The default is `tcp`.

#### `maxconn`

The maximum number of concurrent connections. The default is `10`.

## Common options

The following configuration options are supported by all inputs.

#### `enabled`

Use the `enabled` option to enable and disable inputs. By default, enabled is set to true.

#### `tags`

A list of tags that Filebeat includes in the `tags` field of each published event. Tags make it easy to select specific events in Kibana or apply conditional filtering in Logstash. These tags will be appended to the list of tags specified in the general configuration.
Example:
```yaml
filebeat.inputs:
- type: redis
  . . .
  tags: ["json"]
```


#### `fields`

Optional fields that you can specify to add additional information to the output. For example, you might add fields that you can use for filtering log data. Fields can be scalar values, arrays, dictionaries, or any nested combination of these. By default, the fields that you specify here will be grouped under a `fields` sub-dictionary in the output document. To store the custom fields as top-level fields, set the `fields_under_root` option to true. If a duplicate field is declared in the general configuration, then its value will be overwritten by the value declared here.
```yaml
filebeat.inputs:
- type: redis
  . . .
  fields:
    app_id: query_engine_12
```


#### `fields_under_root`

If this option is set to true, the custom [fields](#filebeat-input-redis-fields) are stored as top-level fields in the output document instead of being grouped under a `fields` sub-dictionary. If the custom field names conflict with other field names added by Filebeat, then the custom fields overwrite the other fields.

#### `processors`

A list of processors to apply to the input data.
See [Processors](https://www.elastic.co/docs/reference/beats/filebeat/filtering-enhancing-data) for information about specifying processors in your config.

#### `pipeline`

The ingest pipeline ID to set for the events generated by this input.
<note>
  The pipeline ID can also be configured in the Elasticsearch output, but this option usually results in simpler configuration files. If the pipeline is configured both in the input and output, the option from the input is used.
</note>

<important>
  The `pipeline` is always lowercased. If `pipeline: Foo-Bar`, then the pipeline name in Elasticsearch needs to be defined as `foo-bar`.
</important>


#### `keep_null`

If this option is set to true, fields with `null` values will be published in the output document. By default, `keep_null` is set to `false`.

#### `index`

If present, this formatted string overrides the index for events from this input (for elasticsearch outputs), or sets the `raw_index` field of the event’s metadata (for other outputs). This string can only refer to the agent name and version and the event timestamp; for access to dynamic fields, use `output.elasticsearch.index` or a processor.
Example value: `"%{[agent.name]}-myindex-%{+yyyy.MM.dd}"` might expand to `"filebeat-myindex-2019.11.01"`.

#### `publisher_pipeline.disable_host`

By default, all events contain `host.name`. This option can be set to `true` to disable the addition of this field to all events. The default value is `false`.

#### `ssl`

Configuration options for SSL parameters like the certificate, key and the certificate authorities to use.
See [SSL](https://www.elastic.co/docs/reference/beats/filebeat/configuration-ssl) for more information.