﻿---
title: Kafka input
description: Use the kafka input to read from topics in a Kafka cluster. To configure this input, specify a list of one or more hosts in the cluster to bootstrap the...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-kafka
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Kafka input
Use the `kafka` input to read from topics in a Kafka cluster.
To configure this input, specify a list of one or more [`hosts`](/docs/reference/beats/filebeat/logstash-output#hosts) in the cluster to bootstrap the connection with, a list of [`topics`](#topics) to track, and a [`group_id`](#groupid) for the connection.
Example configuration:
```yaml
filebeat.inputs:
- type: kafka
  hosts:
    - kafka-broker-1:9092
    - kafka-broker-2:9092
  topics: ["my-topic"]
  group_id: "filebeat"
```

The following example shows how to use the `kafka` input to ingest data from Microsoft Azure Event Hubs that have Kafka compatibility enabled:
```yaml
filebeat.inputs:
- type: kafka
  hosts: ["<your event hub namespace>.servicebus.windows.net:9093"]
  topics: ["<your event hub instance>"]
  group_id: "<your consumer group>"

  username: "$ConnectionString"
  password: "<your connection string>"
  ssl.enabled: true
```

For more details on the mapping between Kafka and Event Hubs configuration parameters, see the [Azure documentation](https://docs.microsoft.com/en-us/azure/event-hubs/event-hubs-for-kafka-ecosystem-overview).

## Compatibility

This input works with all Kafka versions in between 0.11 and 2.8.0. Older versions might work as well, but are not supported.

## Configuration options

The `kafka` input supports the following configuration options plus the [Common options](#filebeat-input-kafka-common-options) described later.
<note>
  If you’re using Elastic Agent with a Kafka input and need to increase throughput, we recommend scaling horizontally by additional Elastic Agents to read from the Kafka topic. Note that each Elastic Agent reads concurrently from each of the partitions it has been assigned.
</note>


#### `hosts`

A list of Kafka bootstrapping hosts (brokers) for this cluster.

#### `topics`

A list of topics to read from.

#### `group_id`

The Kafka consumer group id.

#### `client_id`

The Kafka client id (optional).

#### `version`

The version of the Kafka protocol to use (defaults to `"2.1.0"`). When using Kafka 4.0 and newer, the version must be set to at least `"2.1.0"`.

#### `initial_offset`

The initial offset to start reading, either "oldest" or "newest". Defaults to "oldest".

### `connect_backoff`

How long to wait before trying to reconnect to the kafka cluster after a fatal error. Default is 30s.

### `consume_backoff`

How long to wait before retrying a failed read. Default is 2s.

### `max_wait_time`

How long to wait for the minimum number of input bytes while reading. Default is 250ms.

### `wait_close`

When shutting down, how long to wait for in-flight messages to be delivered and acknowledged.

### `isolation_level`

This configures the Kafka group isolation level:
- `"read_uncommitted"` returns *all* messages in the message channel.
- `"read_committed"` hides messages that are part of an aborted transaction.

The default is `"read_uncommitted"`.

### `fetch`

Kafka fetch settings:
<definitions>
  <definition term="min">
    The minimum number of bytes to wait for. Defaults to 1.
  </definition>
  <definition term="default">
    The default number of bytes to read per request. Defaults to 1MB.
  </definition>
  <definition term="max">
    The maximum number of bytes to read per request. Defaults to 0 (no limit).
  </definition>
</definitions>


### `expand_event_list_from_field`

If the fileset using this input expects to receive multiple messages bundled under a specific field then the config option `expand_event_list_from_field` value can be assigned the name of the field. For example in the case of azure filesets the events are found under the json object "records".
```json
{
"records": [ {event1}, {event2}]
}
```

This setting will be able to split the messages under the group value (*records*) into separate events.

### `rebalance`

Kafka rebalance settings:
<definitions>
  <definition term="strategy">
    Either `"range"` or `"roundrobin"`. Defaults to `"range"`.
  </definition>
  <definition term="timeout">
    How long to wait for an attempted rebalance. Defaults to 60s.
  </definition>
  <definition term="max_retries">
    How many times to retry if rebalancing fails. Defaults to 4.
  </definition>
  <definition term="retry_backoff">
    How long to wait after an unsuccessful rebalance attempt. Defaults to 2s.
  </definition>
</definitions>


### `sasl.mechanism`

The SASL mechanism to use when connecting to Kafka. It can be one of:
- `PLAIN` for SASL/PLAIN.
- `SCRAM-SHA-256` for SCRAM-SHA-256.
- `SCRAM-SHA-512` for SCRAM-SHA-512.

If `sasl.mechanism` is not set, `PLAIN` is used if `username` and `password` are provided. Otherwise, SASL authentication is disabled.
To use `GSSAPI` mechanism to authenticate with Kerberos, you must leave this field empty, and use the [`kerberos`](/docs/reference/beats/filebeat/kafka-output#kerberos-option-kafka) options.

### `kerberos`

<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

Configuration options for Kerberos authentication.
See [Kerberos](https://www.elastic.co/docs/reference/beats/filebeat/configuration-kerberos) for more information.

#### `parsers`

This option expects a list of parsers that the payload has to go through.
Available parsers:
- `ndjson`
- `multiline`


#### `ndjson`

These options make it possible for Filebeat to decode the payload as JSON messages.
Example configuration:
```yaml
- ndjson:
  target: ""
  add_error_key: true
  message_key: log
```

<definitions>
  <definition term="target">
    The name of the new JSON object that should contain the parsed key value pairs. If you leave it empty, the new keys will go under root.
  </definition>
  <definition term="overwrite_keys">
    Values from the decoded JSON object overwrite the fields that Filebeat normally adds (type, source, offset, etc.) in case of conflicts. Disable it if you want to keep previously added values.
  </definition>
  <definition term="expand_keys">
    If this setting is enabled, Filebeat will recursively de-dot keys in the decoded JSON, and expand them into a hierarchical object structure. For example, `{"a.b.c": 123}` would be expanded into `{"a":{"b":{"c":123}}}`. This setting should be enabled when the input is produced by an [ECS logger](https://github.com/elastic/ecs-logging).
  </definition>
  <definition term="add_error_key">
    If this setting is enabled, Filebeat adds an "error.message" and "error.type: json" key in case of JSON unmarshalling errors or when a `message_key` is defined in the configuration but cannot be used.
  </definition>
  <definition term="message_key">
    An optional configuration setting that specifies a JSON key on which to apply the line filtering and multiline settings. If specified the key must be at the top level in the JSON object and the value associated with the key must be a string, otherwise no filtering or multiline aggregation will occur.
  </definition>
  <definition term="document_id">
    Option configuration setting that specifies the JSON key to set the document id. If configured, the field will be removed from the original JSON document and stored in `@metadata._id`
  </definition>
  <definition term="ignore_decoding_error">
    An optional configuration setting that specifies if JSON decoding errors should be logged or not. If set to true, errors will not be logged. The default is false.
  </definition>
</definitions>


#### `multiline`

Options that control how Filebeat deals with log messages that span multiple lines. See [Multiline messages](https://www.elastic.co/docs/reference/beats/filebeat/multiline-examples) for more information about configuring multiline options.

## Common options

The following configuration options are supported by all inputs.

#### `enabled`

Use the `enabled` option to enable and disable inputs. By default, enabled is set to true.

#### `tags`

A list of tags that Filebeat includes in the `tags` field of each published event. Tags make it easy to select specific events in Kibana or apply conditional filtering in Logstash. These tags will be appended to the list of tags specified in the general configuration.
Example:
```yaml
filebeat.inputs:
- type: kafka
  . . .
  tags: ["json"]
```


#### `fields`

Optional fields that you can specify to add additional information to the output. For example, you might add fields that you can use for filtering log data. Fields can be scalar values, arrays, dictionaries, or any nested combination of these. By default, the fields that you specify here will be grouped under a `fields` sub-dictionary in the output document. To store the custom fields as top-level fields, set the `fields_under_root` option to true. If a duplicate field is declared in the general configuration, then its value will be overwritten by the value declared here.
```yaml
filebeat.inputs:
- type: kafka
  . . .
  fields:
    app_id: query_engine_12
```


#### `fields_under_root`

If this option is set to true, the custom [fields](#filebeat-input-kafka-fields) are stored as top-level fields in the output document instead of being grouped under a `fields` sub-dictionary. If the custom field names conflict with other field names added by Filebeat, then the custom fields overwrite the other fields.

#### `processors`

A list of processors to apply to the input data.
See [Processors](https://www.elastic.co/docs/reference/beats/filebeat/filtering-enhancing-data) for information about specifying processors in your config.

#### `pipeline`

The ingest pipeline ID to set for the events generated by this input.
<note>
  The pipeline ID can also be configured in the Elasticsearch output, but this option usually results in simpler configuration files. If the pipeline is configured both in the input and output, the option from the input is used.
</note>

<important>
  The `pipeline` is always lowercased. If `pipeline: Foo-Bar`, then the pipeline name in Elasticsearch needs to be defined as `foo-bar`.
</important>


#### `keep_null`

If this option is set to true, fields with `null` values will be published in the output document. By default, `keep_null` is set to `false`.

#### `index`

If present, this formatted string overrides the index for events from this input (for elasticsearch outputs), or sets the `raw_index` field of the event’s metadata (for other outputs). This string can only refer to the agent name and version and the event timestamp; for access to dynamic fields, use `output.elasticsearch.index` or a processor.
Example value: `"%{[agent.name]}-myindex-%{+yyyy.MM.dd}"` might expand to `"filebeat-myindex-2019.11.01"`.

#### `publisher_pipeline.disable_host`

By default, all events contain `host.name`. This option can be set to `true` to disable the addition of this field to all events. The default value is `false`.