﻿---
title: CometD input
description: Use the https://docs.cometd.org/[cometd] input to stream the real-time events from a Salesforce generic subscription Push Topic. This input can, for example,...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-cometd
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# CometD input
Use the `https://docs.cometd.org/[cometd]` input to stream the real-time events from a [Salesforce generic subscription Push Topic](https://resources.docs.salesforce.com/sfdc/pdf/api_streaming.pdf).
This input can, for example, be used to receive Login and Logout events that are generated when users log in or out of the Salesforce instance.
Example configuration:
```yaml
filebeat.inputs:
- type: cometd
  channel_name: /event/MyEventStream
  auth.oauth2:
    client.id: my-client-id
    client.secret: my-client-secret
    token_url: https://login.salesforce.com/services/oauth2/token
    user: my.email@example.com
    password: my-password
```


## Configuration options

The `cometd` input supports the following configuration options.

### `channel_name`

Salesforce generic subscription Push Topic name. Required.

### `auth.oauth2.client.id`

The client ID used as part of the authentication flow. Required.

### `auth.oauth2.client.secret`

The client secret used as part of the authentication flow. Required.

### `auth.oauth2.token_url`

The endpoint that will be used to generate the token during the oauth2 flow. Required.

### `auth.oauth2.user`

The user used as part of the authentication flow. It is required for authentication - grant type password. Required.

### `auth.oauth2.password`

The password used as part of the authentication flow. It is required for authentication - grant type password. Required.