﻿---
title: Cloud Foundry input
description: Use the cloudfoundry input to get http access logs, container logs and error logs from Cloud Foundry. Connects to the Cloud Foundry loggregator to receive...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-cloudfoundry
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Cloud Foundry input
Use the `cloudfoundry` input to get http access logs, container logs and error logs from Cloud Foundry. Connects to the Cloud Foundry loggregator to receive events.
Example configurations:
```yaml
filebeat.inputs:
- type: cloudfoundry
  api_address: https://api.dev.cfdev.sh
  client_id: uaa-filebeat
  client_secret: verysecret
  shard_id: filebeat
  ssl:
      verification_mode: none
```

```yaml
filebeat.inputs:
- type: cloudfoundry
  api_address: https://api.dev.cfdev.sh
  client_id: uaa-filebeat
  client_secret: verysecret
  shard_id: filebeat
  ssl.certificate_authorities: ["/etc/pki/cf/ca.pem"]
  ssl.certificate: "/etc/pki/cf/cert.pem"
  ssl.key: "/etc/pki/cf/cert.key"
```


## Configuration options

The `cloudfoundry` input supports the following configuration options plus the [Common options](#filebeat-input-cloudfoundry-common-options) described later.

### `api_address`

The URL of the Cloud Foundry API. Optional. Default: "http://api.bosh-lite.com".

### `doppler_address`

The URL of the Cloud Foundry Doppler Websocket. Optional. Default: "(value from ${api_address}/v2/info)".

### `uaa_address`

The URL of the Cloud Foundry UAA API. Optional. Default: "(value from ${api_address}/v2/info)".

### `rlp_address`

The URL of the Cloud Foundry RLP Gateway. Optional. Default: "(`log-stream` subdomain under the same domain as `api_server`)".

### `client_id`

Client ID to authenticate with Cloud Foundry. Default: "".

### `client_secret`

Client Secret to authenticate with Cloud Foundry. Default: "".

### `shard_id`

Shard ID for the connection with Cloud Foundry. Use the same ID across multiple filebeat to shard the load of events. Default: "(generated UUID)".

### `version`

Consumer API version to connect with Cloud Foundry to collect events. Use `v1` to collect events using Doppler/Traffic Control. Use `v2` to collect events from the RLP Gateway. Default: "`v1`".

### `ssl`

This specifies SSL/TLS common config. Default: not used.

## Common options

The following configuration options are supported by all inputs.

#### `enabled`

Use the `enabled` option to enable and disable inputs. By default, enabled is set to true.

#### `tags`

A list of tags that Filebeat includes in the `tags` field of each published event. Tags make it easy to select specific events in Kibana or apply conditional filtering in Logstash. These tags will be appended to the list of tags specified in the general configuration.
Example:
```yaml
filebeat.inputs:
- type: cloudfoundry
  . . .
  tags: ["json"]
```


#### `fields`

Optional fields that you can specify to add additional information to the output. For example, you might add fields that you can use for filtering log data. Fields can be scalar values, arrays, dictionaries, or any nested combination of these. By default, the fields that you specify here will be grouped under a `fields` sub-dictionary in the output document. To store the custom fields as top-level fields, set the `fields_under_root` option to true. If a duplicate field is declared in the general configuration, then its value will be overwritten by the value declared here.
```yaml
filebeat.inputs:
- type: cloudfoundry
  . . .
  fields:
    app_id: query_engine_12
```


#### `fields_under_root`

If this option is set to true, the custom [fields](#filebeat-input-cloudfoundry-fields) are stored as top-level fields in the output document instead of being grouped under a `fields` sub-dictionary. If the custom field names conflict with other field names added by Filebeat, then the custom fields overwrite the other fields.

#### `processors`

A list of processors to apply to the input data.
See [Processors](https://www.elastic.co/docs/reference/beats/filebeat/filtering-enhancing-data) for information about specifying processors in your config.

#### `pipeline`

The ingest pipeline ID to set for the events generated by this input.
<note>
  The pipeline ID can also be configured in the Elasticsearch output, but this option usually results in simpler configuration files. If the pipeline is configured both in the input and output, the option from the input is used.
</note>

<important>
  The `pipeline` is always lowercased. If `pipeline: Foo-Bar`, then the pipeline name in Elasticsearch needs to be defined as `foo-bar`.
</important>


#### `keep_null`

If this option is set to true, fields with `null` values will be published in the output document. By default, `keep_null` is set to `false`.

#### `index`

If present, this formatted string overrides the index for events from this input (for elasticsearch outputs), or sets the `raw_index` field of the event’s metadata (for other outputs). This string can only refer to the agent name and version and the event timestamp; for access to dynamic fields, use `output.elasticsearch.index` or a processor.
Example value: `"%{[agent.name]}-myindex-%{+yyyy.MM.dd}"` might expand to `"filebeat-myindex-2019.11.01"`.

#### `publisher_pipeline.disable_host`

By default, all events contain `host.name`. This option can be set to `true` to disable the addition of this field to all events. The default value is `false`.