﻿---
title: Benchmark input
description: The Benchmark input generates generic events and sends them to the output. This can be useful when you want to benchmark the difference between outputs...
url: https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-benchmark
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Beta
---

# Benchmark input
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

The Benchmark input generates generic events and sends them to the output. This can be useful when you want to benchmark the difference between outputs or output settings.
Example configurations:
Basic example, infinite events as quickly as possible:
```yaml
filebeat.inputs:
- type: benchmark
  enabled: true
  message: "test message"
  threads: 1
```

Send 1024 events and stop example:
```yaml
filebeat.inputs:
- type: benchmark
  enabled: true
  message: "test message"
  threads: 1
  count: 1024
```

Send 5 events per second example:
```yaml
filebeat.inputs:
- type: benchmark
  enabled: true
  message: "test message"
  threads: 1
  eps: 5
```


## Configuration options

The Benchmark input supports the following configuration options plus the [Common options](#filebeat-input-benchmark-common-options) described later.

### `message`

This is the value that will be in the `message` field of the json document.

### `threads`

This is the number of goroutines that will be started generating messages. Normally 1 thread can saturate an output but if necessary this can be increased.

### `count`

This is the number of messages to send. 0 represents sending infinite messages. This is mutually exclusive with the `eps` option.

### `eps`

This is the number of events per second to send. 0 represents sending as quickly as possible. This is mutually exclusive with the `count` option.

## Metrics

This input exposes metrics under the [HTTP monitoring endpoint](https://www.elastic.co/docs/reference/beats/filebeat/http-endpoint). These metrics are exposed under the `/inputs` path. They can be used to observe the activity of the input.

| Metric                   | Description                                                          |
|--------------------------|----------------------------------------------------------------------|
| `events_published_total` | Number of events published.                                          |
| `publishing_time`        | Histogram of the elapsed in nanoseconds (time of publisher.Publish). |


## Common options

The following configuration options are supported by all inputs.

#### `enabled`

Use the `enabled` option to enable and disable inputs. By default, enabled is set to true.

#### `tags`

A list of tags that Filebeat includes in the `tags` field of each published event. Tags make it easy to select specific events in Kibana or apply conditional filtering in Logstash. These tags will be appended to the list of tags specified in the general configuration.
Example:
```yaml
filebeat.inputs:
- type: benchmark
  . . .
  tags: ["json"]
```


#### `fields`

Optional fields that you can specify to add additional information to the output. For example, you might add fields that you can use for filtering log data. Fields can be scalar values, arrays, dictionaries, or any nested combination of these. By default, the fields that you specify here will be grouped under a `fields` sub-dictionary in the output document. To store the custom fields as top-level fields, set the `fields_under_root` option to true. If a duplicate field is declared in the general configuration, then its value will be overwritten by the value declared here.
```yaml
filebeat.inputs:
- type: benchmark
  . . .
  fields:
    app_id: query_engine_12
```


#### `fields_under_root`

If this option is set to true, the custom [fields](#filebeat-input-benchmark-fields) are stored as top-level fields in the output document instead of being grouped under a `fields` sub-dictionary. If the custom field names conflict with other field names added by Filebeat, then the custom fields overwrite the other fields.

#### `processors`

A list of processors to apply to the input data.
See [Processors](https://www.elastic.co/docs/reference/beats/filebeat/filtering-enhancing-data) for information about specifying processors in your config.

#### `pipeline`

The ingest pipeline ID to set for the events generated by this input.
<note>
  The pipeline ID can also be configured in the Elasticsearch output, but this option usually results in simpler configuration files. If the pipeline is configured both in the input and output, the option from the input is used.
</note>

<important>
  The `pipeline` is always lowercased. If `pipeline: Foo-Bar`, then the pipeline name in Elasticsearch needs to be defined as `foo-bar`.
</important>


#### `keep_null`

If this option is set to true, fields with `null` values will be published in the output document. By default, `keep_null` is set to `false`.

#### `index`

If present, this formatted string overrides the index for events from this input (for elasticsearch outputs), or sets the `raw_index` field of the event’s metadata (for other outputs). This string can only refer to the agent name and version and the event timestamp; for access to dynamic fields, use `output.elasticsearch.index` or a processor.
Example value: `"%{[agent.name]}-myindex-%{+yyyy.MM.dd}"` might expand to `"filebeat-myindex-2019.11.01"`.

#### `publisher_pipeline.disable_host`

By default, all events contain `host.name`. This option can be set to `true` to disable the addition of this field to all events. The default value is `false`.