﻿---
title: Zoom fields
description: Module for handling incoming Zoom webhook requests Module for parsing Zoom API Webhooks. 
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-zoom
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Zoom fields
Module for handling incoming Zoom webhook requests

## zoom

Module for parsing Zoom API Webhooks.
<definitions>
  <definition term="zoom.master_account_id">
    Master Account related to a specific Sub Account
    type: keyword
  </definition>
  <definition term="zoom.sub_account_id">
    Related Sub Account
    type: keyword
  </definition>
  <definition term="zoom.operator_id">
    UserID that triggered the event
    type: keyword
  </definition>
  <definition term="zoom.operator">
    Username/Email related to the user that triggered the event
    type: keyword
  </definition>
  <definition term="zoom.account_id">
    Related accountID to the event
    type: keyword
  </definition>
  <definition term="zoom.timestamp">
    Timestamp related to the event
    type: date
  </definition>
  <definition term="zoom.creation_type">
    Creation type
    type: keyword
  </definition>
  <definition term="zoom.account.owner_id">
    UserID of the user whose sub account was created/disassociated
    type: keyword
  </definition>
  <definition term="zoom.account.email">
    Email related to the user the action was performed on
    type: keyword
  </definition>
  <definition term="zoom.account.owner_email">
    Email of the user whose sub account was created/disassociated
    type: keyword
  </definition>
  <definition term="zoom.account.account_name">
    When an account name is updated, this is the new value set
    type: keyword
  </definition>
  <definition term="zoom.account.account_alias">
    When an account alias is updated, this is the new value set
    type: keyword
  </definition>
  <definition term="zoom.account.account_support_name">
    When an account support_name is updated, this is the new value set
    type: keyword
  </definition>
  <definition term="zoom.account.account_support_email">
    When an account support_email is updated, this is the new value set
    type: keyword
  </definition>
  <definition term="zoom.chat_channel.name">
    The name of the channel that has been added/modified/deleted
    type: keyword
  </definition>
  <definition term="zoom.chat_channel.id">
    The ID of the channel that has been added/modified/deleted
    type: keyword
  </definition>
  <definition term="zoom.chat_channel.type">
    Type of channel related to the event. Can be 1(Invite-Only), 2(Private) or 3(Public)
    type: keyword
  </definition>
  <definition term="zoom.chat_message.id">
    Unique ID of the related chat message
    type: keyword
  </definition>
  <definition term="zoom.chat_message.type">
    Type of message, can be either "to_contact" or "to_channel"
    type: keyword
  </definition>
  <definition term="zoom.chat_message.session_id">
    SessionID for the channel related to the message
    type: keyword
  </definition>
  <definition term="zoom.chat_message.contact_email">
    Email address related to the user sending the message
    type: keyword
  </definition>
  <definition term="zoom.chat_message.contact_id">
    UserID belonging to the user receiving a message
    type: keyword
  </definition>
  <definition term="zoom.chat_message.channel_id">
    ChannelID related to the message
    type: keyword
  </definition>
  <definition term="zoom.chat_message.channel_name">
    Channel name related to the message
    type: keyword
  </definition>
  <definition term="zoom.chat_message.message">
    A string containing the full message that was sent
    type: keyword
  </definition>
  <definition term="zoom.meeting.id">
    Unique ID of the related meeting
    type: keyword
  </definition>
  <definition term="zoom.meeting.uuid">
    The UUID of the related meeting
    type: keyword
  </definition>
  <definition term="zoom.meeting.host_id">
    The UserID of the configured meeting host
    type: keyword
  </definition>
  <definition term="zoom.meeting.topic">
    Topic of the related meeting
    type: keyword
  </definition>
  <definition term="zoom.meeting.type">
    Type of meeting created
    type: keyword
  </definition>
  <definition term="zoom.meeting.start_time">
    Date and time the meeting started
    type: date
  </definition>
  <definition term="zoom.meeting.timezone">
    Which timezone is used for the meeting timestamps
    type: keyword
  </definition>
  <definition term="zoom.meeting.duration">
    The duration of a meeting in minutes
    type: long
  </definition>
  <definition term="zoom.meeting.issues">
    When a user reports an issue with the meeting, for example: "Unstable audio quality"
    type: keyword
  </definition>
  <definition term="zoom.meeting.password">
    Password related to the meeting
    type: keyword
  </definition>
  <definition term="zoom.phone.id">
    Unique ID for the phone or conversation
    type: keyword
  </definition>
  <definition term="zoom.phone.user_id">
    UserID for the phone owner related to a Call Log being completed
    type: keyword
  </definition>
  <definition term="zoom.phone.download_url">
    Download URL for the voicemail
    type: keyword
  </definition>
  <definition term="zoom.phone.ringing_start_time">
    The timestamp when a ringtone was established to the callee
    type: date
  </definition>
  <definition term="zoom.phone.connected_start_time">
    The date and time when a ringtone was established to the callee
    type: date
  </definition>
  <definition term="zoom.phone.answer_start_time">
    The date and time when the call was answered
    type: date
  </definition>
  <definition term="zoom.phone.call_end_time">
    The date and time when the call ended
    type: date
  </definition>
  <definition term="zoom.phone.call_id">
    Unique ID of the related call
    type: keyword
  </definition>
  <definition term="zoom.phone.duration">
    Duration of a voicemail in minutes
    type: long
  </definition>
  <definition term="zoom.phone.caller.id">
    UserID of the caller related to the voicemail/call
    type: keyword
  </definition>
  <definition term="zoom.phone.caller.user_id">
    UserID of the person which initiated the call
    type: keyword
  </definition>
  <definition term="zoom.phone.caller.number_type">
    The type of number, can be 1(Internal) or 2(External)
    type: keyword
  </definition>
  <definition term="zoom.phone.caller.name">
    The name of the related callee
    type: keyword
  </definition>
  <definition term="zoom.phone.caller.phone_number">
    Phone Number of the caller related to the call
    type: keyword
  </definition>
  <definition term="zoom.phone.caller.extension_type">
    Extension type of the caller number, can be user, callQueue, autoReceptionist or shareLineGroup
    type: keyword
  </definition>
  <definition term="zoom.phone.caller.extension_number">
    Extension number of the caller
    type: keyword
  </definition>
  <definition term="zoom.phone.caller.timezone">
    Timezone of the caller
    type: keyword
  </definition>
  <definition term="zoom.phone.caller.device_type">
    Device type used by the caller
    type: keyword
  </definition>
  <definition term="zoom.phone.callee.id">
    UserID of the callee related to the voicemail/call
    type: keyword
  </definition>
  <definition term="zoom.phone.callee.user_id">
    UserID of the related callee of a voicemail/call
    type: keyword
  </definition>
  <definition term="zoom.phone.callee.name">
    The name of the related callee
    type: keyword
  </definition>
  <definition term="zoom.phone.callee.number_type">
    The type of number, can be 1(Internal) or 2(External)
    type: keyword
  </definition>
  <definition term="zoom.phone.callee.phone_number">
    Phone Number of the callee related to the call
    type: keyword
  </definition>
  <definition term="zoom.phone.callee.extension_type">
    Extension type of the callee number, can be user, callQueue, autoReceptionist or shareLineGroup
    type: keyword
  </definition>
  <definition term="zoom.phone.callee.extension_number">
    Extension number of the callee related to the call
    type: keyword
  </definition>
  <definition term="zoom.phone.callee.timezone">
    Timezone of the callee related to the call
    type: keyword
  </definition>
  <definition term="zoom.phone.callee.device_type">
    Device type used by the callee related to the call
    type: keyword
  </definition>
  <definition term="zoom.phone.date_time">
    Date and time of the related phone event
    type: date
  </definition>
  <definition term="zoom.recording.id">
    Unique ID of the related recording
    type: keyword
  </definition>
  <definition term="zoom.recording.uuid">
    UUID of the related recording
    type: keyword
  </definition>
  <definition term="zoom.recording.host_id">
    UserID of the host of the meeting that was recorded
    type: keyword
  </definition>
  <definition term="zoom.recording.topic">
    Topic of the meeting related to the recording
    type: keyword
  </definition>
  <definition term="zoom.recording.type">
    Type of recording, can be multiple type of values, please check Zoom documentation
    type: keyword
  </definition>
  <definition term="zoom.recording.start_time">
    The date and time when the recording started
    type: date
  </definition>
  <definition term="zoom.recording.timezone">
    The timezone used for the recording date
    type: keyword
  </definition>
  <definition term="zoom.recording.duration">
    Duration of the recording in minutes
    type: long
  </definition>
  <definition term="zoom.recording.share_url">
    The URL to access the recording
    type: keyword
  </definition>
  <definition term="zoom.recording.total_size">
    Total size of the recording in bytes
    type: long
  </definition>
  <definition term="zoom.recording.recording_count">
    Number of recording files related to the recording
    type: long
  </definition>
  <definition term="zoom.recording.recording_file.recording_start">
    The date and time the recording started
    type: date
  </definition>
  <definition term="zoom.recording.recording_file.recording_end">
    The date and time the recording finished
    type: date
  </definition>
  <definition term="zoom.recording.host_email">
    Email address of the host related to the meeting that was recorded
    type: keyword
  </definition>
  <definition term="zoom.user.id">
    UserID related to the user event
    type: keyword
  </definition>
  <definition term="zoom.user.first_name">
    User first name related to the user event
    type: keyword
  </definition>
  <definition term="zoom.user.last_name">
    User last name related to the user event
    type: keyword
  </definition>
  <definition term="zoom.user.email">
    User email related to the user event
    type: keyword
  </definition>
  <definition term="zoom.user.type">
    User type related to the user event
    type: keyword
  </definition>
  <definition term="zoom.user.phone_number">
    User phone number related to the user event
    type: keyword
  </definition>
  <definition term="zoom.user.phone_country">
    User country code related to the user event
    type: keyword
  </definition>
  <definition term="zoom.user.company">
    User company related to the user event
    type: keyword
  </definition>
  <definition term="zoom.user.pmi">
    User personal meeting ID related to the user event
    type: keyword
  </definition>
  <definition term="zoom.user.use_pmi">
    If a user has PMI enabled
    type: boolean
  </definition>
  <definition term="zoom.user.pic_url">
    Full URL to the profile picture used by the user
    type: keyword
  </definition>
  <definition term="zoom.user.vanity_name">
    Name of the personal meeting room related to the user event
    type: keyword
  </definition>
  <definition term="zoom.user.timezone">
    Timezone configured for the user
    type: keyword
  </definition>
  <definition term="zoom.user.language">
    Language configured for the user
    type: keyword
  </definition>
  <definition term="zoom.user.host_key">
    Host key set for the user
    type: keyword
  </definition>
  <definition term="zoom.user.role">
    The configured role for the user
    type: keyword
  </definition>
  <definition term="zoom.user.dept">
    The configured departement for the user
    type: keyword
  </definition>
  <definition term="zoom.user.presence_status">
    Current presence status of user
    type: keyword
  </definition>
  <definition term="zoom.user.personal_notes">
    Personal notes for the User
    type: keyword
  </definition>
  <definition term="zoom.user.client_type">
    Type of client used by the user. Can be browser, mac, win, iphone or android
    type: keyword
  </definition>
  <definition term="zoom.user.version">
    Version of the client used by the user
    type: keyword
  </definition>
  <definition term="zoom.webinar.id">
    Unique ID for the related webinar
    type: keyword
  </definition>
  <definition term="zoom.webinar.join_url">
    The URL configured to join the webinar
    type: keyword
  </definition>
  <definition term="zoom.webinar.uuid">
    UUID for the related webinar
    type: keyword
  </definition>
  <definition term="zoom.webinar.host_id">
    UserID for the configured host of the webinar
    type: keyword
  </definition>
  <definition term="zoom.webinar.topic">
    Meeting topic of the related webinar
    type: keyword
  </definition>
  <definition term="zoom.webinar.type">
    Type of webinar created. Can be either 5(Webinar), 6(Recurring webinar without fixed time) or 9(Recurring webinar with fixed time)
    type: keyword
  </definition>
  <definition term="zoom.webinar.start_time">
    The date and time when the webinar started
    type: date
  </definition>
  <definition term="zoom.webinar.timezone">
    Timezone used for the dates related to the webinar
    type: keyword
  </definition>
  <definition term="zoom.webinar.duration">
    Duration of the webinar in minutes
    type: long
  </definition>
  <definition term="zoom.webinar.agenda">
    The configured agenda of the webinar
    type: keyword
  </definition>
  <definition term="zoom.webinar.password">
    Password configured to access the webinar
    type: keyword
  </definition>
  <definition term="zoom.webinar.issues">
    Any reported issues about a webinar is reported in this field
    type: keyword
  </definition>
  <definition term="zoom.zoomroom.id">
    Unique ID of the Zoom room
    type: keyword
  </definition>
  <definition term="zoom.zoomroom.room_name">
    The configured name of the Zoom room
    type: keyword
  </definition>
  <definition term="zoom.zoomroom.calendar_name">
    Calendar name of the Zoom room
    type: keyword
  </definition>
  <definition term="zoom.zoomroom.calendar_id">
    Unique ID of the calendar used by the Zoom room
    type: keyword
  </definition>
  <definition term="zoom.zoomroom.event_id">
    Unique ID of the calendar event associated with the Zoom Room
    type: keyword
  </definition>
  <definition term="zoom.zoomroom.change_key">
    Key used by Microsoft products integration that represents a specific version of a calendar
    type: keyword
  </definition>
  <definition term="zoom.zoomroom.resource_email">
    Email address associated with the calendar in use by the Zoom room
    type: keyword
  </definition>
  <definition term="zoom.zoomroom.email">
    Email address associated with the Zoom room itself
    type: keyword
  </definition>
  <definition term="zoom.zoomroom.issue">
    Any reported alerts or issues related to the Zoom room or its equipment
    type: keyword
  </definition>
  <definition term="zoom.zoomroom.alert_type">
    An integer value representing the type of alert. The list of alert types can be found in the Zoom documentation
    type: keyword
  </definition>
  <definition term="zoom.zoomroom.component">
    An integer value representing the type of equipment or component, The list of component types can be found in the Zoom documentation
    type: keyword
  </definition>
  <definition term="zoom.zoomroom.alert_kind">
    An integer value showing if the Zoom room alert has been either 1(Triggered) or 2(Cleared)
    type: keyword
  </definition>
  <definition term="zoom.registrant.id">
    Unique ID of the user registering to a meeting or webinar
    type: keyword
  </definition>
  <definition term="zoom.registrant.status">
    Status of the specific user registration
    type: keyword
  </definition>
  <definition term="zoom.registrant.email">
    Email of the user registering to a meeting or webinar
    type: keyword
  </definition>
  <definition term="zoom.registrant.first_name">
    First name of the user registering to a meeting or webinar
    type: keyword
  </definition>
  <definition term="zoom.registrant.last_name">
    Last name of the user registering to a meeting or webinar
    type: keyword
  </definition>
  <definition term="zoom.registrant.address">
    Address of the user registering to a meeting or webinar
    type: keyword
  </definition>
  <definition term="zoom.registrant.city">
    City of the user registering to a meeting or webinar
    type: keyword
  </definition>
  <definition term="zoom.registrant.country">
    Country of the user registering to a meeting or webinar
    type: keyword
  </definition>
  <definition term="zoom.registrant.zip">
    Zip code of the user registering to a meeting or webinar
    type: keyword
  </definition>
  <definition term="zoom.registrant.state">
    State of the user registering to a meeting or webinar
    type: keyword
  </definition>
  <definition term="zoom.registrant.phone">
    Phone number of the user registering to a meeting or webinar
    type: keyword
  </definition>
  <definition term="zoom.registrant.industry">
    Related industry of the user registering to a meeting or webinar
    type: keyword
  </definition>
  <definition term="zoom.registrant.org">
    Organization related to the user registering to a meeting or webinar
    type: keyword
  </definition>
  <definition term="zoom.registrant.job_title">
    Job title of the user registering to a meeting or webinar
    type: keyword
  </definition>
  <definition term="zoom.registrant.purchasing_time_frame">
    Choosen purchase timeframe of the user registering to a meeting or webinar
    type: keyword
  </definition>
  <definition term="zoom.registrant.role_in_purchase_process">
    Choosen role in a purchase process related to the user registering to a meeting or webinar
    type: keyword
  </definition>
  <definition term="zoom.registrant.no_of_employees">
    Number of employees choosen by the user registering to a meeting or webinar
    type: keyword
  </definition>
  <definition term="zoom.registrant.comments">
    Comments left by the user registering to a meeting or webinar
    type: keyword
  </definition>
  <definition term="zoom.registrant.join_url">
    The URL that the registrant can use to join the webinar
    type: keyword
  </definition>
  <definition term="zoom.participant.id">
    Unique ID of the participant related to a meeting
    type: keyword
  </definition>
  <definition term="zoom.participant.user_id">
    UserID of the participant related to a meeting
    type: keyword
  </definition>
  <definition term="zoom.participant.user_name">
    Username of the participant related to a meeting
    type: keyword
  </definition>
  <definition term="zoom.participant.join_time">
    The date and time a participant joined a meeting
    type: date
  </definition>
  <definition term="zoom.participant.leave_time">
    The date and time a participant left a meeting
    type: date
  </definition>
  <definition term="zoom.participant.sharing_details.link_source">
    Method of sharing with dropbox integration
    type: keyword
  </definition>
  <definition term="zoom.participant.sharing_details.content">
    Type of content that was shared
    type: keyword
  </definition>
  <definition term="zoom.participant.sharing_details.file_link">
    The file link that was shared
    type: keyword
  </definition>
  <definition term="zoom.participant.sharing_details.date_time">
    Timestamp the sharing started
    type: keyword
  </definition>
  <definition term="zoom.participant.sharing_details.source">
    The file source that was share
    type: keyword
  </definition>
  <definition term="zoom.old_values">
    Includes the old values when updating a object like user, meeting, account or webinar
    type: flattened
  </definition>
  <definition term="zoom.settings">
    The current active settings related to a object like user, meeting, account or webinar
    type: flattened
  </definition>
</definitions>