﻿---
title: Traefik fields
description: Module for parsing the Traefik log files. Fields from the Traefik log files. Contains fields for the Traefik access logs. 
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-traefik
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Traefik fields
Module for parsing the Traefik log files.

## traefik

Fields from the Traefik log files.

## access

Contains fields for the Traefik access logs.
<definitions>
  <definition term="traefik.access.user_identifier">
    Is the RFC 1413 identity of the client
    type: keyword
  </definition>
  <definition term="traefik.access.request_count">
    The number of requests
    type: long
  </definition>
  <definition term="traefik.access.frontend_name">
    The name of the frontend used
    type: keyword
  </definition>
  <definition term="traefik.access.backend_url">
    The url of the backend where request is forwarded
    type: keyword
  </definition>
  <definition term="traefik.access.body_sent.bytes">
    type: alias
    alias to: http.response.body.bytes
  </definition>
  <definition term="traefik.access.remote_ip">
    type: alias
    alias to: source.address
  </definition>
  <definition term="traefik.access.user_name">
    type: alias
    alias to: user.name
  </definition>
  <definition term="traefik.access.method">
    type: alias
    alias to: http.request.method
  </definition>
  <definition term="traefik.access.url">
    type: alias
    alias to: url.original
  </definition>
  <definition term="traefik.access.http_version">
    type: alias
    alias to: http.version
  </definition>
  <definition term="traefik.access.response_code">
    type: alias
    alias to: http.response.status_code
  </definition>
  <definition term="traefik.access.referrer">
    type: alias
    alias to: http.request.referrer
  </definition>
  <definition term="traefik.access.agent">
    type: alias
    alias to: user_agent.original
  </definition>
  <definition term="traefik.access.user_agent.name">
    type: alias
    alias to: user_agent.name
  </definition>
  <definition term="traefik.access.user_agent.os">
    type: alias
    alias to: user_agent.os.full_name
  </definition>
  <definition term="traefik.access.user_agent.os_name">
    type: alias
    alias to: user_agent.os.name
  </definition>
  <definition term="traefik.access.user_agent.original">
    type: alias
    alias to: user_agent.original
  </definition>
  <definition term="traefik.access.geoip.continent_name">
    type: alias
    alias to: source.geo.continent_name
  </definition>
  <definition term="traefik.access.geoip.country_iso_code">
    type: alias
    alias to: source.geo.country_iso_code
  </definition>
  <definition term="traefik.access.geoip.location">
    type: alias
    alias to: source.geo.location
  </definition>
  <definition term="traefik.access.geoip.region_name">
    type: alias
    alias to: source.geo.region_name
  </definition>
  <definition term="traefik.access.geoip.city_name">
    type: alias
    alias to: source.geo.city_name
  </definition>
  <definition term="traefik.access.geoip.region_iso_code">
    type: alias
    alias to: source.geo.region_iso_code
  </definition>
</definitions>