﻿---
title: Threat Intel fields
description: Threat intelligence Filebeat Module. Fields for AbuseCH Malware Threat Intel Fields for AbuseCH Malware Threat Intel Fields for Anomali Threat Intel Fields...
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-threatintel
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Threat Intel fields
Threat intelligence Filebeat Module.
<definitions>
  <definition term="threat.indicator.file.hash.tlsh">
    The file's import tlsh, if available.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.hash.sha384">
    The file's sha384 hash, if available.
    type: keyword
  </definition>
  <definition term="threat.feed.name">
    type: keyword
  </definition>
  <definition term="threat.feed.dashboard_id">
    type: keyword
  </definition>
</definitions>


## abusech.malware

Fields for AbuseCH Malware Threat Intel
<definitions>
  <definition term="abusech.malware.file_type">
    File type guessed by URLhaus.
    type: keyword
  </definition>
  <definition term="abusech.malware.signature">
    Malware familiy.
    type: keyword
  </definition>
  <definition term="abusech.malware.urlhaus_download">
    Location (URL) where you can download a copy of this file.
    type: keyword
  </definition>
  <definition term="abusech.malware.virustotal.result">
    AV detection ration.
    type: keyword
  </definition>
  <definition term="abusech.malware.virustotal.percent">
    AV detection in percent.
    type: float
  </definition>
  <definition term="abusech.malware.virustotal.link">
    Link to the Virustotal report.
    type: keyword
  </definition>
</definitions>


## abusech.url

Fields for AbuseCH Malware Threat Intel
<definitions>
  <definition term="abusech.url.id">
    The ID of the url.
    type: keyword
  </definition>
  <definition term="abusech.url.urlhaus_reference">
    Link to URLhaus entry.
    type: keyword
  </definition>
  <definition term="abusech.url.url_status">
    The current status of the URL. Possible values are: online, offline and unknown.
    type: keyword
  </definition>
  <definition term="abusech.url.threat">
    The threat corresponding to this malware URL.
    type: keyword
  </definition>
  <definition term="abusech.url.blacklists.surbl">
    SURBL blacklist status. Possible values are: listed and not_listed
    type: keyword
  </definition>
  <definition term="abusech.url.blacklists.spamhaus_dbl">
    Spamhaus DBL blacklist status.
    type: keyword
  </definition>
  <definition term="abusech.url.reporter">
    The Twitter handle of the reporter that has reported this malware URL (or anonymous).
    type: keyword
  </definition>
  <definition term="abusech.url.larted">
    Indicates whether the malware URL has been reported to the hosting provider (true or false)
    type: boolean
  </definition>
  <definition term="abusech.url.tags">
    A list of tags associated with the queried malware URL
    type: keyword
  </definition>
</definitions>


## anomali.limo

Fields for Anomali Threat Intel
<definitions>
  <definition term="anomali.limo.id">
    The ID of the indicator.
    type: keyword
  </definition>
  <definition term="anomali.limo.name">
    The name of the indicator.
    type: keyword
  </definition>
  <definition term="anomali.limo.pattern">
    The pattern ID of the indicator.
    type: keyword
  </definition>
  <definition term="anomali.limo.valid_from">
    When the indicator was first found or is considered valid.
    type: date
  </definition>
  <definition term="anomali.limo.modified">
    When the indicator was last modified
    type: date
  </definition>
  <definition term="anomali.limo.labels">
    The labels related to the indicator
    type: keyword
  </definition>
  <definition term="anomali.limo.indicator">
    The value of the indicator, for example if the type is domain, this would be the value.
    type: keyword
  </definition>
  <definition term="anomali.limo.description">
    A description of the indicator.
    type: keyword
  </definition>
  <definition term="anomali.limo.title">
    Title describing the indicator.
    type: keyword
  </definition>
  <definition term="anomali.limo.content">
    Extra text or descriptive content related to the indicator.
    type: keyword
  </definition>
  <definition term="anomali.limo.type">
    The indicator type, can for example be "domain, email, FileHash-SHA256".
    type: keyword
  </definition>
  <definition term="anomali.limo.object_marking_refs">
    The STIX reference object.
    type: keyword
  </definition>
</definitions>


## anomali.threatstream

Fields for Anomali ThreatStream
<definitions>
  <definition term="anomali.threatstream.classification">
    Indicates whether an indicator is private or from a public feed and available publicly. Possible values: private, public.
    type: keyword
    example: private
  </definition>
  <definition term="anomali.threatstream.confidence">
    The measure of the accuracy (from 0 to 100) assigned by ThreatStream's predictive analytics technology to indicators.
    type: short
  </definition>
  <definition term="anomali.threatstream.detail2">
    Detail text for indicator.
    type: text
    example: Imported by user 42.
  </definition>
  <definition term="anomali.threatstream.id">
    The ID of the indicator.
    type: keyword
  </definition>
  <definition term="anomali.threatstream.import_session_id">
    ID of the import session that created the indicator on ThreatStream.
    type: keyword
  </definition>
  <definition term="anomali.threatstream.itype">
    Indicator type. Possible values: "apt_domain", "apt_email", "apt_ip", "apt_url", "bot_ip", "c2_domain", "c2_ip", "c2_url", "i2p_ip", "mal_domain", "mal_email", "mal_ip", "mal_md5", "mal_url", "parked_ip", "phish_email", "phish_ip", "phish_url", "scan_ip", "spam_domain", "ssh_ip", "suspicious_domain", "tor_ip" and "torrent_tracker_url".
    type: keyword
  </definition>
  <definition term="anomali.threatstream.maltype">
    Information regarding a malware family, a CVE ID, or another attack or threat, associated with the indicator.
    type: wildcard
  </definition>
  <definition term="anomali.threatstream.md5">
    Hash for the indicator.
    type: keyword
  </definition>
  <definition term="anomali.threatstream.resource_uri">
    Relative URI for the indicator details.
    type: keyword
  </definition>
  <definition term="anomali.threatstream.severity">
    Criticality associated with the threat feed that supplied the indicator. Possible values: low, medium, high, very-high.
    type: keyword
  </definition>
  <definition term="anomali.threatstream.source">
    Source for the indicator.
    type: keyword
    example: Analyst
  </definition>
  <definition term="anomali.threatstream.source_feed_id">
    ID for the integrator source.
    type: keyword
  </definition>
  <definition term="anomali.threatstream.state">
    State for this indicator.
    type: keyword
    example: active
  </definition>
  <definition term="anomali.threatstream.trusted_circle_ids">
    ID of the trusted circle that imported the indicator.
    type: keyword
  </definition>
  <definition term="anomali.threatstream.update_id">
    Update ID.
    type: keyword
  </definition>
  <definition term="anomali.threatstream.url">
    URL for the indicator.
    type: keyword
  </definition>
  <definition term="anomali.threatstream.value_type">
    Data type of the indicator. Possible values: ip, domain, url, email, md5.
    type: keyword
  </definition>
</definitions>


## abusech.malwarebazaar

Fields for Malware Bazaar Threat Intel
<definitions>
  <definition term="abusech.malwarebazaar.file_type">
    File type guessed by Malware Bazaar.
    type: keyword
  </definition>
  <definition term="abusech.malwarebazaar.signature">
    Malware familiy.
    type: keyword
  </definition>
  <definition term="abusech.malwarebazaar.tags">
    A list of tags associated with the queried malware sample.
    type: keyword
  </definition>
  <definition term="abusech.malwarebazaar.intelligence.downloads">
    Number of downloads from MalwareBazaar.
    type: long
  </definition>
  <definition term="abusech.malwarebazaar.intelligence.uploads">
    Number of uploads from MalwareBazaar.
    type: long
  </definition>
  <definition term="abusech.malwarebazaar.intelligence.mail.Generic">
    Malware seen in generic spam traffic.
    type: keyword
  </definition>
  <definition term="abusech.malwarebazaar.intelligence.mail.IT">
    Malware seen in IT spam traffic.
    type: keyword
  </definition>
  <definition term="abusech.malwarebazaar.anonymous">
    Identifies if the sample was submitted anonymously.
    type: long
  </definition>
  <definition term="abusech.malwarebazaar.code_sign">
    Code signing information for the sample.
    type: nested
  </definition>
</definitions>


## misp

Fields for MISP Threat Intel
<definitions>
  <definition term="misp.id">
    Attribute ID.
    type: keyword
  </definition>
  <definition term="misp.orgc_id">
    Organization Community ID of the event.
    type: keyword
  </definition>
  <definition term="misp.org_id">
    Organization ID of the event.
    type: keyword
  </definition>
  <definition term="misp.threat_level_id">
    Threat level from 5 to 1, where 1 is the most critical.
    type: long
  </definition>
  <definition term="misp.info">
    Additional text or information related to the event.
    type: keyword
  </definition>
  <definition term="misp.published">
    When the event was published.
    type: boolean
  </definition>
  <definition term="misp.uuid">
    The UUID of the event object.
    type: keyword
  </definition>
  <definition term="misp.date">
    The date of when the event object was created.
    type: date
  </definition>
  <definition term="misp.attribute_count">
    How many attributes are included in a single event object.
    type: long
  </definition>
  <definition term="misp.timestamp">
    The timestamp of when the event object was created.
    type: date
  </definition>
  <definition term="misp.distribution">
    Distribution type related to MISP.
    type: keyword
  </definition>
  <definition term="misp.proposal_email_lock">
    Settings configured on MISP for email lock on this event object.
    type: boolean
  </definition>
  <definition term="misp.locked">
    If the current MISP event object is locked or not.
    type: boolean
  </definition>
  <definition term="misp.publish_timestamp">
    At what time the event object was published
    type: date
  </definition>
  <definition term="misp.sharing_group_id">
    The ID of the grouped events or sources of the event.
    type: keyword
  </definition>
  <definition term="misp.disable_correlation">
    If correlation is disabled on the MISP event object.
    type: boolean
  </definition>
  <definition term="misp.extends_uuid">
    The UUID of the event object it might extend.
    type: keyword
  </definition>
  <definition term="misp.org.id">
    The organization ID related to the event object.
    type: keyword
  </definition>
  <definition term="misp.org.name">
    The organization name related to the event object.
    type: keyword
  </definition>
  <definition term="misp.org.uuid">
    The UUID of the organization related to the event object.
    type: keyword
  </definition>
  <definition term="misp.org.local">
    If the event object is local or from a remote source.
    type: boolean
  </definition>
  <definition term="misp.orgc.id">
    The Organization Community ID in which the event object was reported from.
    type: keyword
  </definition>
  <definition term="misp.orgc.name">
    The Organization Community name in which the event object was reported from.
    type: keyword
  </definition>
  <definition term="misp.orgc.uuid">
    The Organization Community UUID in which the event object was reported from.
    type: keyword
  </definition>
  <definition term="misp.orgc.local">
    If the Organization Community was local or synced from a remote source.
    type: boolean
  </definition>
  <definition term="misp.attribute.id">
    The ID of the attribute related to the event object.
    type: keyword
  </definition>
  <definition term="misp.attribute.type">
    The type of the attribute related to the event object. For example email, ipv4, sha1 and such.
    type: keyword
  </definition>
  <definition term="misp.attribute.category">
    The category of the attribute related to the event object. For example "Network Activity".
    type: keyword
  </definition>
  <definition term="misp.attribute.to_ids">
    If the attribute should be automatically synced with an IDS.
    type: boolean
  </definition>
  <definition term="misp.attribute.uuid">
    The UUID of the attribute related to the event.
    type: keyword
  </definition>
  <definition term="misp.attribute.event_id">
    The local event ID of the attribute related to the event.
    type: keyword
  </definition>
  <definition term="misp.attribute.distribution">
    How the attribute has been distributed, represented by integer numbers.
    type: long
  </definition>
  <definition term="misp.attribute.timestamp">
    The timestamp in which the attribute was attached to the event object.
    type: date
  </definition>
  <definition term="misp.attribute.comment">
    Comments made to the attribute itself.
    type: keyword
  </definition>
  <definition term="misp.attribute.sharing_group_id">
    The group ID of the sharing group related to the specific attribute.
    type: keyword
  </definition>
  <definition term="misp.attribute.deleted">
    If the attribute has been removed from the event object.
    type: boolean
  </definition>
  <definition term="misp.attribute.disable_correlation">
    If correlation has been enabled on the attribute related to the event object.
    type: boolean
  </definition>
  <definition term="misp.attribute.object_id">
    The ID of the Object in which the attribute is attached.
    type: keyword
  </definition>
  <definition term="misp.attribute.object_relation">
    The type of relation the attribute has with the event object itself.
    type: keyword
  </definition>
  <definition term="misp.attribute.value">
    The value of the attribute, depending on the type like "url, sha1, email-src".
    type: keyword
  </definition>
  <definition term="misp.context.attribute.id">
    The ID of the secondary attribute related to the event object.
    type: keyword
  </definition>
  <definition term="misp.context.attribute.type">
    The type of the secondary attribute related to the event object. For example email, ipv4, sha1 and such.
    type: keyword
  </definition>
  <definition term="misp.context.attribute.category">
    The category of the secondary attribute related to the event object. For example "Network Activity".
    type: keyword
  </definition>
  <definition term="misp.context.attribute.to_ids">
    If the secondary attribute should be automatically synced with an IDS.
    type: boolean
  </definition>
  <definition term="misp.context.attribute.uuid">
    The UUID of the secondary attribute related to the event.
    type: keyword
  </definition>
  <definition term="misp.context.attribute.event_id">
    The local event ID of the secondary attribute related to the event.
    type: keyword
  </definition>
  <definition term="misp.context.attribute.distribution">
    How the secondary attribute has been distributed, represented by integer numbers.
    type: long
  </definition>
  <definition term="misp.context.attribute.timestamp">
    The timestamp in which the secondary attribute was attached to the event object.
    type: date
  </definition>
  <definition term="misp.context.attribute.comment">
    Comments made to the secondary attribute itself.
    type: keyword
  </definition>
  <definition term="misp.context.attribute.sharing_group_id">
    The group ID of the sharing group related to the specific secondary attribute.
    type: keyword
  </definition>
  <definition term="misp.context.attribute.deleted">
    If the secondary attribute has been removed from the event object.
    type: boolean
  </definition>
  <definition term="misp.context.attribute.disable_correlation">
    If correlation has been enabled on the secondary attribute related to the event object.
    type: boolean
  </definition>
  <definition term="misp.context.attribute.object_id">
    The ID of the Object in which the secondary attribute is attached.
    type: keyword
  </definition>
  <definition term="misp.context.attribute.object_relation">
    The type of relation the secondary attribute has with the event object itself.
    type: keyword
  </definition>
  <definition term="misp.context.attribute.value">
    The value of the attribute, depending on the type like "url, sha1, email-src".
    type: keyword
  </definition>
</definitions>


## otx

Fields for OTX Threat Intel
<definitions>
  <definition term="otx.id">
    The ID of the indicator.
    type: keyword
  </definition>
  <definition term="otx.indicator">
    The value of the indicator, for example if the type is domain, this would be the value.
    type: keyword
  </definition>
  <definition term="otx.description">
    A description of the indicator.
    type: keyword
  </definition>
  <definition term="otx.title">
    Title describing the indicator.
    type: keyword
  </definition>
  <definition term="otx.content">
    Extra text or descriptive content related to the indicator.
    type: keyword
  </definition>
  <definition term="otx.type">
    The indicator type, can for example be "domain, email, FileHash-SHA256".
    type: keyword
  </definition>
</definitions>


## threatq

Fields for ThreatQ Threat Library
<definitions>
  <definition term="threatq.updated_at">
    Last modification time
    type: date
  </definition>
  <definition term="threatq.created_at">
    Object creation time
    type: date
  </definition>
  <definition term="threatq.expires_at">
    Expiration time
    type: date
  </definition>
  <definition term="threatq.expires_calculated_at">
    Expiration calculation time
    type: date
  </definition>
  <definition term="threatq.published_at">
    Object publication time
    type: date
  </definition>
  <definition term="threatq.status">
    Object status within the Threat Library
    type: keyword
  </definition>
  <definition term="threatq.indicator_value">
    Original indicator value
    type: keyword
  </definition>
  <definition term="threatq.adversaries">
    Adversaries that are linked to the object
    type: keyword
  </definition>
  <definition term="threatq.attributes">
    These provide additional context about an object
    type: flattened
  </definition>
</definitions>