﻿---
title: System fields
description: Module for parsing system log files. Fields from the system log files. Fields from the Linux authorization logs. Fields specific to events created by...
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-system
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# System fields
Module for parsing system log files.

## system

Fields from the system log files.

## auth

Fields from the Linux authorization logs.
<definitions>
  <definition term="system.auth.timestamp">
    type: alias
    alias to: @timestamp
  </definition>
  <definition term="system.auth.hostname">
    type: alias
    alias to: host.hostname
  </definition>
  <definition term="system.auth.program">
    type: alias
    alias to: process.name
  </definition>
  <definition term="system.auth.pid">
    type: alias
    alias to: process.pid
  </definition>
  <definition term="system.auth.message">
    type: alias
    alias to: message
  </definition>
  <definition term="system.auth.user">
    type: alias
    alias to: user.name
  </definition>
  <definition term="system.auth.ssh.method">
    The SSH authentication method. Can be one of "password" or "publickey".
  </definition>
  <definition term="system.auth.ssh.signature">
    The signature of the client public key.
  </definition>
  <definition term="system.auth.ssh.dropped_ip">
    The client IP from SSH connections that are open and immediately dropped.
    type: ip
  </definition>
  <definition term="system.auth.ssh.event">
    The SSH event as found in the logs (Accepted, Invalid, Failed, etc.)
    example: Accepted
  </definition>
  <definition term="system.auth.ssh.ip">
    type: alias
    alias to: source.ip
  </definition>
  <definition term="system.auth.ssh.port">
    type: alias
    alias to: source.port
  </definition>
  <definition term="system.auth.ssh.geoip.continent_name">
    type: alias
    alias to: source.geo.continent_name
  </definition>
  <definition term="system.auth.ssh.geoip.country_iso_code">
    type: alias
    alias to: source.geo.country_iso_code
  </definition>
  <definition term="system.auth.ssh.geoip.location">
    type: alias
    alias to: source.geo.location
  </definition>
  <definition term="system.auth.ssh.geoip.region_name">
    type: alias
    alias to: source.geo.region_name
  </definition>
  <definition term="system.auth.ssh.geoip.city_name">
    type: alias
    alias to: source.geo.city_name
  </definition>
  <definition term="system.auth.ssh.geoip.region_iso_code">
    type: alias
    alias to: source.geo.region_iso_code
  </definition>
</definitions>


## sudo

Fields specific to events created by the `sudo` command.
<definitions>
  <definition term="system.auth.sudo.error">
    The error message in case the sudo command failed.
    example: user NOT in sudoers
  </definition>
  <definition term="system.auth.sudo.tty">
    The TTY where the sudo command is executed.
  </definition>
  <definition term="system.auth.sudo.pwd">
    The current directory where the sudo command is executed.
  </definition>
  <definition term="system.auth.sudo.user">
    The target user to which the sudo command is switching.
    example: root
  </definition>
  <definition term="system.auth.sudo.command">
    The command executed via sudo.
  </definition>
</definitions>


## useradd

Fields specific to events created by the `useradd` command.
<definitions>
  <definition term="system.auth.useradd.home">
    The home folder for the new user.
  </definition>
  <definition term="system.auth.useradd.shell">
    The default shell for the new user.
  </definition>
  <definition term="system.auth.useradd.name">
    type: alias
    alias to: user.name
  </definition>
  <definition term="system.auth.useradd.uid">
    type: alias
    alias to: user.id
  </definition>
  <definition term="system.auth.useradd.gid">
    type: alias
    alias to: group.id
  </definition>
</definitions>


## groupadd

Fields specific to events created by the `groupadd` command.
<definitions>
  <definition term="system.auth.groupadd.name">
    type: alias
    alias to: group.name
  </definition>
  <definition term="system.auth.groupadd.gid">
    type: alias
    alias to: group.id
  </definition>
</definitions>


## syslog

Contains fields from the syslog system logs.
<definitions>
  <definition term="system.syslog.timestamp">
    type: alias
    alias to: @timestamp
  </definition>
  <definition term="system.syslog.hostname">
    type: alias
    alias to: host.hostname
  </definition>
  <definition term="system.syslog.program">
    type: alias
    alias to: process.name
  </definition>
  <definition term="system.syslog.pid">
    type: alias
    alias to: process.pid
  </definition>
  <definition term="system.syslog.message">
    type: alias
    alias to: message
  </definition>
</definitions>