﻿---
title: Sophos fields
description: sophos Module Module for parsing sophosxg syslog. 
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-sophos
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Sophos fields
sophos Module

## sophos.xg

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Module for parsing sophosxg syslog.
<definitions>
  <definition term="sophos.xg.action">
    Event Action
    type: keyword
  </definition>
  <definition term="sophos.xg.activityname">
    Web policy activity that matched and caused the policy result.
    type: keyword
  </definition>
  <definition term="sophos.xg.ap">
    Access Point Serial ID or LocalWifi0 or LocalWifi1.
    type: keyword
  </definition>
  <definition term="sophos.xg.app_category">
    Name of the category under which application falls
    type: keyword
  </definition>
  <definition term="sophos.xg.app_filter_policy_id">
    Application filter policy ID applied on the traffic
    type: keyword
  </definition>
  <definition term="sophos.xg.app_is_cloud">
    Application is Cloud
    type: keyword
  </definition>
  <definition term="sophos.xg.app_name">
    Application name
    type: keyword
  </definition>
  <definition term="sophos.xg.app_resolved_by">
    Application is resolved by signature or synchronized application
    type: keyword
  </definition>
  <definition term="sophos.xg.app_risk">
    Risk level assigned to the application
    type: keyword
  </definition>
  <definition term="sophos.xg.app_technology">
    Technology of the application
    type: keyword
  </definition>
  <definition term="sophos.xg.appfilter_policy_id">
    Application Filter policy applied on the traffic
    type: integer
  </definition>
  <definition term="sophos.xg.application">
    Application name
    type: keyword
  </definition>
  <definition term="sophos.xg.application_category">
    Application is resolved by signature or synchronized application
    type: keyword
  </definition>
  <definition term="sophos.xg.application_filter_policy">
    Application Filter policy applied on the traffic
    type: integer
  </definition>
  <definition term="sophos.xg.application_name">
    Application name
    type: keyword
  </definition>
  <definition term="sophos.xg.application_risk">
    Risk level assigned to the application
    type: keyword
  </definition>
  <definition term="sophos.xg.application_technology">
    Technology of the application
    type: keyword
  </definition>
  <definition term="sophos.xg.appresolvedby">
    Technology of the application
    type: keyword
  </definition>
  <definition term="sophos.xg.auth_client">
    Auth Client
    type: keyword
  </definition>
  <definition term="sophos.xg.auth_mechanism">
    Auth mechanism
    type: keyword
  </definition>
  <definition term="sophos.xg.av_policy_name">
    Malware scanning policy name which is applied on the traffic
    type: keyword
  </definition>
  <definition term="sophos.xg.backup_mode">
    Backup mode
    type: keyword
  </definition>
  <definition term="sophos.xg.branch_name">
    Branch Name
    type: keyword
  </definition>
  <definition term="sophos.xg.category">
    IPS signature category.
    type: keyword
  </definition>
  <definition term="sophos.xg.category_type">
    Type of category under which website falls
    type: keyword
  </definition>
  <definition term="sophos.xg.classification">
    Signature classification
    type: keyword
  </definition>
  <definition term="sophos.xg.client_host_name">
    Client host name
    type: keyword
  </definition>
  <definition term="sophos.xg.client_physical_address">
    Client physical address
    type: keyword
  </definition>
  <definition term="sophos.xg.clients_conn_ssid">
    Number of client connected to the SSID.
    type: long
  </definition>
  <definition term="sophos.xg.collisions">
    collisions
    type: long
  </definition>
  <definition term="sophos.xg.con_event">
    Event Start/Stop
    type: keyword
  </definition>
  <definition term="sophos.xg.con_id">
    Unique identifier of connection
    type: integer
  </definition>
  <definition term="sophos.xg.configuration">
    Configuration
    type: float
  </definition>
  <definition term="sophos.xg.conn_id">
    Unique identifier of connection
    type: integer
  </definition>
  <definition term="sophos.xg.connectionname">
    Connectionname
    type: keyword
  </definition>
  <definition term="sophos.xg.connectiontype">
    Connectiontype
    type: keyword
  </definition>
  <definition term="sophos.xg.connevent">
    Event on which this log is generated
    type: keyword
  </definition>
  <definition term="sophos.xg.connid">
    Connection ID
    type: keyword
  </definition>
  <definition term="sophos.xg.content_type">
    Type of the content
    type: keyword
  </definition>
  <definition term="sophos.xg.contenttype">
    Type of the content
    type: keyword
  </definition>
  <definition term="sophos.xg.context_match">
    Context Match
    type: keyword
  </definition>
  <definition term="sophos.xg.context_prefix">
    Content Prefix
    type: keyword
  </definition>
  <definition term="sophos.xg.context_suffix">
    Context Suffix
    type: keyword
  </definition>
  <definition term="sophos.xg.cookie">
    cookie
    type: keyword
  </definition>
  <definition term="sophos.xg.date">
    Date (yyyy-mm-dd) when the event occurred
    type: date
  </definition>
  <definition term="sophos.xg.destinationip">
    Original destination IP address of traffic
    type: ip
  </definition>
  <definition term="sophos.xg.device">
    device
    type: keyword
  </definition>
  <definition term="sophos.xg.device_id">
    Serial number of the device
    type: keyword
  </definition>
  <definition term="sophos.xg.device_model">
    Model number of the device
    type: keyword
  </definition>
  <definition term="sophos.xg.device_name">
    Model number of the device
    type: keyword
  </definition>
  <definition term="sophos.xg.dictionary_name">
    Dictionary Name
    type: keyword
  </definition>
  <definition term="sophos.xg.dir_disp">
    TPacket direction. Possible values:“org”, “reply”, “”
    type: keyword
  </definition>
  <definition term="sophos.xg.direction">
    Direction
    type: keyword
  </definition>
  <definition term="sophos.xg.domainname">
    Domain from which virus was downloaded
    type: keyword
  </definition>
  <definition term="sophos.xg.download_file_name">
    Download file name
    type: keyword
  </definition>
  <definition term="sophos.xg.download_file_type">
    Download file type
    type: keyword
  </definition>
  <definition term="sophos.xg.dst_country_code">
    Code of the country to which the destination IP belongs
    type: keyword
  </definition>
  <definition term="sophos.xg.dst_domainname">
    Receiver domain name
    type: keyword
  </definition>
  <definition term="sophos.xg.dst_ip">
    Original destination IP address of traffic
    type: ip
  </definition>
  <definition term="sophos.xg.dst_port">
    Original destination port of TCP and UDP traffic
    type: integer
  </definition>
  <definition term="sophos.xg.dst_zone_type">
    Type of destination zone
    type: keyword
  </definition>
  <definition term="sophos.xg.dstdomain">
    Destination Domain
    type: keyword
  </definition>
  <definition term="sophos.xg.duration">
    Durability of traffic (seconds)
    type: long
  </definition>
  <definition term="sophos.xg.email_subject">
    Email Subject
    type: keyword
  </definition>
  <definition term="sophos.xg.ep_uuid">
    Endpoint UUID
    type: keyword
  </definition>
  <definition term="sophos.xg.ether_type">
    ethernet frame type
    type: keyword
  </definition>
  <definition term="sophos.xg.eventid">
    ATP Evenet ID
    type: keyword
  </definition>
  <definition term="sophos.xg.eventtime">
    Event time
    type: date
  </definition>
  <definition term="sophos.xg.eventtype">
    ATP event type
    type: keyword
  </definition>
  <definition term="sophos.xg.exceptions">
    List of the checks excluded by web exceptions.
    type: keyword
  </definition>
  <definition term="sophos.xg.execution_path">
    ATP execution path
    type: keyword
  </definition>
  <definition term="sophos.xg.extra">
    extra
    type: keyword
  </definition>
  <definition term="sophos.xg.file_name">
    Filename
    type: keyword
  </definition>
  <definition term="sophos.xg.file_path">
    File path
    type: keyword
  </definition>
  <definition term="sophos.xg.file_size">
    File Size
    type: integer
  </definition>
  <definition term="sophos.xg.filename">
    File name associated with the event
    type: keyword
  </definition>
  <definition term="sophos.xg.filepath">
    Path of the file containing virus
    type: keyword
  </definition>
  <definition term="sophos.xg.filesize">
    Size of the file that contained virus
    type: integer
  </definition>
  <definition term="sophos.xg.free">
    free
    type: integer
  </definition>
  <definition term="sophos.xg.from_email_address">
    Sender email address
    type: keyword
  </definition>
  <definition term="sophos.xg.ftp_direction">
    Direction of FTP transfer: Upload or Download
    type: keyword
  </definition>
  <definition term="sophos.xg.ftp_url">
    FTP URL from which virus was downloaded
    type: keyword
  </definition>
  <definition term="sophos.xg.ftpcommand">
    FTP command used when virus was found
    type: keyword
  </definition>
  <definition term="sophos.xg.fw_rule_id">
    Firewall Rule ID which is applied on the traffic
    type: integer
  </definition>
  <definition term="sophos.xg.fw_rule_type">
    Firewall rule type which is applied on the traffic
    type: keyword
  </definition>
  <definition term="sophos.xg.hb_health">
    Heartbeat status
    type: keyword
  </definition>
  <definition term="sophos.xg.hb_status">
    Heartbeat status
    type: keyword
  </definition>
  <definition term="sophos.xg.host">
    Host
    type: keyword
  </definition>
  <definition term="sophos.xg.http_category">
    HTTP Category
    type: keyword
  </definition>
  <definition term="sophos.xg.http_category_type">
    HTTP Category Type
    type: keyword
  </definition>
  <definition term="sophos.xg.httpresponsecode">
    code of HTTP response
    type: long
  </definition>
  <definition term="sophos.xg.iap">
    Internet Access policy ID applied on the traffic
    type: keyword
  </definition>
  <definition term="sophos.xg.icmp_code">
    ICMP code of ICMP traffic
    type: keyword
  </definition>
  <definition term="sophos.xg.icmp_type">
    ICMP type of ICMP traffic
    type: keyword
  </definition>
  <definition term="sophos.xg.idle_cpu">
    idle ##
    type: float
  </definition>
  <definition term="sophos.xg.idp_policy_id">
    IPS policy ID which is applied on the traffic
    type: integer
  </definition>
  <definition term="sophos.xg.idp_policy_name">
    IPS policy name i.e. IPS policy name which is applied on the traffic
    type: keyword
  </definition>
  <definition term="sophos.xg.in_interface">
    Interface for incoming traffic, e.g., Port A
    type: keyword
  </definition>
  <definition term="sophos.xg.interface">
    interface
    type: keyword
  </definition>
  <definition term="sophos.xg.ipaddress">
    Ipaddress
    type: keyword
  </definition>
  <definition term="sophos.xg.ips_policy_id">
    IPS policy ID applied on the traffic
    type: integer
  </definition>
  <definition term="sophos.xg.lease_time">
    Lease Time
    type: keyword
  </definition>
  <definition term="sophos.xg.localgateway">
    Localgateway
    type: keyword
  </definition>
  <definition term="sophos.xg.localnetwork">
    Localnetwork
    type: keyword
  </definition>
  <definition term="sophos.xg.log_component">
    Component responsible for logging e.g. Firewall rule
    type: keyword
  </definition>
  <definition term="sophos.xg.log_id">
    Unique 12 characters code (0101011)
    type: keyword
  </definition>
  <definition term="sophos.xg.log_subtype">
    Sub type of event
    type: keyword
  </definition>
  <definition term="sophos.xg.log_type">
    Type of event e.g. firewall event
    type: keyword
  </definition>
  <definition term="sophos.xg.log_version">
    Log Version
    type: keyword
  </definition>
  <definition term="sophos.xg.login_user">
    ATP login user
    type: keyword
  </definition>
  <definition term="sophos.xg.mailid">
    mailid
    type: keyword
  </definition>
  <definition term="sophos.xg.mailsize">
    mailsize
    type: integer
  </definition>
  <definition term="sophos.xg.message">
    Message
    type: keyword
  </definition>
  <definition term="sophos.xg.mode">
    Mode
    type: keyword
  </definition>
  <definition term="sophos.xg.nat_rule_id">
    NAT Rule ID
    type: keyword
  </definition>
  <definition term="sophos.xg.newversion">
    Newversion
    type: keyword
  </definition>
  <definition term="sophos.xg.oldversion">
    Oldversion
    type: keyword
  </definition>
  <definition term="sophos.xg.out_interface">
    Interface for outgoing traffic, e.g., Port B
    type: keyword
  </definition>
  <definition term="sophos.xg.override_authorizer">
    Override authorizer
    type: keyword
  </definition>
  <definition term="sophos.xg.override_name">
    Override name
    type: keyword
  </definition>
  <definition term="sophos.xg.override_token">
    Override token
    type: keyword
  </definition>
  <definition term="sophos.xg.phpsessid">
    PHP session ID
    type: keyword
  </definition>
  <definition term="sophos.xg.platform">
    Platform of the traffic.
    type: keyword
  </definition>
  <definition term="sophos.xg.policy_type">
    Policy type applied to the traffic
    type: keyword
  </definition>
  <definition term="sophos.xg.priority">
    Severity level of traffic
    type: keyword
  </definition>
  <definition term="sophos.xg.protocol">
    Protocol number of traffic
    type: keyword
  </definition>
  <definition term="sophos.xg.qualifier">
    Qualifier
    type: keyword
  </definition>
  <definition term="sophos.xg.quarantine">
    Path and filename of the file quarantined
    type: keyword
  </definition>
  <definition term="sophos.xg.quarantine_reason">
    Quarantine reason
    type: keyword
  </definition>
  <definition term="sophos.xg.querystring">
    querystring
    type: keyword
  </definition>
  <definition term="sophos.xg.raw_data">
    Raw data
    type: keyword
  </definition>
  <definition term="sophos.xg.received_pkts">
    Total number of packets received
    type: long
  </definition>
  <definition term="sophos.xg.receiveddrops">
    received drops
    type: long
  </definition>
  <definition term="sophos.xg.receivederrors">
    received errors
    type: keyword
  </definition>
  <definition term="sophos.xg.receivedkbits">
    received kbits
    type: long
  </definition>
  <definition term="sophos.xg.recv_bytes">
    Total number of bytes received
    type: long
  </definition>
  <definition term="sophos.xg.red_id">
    RED ID
    type: keyword
  </definition>
  <definition term="sophos.xg.referer">
    Referer
    type: keyword
  </definition>
  <definition term="sophos.xg.remote_ip">
    Remote IP
    type: ip
  </definition>
  <definition term="sophos.xg.remotenetwork">
    remotenetwork
    type: keyword
  </definition>
  <definition term="sophos.xg.reported_host">
    Reported Host
    type: keyword
  </definition>
  <definition term="sophos.xg.reported_ip">
    Reported IP
    type: keyword
  </definition>
  <definition term="sophos.xg.reports">
    Reports
    type: float
  </definition>
  <definition term="sophos.xg.rule_priority">
    Priority of IPS policy
    type: keyword
  </definition>
  <definition term="sophos.xg.sent_bytes">
    Total number of bytes sent
    type: long
  </definition>
  <definition term="sophos.xg.sent_pkts">
    Total number of packets sent
    type: long
  </definition>
  <definition term="sophos.xg.server">
    Server
    type: keyword
  </definition>
  <definition term="sophos.xg.sessionid">
    Sessionid
    type: keyword
  </definition>
  <definition term="sophos.xg.sha1sum">
    SHA1 checksum of the item being analyzed
    type: keyword
  </definition>
  <definition term="sophos.xg.signature">
    Signature
    type: float
  </definition>
  <definition term="sophos.xg.signature_id">
    Signature ID
    type: keyword
  </definition>
  <definition term="sophos.xg.signature_msg">
    Signature messsage
    type: keyword
  </definition>
  <definition term="sophos.xg.site_category">
    Site Category
    type: keyword
  </definition>
  <definition term="sophos.xg.source">
    Source
    type: keyword
  </definition>
  <definition term="sophos.xg.sourceip">
    Original source IP address of traffic
    type: ip
  </definition>
  <definition term="sophos.xg.spamaction">
    Spam Action
    type: keyword
  </definition>
  <definition term="sophos.xg.sqli">
    related SQLI caught by the WAF
    type: keyword
  </definition>
  <definition term="sophos.xg.src_country_code">
    Code of the country to which the source IP belongs
    type: keyword
  </definition>
  <definition term="sophos.xg.src_domainname">
    Sender domain name
    type: keyword
  </definition>
  <definition term="sophos.xg.src_ip">
    Original source IP address of traffic
    type: ip
  </definition>
  <definition term="sophos.xg.src_mac">
    Original source MAC address of traffic
    type: keyword
  </definition>
  <definition term="sophos.xg.src_port">
    Original source port of TCP and UDP traffic
    type: integer
  </definition>
  <definition term="sophos.xg.src_zone_type">
    Type of source zone
    type: keyword
  </definition>
  <definition term="sophos.xg.ssid">
    Configured SSID name.
    type: keyword
  </definition>
  <definition term="sophos.xg.start_time">
    Start time
    type: date
  </definition>
  <definition term="sophos.xg.starttime">
    Starttime
    type: date
  </definition>
  <definition term="sophos.xg.status">
    Ultimate status of traffic – Allowed or Denied
    type: keyword
  </definition>
  <definition term="sophos.xg.status_code">
    Status code
    type: keyword
  </definition>
  <definition term="sophos.xg.subject">
    Email subject
    type: keyword
  </definition>
  <definition term="sophos.xg.syslog_server_name">
    Syslog server name.
    type: keyword
  </definition>
  <definition term="sophos.xg.system_cpu">
    system
    type: float
  </definition>
  <definition term="sophos.xg.target">
    Platform of the traffic.
    type: keyword
  </definition>
  <definition term="sophos.xg.temp">
    Temp
    type: float
  </definition>
  <definition term="sophos.xg.threatname">
    ATP threatname
    type: keyword
  </definition>
  <definition term="sophos.xg.timestamp">
    timestamp
    type: date
  </definition>
  <definition term="sophos.xg.timezone">
    Time (hh:mm:ss) when the event occurred
    type: keyword
  </definition>
  <definition term="sophos.xg.to_email_address">
    Receipeint email address
    type: keyword
  </definition>
  <definition term="sophos.xg.total_memory">
    Total Memory
    type: integer
  </definition>
  <definition term="sophos.xg.trans_dst_ip">
    Translated destination IP address for outgoing traffic
    type: ip
  </definition>
  <definition term="sophos.xg.trans_dst_port">
    Translated destination port for outgoing traffic
    type: integer
  </definition>
  <definition term="sophos.xg.trans_src_ip">
    Translated source IP address for outgoing traffic
    type: ip
  </definition>
  <definition term="sophos.xg.trans_src_port">
    Translated source port for outgoing traffic
    type: integer
  </definition>
  <definition term="sophos.xg.transaction_id">
    Transaction ID
    type: keyword
  </definition>
  <definition term="sophos.xg.transactionid">
    Transaction ID of the AV scan.
    type: keyword
  </definition>
  <definition term="sophos.xg.transmitteddrops">
    transmitted drops
    type: long
  </definition>
  <definition term="sophos.xg.transmittederrors">
    transmitted errors
    type: keyword
  </definition>
  <definition term="sophos.xg.transmittedkbits">
    transmitted kbits
    type: long
  </definition>
  <definition term="sophos.xg.unit">
    unit
    type: keyword
  </definition>
  <definition term="sophos.xg.updatedip">
    updatedip
    type: ip
  </definition>
  <definition term="sophos.xg.upload_file_name">
    Upload file name
    type: keyword
  </definition>
  <definition term="sophos.xg.upload_file_type">
    Upload file type
    type: keyword
  </definition>
  <definition term="sophos.xg.url">
    URL from which virus was downloaded
    type: keyword
  </definition>
  <definition term="sophos.xg.used">
    used
    type: integer
  </definition>
  <definition term="sophos.xg.used_quota">
    Used Quota
    type: keyword
  </definition>
  <definition term="sophos.xg.user">
    User
    type: keyword
  </definition>
  <definition term="sophos.xg.user_cpu">
    system
    type: float
  </definition>
  <definition term="sophos.xg.user_gp">
    Group name to which the user belongs.
    type: keyword
  </definition>
  <definition term="sophos.xg.user_group">
    Group name to which the user belongs
    type: keyword
  </definition>
  <definition term="sophos.xg.user_name">
    user_name
    type: keyword
  </definition>
  <definition term="sophos.xg.users">
    Number of users from System Health / Live User events.
    type: long
  </definition>
  <definition term="sophos.xg.vconn_id">
    Connection ID of the master connection
    type: integer
  </definition>
  <definition term="sophos.xg.virus">
    virus name
    type: keyword
  </definition>
  <definition term="sophos.xg.web_policy_id">
    Web policy ID
    type: keyword
  </definition>
  <definition term="sophos.xg.website">
    Website
    type: keyword
  </definition>
  <definition term="sophos.xg.xss">
    related XSS caught by the WAF
    type: keyword
  </definition>
</definitions>