﻿---
title: Snyk fields
description: Snyk module Module for parsing Snyk project vulnerabilities. Module for parsing Snyk audit logs. Module for parsing Snyk project vulnerabilities. 
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-snyk
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Snyk fields
Snyk module

## snyk

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Module for parsing Snyk project vulnerabilities.
<definitions>
  <definition term="snyk.projects">
    Array with all related projects objects.
    type: flattened
  </definition>
  <definition term="snyk.related.projects">
    Array of all the related project ID's.
    type: keyword
  </definition>
</definitions>


## audit

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Module for parsing Snyk audit logs.
<definitions>
  <definition term="snyk.audit.org_id">
    ID of the related Organization related to the event.
    type: keyword
  </definition>
  <definition term="snyk.audit.project_id">
    ID of the project related to the event.
    type: keyword
  </definition>
  <definition term="snyk.audit.content">
    Overview of the content that was changed, both old and new values.
    type: flattened
  </definition>
</definitions>


## vulnerabilities

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Module for parsing Snyk project vulnerabilities.
<definitions>
  <definition term="snyk.vulnerabilities.cvss3">
    CSSv3 scores.
    type: keyword
  </definition>
  <definition term="snyk.vulnerabilities.disclosure_time">
    The time this vulnerability was originally disclosed to the package maintainers.
    type: date
  </definition>
  <definition term="snyk.vulnerabilities.exploit_maturity">
    The Snyk exploit maturity level.
    type: keyword
  </definition>
  <definition term="snyk.vulnerabilities.id">
    The vulnerability reference ID.
    type: keyword
  </definition>
  <definition term="snyk.vulnerabilities.is_ignored">
    If the vulnerability report has been ignored.
    type: boolean
  </definition>
  <definition term="snyk.vulnerabilities.is_patchable">
    If vulnerability is fixable by using a Snyk supplied patch.
    type: boolean
  </definition>
  <definition term="snyk.vulnerabilities.is_patched">
    If the vulnerability has been patched.
    type: boolean
  </definition>
  <definition term="snyk.vulnerabilities.is_pinnable">
    If the vulnerability is fixable by pinning a transitive dependency.
    type: boolean
  </definition>
  <definition term="snyk.vulnerabilities.is_upgradable">
    If the vulnerability fixable by upgrading a dependency.
    type: boolean
  </definition>
  <definition term="snyk.vulnerabilities.language">
    The package's programming language.
    type: keyword
  </definition>
  <definition term="snyk.vulnerabilities.package">
    The package identifier according to its package manager.
    type: keyword
  </definition>
  <definition term="snyk.vulnerabilities.package_manager">
    The package manager.
    type: keyword
  </definition>
  <definition term="snyk.vulnerabilities.patches">
    Patches required to resolve the issue created by Snyk.
    type: flattened
  </definition>
  <definition term="snyk.vulnerabilities.priority_score">
    The CVS priority score.
    type: long
  </definition>
  <definition term="snyk.vulnerabilities.publication_time">
    The vulnerability publication time.
    type: date
  </definition>
  <definition term="snyk.vulnerabilities.jira_issue_url">
    Link to the related Jira issue.
    type: keyword
  </definition>
  <definition term="snyk.vulnerabilities.original_severity">
    The original severity of the vulnerability.
    type: long
  </definition>
  <definition term="snyk.vulnerabilities.reachability">
    If the vulnerable function from the library is used in the code scanned. Can either be No Info, Potentially reachable and Reachable.
    type: keyword
  </definition>
  <definition term="snyk.vulnerabilities.title">
    The issue title.
    type: keyword
  </definition>
  <definition term="snyk.vulnerabilities.type">
    The issue type. Can be either "license" or "vulnerability".
    type: keyword
  </definition>
  <definition term="snyk.vulnerabilities.unique_severities_list">
    A list of related unique severities.
    type: keyword
  </definition>
  <definition term="snyk.vulnerabilities.version">
    The package version this issue is applicable to.
    type: keyword
  </definition>
  <definition term="snyk.vulnerabilities.introduced_date">
    The date the vulnerability was initially found.
    type: date
  </definition>
  <definition term="snyk.vulnerabilities.is_fixed">
    If the related vulnerability has been resolved.
    type: boolean
  </definition>
  <definition term="snyk.vulnerabilities.credit">
    Reference to the person that original found the vulnerability.
    type: keyword
  </definition>
  <definition term="snyk.vulnerabilities.semver">
    One or more semver ranges this issue is applicable to. The format varies according to package manager.
    type: flattened
  </definition>
  <definition term="snyk.vulnerabilities.identifiers.alternative">
    Additional vulnerability identifiers.
    type: keyword
  </definition>
  <definition term="snyk.vulnerabilities.identifiers.cwe">
    CWE vulnerability identifiers.
    type: keyword
  </definition>
</definitions>