﻿---
title: Salesforce fields
description: Salesforce Module Fileset for ingesting Salesforce Apex logs. Fileset for ingesting Salesforce Apex logs. Fileset for ingesting Salesforce Login (REST)...
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-salesforce
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Salesforce fields
Salesforce Module

## salesforce

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Fileset for ingesting Salesforce Apex logs.
<definitions>
  <definition term="salesforce.instance_url">
    The Instance URL of the Salesforce instance.
    type: keyword
  </definition>
</definitions>


## apex

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Fileset for ingesting Salesforce Apex logs.
<definitions>
  <definition term="salesforce.apex.document_id">
    Unique ID of the Apex document.
    type: keyword
  </definition>
  <definition term="salesforce.apex.action">
    Action performed by the callout.
    type: keyword
  </definition>
  <definition term="salesforce.apex.callout_time">
    Time spent waiting on web service callouts, in milliseconds.
    type: float
  </definition>
  <definition term="salesforce.apex.class_name">
    The Apex class name. If the class is part of a managed package, this string includes the package namespace.
    type: keyword
  </definition>
  <definition term="salesforce.apex.client_name">
    The name of the client that's using Salesforce services. This field is an optional parameter that can be passed in API calls. If blank, the caller didn't specify a client in the CallOptions header.
    type: keyword
  </definition>
  <definition term="salesforce.apex.cpu_time">
    The CPU time in milliseconds used to complete the request.
    type: float
  </definition>
  <definition term="salesforce.apex.db_blocks">
    Indicates how much activity is occurring in the database. A high value for this field suggests that adding indexes or filters on your queries would benefit performance.
    type: long
  </definition>
  <definition term="salesforce.apex.db_cpu_time">
    The CPU time in milliseconds to complete the request. Indicates the amount of activity taking place in the database layer during the request.
    type: float
  </definition>
  <definition term="salesforce.apex.db_total_time">
    Time (in milliseconds) spent waiting for database processing in aggregate for all operations in the request. Compare this field to cpu_time to determine whether performance issues are occurring in the database layer or in your own code.
    type: float
  </definition>
  <definition term="salesforce.apex.entity">
    Name of the external object being accessed.
    type: keyword
  </definition>
  <definition term="salesforce.apex.entity_name">
    The name of the object affected by the trigger.
    type: keyword
  </definition>
  <definition term="salesforce.apex.entry_point">
    The entry point for this Apex execution.
    type: keyword
  </definition>
  <definition term="salesforce.apex.event_type">
    The type of event.
    type: keyword
  </definition>
  <definition term="salesforce.apex.execute_ms">
    How long it took (in milliseconds) for Salesforce to prepare and execute the query. Available in API version 42.0 and later.
    type: float
  </definition>
  <definition term="salesforce.apex.fetch_ms">
    How long it took (in milliseconds) to retrieve the query results from the external system. Available in API version 42.0 and later.
    type: float
  </definition>
  <definition term="salesforce.apex.filter">
    Field expressions to filter which rows to return. Corresponds to WHERE in SOQL queries.
    type: keyword
  </definition>
  <definition term="salesforce.apex.is_long_running_request">
    Indicates whether the request is counted against your org's concurrent long-running Apex request limit (true) or not (false).
    type: keyword
  </definition>
  <definition term="salesforce.apex.limit">
    Maximum number of rows to return for a query. Corresponds to LIMIT in SOQL queries.
    type: long
  </definition>
  <definition term="salesforce.apex.limit_usage_pct">
    The percentage of Apex SOAP calls that were made against the organization's limit.
    type: float
  </definition>
  <definition term="salesforce.apex.login_key">
    The string that ties together all events in a given user's login session. It starts with a login event and ends with either a logout event or the user session expiring.
    type: keyword
  </definition>
  <definition term="salesforce.apex.media_type">
    The media type of the response.
    type: keyword
  </definition>
  <definition term="salesforce.apex.message">
    Error or warning message associated with the failed call.
    type: text
  </definition>
  <definition term="salesforce.apex.method_name">
    The name of the calling Apex method.
    type: keyword
  </definition>
  <definition term="salesforce.apex.fields_count">
    The number of fields or columns, where applicable.
    type: long
  </definition>
  <definition term="salesforce.apex.soql_queries_count">
    The number of SOQL queries that were executed during the event.
    type: long
  </definition>
  <definition term="salesforce.apex.offset">
    Number of rows to skip when paging through a result set. Corresponds to OFFSET in SOQL queries.
    type: long
  </definition>
  <definition term="salesforce.apex.orderby">
    Field or column to use for sorting query results, and whether to sort the results in ascending (default) or descending order. Corresponds to ORDER BY in SOQL queries.
    type: keyword
  </definition>
  <definition term="salesforce.apex.organization_id">
    The 15-character ID of the organization.
    type: keyword
  </definition>
  <definition term="salesforce.apex.query">
    The SOQL query, if one was performed.
    type: keyword
  </definition>
  <definition term="salesforce.apex.quiddity">
    The type of outer execution associated with this event.
    type: keyword
  </definition>
  <definition term="salesforce.apex.request_id">
    The unique ID of a single transaction. A transaction can contain one or more events. Each event in a given transaction has the same request_id.
    type: keyword
  </definition>
  <definition term="salesforce.apex.request_status">
    The status of the request for a page view or user interface action.
    type: keyword
  </definition>
  <definition term="salesforce.apex.rows_total">
    Total number of records in the result set. The value is always -1 if the custom adapter's DataSource.Provider class doesn't declare the QUERY_TOTAL_SIZE capability.
    type: long
  </definition>
  <definition term="salesforce.apex.rows_fetched">
    Number of rows fetched by the callout. Available in API version 42.0 and later.
    type: long
  </definition>
  <definition term="salesforce.apex.rows_processed">
    The number of rows that were processed in the request.
    type: long
  </definition>
  <definition term="salesforce.apex.run_time">
    The amount of time that the request took in milliseconds.
    type: float
  </definition>
  <definition term="salesforce.apex.select">
    Comma-separated list of fields being queried. Corresponds to SELECT in SOQL queries.
    type: keyword
  </definition>
  <definition term="salesforce.apex.subqueries">
    Reserved for future use.
    type: keyword
  </definition>
  <definition term="salesforce.apex.throughput">
    Number of records retrieved in one second.
    type: float
  </definition>
  <definition term="salesforce.apex.trigger_id">
    The 15-character ID of the trigger that was fired.
    type: keyword
  </definition>
  <definition term="salesforce.apex.trigger_name">
    For triggers coming from managed packages, trigger_name includes a namespace prefix separated with a . character. If no namespace prefix is present, the trigger is from an unmanaged trigger.
    type: keyword
  </definition>
  <definition term="salesforce.apex.trigger_type">
    The type of this trigger.
    type: keyword
  </definition>
  <definition term="salesforce.apex.type">
    The type of Apex callout.
    type: keyword
  </definition>
  <definition term="salesforce.apex.uri">
    The URI of the page that's receiving the request.
    type: keyword
  </definition>
  <definition term="salesforce.apex.uri_derived_id">
    The 18-character case-safe ID of the URI of the page that's receiving the request.
    type: keyword
  </definition>
  <definition term="salesforce.apex.user_agent">
    The numeric code for the type of client used to make the request (for example, the browser, application, or API).
    type: keyword
  </definition>
  <definition term="salesforce.apex.user_id_derived">
    The 18-character case-safe ID of the user who's using Salesforce services through the UI or the API.
    type: keyword
  </definition>
</definitions>


## salesforce.login

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Fileset for ingesting Salesforce Login (REST) logs.
<definitions>
  <definition term="salesforce.login.document_id">
    Unique Id.
    type: keyword
  </definition>
  <definition term="salesforce.login.application">
    The application used to access the organization.
    type: keyword
  </definition>
  <definition term="salesforce.login.api.type">
    The type of Salesforce API request.
    type: keyword
  </definition>
  <definition term="salesforce.login.api.version">
    The version of the Salesforce API that's being used.
    type: keyword
  </definition>
  <definition term="salesforce.login.auth.service_id">
    The authentication method used by a third-party identification provider for an OpenID Connect single sign-on protocol.
    type: keyword
  </definition>
  <definition term="salesforce.login.auth.method_reference">
    The authentication method used by a third-party identification provider for an OpenID Connect single sign-on protocol. This field is available in API version 51.0 and later.
    type: keyword
  </definition>
  <definition term="salesforce.login.session.level">
    Session-level security controls user access to features that support it, such as connected apps and reporting. This field is available in API version 42.0 and later.
    type: text
  </definition>
  <definition term="salesforce.login.session.key">
    The user's unique session ID. Use this value to identify all user events within a session. When a user logs out and logs in again, a new session is started. For LoginEvent, this field is often null because the event is captured before a session is created. For example, vMASKIU6AxEr+Op5. This field is available in API version 46.0 and later.
    type: keyword
  </definition>
  <definition term="salesforce.login.key">
    The string that ties together all events in a given user's login session. It starts with a login event and ends with either a logout event or the user session expiring.
    type: keyword
  </definition>
  <definition term="salesforce.login.history_id">
    Tracks a user session so you can correlate user activity with a particular login instance. This field is also available on the LoginHistory, AuthSession, and other objects, making it easier to trace events back to a user's original authentication.
    type: keyword
  </definition>
  <definition term="salesforce.login.type">
    The type of login used to access the session.
    type: keyword
  </definition>
  <definition term="salesforce.login.geo_id">
    The Salesforce ID of the LoginGeo object associated with the login user's IP address.
    type: keyword
  </definition>
  <definition term="salesforce.login.additional_info">
    JSON serialization of additional information that's captured from the HTTP headers during a login request.
    type: text
  </definition>
  <definition term="salesforce.login.client_version">
    The version number of the login client. If no version number is available, “Unknown” is returned.
    type: keyword
  </definition>
  <definition term="salesforce.login.client_ip">
    The IP address of the client that's using Salesforce services. A Salesforce internal IP (such as a login from Salesforce Workbench or AppExchange) is shown as “Salesforce.com IP”.
    type: keyword
  </definition>
  <definition term="salesforce.login.cpu_time">
    The CPU time in milliseconds used to complete the request. This field indicates the amount of activity taking place in the app server layer.
    type: long
  </definition>
  <definition term="salesforce.login.db_time_total">
    The time in nanoseconds for a database round trip. Includes time spent in the JDBC driver, network to the database, and DB's CPU time. Compare this field to cpu_time to determine whether performance issues are occurring in the database layer or in your own code.
    type: double
  </definition>
  <definition term="salesforce.login.event_type">
    The type of event. The value is always Login.
    type: keyword
  </definition>
  <definition term="salesforce.login.organization_id">
    The 15-character ID of the organization.
    type: keyword
  </definition>
  <definition term="salesforce.login.request_id">
    The unique ID of a single transaction. A transaction can contain one or more events. Each event in a given transaction has the same REQUEST_ID.
    type: keyword
  </definition>
  <definition term="salesforce.login.request_status">
    The status of the request for a page view or user interface action.
    type: keyword
  </definition>
  <definition term="salesforce.login.run_time">
    The amount of time that the request took in milliseconds.
    type: long
  </definition>
  <definition term="salesforce.login.user_id">
    The 15-character ID of the user who's using Salesforce services through the UI or the API.
    type: keyword
  </definition>
  <definition term="salesforce.login.uri_id_derived">
    The 18-character case insensitive ID of the URI of the page that's receiving the request.
    type: keyword
  </definition>
  <definition term="salesforce.login.evaluation_time">
    The amount of time it took to evaluate the transaction security policy, in milliseconds.
    type: float
  </definition>
  <definition term="salesforce.login.login_type">
    The type of login used to access the session.
    type: keyword
  </definition>
</definitions>


## salesforce.logout

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Fileset for parsing Salesforce Logout (REST) logs.
<definitions>
  <definition term="salesforce.logout.document_id">
    Unique Id.
    type: keyword
  </definition>
  <definition term="salesforce.logout.session.key">
    The user's unique session ID. You can use this value to identify all user events within a session. When a user logs out and logs in again, a new session is started.
    type: keyword
  </definition>
  <definition term="salesforce.logout.session.level">
    The security level of the session that was used when logging out (e.g. Standard Session or High-Assurance Session).
    type: text
  </definition>
  <definition term="salesforce.logout.session.type">
    The session type that was used when logging out (e.g. API, Oauth2 or UI).
    type: keyword
  </definition>
  <definition term="salesforce.logout.login_key">
    The string that ties together all events in a given user's login session. It starts with a login event and ends with either a logout event or the user session expiring.
    type: keyword
  </definition>
  <definition term="salesforce.logout.api.type">
    The type of Salesforce API request.
    type: keyword
  </definition>
  <definition term="salesforce.logout.api.version">
    The version of the Salesforce API that's being used.
    type: keyword
  </definition>
  <definition term="salesforce.logout.app_type">
    The application type that was in use upon logging out.
    type: keyword
  </definition>
  <definition term="salesforce.logout.browser_type">
    The identifier string returned by the browser used at login.
    type: keyword
  </definition>
  <definition term="salesforce.logout.client_version">
    The version of the client that was in use upon logging out.
    type: keyword
  </definition>
  <definition term="salesforce.logout.event_type">
    The type of event. The value is always Logout.
    type: keyword
  </definition>
  <definition term="salesforce.logout.organization_by_id">
    The 15-character ID of the organization.
    type: keyword
  </definition>
  <definition term="salesforce.logout.platform_type">
    The code for the client platform. If a timeout caused the logout, this field is null.
    type: keyword
  </definition>
  <definition term="salesforce.logout.resolution_type">
    The screen resolution of the client. If a timeout caused the logout, this field is null.
    type: keyword
  </definition>
  <definition term="salesforce.logout.user_id">
    The 15-character ID of the user who's using Salesforce services through the UI or the API.
    type: keyword
  </definition>
  <definition term="salesforce.logout.user_id_derived">
    The 18-character case-safe ID of the user who's using Salesforce services through the UI or the API.
    type: keyword
  </definition>
  <definition term="salesforce.logout.user_initiated_logout">
    The value is 1 if the user intentionally logged out of the organization by clicking the Logout button. If the user's session timed out due to inactivity or another implicit logout action, the value is 0.
    type: keyword
  </definition>
  <definition term="salesforce.logout.created_by_id">
    Unavailable
    type: keyword
  </definition>
  <definition term="salesforce.logout.event_identifier">
    This field is populated only when the activity that this event monitors requires extra authentication, such as multi-factor authentication. In this case, Salesforce generates more events and sets the RelatedEventIdentifier field of the new events to the value of the EventIdentifier field of the original event. Use this field with the EventIdentifier field to correlate all the related events. If no extra authentication is required, this field is blank.
    type: keyword
  </definition>
  <definition term="salesforce.logout.organization_id">
    The 15-character ID of the organization.
    type: keyword
  </definition>
</definitions>


## salesforce.setup_audit_trail

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Fileset for ingesting Salesforce SetupAuditTrail logs.
<definitions>
  <definition term="salesforce.setup_audit_trail.document_id">
    Unique Id.
    type: keyword
  </definition>
  <definition term="salesforce.setup_audit_trail.created_by_context">
    The context under which the Setup change was made. For example, if Einstein uses cloud-to-cloud services to make a change in Setup, the value of this field is Einstein.
    type: keyword
  </definition>
  <definition term="salesforce.setup_audit_trail.created_by_id">
    Unknown
    type: keyword
  </definition>
  <definition term="salesforce.setup_audit_trail.created_by_issuer">
    Reserved for future use.
    type: keyword
  </definition>
  <definition term="salesforce.setup_audit_trail.delegate_user">
    The Login-As user who executed the action in Setup. If a Login-As user didn't perform the action, this field is blank. This field is available in API version 35.0 and later.
    type: keyword
  </definition>
  <definition term="salesforce.setup_audit_trail.display">
    The full description of changes made in Setup. For example, if the Action field has a value of PermSetCreate, the Display field has a value like “Created permission set MAD: with user license Salesforce.
    type: keyword
  </definition>
  <definition term="salesforce.setup_audit_trail.responsible_namespace_prefix">
    Unknown
    type: keyword
  </definition>
  <definition term="salesforce.setup_audit_trail.section">
    The section in the Setup menu where the action occurred. For example, Manage Users or Company Profile.
    type: keyword
  </definition>
</definitions>