﻿---
title: PostgreSQL fields
description: Module for parsing the PostgreSQL log files. Fields from PostgreSQL logs. Fields from the PostgreSQL log files. 
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-postgresql
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# PostgreSQL fields
Module for parsing the PostgreSQL log files.

## postgresql

Fields from PostgreSQL logs.

## log

Fields from the PostgreSQL log files.
<definitions>
  <definition term="postgresql.log.timestamp Elastic Stack: Deprecated since 7.3">
    The timestamp from the log line.
  </definition>
  <definition term="postgresql.log.core_id Elastic Stack: Deprecated since 8.0">
    Core id. (deprecated, there is no core_id in PostgreSQL logs, this is actually session_line_number).
    type: alias
    alias to: postgresql.log.session_line_number
  </definition>
  <definition term="postgresql.log.client_addr">
    Host where the connection originated from.
    example: 127.0.0.1
  </definition>
  <definition term="postgresql.log.client_port">
    Port where the connection originated from.
    example: 59700
  </definition>
  <definition term="postgresql.log.session_id">
    PostgreSQL session.
    example: 5ff1dd98.22
  </definition>
  <definition term="postgresql.log.session_line_number">
    Line number inside a session. (%l in `log_line_prefix`).
    type: long
  </definition>
  <definition term="postgresql.log.database">
    Name of database.
    example: postgres
  </definition>
  <definition term="postgresql.log.query">
    Query statement. In the case of CSV parse, look at command_tag to get more context.
    example: SELECT * FROM users;
  </definition>
  <definition term="postgresql.log.query_step">
    Statement step when using extended query protocol (one of statement, parse, bind or execute).
    example: parse
  </definition>
  <definition term="postgresql.log.query_name">
    Name given to a query when using extended query protocol. If it is "<unnamed>", or not present, this field is ignored.
    example: pdo_stmt_00000001
  </definition>
  <definition term="postgresql.log.command_tag">
    Type of session's current command. The complete list can be found at: src/include/tcop/cmdtaglist.h
    example: SELECT
  </definition>
  <definition term="postgresql.log.session_start_time">
    Time when this session started.
    type: date
  </definition>
  <definition term="postgresql.log.virtual_transaction_id">
    Backend local transaction id.
  </definition>
  <definition term="postgresql.log.transaction_id">
    The id of current transaction.
    type: long
  </definition>
  <definition term="postgresql.log.sql_state_code">
    State code returned by Postgres (if any). See also [https://www.postgresql.org/docs/current/errcodes-appendix.html](https://www.postgresql.org/docs/current/errcodes-appendix.html)
    type: keyword
  </definition>
  <definition term="postgresql.log.detail">
    More information about the message, parameters in case of a parametrized query. e.g. 'Role "user" does not exist.', 'parameters: $1 = 42', etc.
  </definition>
  <definition term="postgresql.log.hint">
    A possible solution to solve an error.
  </definition>
  <definition term="postgresql.log.internal_query">
    Internal query that led to the error (if any).
  </definition>
  <definition term="postgresql.log.internal_query_pos">
    Character count of the internal query (if any).
    type: long
  </definition>
  <definition term="postgresql.log.context">
    Error context.
  </definition>
  <definition term="postgresql.log.query_pos">
    Character count of the error position (if any).
    type: long
  </definition>
  <definition term="postgresql.log.location">
    Location of the error in the PostgreSQL source code (if log_error_verbosity is set to verbose).
  </definition>
  <definition term="postgresql.log.application_name">
    Name of the application of this event. It is defined by the client.
  </definition>
  <definition term="postgresql.log.backend_type">
    Type of backend of this event. Possible types are autovacuum launcher, autovacuum worker, logical replication launcher, logical replication worker, parallel worker, background writer, client backend, checkpointer, startup, walreceiver, walsender and walwriter. In addition, background workers registered by extensions may have additional types.
    example: client backend
  </definition>
  <definition term="postgresql.log.error.code Elastic Stack: Deprecated since 8.0">
    Error code returned by Postgres (if any). Deprecated: errors can have letters. Use sql_state_code instead.
    type: alias
    alias to: postgresql.log.sql_state_code
  </definition>
  <definition term="postgresql.log.timezone">
    type: alias
    alias to: event.timezone
  </definition>
  <definition term="postgresql.log.user">
    type: alias
    alias to: user.name
  </definition>
  <definition term="postgresql.log.level">
    Valid values are DEBUG5, DEBUG4, DEBUG3, DEBUG2, DEBUG1, INFO, NOTICE, WARNING, ERROR, LOG, FATAL, and PANIC.
    type: alias
    example: LOG
    alias to: log.level
  </definition>
  <definition term="postgresql.log.message">
    type: alias
    alias to: message
  </definition>
</definitions>