﻿---
title: Palo Alto Networks fields
description: Module for Palo Alto Networks (PAN-OS) Fields from the panw module. Fields for the Palo Alto Networks PAN-OS logs. Fields to extend the top-level source...
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-panw
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Palo Alto Networks fields
Module for Palo Alto Networks (PAN-OS)

## panw

Fields from the panw module.

## panos

Fields for the Palo Alto Networks PAN-OS logs.
<definitions>
  <definition term="panw.panos.ruleset">
    Name of the rule that matched this session.
    type: keyword
  </definition>
</definitions>


## source

Fields to extend the top-level source object.
<definitions>
  <definition term="panw.panos.source.zone">
    Source zone for this session.
    type: keyword
  </definition>
  <definition term="panw.panos.source.interface">
    Source interface for this session.
    type: keyword
  </definition>
</definitions>


## nat

Post-NAT source address, if source NAT is performed.
<definitions>
  <definition term="panw.panos.source.nat.ip">
    Post-NAT source IP.
    type: ip
  </definition>
  <definition term="panw.panos.source.nat.port">
    Post-NAT source port.
    type: long
  </definition>
</definitions>


## destination

Fields to extend the top-level destination object.
<definitions>
  <definition term="panw.panos.destination.zone">
    Destination zone for this session.
    type: keyword
  </definition>
  <definition term="panw.panos.destination.interface">
    Destination interface for this session.
    type: keyword
  </definition>
</definitions>


## nat

Post-NAT destination address, if destination NAT is performed.
<definitions>
  <definition term="panw.panos.destination.nat.ip">
    Post-NAT destination IP.
    type: ip
  </definition>
  <definition term="panw.panos.destination.nat.port">
    Post-NAT destination port.
    type: long
  </definition>
  <definition term="panw.panos.endreason">
    The reason a session terminated.
    type: keyword
  </definition>
</definitions>


## network

Fields to extend the top-level network object.
<definitions>
  <definition term="panw.panos.network.pcap_id">
    Packet capture ID for a threat.
    type: keyword
  </definition>
  <definition term="panw.panos.network.nat.community_id">
    Community ID flow-hash for the NAT 5-tuple.
    type: keyword
  </definition>
</definitions>


## file

Fields to extend the top-level file object.
<definitions>
  <definition term="panw.panos.file.hash">
    Binary hash for a threat file sent to be analyzed by the WildFire service.
    type: keyword
  </definition>
</definitions>


## url

Fields to extend the top-level url object.
<definitions>
  <definition term="panw.panos.url.category">
    For threat URLs, it's the URL category. For WildFire, the verdict on the file and is either 'malicious', 'grayware', or 'benign'.
    type: keyword
  </definition>
  <definition term="panw.panos.flow_id">
    Internal numeric identifier for each session.
    type: keyword
  </definition>
  <definition term="panw.panos.sequence_number">
    Log entry identifier that is incremented sequentially. Unique for each log type.
    type: long
  </definition>
  <definition term="panw.panos.threat.resource">
    URL or file name for a threat.
    type: keyword
  </definition>
  <definition term="panw.panos.threat.id">
    Palo Alto Networks identifier for the threat.
    type: keyword
  </definition>
  <definition term="panw.panos.threat.name">
    Palo Alto Networks name for the threat.
    type: keyword
  </definition>
  <definition term="panw.panos.action">
    Action taken for the session.
    type: keyword
  </definition>
  <definition term="panw.panos.type">
    Specifies the type of the log
  </definition>
  <definition term="panw.panos.sub_type">
    Specifies the sub type of the log
  </definition>
  <definition term="panw.panos.virtual_sys">
    Virtual system instance
    type: keyword
  </definition>
  <definition term="panw.panos.client_os_ver">
    The client device’s OS version.
    type: keyword
  </definition>
  <definition term="panw.panos.client_os">
    The client device’s OS version.
    type: keyword
  </definition>
  <definition term="panw.panos.client_ver">
    The client’s GlobalProtect app version.
    type: keyword
  </definition>
  <definition term="panw.panos.stage">
    A string showing the stage of the connection
    type: keyword
    example: before-login
  </definition>
  <definition term="panw.panos.actionflags">
    A bit field indicating if the log was forwarded to Panorama.
    type: keyword
  </definition>
  <definition term="panw.panos.error">
    A string showing that error that has occurred in any event.
    type: keyword
  </definition>
  <definition term="panw.panos.error_code">
    An integer associated with any errors that occurred.
    type: integer
  </definition>
  <definition term="panw.panos.repeatcnt">
    The number of sessions with the same source IP address, destination IP address, application, and subtype that GlobalProtect has detected within the last five seconds.An integer associated with any errors that occurred.
    type: integer
  </definition>
  <definition term="panw.panos.serial_number">
    The serial number of the user’s machine or device.
    type: keyword
  </definition>
  <definition term="panw.panos.auth_method">
    A string showing the authentication type
    type: keyword
    example: LDAP
  </definition>
  <definition term="panw.panos.datasource">
    Source from which mapping information is collected.
    type: keyword
  </definition>
  <definition term="panw.panos.datasourcetype">
    Mechanism used to identify the IP/User mappings within a data source.
    type: keyword
  </definition>
  <definition term="panw.panos.datasourcename">
    User-ID source that sends the IP (Port)-User Mapping.
    type: keyword
  </definition>
  <definition term="panw.panos.factorno">
    Indicates the use of primary authentication (1) or additional factors (2, 3).
    type: integer
  </definition>
  <definition term="panw.panos.factortype">
    Vendor used to authenticate a user when Multi Factor authentication is present.
    type: keyword
  </definition>
  <definition term="panw.panos.factorcompletiontime">
    Time the authentication was completed.
    type: date
  </definition>
  <definition term="panw.panos.ugflags">
    Displays whether the user group that was found during user group mapping. Supported values are: User Group Found—Indicates whether the user could be mapped to a group. Duplicate User—Indicates whether duplicate users were found in a user group. Displays N/A if no user group is found.
    type: keyword
  </definition>
</definitions>


## device_group_hierarchy

A sequence of identification numbers that indicate the device group’s location within a device group hierarchy. The firewall (or virtual system) generating the log includes the identification number of each ancestor in its device group hierarchy. The shared device group (level 0) is not included in this structure. If the log values are 12, 34, 45, 0, it means that the log was generated by a firewall (or virtual system) that belongs to device group 45, and its ancestors are 34, and 12.
<definitions>
  <definition term="panw.panos.device_group_hierarchy.level_1">
    A sequence of identification numbers that indicate the device group’s location within a device group hierarchy. The firewall (or virtual system) generating the log includes the identification number of each ancestor in its device group hierarchy. The shared device group (level 0) is not included in this structure. If the log values are 12, 34, 45, 0, it means that the log was generated by a firewall (or virtual system) that belongs to device group 45, and its ancestors are 34, and 12.
    type: keyword
  </definition>
  <definition term="panw.panos.device_group_hierarchy.level_2">
    A sequence of identification numbers that indicate the device group’s location within a device group hierarchy. The firewall (or virtual system) generating the log includes the identification number of each ancestor in its device group hierarchy. The shared device group (level 0) is not included in this structure. If the log values are 12, 34, 45, 0, it means that the log was generated by a firewall (or virtual system) that belongs to device group 45, and its ancestors are 34, and 12.
    type: keyword
  </definition>
  <definition term="panw.panos.device_group_hierarchy.level_3">
    A sequence of identification numbers that indicate the device group’s location within a device group hierarchy. The firewall (or virtual system) generating the log includes the identification number of each ancestor in its device group hierarchy. The shared device group (level 0) is not included in this structure. If the log values are 12, 34, 45, 0, it means that the log was generated by a firewall (or virtual system) that belongs to device group 45, and its ancestors are 34, and 12.
    type: keyword
  </definition>
  <definition term="panw.panos.device_group_hierarchy.level_4">
    A sequence of identification numbers that indicate the device group’s location within a device group hierarchy. The firewall (or virtual system) generating the log includes the identification number of each ancestor in its device group hierarchy. The shared device group (level 0) is not included in this structure. If the log values are 12, 34, 45, 0, it means that the log was generated by a firewall (or virtual system) that belongs to device group 45, and its ancestors are 34, and 12.
    type: keyword
  </definition>
  <definition term="panw.panos.timeout">
    Timeout after which the IP/User Mappings are cleared.
    type: integer
  </definition>
  <definition term="panw.panos.vsys_id">
    A unique identifier for a virtual system on a Palo Alto Networks firewall.
    type: keyword
  </definition>
  <definition term="panw.panos.vsys_name">
    The name of the virtual system associated with the session; only valid on firewalls enabled for multiple virtual systems.
    type: keyword
  </definition>
  <definition term="panw.panos.description">
    Additional information for any event that has occurred.
    type: keyword
  </definition>
  <definition term="panw.panos.tunnel_type">
    The type of tunnel (either SSLVPN or IPSec).
    type: keyword
  </definition>
  <definition term="panw.panos.connect_method">
    A string showing the how the GlobalProtect app connects to Gateway
    type: keyword
  </definition>
  <definition term="panw.panos.matchname">
    Name of the HIP object or profile.
    type: keyword
  </definition>
  <definition term="panw.panos.matchtype">
    Whether the hip field represents a HIP object or a HIP profile.
    type: keyword
  </definition>
  <definition term="panw.panos.priority">
    The priority order of the gateway that is based on highest (1), high (2), medium (3), low (4), or lowest (5) to which the GlobalProtect app can connect.
    type: keyword
  </definition>
  <definition term="panw.panos.response_time">
    The SSL response time of the selected gateway that is measured in milliseconds on the endpoint during tunnel setup.
    type: keyword
  </definition>
  <definition term="panw.panos.attempted_gateways">
    The fields that are collected for each gateway connection attempt with the gateway name, SSL response time, and priority
    type: keyword
  </definition>
  <definition term="panw.panos.gateway">
    The name of the gateway that is specified on the portal configuration.
    type: keyword
  </definition>
  <definition term="panw.panos.selection_type">
    The connection method that is selected to connect to the gateway.
    type: keyword
  </definition>
</definitions>