﻿---
title: Oracle fields
description: Oracle Module Fields from Oracle logs. Module for parsing Oracle Database audit logs 
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-oracle
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Oracle fields
Oracle Module

## oracle

Fields from Oracle logs.

## database_audit

Module for parsing Oracle Database audit logs
<definitions>
  <definition term="oracle.database_audit.priv_used">
    System privilege used to execute the action.
    type: integer
  </definition>
  <definition term="oracle.database_audit.logoff_pread">
    Physical reads for the session.
    type: integer
  </definition>
  <definition term="oracle.database_audit.logoff_lread">
    Logical reads for the session.
    type: integer
  </definition>
  <definition term="oracle.database_audit.logoff_lwrite">
    Logical writes for the session.
    type: integer
  </definition>
  <definition term="oracle.database_audit.logoff_dead">
    Deadlocks detected during the session.
    type: integer
  </definition>
  <definition term="oracle.database_audit.sessioncpu">
    Amount of CPU time used by each Oracle session.
    type: integer
  </definition>
  <definition term="oracle.database_audit.returncode">
    Oracle error code generated by the action.
    type: integer
  </definition>
  <definition term="oracle.database_audit.statement">
    nth statement in the user session.
    type: integer
  </definition>
  <definition term="oracle.database_audit.userid">
    Name of the user whose actions were audited.
    type: keyword
  </definition>
  <definition term="oracle.database_audit.entryid">
    Numeric ID for each audit trail entry in the session. The entry ID is an index of a session's audit entries that starts at 1 and increases to the number of entries that are written.
    type: integer
  </definition>
  <definition term="oracle.database_audit.comment_text">
    Text comment on the audit trail entry, providing more information about the statement audited.
    type: text
  </definition>
  <definition term="oracle.database_audit.os_userid">
    Operating system login username of the user whose actions were audited.
    type: keyword
  </definition>
  <definition term="oracle.database_audit.terminal">
    Identifier of the user's terminal.
    type: text
  </definition>
  <definition term="oracle.database_audit.status">
    Database Audit Status.
    type: keyword
  </definition>
  <definition term="oracle.database_audit.session_id">
    Indicates the audit session ID number.
    type: keyword
  </definition>
  <definition term="oracle.database_audit.client.terminal">
    If available, the client terminal type, for example "pty".
    type: keyword
  </definition>
  <definition term="oracle.database_audit.client.address">
    The IP Address or Domain used by the client.
    type: keyword
  </definition>
  <definition term="oracle.database_audit.client.user">
    The user running the client or connection to the database.
    type: keyword
  </definition>
  <definition term="oracle.database_audit.database.user">
    The database user used to authenticate.
    type: keyword
  </definition>
  <definition term="oracle.database_audit.privilege">
    The privilege group related to the database user.
    type: keyword
  </definition>
  <definition term="oracle.database_audit.entry.id">
    Indicates the current audit entry number, assigned to each audit trail record. The audit entry.id sequence number is shared between fine-grained audit records and regular audit records.
    type: keyword
  </definition>
  <definition term="oracle.database_audit.database.host">
    Client host machine name.
    type: keyword
  </definition>
  <definition term="oracle.database_audit.action">
    The action performed during the audit event. This could for example be the raw query.
    type: keyword
  </definition>
  <definition term="oracle.database_audit.action_number">
    Action is a numeric value representing the action the user performed. The corresponding name of the action type is in the AUDIT_ACTIONS table. For example, action 100 refers to LOGON.
    type: keyword
  </definition>
  <definition term="oracle.database_audit.database.id">
    Database identifier calculated when the database is created. It corresponds to the DBID column of the V$DATABASE data dictionary view.
    type: keyword
  </definition>
  <definition term="oracle.database_audit.length">
    Refers to the total number of bytes used in this audit record. This number includes the trailing newline bytes (\n), if any, at the end of the audit record.
    type: long
  </definition>
</definitions>