﻿---
title: Okta fields
description: Module for handling system logs from Okta. Fields from Okta. Fields that let you store information of the actor for the LogEvent. Fields that let you...
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-okta
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Okta fields
Module for handling system logs from Okta.

## okta

Fields from Okta.
<definitions>
  <definition term="okta.uuid">
    The unique identifier of the Okta LogEvent.
    type: keyword
  </definition>
  <definition term="okta.event_type">
    The type of the LogEvent.
    type: keyword
  </definition>
  <definition term="okta.version">
    The version of the LogEvent.
    type: keyword
  </definition>
  <definition term="okta.severity">
    The severity of the LogEvent. Must be one of DEBUG, INFO, WARN, or ERROR.
    type: keyword
  </definition>
  <definition term="okta.display_message">
    The display message of the LogEvent.
    type: keyword
  </definition>
</definitions>


## actor

Fields that let you store information of the actor for the LogEvent.
<definitions>
  <definition term="okta.actor.id">
    Identifier of the actor.
    type: keyword
  </definition>
  <definition term="okta.actor.type">
    Type of the actor.
    type: keyword
  </definition>
  <definition term="okta.actor.alternate_id">
    Alternate identifier of the actor.
    type: keyword
  </definition>
  <definition term="okta.actor.display_name">
    Display name of the actor.
    type: keyword
  </definition>
</definitions>


## client

Fields that let you store information about the client of the actor.
<definitions>
  <definition term="okta.client.ip">
    The IP address of the client.
    type: ip
  </definition>
</definitions>


## user_agent

Fields about the user agent information of the client.
<definitions>
  <definition term="okta.client.user_agent.raw_user_agent">
    The raw informaton of the user agent.
    type: keyword
  </definition>
  <definition term="okta.client.user_agent.os">
    The OS informaton.
    type: keyword
  </definition>
  <definition term="okta.client.user_agent.browser">
    The browser informaton of the client.
    type: keyword
  </definition>
  <definition term="okta.client.zone">
    The zone information of the client.
    type: keyword
  </definition>
  <definition term="okta.client.device">
    The information of the client device.
    type: keyword
  </definition>
  <definition term="okta.client.id">
    The identifier of the client.
    type: keyword
  </definition>
</definitions>


## outcome

Fields that let you store information about the outcome.
<definitions>
  <definition term="okta.outcome.reason">
    The reason of the outcome.
    type: keyword
  </definition>
  <definition term="okta.outcome.result">
    The result of the outcome. Must be one of: SUCCESS, FAILURE, SKIPPED, ALLOW, DENY, CHALLENGE, UNKNOWN.
    type: keyword
  </definition>
  <definition term="okta.target">
    The list of targets.
    type: flattened
  </definition>
</definitions>


## transaction

Fields that let you store information about related transaction.
<definitions>
  <definition term="okta.transaction.id">
    Identifier of the transaction.
    type: keyword
  </definition>
  <definition term="okta.transaction.type">
    The type of transaction. Must be one of "WEB", "JOB".
    type: keyword
  </definition>
</definitions>


## debug_context

Fields that let you store information about the debug context.

## debug_data

The debug data.
<definitions>
  <definition term="okta.debug_context.debug_data.device_fingerprint">
    The fingerprint of the device.
    type: keyword
  </definition>
  <definition term="okta.debug_context.debug_data.factor">
    The factor used for authentication.
    type: keyword
  </definition>
  <definition term="okta.debug_context.debug_data.request_id">
    The identifier of the request.
    type: keyword
  </definition>
  <definition term="okta.debug_context.debug_data.request_uri">
    The request URI.
    type: keyword
  </definition>
  <definition term="okta.debug_context.debug_data.threat_suspected">
    Threat suspected.
    type: keyword
  </definition>
  <definition term="okta.debug_context.debug_data.risk_behaviors">
    The set of behaviors that contribute to a risk assessment.
    type: keyword
  </definition>
  <definition term="okta.debug_context.debug_data.risk_level">
    The risk level assigned to the sign in attempt.
    type: keyword
  </definition>
  <definition term="okta.debug_context.debug_data.risk_reasons">
    The reasons for the risk.
    type: keyword
  </definition>
  <definition term="okta.debug_context.debug_data.url">
    The URL.
    type: keyword
  </definition>
  <definition term="okta.debug_context.debug_data.flattened">
    The complete debug_data object.
    type: flattened
  </definition>
</definitions>


## suspicious_activity

The suspicious activity fields from the debug data.
<definitions>
  <definition term="okta.debug_context.debug_data.suspicious_activity.browser">
    The browser used.
    type: keyword
  </definition>
  <definition term="okta.debug_context.debug_data.suspicious_activity.event_city">
    The city where the suspicious activity took place.
    type: keyword
  </definition>
  <definition term="okta.debug_context.debug_data.suspicious_activity.event_country">
    The country where the suspicious activity took place.
    type: keyword
  </definition>
  <definition term="okta.debug_context.debug_data.suspicious_activity.event_id">
    The event ID.
    type: keyword
  </definition>
  <definition term="okta.debug_context.debug_data.suspicious_activity.event_ip">
    The IP of the suspicious event.
    type: ip
  </definition>
  <definition term="okta.debug_context.debug_data.suspicious_activity.event_latitude">
    The latitude where the suspicious activity took place.
    type: float
  </definition>
  <definition term="okta.debug_context.debug_data.suspicious_activity.event_longitude">
    The longitude where the suspicious activity took place.
    type: float
  </definition>
  <definition term="okta.debug_context.debug_data.suspicious_activity.event_state">
    The state where the suspicious activity took place.
    type: keyword
  </definition>
  <definition term="okta.debug_context.debug_data.suspicious_activity.event_transaction_id">
    The event transaction ID.
    type: keyword
  </definition>
  <definition term="okta.debug_context.debug_data.suspicious_activity.event_type">
    The event type.
    type: keyword
  </definition>
  <definition term="okta.debug_context.debug_data.suspicious_activity.os">
    The OS of the system from where the suspicious activity occured.
    type: keyword
  </definition>
  <definition term="okta.debug_context.debug_data.suspicious_activity.timestamp">
    The timestamp of when the activity occurred.
    type: date
  </definition>
</definitions>


## authentication_context

Fields that let you store information about authentication context.
<definitions>
  <definition term="okta.authentication_context.authentication_provider">
    The information about the authentication provider. Must be one of OKTA_AUTHENTICATION_PROVIDER, ACTIVE_DIRECTORY, LDAP, FEDERATION, SOCIAL, FACTOR_PROVIDER.
    type: keyword
  </definition>
  <definition term="okta.authentication_context.authentication_step">
    The authentication step.
    type: integer
  </definition>
  <definition term="okta.authentication_context.credential_provider">
    The information about credential provider. Must be one of OKTA_CREDENTIAL_PROVIDER, RSA, SYMANTEC, GOOGLE, DUO, YUBIKEY.
    type: keyword
  </definition>
  <definition term="okta.authentication_context.credential_type">
    The information about credential type. Must be one of OTP, SMS, PASSWORD, ASSERTION, IWA, EMAIL, OAUTH2, JWT, CERTIFICATE, PRE_SHARED_SYMMETRIC_KEY, OKTA_CLIENT_SESSION, DEVICE_UDID.
    type: keyword
  </definition>
  <definition term="okta.authentication_context.issuer">
    The information about the issuer.
    type: array
  </definition>
  <definition term="okta.authentication_context.external_session_id">
    The session identifer of the external session if any.
    type: keyword
  </definition>
  <definition term="okta.authentication_context.interface">
    The interface used. e.g., Outlook, Office365, wsTrust
    type: keyword
  </definition>
</definitions>


## security_context

Fields that let you store information about security context.

## as

The autonomous system.
<definitions>
  <definition term="okta.security_context.as.number">
    The AS number.
    type: integer
  </definition>
</definitions>


## organization

The organization that owns the AS number.
<definitions>
  <definition term="okta.security_context.as.organization.name">
    The organization name.
    type: keyword
  </definition>
  <definition term="okta.security_context.isp">
    The Internet Service Provider.
    type: keyword
  </definition>
  <definition term="okta.security_context.domain">
    The domain name.
    type: keyword
  </definition>
  <definition term="okta.security_context.is_proxy">
    Whether it is a proxy or not.
    type: boolean
  </definition>
</definitions>


## request

Fields that let you store information about the request, in the form of list of ip_chain.
<definitions>
  <definition term="okta.request.ip_chain">
    List of ip_chain objects.
    type: flattened
  </definition>
</definitions>