﻿---
title: Office 365 fields
description: Module for handling logs from Office 365. Fields from Office 365 Management API audit logs. 
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-o365
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Office 365 fields
Module for handling logs from Office 365.

## o365.audit

Fields from Office 365 Management API audit logs.
<definitions>
  <definition term="o365.audit.AADGroupId">
    type: keyword
  </definition>
  <definition term="o365.audit.Activity">
    type: keyword
  </definition>
  <definition term="o365.audit.Actor">
    type: array
  </definition>
  <definition term="o365.audit.ActorContextId">
    type: keyword
  </definition>
  <definition term="o365.audit.ActorIpAddress">
    type: keyword
  </definition>
  <definition term="o365.audit.ActorUserId">
    type: keyword
  </definition>
  <definition term="o365.audit.ActorYammerUserId">
    type: keyword
  </definition>
  <definition term="o365.audit.AlertEntityId">
    type: keyword
  </definition>
  <definition term="o365.audit.AlertId">
    type: keyword
  </definition>
  <definition term="o365.audit.AlertLinks">
    type: array
  </definition>
  <definition term="o365.audit.AlertType">
    type: keyword
  </definition>
  <definition term="o365.audit.AppId">
    type: keyword
  </definition>
  <definition term="o365.audit.ApplicationDisplayName">
    type: keyword
  </definition>
  <definition term="o365.audit.ApplicationId">
    type: keyword
  </definition>
  <definition term="o365.audit.AzureActiveDirectoryEventType">
    type: keyword
  </definition>
  <definition term="o365.audit.ExchangeMetaData.*">
    type: object
  </definition>
  <definition term="o365.audit.Category">
    type: keyword
  </definition>
  <definition term="o365.audit.ClientAppId">
    type: keyword
  </definition>
  <definition term="o365.audit.ClientInfoString">
    type: keyword
  </definition>
  <definition term="o365.audit.ClientIP">
    type: keyword
  </definition>
  <definition term="o365.audit.ClientIPAddress">
    type: keyword
  </definition>
  <definition term="o365.audit.Comments">
    type: text
  </definition>
  <definition term="o365.audit.CommunicationType">
    type: keyword
  </definition>
  <definition term="o365.audit.CorrelationId">
    type: keyword
  </definition>
  <definition term="o365.audit.CreationTime">
    type: keyword
  </definition>
  <definition term="o365.audit.CustomUniqueId">
    type: keyword
  </definition>
  <definition term="o365.audit.Data">
    type: keyword
  </definition>
  <definition term="o365.audit.DataType">
    type: keyword
  </definition>
  <definition term="o365.audit.DoNotDistributeEvent">
    type: boolean
  </definition>
  <definition term="o365.audit.EntityType">
    type: keyword
  </definition>
  <definition term="o365.audit.ErrorNumber">
    type: keyword
  </definition>
  <definition term="o365.audit.EventData">
    type: keyword
  </definition>
  <definition term="o365.audit.EventSource">
    type: keyword
  </definition>
  <definition term="o365.audit.ExceptionInfo.*">
    type: object
  </definition>
  <definition term="o365.audit.Experience">
    type: keyword
  </definition>
  <definition term="o365.audit.ExtendedProperties.*">
    type: object
  </definition>
  <definition term="o365.audit.ExternalAccess">
    type: keyword
  </definition>
  <definition term="o365.audit.FromApp">
    type: boolean
  </definition>
  <definition term="o365.audit.GroupName">
    type: keyword
  </definition>
  <definition term="o365.audit.Id">
    type: keyword
  </definition>
  <definition term="o365.audit.ImplicitShare">
    type: keyword
  </definition>
  <definition term="o365.audit.IncidentId">
    type: keyword
  </definition>
  <definition term="o365.audit.InternalLogonType">
    type: keyword
  </definition>
  <definition term="o365.audit.InterSystemsId">
    type: keyword
  </definition>
  <definition term="o365.audit.IntraSystemId">
    type: keyword
  </definition>
  <definition term="o365.audit.IsDocLib">
    type: boolean
  </definition>
  <definition term="o365.audit.Item.*">
    type: object
  </definition>
  <definition term="o365.audit.Item.*.*">
    type: object
  </definition>
  <definition term="o365.audit.ItemCount">
    type: long
  </definition>
  <definition term="o365.audit.ItemName">
    type: keyword
  </definition>
  <definition term="o365.audit.ItemType">
    type: keyword
  </definition>
  <definition term="o365.audit.ListBaseTemplateType">
    type: keyword
  </definition>
  <definition term="o365.audit.ListBaseType">
    type: keyword
  </definition>
  <definition term="o365.audit.ListColor">
    type: keyword
  </definition>
  <definition term="o365.audit.ListIcon">
    type: keyword
  </definition>
  <definition term="o365.audit.ListId">
    type: keyword
  </definition>
  <definition term="o365.audit.ListTitle">
    type: keyword
  </definition>
  <definition term="o365.audit.ListItemUniqueId">
    type: keyword
  </definition>
  <definition term="o365.audit.LogonError">
    type: keyword
  </definition>
  <definition term="o365.audit.LogonType">
    type: keyword
  </definition>
  <definition term="o365.audit.LogonUserSid">
    type: keyword
  </definition>
  <definition term="o365.audit.MailboxGuid">
    type: keyword
  </definition>
  <definition term="o365.audit.MailboxOwnerMasterAccountSid">
    type: keyword
  </definition>
  <definition term="o365.audit.MailboxOwnerSid">
    type: keyword
  </definition>
  <definition term="o365.audit.MailboxOwnerUPN">
    type: keyword
  </definition>
  <definition term="o365.audit.Members">
    type: array
  </definition>
  <definition term="o365.audit.Members.*">
    type: object
  </definition>
  <definition term="o365.audit.ModifiedProperties.*.*">
    type: object
  </definition>
  <definition term="o365.audit.Name">
    type: keyword
  </definition>
  <definition term="o365.audit.ObjectId">
    type: keyword
  </definition>
  <definition term="o365.audit.ObjectDisplayName">
    type: keyword
  </definition>
  <definition term="o365.audit.ObjectType">
    type: keyword
  </definition>
  <definition term="o365.audit.Operation">
    type: keyword
  </definition>
  <definition term="o365.audit.OperationId">
    type: keyword
  </definition>
  <definition term="o365.audit.OperationProperties">
    type: object
  </definition>
  <definition term="o365.audit.OrganizationId">
    type: keyword
  </definition>
  <definition term="o365.audit.OrganizationName">
    type: keyword
  </definition>
  <definition term="o365.audit.OriginatingServer">
    type: keyword
  </definition>
  <definition term="o365.audit.Parameters.*">
    type: object
  </definition>
  <definition term="o365.audit.PolicyDetails">
    type: array
  </definition>
  <definition term="o365.audit.PolicyId">
    type: keyword
  </definition>
  <definition term="o365.audit.RecordType">
    type: keyword
  </definition>
  <definition term="o365.audit.RequestId">
    type: keyword
  </definition>
  <definition term="o365.audit.ResultStatus">
    type: keyword
  </definition>
  <definition term="o365.audit.SensitiveInfoDetectionIsIncluded">
    type: keyword
  </definition>
  <definition term="o365.audit.SharePointMetaData.*">
    type: object
  </definition>
  <definition term="o365.audit.SessionId">
    type: keyword
  </definition>
  <definition term="o365.audit.Severity">
    type: keyword
  </definition>
  <definition term="o365.audit.Site">
    type: keyword
  </definition>
  <definition term="o365.audit.SiteUrl">
    type: keyword
  </definition>
  <definition term="o365.audit.Source">
    type: keyword
  </definition>
  <definition term="o365.audit.SourceFileExtension">
    type: keyword
  </definition>
  <definition term="o365.audit.SourceFileName">
    type: keyword
  </definition>
  <definition term="o365.audit.SourceRelativeUrl">
    type: keyword
  </definition>
  <definition term="o365.audit.Status">
    type: keyword
  </definition>
  <definition term="o365.audit.SupportTicketId">
    type: keyword
  </definition>
  <definition term="o365.audit.Target">
    type: array
  </definition>
  <definition term="o365.audit.TargetContextId">
    type: keyword
  </definition>
  <definition term="o365.audit.TargetUserOrGroupName">
    type: keyword
  </definition>
  <definition term="o365.audit.TargetUserOrGroupType">
    type: keyword
  </definition>
  <definition term="o365.audit.TeamName">
    type: keyword
  </definition>
  <definition term="o365.audit.TeamGuid">
    type: keyword
  </definition>
  <definition term="o365.audit.TemplateTypeId">
    type: keyword
  </definition>
  <definition term="o365.audit.Timestamp">
    type: keyword
  </definition>
  <definition term="o365.audit.UniqueSharingId">
    type: keyword
  </definition>
  <definition term="o365.audit.UserAgent">
    type: keyword
  </definition>
  <definition term="o365.audit.UserId">
    type: keyword
  </definition>
  <definition term="o365.audit.UserKey">
    type: keyword
  </definition>
  <definition term="o365.audit.UserType">
    type: keyword
  </definition>
  <definition term="o365.audit.Version">
    type: keyword
  </definition>
  <definition term="o365.audit.WebId">
    type: keyword
  </definition>
  <definition term="o365.audit.Workload">
    type: keyword
  </definition>
  <definition term="o365.audit.WorkspaceId">
    type: keyword
  </definition>
  <definition term="o365.audit.WorkspaceName">
    type: keyword
  </definition>
  <definition term="o365.audit.YammerNetworkId">
    type: keyword
  </definition>
</definitions>