﻿---
title: Nginx fields
description: Module for parsing the Nginx log files. Fields from the Nginx log files. Contains fields for the Nginx access logs. Contains fields for the Nginx error...
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-nginx
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Nginx fields
Module for parsing the Nginx log files.

## nginx

Fields from the Nginx log files.

## access

Contains fields for the Nginx access logs.
<definitions>
  <definition term="nginx.access.remote_ip_list">
    An array of remote IP addresses. It is a list because it is common to include, besides the client IP address, IP addresses from headers like `X-Forwarded-For`. Real source IP is restored to `source.ip`.
    type: array
  </definition>
  <definition term="nginx.access.body_sent.bytes">
    type: alias
    alias to: http.response.body.bytes
  </definition>
  <definition term="nginx.access.user_name">
    type: alias
    alias to: user.name
  </definition>
  <definition term="nginx.access.method">
    type: alias
    alias to: http.request.method
  </definition>
  <definition term="nginx.access.url">
    type: alias
    alias to: url.original
  </definition>
  <definition term="nginx.access.http_version">
    type: alias
    alias to: http.version
  </definition>
  <definition term="nginx.access.response_code">
    type: alias
    alias to: http.response.status_code
  </definition>
  <definition term="nginx.access.referrer">
    type: alias
    alias to: http.request.referrer
  </definition>
  <definition term="nginx.access.agent">
    type: alias
    alias to: user_agent.original
  </definition>
  <definition term="nginx.access.user_agent.device">
    type: alias
    alias to: user_agent.device.name
  </definition>
  <definition term="nginx.access.user_agent.name">
    type: alias
    alias to: user_agent.name
  </definition>
  <definition term="nginx.access.user_agent.os">
    type: alias
    alias to: user_agent.os.full_name
  </definition>
  <definition term="nginx.access.user_agent.os_name">
    type: alias
    alias to: user_agent.os.name
  </definition>
  <definition term="nginx.access.user_agent.original">
    type: alias
    alias to: user_agent.original
  </definition>
  <definition term="nginx.access.geoip.continent_name">
    type: alias
    alias to: source.geo.continent_name
  </definition>
  <definition term="nginx.access.geoip.country_iso_code">
    type: alias
    alias to: source.geo.country_iso_code
  </definition>
  <definition term="nginx.access.geoip.location">
    type: alias
    alias to: source.geo.location
  </definition>
  <definition term="nginx.access.geoip.region_name">
    type: alias
    alias to: source.geo.region_name
  </definition>
  <definition term="nginx.access.geoip.city_name">
    type: alias
    alias to: source.geo.city_name
  </definition>
  <definition term="nginx.access.geoip.region_iso_code">
    type: alias
    alias to: source.geo.region_iso_code
  </definition>
</definitions>


## error

Contains fields for the Nginx error logs.
<definitions>
  <definition term="nginx.error.connection_id">
    Connection identifier.
    type: long
  </definition>
  <definition term="nginx.error.level">
    type: alias
    alias to: log.level
  </definition>
  <definition term="nginx.error.pid">
    type: alias
    alias to: process.pid
  </definition>
  <definition term="nginx.error.tid">
    type: alias
    alias to: process.thread.id
  </definition>
  <definition term="nginx.error.message">
    type: alias
    alias to: message
  </definition>
</definitions>


## ingress_controller

Contains fields for the Ingress Nginx controller access logs.
<definitions>
  <definition term="nginx.ingress_controller.remote_ip_list">
    An array of remote IP addresses. It is a list because it is common to include, besides the client IP address, IP addresses from headers like `X-Forwarded-For`. Real source IP is restored to `source.ip`.
    type: array
  </definition>
  <definition term="nginx.ingress_controller.upstream_address_list">
    An array of the upstream addresses. It is a list because it is common that several upstream servers were contacted during request processing.
    type: keyword
  </definition>
  <definition term="nginx.ingress_controller.upstream.response.length_list">
    An array of upstream response lengths. It is a list because it is common that several upstream servers were contacted during request processing.
    type: keyword
  </definition>
  <definition term="nginx.ingress_controller.upstream.response.time_list">
    An array of upstream response durations. It is a list because it is common that several upstream servers were contacted during request processing.
    type: keyword
  </definition>
  <definition term="nginx.ingress_controller.upstream.response.status_code_list">
    An array of upstream response status codes. It is a list because it is common that several upstream servers were contacted during request processing.
    type: keyword
  </definition>
  <definition term="nginx.ingress_controller.http.request.length">
    The request length (including request line, header, and request body)
    type: long
    format: bytes
  </definition>
  <definition term="nginx.ingress_controller.http.request.time">
    Time elapsed since the first bytes were read from the client
    type: double
    format: duration
  </definition>
  <definition term="nginx.ingress_controller.upstream.name">
    The name of the upstream.
    type: keyword
  </definition>
  <definition term="nginx.ingress_controller.upstream.alternative_name">
    The name of the alternative upstream.
    type: keyword
  </definition>
  <definition term="nginx.ingress_controller.upstream.response.length">
    The length of the response obtained from the upstream server. If several servers were contacted during request process, the summary of the multiple response lengths is stored.
    type: long
    format: bytes
  </definition>
  <definition term="nginx.ingress_controller.upstream.response.time">
    The time spent on receiving the response from the upstream as seconds with millisecond resolution. If several servers were contacted during request process, the summary of the multiple response times is stored.
    type: double
    format: duration
  </definition>
  <definition term="nginx.ingress_controller.upstream.response.status_code">
    The status code of the response obtained from the upstream server. If several servers were contacted during request process, only the status code of the response from the last one is stored in this field.
    type: long
  </definition>
  <definition term="nginx.ingress_controller.upstream.ip">
    The IP address of the upstream server. If several servers were contacted during request process, only the last one is stored in this field.
    type: ip
  </definition>
  <definition term="nginx.ingress_controller.upstream.port">
    The port of the upstream server. If several servers were contacted during request process, only the last one is stored in this field.
    type: long
  </definition>
  <definition term="nginx.ingress_controller.http.request.id">
    The randomly generated ID of the request
    type: keyword
  </definition>
  <definition term="nginx.ingress_controller.body_sent.bytes">
    type: alias
    alias to: http.response.body.bytes
  </definition>
  <definition term="nginx.ingress_controller.user_name">
    type: alias
    alias to: user.name
  </definition>
  <definition term="nginx.ingress_controller.method">
    type: alias
    alias to: http.request.method
  </definition>
  <definition term="nginx.ingress_controller.url">
    type: alias
    alias to: url.original
  </definition>
  <definition term="nginx.ingress_controller.http_version">
    type: alias
    alias to: http.version
  </definition>
  <definition term="nginx.ingress_controller.response_code">
    type: alias
    alias to: http.response.status_code
  </definition>
  <definition term="nginx.ingress_controller.referrer">
    type: alias
    alias to: http.request.referrer
  </definition>
  <definition term="nginx.ingress_controller.agent">
    type: alias
    alias to: user_agent.original
  </definition>
  <definition term="nginx.ingress_controller.user_agent.device">
    type: alias
    alias to: user_agent.device.name
  </definition>
  <definition term="nginx.ingress_controller.user_agent.name">
    type: alias
    alias to: user_agent.name
  </definition>
  <definition term="nginx.ingress_controller.user_agent.os">
    type: alias
    alias to: user_agent.os.full_name
  </definition>
  <definition term="nginx.ingress_controller.user_agent.os_name">
    type: alias
    alias to: user_agent.os.name
  </definition>
  <definition term="nginx.ingress_controller.user_agent.original">
    type: alias
    alias to: user_agent.original
  </definition>
  <definition term="nginx.ingress_controller.geoip.continent_name">
    type: alias
    alias to: source.geo.continent_name
  </definition>
  <definition term="nginx.ingress_controller.geoip.country_iso_code">
    type: alias
    alias to: source.geo.country_iso_code
  </definition>
  <definition term="nginx.ingress_controller.geoip.location">
    type: alias
    alias to: source.geo.location
  </definition>
  <definition term="nginx.ingress_controller.geoip.region_name">
    type: alias
    alias to: source.geo.region_name
  </definition>
  <definition term="nginx.ingress_controller.geoip.city_name">
    type: alias
    alias to: source.geo.city_name
  </definition>
  <definition term="nginx.ingress_controller.geoip.region_iso_code">
    type: alias
    alias to: source.geo.region_iso_code
  </definition>
</definitions>