﻿---
title: NetFlow fields
description: Fields from NetFlow and IPFIX flows. Fields from NetFlow and IPFIX. Metadata related to the exporter device that generated this record. 
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-netflow
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# NetFlow fields
Fields from NetFlow and IPFIX flows.

## netflow

Fields from NetFlow and IPFIX.
<definitions>
  <definition term="netflow.type">
    The type of NetFlow record described by this event.
    type: keyword
  </definition>
</definitions>


## exporter

Metadata related to the exporter device that generated this record.
<definitions>
  <definition term="netflow.exporter.address">
    Exporter's network address in IP:port format.
    type: keyword
  </definition>
  <definition term="netflow.exporter.source_id">
    Observation domain ID to which this record belongs.
    type: long
  </definition>
  <definition term="netflow.exporter.timestamp">
    Time and date of export.
    type: date
  </definition>
  <definition term="netflow.exporter.uptime_millis">
    How long the exporter process has been running, in milliseconds.
    type: long
  </definition>
  <definition term="netflow.exporter.version">
    NetFlow version used.
    type: integer
  </definition>
  <definition term="netflow.absolute_error">
    type: double
  </definition>
  <definition term="netflow.address_pool_high_threshold">
    type: long
  </definition>
  <definition term="netflow.address_pool_low_threshold">
    type: long
  </definition>
  <definition term="netflow.address_port_mapping_high_threshold">
    type: long
  </definition>
  <definition term="netflow.address_port_mapping_low_threshold">
    type: long
  </definition>
  <definition term="netflow.address_port_mapping_per_user_high_threshold">
    type: long
  </definition>
  <definition term="netflow.afc_protocol">
    type: integer
  </definition>
  <definition term="netflow.afc_protocol_name">
    type: keyword
  </definition>
  <definition term="netflow.anonymization_flags">
    type: integer
  </definition>
  <definition term="netflow.anonymization_technique">
    type: integer
  </definition>
  <definition term="netflow.application_business-relevance">
    type: long
  </definition>
  <definition term="netflow.application_category_name">
    type: keyword
  </definition>
  <definition term="netflow.application_description">
    type: keyword
  </definition>
  <definition term="netflow.application_group_name">
    type: keyword
  </definition>
  <definition term="netflow.application_http_uri_statistics">
    type: short
  </definition>
  <definition term="netflow.application_http_user-agent">
    type: short
  </definition>
  <definition term="netflow.application_id">
    type: short
  </definition>
  <definition term="netflow.application_name">
    type: keyword
  </definition>
  <definition term="netflow.application_sub_category_name">
    type: keyword
  </definition>
  <definition term="netflow.application_traffic-class">
    type: long
  </definition>
  <definition term="netflow.art_client_network_time_maximum">
    type: long
  </definition>
  <definition term="netflow.art_client_network_time_minimum">
    type: long
  </definition>
  <definition term="netflow.art_client_network_time_sum">
    type: long
  </definition>
  <definition term="netflow.art_clientpackets">
    type: long
  </definition>
  <definition term="netflow.art_count_late_responses">
    type: long
  </definition>
  <definition term="netflow.art_count_new_connections">
    type: long
  </definition>
  <definition term="netflow.art_count_responses">
    type: long
  </definition>
  <definition term="netflow.art_count_responses_histogram_bucket1">
    type: long
  </definition>
  <definition term="netflow.art_count_responses_histogram_bucket2">
    type: long
  </definition>
  <definition term="netflow.art_count_responses_histogram_bucket3">
    type: long
  </definition>
  <definition term="netflow.art_count_responses_histogram_bucket4">
    type: long
  </definition>
  <definition term="netflow.art_count_responses_histogram_bucket5">
    type: long
  </definition>
  <definition term="netflow.art_count_responses_histogram_bucket6">
    type: long
  </definition>
  <definition term="netflow.art_count_responses_histogram_bucket7">
    type: long
  </definition>
  <definition term="netflow.art_count_retransmissions">
    type: long
  </definition>
  <definition term="netflow.art_count_transactions">
    type: long
  </definition>
  <definition term="netflow.art_network_time_maximum">
    type: long
  </definition>
  <definition term="netflow.art_network_time_minimum">
    type: long
  </definition>
  <definition term="netflow.art_network_time_sum">
    type: long
  </definition>
  <definition term="netflow.art_response_time_maximum">
    type: long
  </definition>
  <definition term="netflow.art_response_time_minimum">
    type: long
  </definition>
  <definition term="netflow.art_response_time_sum">
    type: long
  </definition>
  <definition term="netflow.art_server_network_time_maximum">
    type: long
  </definition>
  <definition term="netflow.art_server_network_time_minimum">
    type: long
  </definition>
  <definition term="netflow.art_server_network_time_sum">
    type: long
  </definition>
  <definition term="netflow.art_server_response_time_maximum">
    type: long
  </definition>
  <definition term="netflow.art_server_response_time_minimum">
    type: long
  </definition>
  <definition term="netflow.art_server_response_time_sum">
    type: long
  </definition>
  <definition term="netflow.art_serverpackets">
    type: long
  </definition>
  <definition term="netflow.art_total_response_time_maximum">
    type: long
  </definition>
  <definition term="netflow.art_total_response_time_minimum">
    type: long
  </definition>
  <definition term="netflow.art_total_response_time_sum">
    type: long
  </definition>
  <definition term="netflow.art_total_transaction_time_maximum">
    type: long
  </definition>
  <definition term="netflow.art_total_transaction_time_minimum">
    type: long
  </definition>
  <definition term="netflow.art_total_transaction_time_sum">
    type: long
  </definition>
  <definition term="netflow.assembled_fragment_count">
    type: long
  </definition>
  <definition term="netflow.audit_counter">
    type: long
  </definition>
  <definition term="netflow.average_interarrival_time">
    type: long
  </definition>
  <definition term="netflow.bgp_destination_as_number">
    type: long
  </definition>
  <definition term="netflow.bgp_next_adjacent_as_number">
    type: long
  </definition>
  <definition term="netflow.bgp_next_hop_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.bgp_next_hop_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.bgp_prev_adjacent_as_number">
    type: long
  </definition>
  <definition term="netflow.bgp_source_as_number">
    type: long
  </definition>
  <definition term="netflow.bgp_validity_state">
    type: short
  </definition>
  <definition term="netflow.biflow_direction">
    type: short
  </definition>
  <definition term="netflow.bind_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.bind_transport_port">
    type: integer
  </definition>
  <definition term="netflow.class_id">
    type: long
  </definition>
  <definition term="netflow.class_name">
    type: keyword
  </definition>
  <definition term="netflow.classification_engine_id">
    type: short
  </definition>
  <definition term="netflow.collection_time_milliseconds">
    type: date
  </definition>
  <definition term="netflow.collector_certificate">
    type: short
  </definition>
  <definition term="netflow.collector_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.collector_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.collector_transport_port">
    type: integer
  </definition>
  <definition term="netflow.common_properties_id">
    type: long
  </definition>
  <definition term="netflow.confidence_level">
    type: double
  </definition>
  <definition term="netflow.conn_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.conn_transport_port">
    type: integer
  </definition>
  <definition term="netflow.connection_sum_duration_seconds">
    type: long
  </definition>
  <definition term="netflow.connection_transaction_id">
    type: long
  </definition>
  <definition term="netflow.conntrack_id">
    type: long
  </definition>
  <definition term="netflow.data_byte_count">
    type: long
  </definition>
  <definition term="netflow.data_link_frame_section">
    type: short
  </definition>
  <definition term="netflow.data_link_frame_size">
    type: integer
  </definition>
  <definition term="netflow.data_link_frame_type">
    type: integer
  </definition>
  <definition term="netflow.data_records_reliability">
    type: boolean
  </definition>
  <definition term="netflow.delta_flow_count">
    type: long
  </definition>
  <definition term="netflow.destination_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.destination_ipv4_prefix">
    type: ip
  </definition>
  <definition term="netflow.destination_ipv4_prefix_length">
    type: short
  </definition>
  <definition term="netflow.destination_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.destination_ipv6_prefix">
    type: ip
  </definition>
  <definition term="netflow.destination_ipv6_prefix_length">
    type: short
  </definition>
  <definition term="netflow.destination_mac_address">
    type: keyword
  </definition>
  <definition term="netflow.destination_transport_port">
    type: integer
  </definition>
  <definition term="netflow.digest_hash_value">
    type: long
  </definition>
  <definition term="netflow.distinct_count_of_destination_ip_address">
    type: long
  </definition>
  <definition term="netflow.distinct_count_of_destination_ipv4_address">
    type: long
  </definition>
  <definition term="netflow.distinct_count_of_destination_ipv6_address">
    type: long
  </definition>
  <definition term="netflow.distinct_count_of_source_ip_address">
    type: long
  </definition>
  <definition term="netflow.distinct_count_of_source_ipv4_address">
    type: long
  </definition>
  <definition term="netflow.distinct_count_of_source_ipv6_address">
    type: long
  </definition>
  <definition term="netflow.dns_authoritative">
    type: short
  </definition>
  <definition term="netflow.dns_cname">
    type: keyword
  </definition>
  <definition term="netflow.dns_id">
    type: integer
  </definition>
  <definition term="netflow.dns_mx_exchange">
    type: keyword
  </definition>
  <definition term="netflow.dns_mx_preference">
    type: integer
  </definition>
  <definition term="netflow.dns_nsd_name">
    type: keyword
  </definition>
  <definition term="netflow.dns_nx_domain">
    type: short
  </definition>
  <definition term="netflow.dns_ptrd_name">
    type: keyword
  </definition>
  <definition term="netflow.dns_qname">
    type: keyword
  </definition>
  <definition term="netflow.dns_qr_type">
    type: integer
  </definition>
  <definition term="netflow.dns_query_response">
    type: short
  </definition>
  <definition term="netflow.dns_rr_section">
    type: short
  </definition>
  <definition term="netflow.dns_soa_expire">
    type: long
  </definition>
  <definition term="netflow.dns_soa_minimum">
    type: long
  </definition>
  <definition term="netflow.dns_soa_refresh">
    type: long
  </definition>
  <definition term="netflow.dns_soa_retry">
    type: long
  </definition>
  <definition term="netflow.dns_soa_serial">
    type: long
  </definition>
  <definition term="netflow.dns_soam_name">
    type: keyword
  </definition>
  <definition term="netflow.dns_soar_name">
    type: keyword
  </definition>
  <definition term="netflow.dns_srv_port">
    type: integer
  </definition>
  <definition term="netflow.dns_srv_priority">
    type: integer
  </definition>
  <definition term="netflow.dns_srv_target">
    type: integer
  </definition>
  <definition term="netflow.dns_srv_weight">
    type: integer
  </definition>
  <definition term="netflow.dns_ttl">
    type: long
  </definition>
  <definition term="netflow.dns_txt_data">
    type: keyword
  </definition>
  <definition term="netflow.dot1q_customer_dei">
    type: boolean
  </definition>
  <definition term="netflow.dot1q_customer_destination_mac_address">
    type: keyword
  </definition>
  <definition term="netflow.dot1q_customer_priority">
    type: short
  </definition>
  <definition term="netflow.dot1q_customer_source_mac_address">
    type: keyword
  </definition>
  <definition term="netflow.dot1q_customer_vlan_id">
    type: integer
  </definition>
  <definition term="netflow.dot1q_dei">
    type: boolean
  </definition>
  <definition term="netflow.dot1q_priority">
    type: short
  </definition>
  <definition term="netflow.dot1q_service_instance_id">
    type: long
  </definition>
  <definition term="netflow.dot1q_service_instance_priority">
    type: short
  </definition>
  <definition term="netflow.dot1q_service_instance_tag">
    type: short
  </definition>
  <definition term="netflow.dot1q_vlan_id">
    type: integer
  </definition>
  <definition term="netflow.dropped_layer2_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.dropped_layer2_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.dropped_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.dropped_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.dropped_packet_delta_count">
    type: long
  </definition>
  <definition term="netflow.dropped_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.dst_traffic_index">
    type: long
  </definition>
  <definition term="netflow.egress_broadcast_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.egress_interface">
    type: long
  </definition>
  <definition term="netflow.egress_interface_type">
    type: long
  </definition>
  <definition term="netflow.egress_physical_interface">
    type: long
  </definition>
  <definition term="netflow.egress_unicast_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.egress_vrfid">
    type: long
  </definition>
  <definition term="netflow.encrypted_technology">
    type: keyword
  </definition>
  <definition term="netflow.engine_id">
    type: short
  </definition>
  <definition term="netflow.engine_type">
    type: short
  </definition>
  <definition term="netflow.ethernet_header_length">
    type: short
  </definition>
  <definition term="netflow.ethernet_payload_length">
    type: integer
  </definition>
  <definition term="netflow.ethernet_total_length">
    type: integer
  </definition>
  <definition term="netflow.ethernet_type">
    type: integer
  </definition>
  <definition term="netflow.expired_fragment_count">
    type: long
  </definition>
  <definition term="netflow.export_interface">
    type: long
  </definition>
  <definition term="netflow.export_protocol_version">
    type: short
  </definition>
  <definition term="netflow.export_sctp_stream_id">
    type: integer
  </definition>
  <definition term="netflow.export_transport_protocol">
    type: short
  </definition>
  <definition term="netflow.exported_flow_record_total_count">
    type: long
  </definition>
  <definition term="netflow.exported_message_total_count">
    type: long
  </definition>
  <definition term="netflow.exported_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.exporter_certificate">
    type: short
  </definition>
  <definition term="netflow.exporter_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.exporter_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.exporter_transport_port">
    type: integer
  </definition>
  <definition term="netflow.exporting_process_id">
    type: long
  </definition>
  <definition term="netflow.external_address_realm">
    type: short
  </definition>
  <definition term="netflow.firewall_event">
    type: short
  </definition>
  <definition term="netflow.first_eight_non_empty_packet_directions">
    type: short
  </definition>
  <definition term="netflow.first_non_empty_packet_size">
    type: integer
  </definition>
  <definition term="netflow.first_packet_banner">
    type: keyword
  </definition>
  <definition term="netflow.flags_and_sampler_id">
    type: long
  </definition>
  <definition term="netflow.flow_active_timeout">
    type: integer
  </definition>
  <definition term="netflow.flow_attributes">
    type: integer
  </definition>
  <definition term="netflow.flow_direction">
    type: short
  </definition>
  <definition term="netflow.flow_duration_microseconds">
    type: long
  </definition>
  <definition term="netflow.flow_duration_milliseconds">
    type: long
  </definition>
  <definition term="netflow.flow_end_delta_microseconds">
    type: long
  </definition>
  <definition term="netflow.flow_end_microseconds">
    type: date
  </definition>
  <definition term="netflow.flow_end_milliseconds">
    type: date
  </definition>
  <definition term="netflow.flow_end_nanoseconds">
    type: date
  </definition>
  <definition term="netflow.flow_end_reason">
    type: short
  </definition>
  <definition term="netflow.flow_end_seconds">
    type: date
  </definition>
  <definition term="netflow.flow_end_sys_up_time">
    type: long
  </definition>
  <definition term="netflow.flow_id">
    type: long
  </definition>
  <definition term="netflow.flow_idle_timeout">
    type: integer
  </definition>
  <definition term="netflow.flow_key_indicator">
    type: long
  </definition>
  <definition term="netflow.flow_label_ipv6">
    type: long
  </definition>
  <definition term="netflow.flow_sampling_time_interval">
    type: long
  </definition>
  <definition term="netflow.flow_sampling_time_spacing">
    type: long
  </definition>
  <definition term="netflow.flow_selected_flow_delta_count">
    type: long
  </definition>
  <definition term="netflow.flow_selected_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.flow_selected_packet_delta_count">
    type: long
  </definition>
  <definition term="netflow.flow_selector_algorithm">
    type: integer
  </definition>
  <definition term="netflow.flow_start_delta_microseconds">
    type: long
  </definition>
  <definition term="netflow.flow_start_microseconds">
    type: date
  </definition>
  <definition term="netflow.flow_start_milliseconds">
    type: date
  </definition>
  <definition term="netflow.flow_start_nanoseconds">
    type: date
  </definition>
  <definition term="netflow.flow_start_seconds">
    type: date
  </definition>
  <definition term="netflow.flow_start_sys_up_time">
    type: long
  </definition>
  <definition term="netflow.flow_table_flush_event_count">
    type: long
  </definition>
  <definition term="netflow.flow_table_peak_count">
    type: long
  </definition>
  <definition term="netflow.forwarding_status">
    type: short
  </definition>
  <definition term="netflow.fragment_flags">
    type: short
  </definition>
  <definition term="netflow.fragment_identification">
    type: long
  </definition>
  <definition term="netflow.fragment_offset">
    type: integer
  </definition>
  <definition term="netflow.fw_blackout_secs">
    type: long
  </definition>
  <definition term="netflow.fw_configured_value">
    type: long
  </definition>
  <definition term="netflow.fw_cts_src_sgt">
    type: long
  </definition>
  <definition term="netflow.fw_event_level">
    type: long
  </definition>
  <definition term="netflow.fw_event_level_id">
    type: long
  </definition>
  <definition term="netflow.fw_ext_event">
    type: integer
  </definition>
  <definition term="netflow.fw_ext_event_alt">
    type: long
  </definition>
  <definition term="netflow.fw_ext_event_desc">
    type: keyword
  </definition>
  <definition term="netflow.fw_half_open_count">
    type: long
  </definition>
  <definition term="netflow.fw_half_open_high">
    type: long
  </definition>
  <definition term="netflow.fw_half_open_rate">
    type: long
  </definition>
  <definition term="netflow.fw_max_sessions">
    type: long
  </definition>
  <definition term="netflow.fw_rule">
    type: keyword
  </definition>
  <definition term="netflow.fw_summary_pkt_count">
    type: long
  </definition>
  <definition term="netflow.fw_zone_pair_id">
    type: long
  </definition>
  <definition term="netflow.fw_zone_pair_name">
    type: long
  </definition>
  <definition term="netflow.global_address_mapping_high_threshold">
    type: long
  </definition>
  <definition term="netflow.gre_key">
    type: long
  </definition>
  <definition term="netflow.hash_digest_output">
    type: boolean
  </definition>
  <definition term="netflow.hash_flow_domain">
    type: integer
  </definition>
  <definition term="netflow.hash_initialiser_value">
    type: long
  </definition>
  <definition term="netflow.hash_ip_payload_offset">
    type: long
  </definition>
  <definition term="netflow.hash_ip_payload_size">
    type: long
  </definition>
  <definition term="netflow.hash_output_range_max">
    type: long
  </definition>
  <definition term="netflow.hash_output_range_min">
    type: long
  </definition>
  <definition term="netflow.hash_selected_range_max">
    type: long
  </definition>
  <definition term="netflow.hash_selected_range_min">
    type: long
  </definition>
  <definition term="netflow.http_content_type">
    type: keyword
  </definition>
  <definition term="netflow.http_message_version">
    type: keyword
  </definition>
  <definition term="netflow.http_reason_phrase">
    type: keyword
  </definition>
  <definition term="netflow.http_request_host">
    type: keyword
  </definition>
  <definition term="netflow.http_request_method">
    type: keyword
  </definition>
  <definition term="netflow.http_request_target">
    type: keyword
  </definition>
  <definition term="netflow.http_status_code">
    type: integer
  </definition>
  <definition term="netflow.http_user_agent">
    type: keyword
  </definition>
  <definition term="netflow.icmp_code_ipv4">
    type: short
  </definition>
  <definition term="netflow.icmp_code_ipv6">
    type: short
  </definition>
  <definition term="netflow.icmp_type_code_ipv4">
    type: integer
  </definition>
  <definition term="netflow.icmp_type_code_ipv6">
    type: integer
  </definition>
  <definition term="netflow.icmp_type_ipv4">
    type: short
  </definition>
  <definition term="netflow.icmp_type_ipv6">
    type: short
  </definition>
  <definition term="netflow.igmp_type">
    type: short
  </definition>
  <definition term="netflow.ignored_data_record_total_count">
    type: long
  </definition>
  <definition term="netflow.ignored_layer2_frame_total_count">
    type: long
  </definition>
  <definition term="netflow.ignored_layer2_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.ignored_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.ignored_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.information_element_data_type">
    type: short
  </definition>
  <definition term="netflow.information_element_description">
    type: keyword
  </definition>
  <definition term="netflow.information_element_id">
    type: integer
  </definition>
  <definition term="netflow.information_element_index">
    type: integer
  </definition>
  <definition term="netflow.information_element_name">
    type: keyword
  </definition>
  <definition term="netflow.information_element_range_begin">
    type: long
  </definition>
  <definition term="netflow.information_element_range_end">
    type: long
  </definition>
  <definition term="netflow.information_element_semantics">
    type: short
  </definition>
  <definition term="netflow.information_element_units">
    type: integer
  </definition>
  <definition term="netflow.ingress_broadcast_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.ingress_interface">
    type: long
  </definition>
  <definition term="netflow.ingress_interface_type">
    type: long
  </definition>
  <definition term="netflow.ingress_multicast_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.ingress_physical_interface">
    type: long
  </definition>
  <definition term="netflow.ingress_unicast_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.ingress_vrfid">
    type: long
  </definition>
  <definition term="netflow.initial_tcp_flags">
    type: short
  </definition>
  <definition term="netflow.initiator_octets">
    type: long
  </definition>
  <definition term="netflow.initiator_packets">
    type: long
  </definition>
  <definition term="netflow.interface_description">
    type: keyword
  </definition>
  <definition term="netflow.interface_name">
    type: keyword
  </definition>
  <definition term="netflow.intermediate_process_id">
    type: long
  </definition>
  <definition term="netflow.internal_address_realm">
    type: short
  </definition>
  <definition term="netflow.ip_class_of_service">
    type: short
  </definition>
  <definition term="netflow.ip_diff_serv_code_point">
    type: short
  </definition>
  <definition term="netflow.ip_header_length">
    type: short
  </definition>
  <definition term="netflow.ip_header_packet_section">
    type: short
  </definition>
  <definition term="netflow.ip_next_hop_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.ip_next_hop_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.ip_payload_length">
    type: long
  </definition>
  <definition term="netflow.ip_payload_packet_section">
    type: short
  </definition>
  <definition term="netflow.ip_precedence">
    type: short
  </definition>
  <definition term="netflow.ip_sec_spi">
    type: long
  </definition>
  <definition term="netflow.ip_total_length">
    type: long
  </definition>
  <definition term="netflow.ip_ttl">
    type: short
  </definition>
  <definition term="netflow.ip_version">
    type: short
  </definition>
  <definition term="netflow.ipv4_ihl">
    type: short
  </definition>
  <definition term="netflow.ipv4_options">
    type: long
  </definition>
  <definition term="netflow.ipv4_router_sc">
    type: ip
  </definition>
  <definition term="netflow.ipv6_extension_headers">
    type: long
  </definition>
  <definition term="netflow.is_multicast">
    type: short
  </definition>
  <definition term="netflow.ixia_browser_id">
    type: short
  </definition>
  <definition term="netflow.ixia_browser_name">
    type: keyword
  </definition>
  <definition term="netflow.ixia_device_id">
    type: short
  </definition>
  <definition term="netflow.ixia_device_name">
    type: keyword
  </definition>
  <definition term="netflow.ixia_dns_answer">
    type: keyword
  </definition>
  <definition term="netflow.ixia_dns_classes">
    type: keyword
  </definition>
  <definition term="netflow.ixia_dns_query">
    type: keyword
  </definition>
  <definition term="netflow.ixia_dns_record_txt">
    type: keyword
  </definition>
  <definition term="netflow.ixia_dst_as_name">
    type: keyword
  </definition>
  <definition term="netflow.ixia_dst_city_name">
    type: keyword
  </definition>
  <definition term="netflow.ixia_dst_country_code">
    type: keyword
  </definition>
  <definition term="netflow.ixia_dst_country_name">
    type: keyword
  </definition>
  <definition term="netflow.ixia_dst_latitude">
    type: float
  </definition>
  <definition term="netflow.ixia_dst_longitude">
    type: float
  </definition>
  <definition term="netflow.ixia_dst_region_code">
    type: keyword
  </definition>
  <definition term="netflow.ixia_dst_region_node">
    type: keyword
  </definition>
  <definition term="netflow.ixia_encrypt_cipher">
    type: keyword
  </definition>
  <definition term="netflow.ixia_encrypt_key_length">
    type: integer
  </definition>
  <definition term="netflow.ixia_encrypt_type">
    type: keyword
  </definition>
  <definition term="netflow.ixia_http_host_name">
    type: keyword
  </definition>
  <definition term="netflow.ixia_http_uri">
    type: keyword
  </definition>
  <definition term="netflow.ixia_http_user_agent">
    type: keyword
  </definition>
  <definition term="netflow.ixia_imsi_subscriber">
    type: keyword
  </definition>
  <definition term="netflow.ixia_l7_app_id">
    type: long
  </definition>
  <definition term="netflow.ixia_l7_app_name">
    type: keyword
  </definition>
  <definition term="netflow.ixia_latency">
    type: long
  </definition>
  <definition term="netflow.ixia_rev_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.ixia_rev_packet_delta_count">
    type: long
  </definition>
  <definition term="netflow.ixia_src_as_name">
    type: keyword
  </definition>
  <definition term="netflow.ixia_src_city_name">
    type: keyword
  </definition>
  <definition term="netflow.ixia_src_country_code">
    type: keyword
  </definition>
  <definition term="netflow.ixia_src_country_name">
    type: keyword
  </definition>
  <definition term="netflow.ixia_src_latitude">
    type: float
  </definition>
  <definition term="netflow.ixia_src_longitude">
    type: float
  </definition>
  <definition term="netflow.ixia_src_region_code">
    type: keyword
  </definition>
  <definition term="netflow.ixia_src_region_name">
    type: keyword
  </definition>
  <definition term="netflow.ixia_threat_ipv4">
    type: ip
  </definition>
  <definition term="netflow.ixia_threat_ipv6">
    type: ip
  </definition>
  <definition term="netflow.ixia_threat_type">
    type: keyword
  </definition>
  <definition term="netflow.large_packet_count">
    type: long
  </definition>
  <definition term="netflow.layer2_frame_delta_count">
    type: long
  </definition>
  <definition term="netflow.layer2_frame_total_count">
    type: long
  </definition>
  <definition term="netflow.layer2_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.layer2_octet_delta_sum_of_squares">
    type: long
  </definition>
  <definition term="netflow.layer2_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.layer2_octet_total_sum_of_squares">
    type: long
  </definition>
  <definition term="netflow.layer2_segment_id">
    type: long
  </definition>
  <definition term="netflow.layer2packet_section_data">
    type: short
  </definition>
  <definition term="netflow.layer2packet_section_offset">
    type: integer
  </definition>
  <definition term="netflow.layer2packet_section_size">
    type: integer
  </definition>
  <definition term="netflow.line_card_id">
    type: long
  </definition>
  <definition term="netflow.log_op">
    type: short
  </definition>
  <definition term="netflow.lower_ci_limit">
    type: double
  </definition>
  <definition term="netflow.mark">
    type: long
  </definition>
  <definition term="netflow.max_bib_entries">
    type: long
  </definition>
  <definition term="netflow.max_entries_per_user">
    type: long
  </definition>
  <definition term="netflow.max_export_seconds">
    type: date
  </definition>
  <definition term="netflow.max_flow_end_microseconds">
    type: date
  </definition>
  <definition term="netflow.max_flow_end_milliseconds">
    type: date
  </definition>
  <definition term="netflow.max_flow_end_nanoseconds">
    type: date
  </definition>
  <definition term="netflow.max_flow_end_seconds">
    type: date
  </definition>
  <definition term="netflow.max_fragments_pending_reassembly">
    type: long
  </definition>
  <definition term="netflow.max_packet_size">
    type: integer
  </definition>
  <definition term="netflow.max_session_entries">
    type: long
  </definition>
  <definition term="netflow.max_subscribers">
    type: long
  </definition>
  <definition term="netflow.maximum_ip_total_length">
    type: long
  </definition>
  <definition term="netflow.maximum_layer2_total_length">
    type: long
  </definition>
  <definition term="netflow.maximum_ttl">
    type: short
  </definition>
  <definition term="netflow.mean_flow_rate">
    type: long
  </definition>
  <definition term="netflow.mean_packet_rate">
    type: long
  </definition>
  <definition term="netflow.message_md5_checksum">
    type: short
  </definition>
  <definition term="netflow.message_scope">
    type: short
  </definition>
  <definition term="netflow.metering_process_id">
    type: long
  </definition>
  <definition term="netflow.metro_evc_id">
    type: keyword
  </definition>
  <definition term="netflow.metro_evc_type">
    type: short
  </definition>
  <definition term="netflow.mib_capture_time_semantics">
    type: short
  </definition>
  <definition term="netflow.mib_context_engine_id">
    type: short
  </definition>
  <definition term="netflow.mib_context_name">
    type: keyword
  </definition>
  <definition term="netflow.mib_index_indicator">
    type: long
  </definition>
  <definition term="netflow.mib_module_name">
    type: keyword
  </definition>
  <definition term="netflow.mib_object_description">
    type: keyword
  </definition>
  <definition term="netflow.mib_object_identifier">
    type: short
  </definition>
  <definition term="netflow.mib_object_name">
    type: keyword
  </definition>
  <definition term="netflow.mib_object_syntax">
    type: keyword
  </definition>
  <definition term="netflow.mib_object_value_bits">
    type: short
  </definition>
  <definition term="netflow.mib_object_value_counter">
    type: long
  </definition>
  <definition term="netflow.mib_object_value_gauge">
    type: long
  </definition>
  <definition term="netflow.mib_object_value_integer">
    type: integer
  </definition>
  <definition term="netflow.mib_object_value_ip_address">
    type: ip
  </definition>
  <definition term="netflow.mib_object_value_octet_string">
    type: short
  </definition>
  <definition term="netflow.mib_object_value_oid">
    type: short
  </definition>
  <definition term="netflow.mib_object_value_time_ticks">
    type: long
  </definition>
  <definition term="netflow.mib_object_value_unsigned">
    type: long
  </definition>
  <definition term="netflow.mib_sub_identifier">
    type: long
  </definition>
  <definition term="netflow.min_export_seconds">
    type: date
  </definition>
  <definition term="netflow.min_flow_start_microseconds">
    type: date
  </definition>
  <definition term="netflow.min_flow_start_milliseconds">
    type: date
  </definition>
  <definition term="netflow.min_flow_start_nanoseconds">
    type: date
  </definition>
  <definition term="netflow.min_flow_start_seconds">
    type: date
  </definition>
  <definition term="netflow.minimum_ip_total_length">
    type: long
  </definition>
  <definition term="netflow.minimum_layer2_total_length">
    type: long
  </definition>
  <definition term="netflow.minimum_ttl">
    type: short
  </definition>
  <definition term="netflow.mobile_imsi">
    type: keyword
  </definition>
  <definition term="netflow.mobile_msisdn">
    type: keyword
  </definition>
  <definition term="netflow.monitoring_interval_end_milli_seconds">
    type: date
  </definition>
  <definition term="netflow.monitoring_interval_start_milli_seconds">
    type: date
  </definition>
  <definition term="netflow.mpls_label_stack_depth">
    type: long
  </definition>
  <definition term="netflow.mpls_label_stack_length">
    type: long
  </definition>
  <definition term="netflow.mpls_label_stack_section">
    type: short
  </definition>
  <definition term="netflow.mpls_label_stack_section10">
    type: short
  </definition>
  <definition term="netflow.mpls_label_stack_section2">
    type: short
  </definition>
  <definition term="netflow.mpls_label_stack_section3">
    type: short
  </definition>
  <definition term="netflow.mpls_label_stack_section4">
    type: short
  </definition>
  <definition term="netflow.mpls_label_stack_section5">
    type: short
  </definition>
  <definition term="netflow.mpls_label_stack_section6">
    type: short
  </definition>
  <definition term="netflow.mpls_label_stack_section7">
    type: short
  </definition>
  <definition term="netflow.mpls_label_stack_section8">
    type: short
  </definition>
  <definition term="netflow.mpls_label_stack_section9">
    type: short
  </definition>
  <definition term="netflow.mpls_payload_length">
    type: long
  </definition>
  <definition term="netflow.mpls_payload_packet_section">
    type: short
  </definition>
  <definition term="netflow.mpls_top_label_exp">
    type: short
  </definition>
  <definition term="netflow.mpls_top_label_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.mpls_top_label_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.mpls_top_label_prefix_length">
    type: short
  </definition>
  <definition term="netflow.mpls_top_label_stack_section">
    type: short
  </definition>
  <definition term="netflow.mpls_top_label_ttl">
    type: short
  </definition>
  <definition term="netflow.mpls_top_label_type">
    type: short
  </definition>
  <definition term="netflow.mpls_vpn_route_distinguisher">
    type: short
  </definition>
  <definition term="netflow.mptcp_address_id">
    type: short
  </definition>
  <definition term="netflow.mptcp_flags">
    type: short
  </definition>
  <definition term="netflow.mptcp_initial_data_sequence_number">
    type: long
  </definition>
  <definition term="netflow.mptcp_maximum_segment_size">
    type: integer
  </definition>
  <definition term="netflow.mptcp_receiver_token">
    type: long
  </definition>
  <definition term="netflow.multicast_replication_factor">
    type: long
  </definition>
  <definition term="netflow.nat_event">
    type: short
  </definition>
  <definition term="netflow.nat_inside_svcid">
    type: integer
  </definition>
  <definition term="netflow.nat_instance_id">
    type: long
  </definition>
  <definition term="netflow.nat_originating_address_realm">
    type: short
  </definition>
  <definition term="netflow.nat_outside_svcid">
    type: integer
  </definition>
  <definition term="netflow.nat_pool_id">
    type: long
  </definition>
  <definition term="netflow.nat_pool_name">
    type: keyword
  </definition>
  <definition term="netflow.nat_quota_exceeded_event">
    type: long
  </definition>
  <definition term="netflow.nat_sub_string">
    type: keyword
  </definition>
  <definition term="netflow.nat_threshold_event">
    type: long
  </definition>
  <definition term="netflow.nat_type">
    type: short
  </definition>
  <definition term="netflow.netscale_ica_client_version">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_aaa_username">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_app_name">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_app_name_app_id">
    type: long
  </definition>
  <definition term="netflow.netscaler_app_name_incarnation_number">
    type: long
  </definition>
  <definition term="netflow.netscaler_app_template_name">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_app_unit_name_app_id">
    type: long
  </definition>
  <definition term="netflow.netscaler_application_startup_duration">
    type: long
  </definition>
  <definition term="netflow.netscaler_application_startup_time">
    type: long
  </definition>
  <definition term="netflow.netscaler_cache_redir_client_connection_core_id">
    type: long
  </definition>
  <definition term="netflow.netscaler_cache_redir_client_connection_transaction_id">
    type: long
  </definition>
  <definition term="netflow.netscaler_client_rtt">
    type: long
  </definition>
  <definition term="netflow.netscaler_connection_chain_hop_count">
    type: long
  </definition>
  <definition term="netflow.netscaler_connection_chain_id">
    type: short
  </definition>
  <definition term="netflow.netscaler_connection_id">
    type: long
  </definition>
  <definition term="netflow.netscaler_current_license_consumed">
    type: long
  </definition>
  <definition term="netflow.netscaler_db_clt_host_name">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_db_database_name">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_db_login_flags">
    type: long
  </definition>
  <definition term="netflow.netscaler_db_protocol_name">
    type: short
  </definition>
  <definition term="netflow.netscaler_db_req_string">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_db_req_type">
    type: short
  </definition>
  <definition term="netflow.netscaler_db_resp_length">
    type: long
  </definition>
  <definition term="netflow.netscaler_db_resp_status">
    type: long
  </definition>
  <definition term="netflow.netscaler_db_resp_status_string">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_db_user_name">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_flow_flags">
    type: long
  </definition>
  <definition term="netflow.netscaler_http_client_interaction_end_time">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_client_interaction_start_time">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_client_render_end_time">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_client_render_start_time">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_content_type">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_domain_name">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_req_authorization">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_req_cookie">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_req_forw_fb">
    type: long
  </definition>
  <definition term="netflow.netscaler_http_req_forw_lb">
    type: long
  </definition>
  <definition term="netflow.netscaler_http_req_host">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_req_method">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_req_rcv_fb">
    type: long
  </definition>
  <definition term="netflow.netscaler_http_req_rcv_lb">
    type: long
  </definition>
  <definition term="netflow.netscaler_http_req_referer">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_req_url">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_req_user_agent">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_req_via">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_req_xforwarded_for">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_res_forw_fb">
    type: long
  </definition>
  <definition term="netflow.netscaler_http_res_forw_lb">
    type: long
  </definition>
  <definition term="netflow.netscaler_http_res_location">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_res_rcv_fb">
    type: long
  </definition>
  <definition term="netflow.netscaler_http_res_rcv_lb">
    type: long
  </definition>
  <definition term="netflow.netscaler_http_res_set_cookie">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_res_set_cookie2">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_http_rsp_len">
    type: long
  </definition>
  <definition term="netflow.netscaler_http_rsp_status">
    type: integer
  </definition>
  <definition term="netflow.netscaler_ica_app_module_path">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_ica_app_process_id">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_application_name">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_ica_application_termination_time">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_application_termination_type">
    type: integer
  </definition>
  <definition term="netflow.netscaler_ica_channel_id1">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_channel_id1_bytes">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_channel_id2">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_channel_id2_bytes">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_channel_id3">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_channel_id3_bytes">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_channel_id4">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_channel_id4_bytes">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_channel_id5">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_channel_id5_bytes">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_client_host_name">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_ica_client_ip">
    type: ip
  </definition>
  <definition term="netflow.netscaler_ica_client_launcher">
    type: integer
  </definition>
  <definition term="netflow.netscaler_ica_client_side_rto_count">
    type: integer
  </definition>
  <definition term="netflow.netscaler_ica_client_side_window_size">
    type: integer
  </definition>
  <definition term="netflow.netscaler_ica_client_type">
    type: integer
  </definition>
  <definition term="netflow.netscaler_ica_clientside_delay">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_clientside_jitter">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_clientside_packets_retransmit">
    type: integer
  </definition>
  <definition term="netflow.netscaler_ica_clientside_rtt">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_clientside_rx_bytes">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_clientside_srtt">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_clientside_tx_bytes">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_connection_priority">
    type: integer
  </definition>
  <definition term="netflow.netscaler_ica_device_serial_no">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_domain_name">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_ica_flags">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_host_delay">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_l7_client_latency">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_l7_server_latency">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_launch_mechanism">
    type: integer
  </definition>
  <definition term="netflow.netscaler_ica_network_update_end_time">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_network_update_start_time">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_rtt">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_server_name">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_ica_server_side_rto_count">
    type: integer
  </definition>
  <definition term="netflow.netscaler_ica_server_side_window_size">
    type: integer
  </definition>
  <definition term="netflow.netscaler_ica_serverside_delay">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_serverside_jitter">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_serverside_packets_retransmit">
    type: integer
  </definition>
  <definition term="netflow.netscaler_ica_serverside_rtt">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_serverside_srtt">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_session_end_time">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_session_guid">
    type: short
  </definition>
  <definition term="netflow.netscaler_ica_session_reconnects">
    type: short
  </definition>
  <definition term="netflow.netscaler_ica_session_setup_time">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_session_update_begin_sec">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_session_update_end_sec">
    type: long
  </definition>
  <definition term="netflow.netscaler_ica_username">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_license_type">
    type: short
  </definition>
  <definition term="netflow.netscaler_main_page_core_id">
    type: long
  </definition>
  <definition term="netflow.netscaler_main_page_id">
    type: long
  </definition>
  <definition term="netflow.netscaler_max_license_count">
    type: long
  </definition>
  <definition term="netflow.netscaler_msi_client_cookie">
    type: short
  </definition>
  <definition term="netflow.netscaler_round_trip_time">
    type: long
  </definition>
  <definition term="netflow.netscaler_server_ttfb">
    type: long
  </definition>
  <definition term="netflow.netscaler_server_ttlb">
    type: long
  </definition>
  <definition term="netflow.netscaler_syslog_message">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_syslog_priority">
    type: short
  </definition>
  <definition term="netflow.netscaler_syslog_timestamp">
    type: long
  </definition>
  <definition term="netflow.netscaler_transaction_id">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown270">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown271">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown272">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown273">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown274">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown275">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown276">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown277">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown278">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown279">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown280">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown281">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown282">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown283">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown284">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown285">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown286">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown287">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown288">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown289">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown290">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown291">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown292">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown293">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown294">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown295">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown296">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown297">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown298">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown299">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown300">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown301">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown302">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown303">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown304">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown305">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown306">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown307">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown308">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown309">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown310">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown311">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown312">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown313">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown314">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown315">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown316">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_unknown317">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown318">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown319">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_unknown320">
    type: integer
  </definition>
  <definition term="netflow.netscaler_unknown321">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown322">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown323">
    type: integer
  </definition>
  <definition term="netflow.netscaler_unknown324">
    type: integer
  </definition>
  <definition term="netflow.netscaler_unknown325">
    type: integer
  </definition>
  <definition term="netflow.netscaler_unknown326">
    type: integer
  </definition>
  <definition term="netflow.netscaler_unknown327">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown328">
    type: integer
  </definition>
  <definition term="netflow.netscaler_unknown329">
    type: integer
  </definition>
  <definition term="netflow.netscaler_unknown330">
    type: integer
  </definition>
  <definition term="netflow.netscaler_unknown331">
    type: integer
  </definition>
  <definition term="netflow.netscaler_unknown332">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown333">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_unknown334">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_unknown335">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown336">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown337">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown338">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown339">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown340">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown341">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown342">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown343">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown344">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown345">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown346">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown347">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown348">
    type: integer
  </definition>
  <definition term="netflow.netscaler_unknown349">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_unknown350">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_unknown351">
    type: keyword
  </definition>
  <definition term="netflow.netscaler_unknown352">
    type: integer
  </definition>
  <definition term="netflow.netscaler_unknown353">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown354">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown355">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown356">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown357">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown363">
    type: short
  </definition>
  <definition term="netflow.netscaler_unknown383">
    type: short
  </definition>
  <definition term="netflow.netscaler_unknown391">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown398">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown404">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown405">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown427">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown429">
    type: short
  </definition>
  <definition term="netflow.netscaler_unknown432">
    type: short
  </definition>
  <definition term="netflow.netscaler_unknown433">
    type: short
  </definition>
  <definition term="netflow.netscaler_unknown453">
    type: long
  </definition>
  <definition term="netflow.netscaler_unknown465">
    type: long
  </definition>
  <definition term="netflow.new_connection_delta_count">
    type: long
  </definition>
  <definition term="netflow.next_header_ipv6">
    type: short
  </definition>
  <definition term="netflow.non_empty_packet_count">
    type: long
  </definition>
  <definition term="netflow.not_sent_flow_total_count">
    type: long
  </definition>
  <definition term="netflow.not_sent_layer2_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.not_sent_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.not_sent_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.observation_domain_id">
    type: long
  </definition>
  <definition term="netflow.observation_domain_name">
    type: keyword
  </definition>
  <definition term="netflow.observation_point_id">
    type: long
  </definition>
  <definition term="netflow.observation_point_type">
    type: short
  </definition>
  <definition term="netflow.observation_time_microseconds">
    type: date
  </definition>
  <definition term="netflow.observation_time_milliseconds">
    type: date
  </definition>
  <definition term="netflow.observation_time_nanoseconds">
    type: date
  </definition>
  <definition term="netflow.observation_time_seconds">
    type: date
  </definition>
  <definition term="netflow.observed_flow_total_count">
    type: long
  </definition>
  <definition term="netflow.octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.octet_delta_sum_of_squares">
    type: long
  </definition>
  <definition term="netflow.octet_total_count">
    type: long
  </definition>
  <definition term="netflow.octet_total_sum_of_squares">
    type: long
  </definition>
  <definition term="netflow.opaque_octets">
    type: short
  </definition>
  <definition term="netflow.original_exporter_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.original_exporter_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.original_flows_completed">
    type: long
  </definition>
  <definition term="netflow.original_flows_initiated">
    type: long
  </definition>
  <definition term="netflow.original_flows_present">
    type: long
  </definition>
  <definition term="netflow.original_observation_domain_id">
    type: long
  </definition>
  <definition term="netflow.os_finger_print">
    type: keyword
  </definition>
  <definition term="netflow.os_name">
    type: keyword
  </definition>
  <definition term="netflow.os_version">
    type: keyword
  </definition>
  <definition term="netflow.p2p_technology">
    type: keyword
  </definition>
  <definition term="netflow.packet_delta_count">
    type: long
  </definition>
  <definition term="netflow.packet_total_count">
    type: long
  </definition>
  <definition term="netflow.padding_octets">
    type: short
  </definition>
  <definition term="netflow.payload">
    type: keyword
  </definition>
  <definition term="netflow.payload_entropy">
    type: short
  </definition>
  <definition term="netflow.payload_length_ipv6">
    type: integer
  </definition>
  <definition term="netflow.policy_qos_classification_hierarchy">
    type: long
  </definition>
  <definition term="netflow.policy_qos_queue_index">
    type: long
  </definition>
  <definition term="netflow.policy_qos_queuedrops">
    type: long
  </definition>
  <definition term="netflow.policy_qos_queueindex">
    type: long
  </definition>
  <definition term="netflow.port_id">
    type: long
  </definition>
  <definition term="netflow.port_range_end">
    type: integer
  </definition>
  <definition term="netflow.port_range_num_ports">
    type: integer
  </definition>
  <definition term="netflow.port_range_start">
    type: integer
  </definition>
  <definition term="netflow.port_range_step_size">
    type: integer
  </definition>
  <definition term="netflow.post_destination_mac_address">
    type: keyword
  </definition>
  <definition term="netflow.post_dot1q_customer_vlan_id">
    type: integer
  </definition>
  <definition term="netflow.post_dot1q_vlan_id">
    type: integer
  </definition>
  <definition term="netflow.post_ip_class_of_service">
    type: short
  </definition>
  <definition term="netflow.post_ip_diff_serv_code_point">
    type: short
  </definition>
  <definition term="netflow.post_ip_precedence">
    type: short
  </definition>
  <definition term="netflow.post_layer2_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.post_layer2_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.post_mcast_layer2_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.post_mcast_layer2_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.post_mcast_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.post_mcast_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.post_mcast_packet_delta_count">
    type: long
  </definition>
  <definition term="netflow.post_mcast_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.post_mpls_top_label_exp">
    type: short
  </definition>
  <definition term="netflow.post_napt_destination_transport_port">
    type: integer
  </definition>
  <definition term="netflow.post_napt_source_transport_port">
    type: integer
  </definition>
  <definition term="netflow.post_nat_destination_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.post_nat_destination_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.post_nat_source_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.post_nat_source_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.post_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.post_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.post_packet_delta_count">
    type: long
  </definition>
  <definition term="netflow.post_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.post_source_mac_address">
    type: keyword
  </definition>
  <definition term="netflow.post_vlan_id">
    type: integer
  </definition>
  <definition term="netflow.private_enterprise_number">
    type: long
  </definition>
  <definition term="netflow.procera_apn">
    type: keyword
  </definition>
  <definition term="netflow.procera_base_service">
    type: keyword
  </definition>
  <definition term="netflow.procera_content_categories">
    type: keyword
  </definition>
  <definition term="netflow.procera_device_id">
    type: long
  </definition>
  <definition term="netflow.procera_external_rtt">
    type: integer
  </definition>
  <definition term="netflow.procera_flow_behavior">
    type: keyword
  </definition>
  <definition term="netflow.procera_ggsn">
    type: keyword
  </definition>
  <definition term="netflow.procera_http_content_type">
    type: keyword
  </definition>
  <definition term="netflow.procera_http_file_length">
    type: long
  </definition>
  <definition term="netflow.procera_http_language">
    type: keyword
  </definition>
  <definition term="netflow.procera_http_location">
    type: keyword
  </definition>
  <definition term="netflow.procera_http_referer">
    type: keyword
  </definition>
  <definition term="netflow.procera_http_request_method">
    type: keyword
  </definition>
  <definition term="netflow.procera_http_request_version">
    type: keyword
  </definition>
  <definition term="netflow.procera_http_response_status">
    type: integer
  </definition>
  <definition term="netflow.procera_http_url">
    type: keyword
  </definition>
  <definition term="netflow.procera_http_user_agent">
    type: keyword
  </definition>
  <definition term="netflow.procera_imsi">
    type: long
  </definition>
  <definition term="netflow.procera_incoming_octets">
    type: long
  </definition>
  <definition term="netflow.procera_incoming_packets">
    type: long
  </definition>
  <definition term="netflow.procera_incoming_shaping_drops">
    type: long
  </definition>
  <definition term="netflow.procera_incoming_shaping_latency">
    type: integer
  </definition>
  <definition term="netflow.procera_internal_rtt">
    type: integer
  </definition>
  <definition term="netflow.procera_local_ipv4_host">
    type: ip
  </definition>
  <definition term="netflow.procera_local_ipv6_host">
    type: ip
  </definition>
  <definition term="netflow.procera_msisdn">
    type: long
  </definition>
  <definition term="netflow.procera_outgoing_octets">
    type: long
  </definition>
  <definition term="netflow.procera_outgoing_packets">
    type: long
  </definition>
  <definition term="netflow.procera_outgoing_shaping_drops">
    type: long
  </definition>
  <definition term="netflow.procera_outgoing_shaping_latency">
    type: integer
  </definition>
  <definition term="netflow.procera_property">
    type: keyword
  </definition>
  <definition term="netflow.procera_qoe_incoming_external">
    type: float
  </definition>
  <definition term="netflow.procera_qoe_incoming_internal">
    type: float
  </definition>
  <definition term="netflow.procera_qoe_outgoing_external">
    type: float
  </definition>
  <definition term="netflow.procera_qoe_outgoing_internal">
    type: float
  </definition>
  <definition term="netflow.procera_rat">
    type: keyword
  </definition>
  <definition term="netflow.procera_remote_ipv4_host">
    type: ip
  </definition>
  <definition term="netflow.procera_remote_ipv6_host">
    type: ip
  </definition>
  <definition term="netflow.procera_rnc">
    type: integer
  </definition>
  <definition term="netflow.procera_server_hostname">
    type: keyword
  </definition>
  <definition term="netflow.procera_service">
    type: keyword
  </definition>
  <definition term="netflow.procera_sgsn">
    type: keyword
  </definition>
  <definition term="netflow.procera_subscriber_identifier">
    type: keyword
  </definition>
  <definition term="netflow.procera_template_name">
    type: keyword
  </definition>
  <definition term="netflow.procera_user_location_information">
    type: keyword
  </definition>
  <definition term="netflow.protocol_identifier">
    type: short
  </definition>
  <definition term="netflow.pseudo_wire_control_word">
    type: long
  </definition>
  <definition term="netflow.pseudo_wire_destination_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.pseudo_wire_id">
    type: long
  </definition>
  <definition term="netflow.pseudo_wire_type">
    type: integer
  </definition>
  <definition term="netflow.reason">
    type: long
  </definition>
  <definition term="netflow.reason_text">
    type: keyword
  </definition>
  <definition term="netflow.relative_error">
    type: double
  </definition>
  <definition term="netflow.responder_octets">
    type: long
  </definition>
  <definition term="netflow.responder_packets">
    type: long
  </definition>
  <definition term="netflow.reverse_absolute_error">
    type: double
  </definition>
  <definition term="netflow.reverse_anonymization_flags">
    type: integer
  </definition>
  <definition term="netflow.reverse_anonymization_technique">
    type: integer
  </definition>
  <definition term="netflow.reverse_application_category_name">
    type: keyword
  </definition>
  <definition term="netflow.reverse_application_description">
    type: keyword
  </definition>
  <definition term="netflow.reverse_application_group_name">
    type: keyword
  </definition>
  <definition term="netflow.reverse_application_id">
    type: keyword
  </definition>
  <definition term="netflow.reverse_application_name">
    type: keyword
  </definition>
  <definition term="netflow.reverse_application_sub_category_name">
    type: keyword
  </definition>
  <definition term="netflow.reverse_average_interarrival_time">
    type: long
  </definition>
  <definition term="netflow.reverse_bgp_destination_as_number">
    type: long
  </definition>
  <definition term="netflow.reverse_bgp_next_adjacent_as_number">
    type: long
  </definition>
  <definition term="netflow.reverse_bgp_next_hop_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_bgp_next_hop_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_bgp_prev_adjacent_as_number">
    type: long
  </definition>
  <definition term="netflow.reverse_bgp_source_as_number">
    type: long
  </definition>
  <definition term="netflow.reverse_bgp_validity_state">
    type: short
  </definition>
  <definition term="netflow.reverse_class_id">
    type: short
  </definition>
  <definition term="netflow.reverse_class_name">
    type: keyword
  </definition>
  <definition term="netflow.reverse_classification_engine_id">
    type: short
  </definition>
  <definition term="netflow.reverse_collection_time_milliseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_collector_certificate">
    type: keyword
  </definition>
  <definition term="netflow.reverse_confidence_level">
    type: double
  </definition>
  <definition term="netflow.reverse_connection_sum_duration_seconds">
    type: long
  </definition>
  <definition term="netflow.reverse_connection_transaction_id">
    type: long
  </definition>
  <definition term="netflow.reverse_data_byte_count">
    type: long
  </definition>
  <definition term="netflow.reverse_data_link_frame_section">
    type: keyword
  </definition>
  <definition term="netflow.reverse_data_link_frame_size">
    type: integer
  </definition>
  <definition term="netflow.reverse_data_link_frame_type">
    type: integer
  </definition>
  <definition term="netflow.reverse_data_records_reliability">
    type: short
  </definition>
  <definition term="netflow.reverse_delta_flow_count">
    type: long
  </definition>
  <definition term="netflow.reverse_destination_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_destination_ipv4_prefix">
    type: ip
  </definition>
  <definition term="netflow.reverse_destination_ipv4_prefix_length">
    type: short
  </definition>
  <definition term="netflow.reverse_destination_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_destination_ipv6_prefix">
    type: ip
  </definition>
  <definition term="netflow.reverse_destination_ipv6_prefix_length">
    type: short
  </definition>
  <definition term="netflow.reverse_destination_mac_address">
    type: keyword
  </definition>
  <definition term="netflow.reverse_destination_transport_port">
    type: integer
  </definition>
  <definition term="netflow.reverse_digest_hash_value">
    type: long
  </definition>
  <definition term="netflow.reverse_distinct_count_of_destination_ip_address">
    type: long
  </definition>
  <definition term="netflow.reverse_distinct_count_of_destination_ipv4_address">
    type: long
  </definition>
  <definition term="netflow.reverse_distinct_count_of_destination_ipv6_address">
    type: long
  </definition>
  <definition term="netflow.reverse_distinct_count_of_source_ip_address">
    type: long
  </definition>
  <definition term="netflow.reverse_distinct_count_of_source_ipv4_address">
    type: long
  </definition>
  <definition term="netflow.reverse_distinct_count_of_source_ipv6_address">
    type: long
  </definition>
  <definition term="netflow.reverse_dot1q_customer_dei">
    type: short
  </definition>
  <definition term="netflow.reverse_dot1q_customer_destination_mac_address">
    type: keyword
  </definition>
  <definition term="netflow.reverse_dot1q_customer_priority">
    type: short
  </definition>
  <definition term="netflow.reverse_dot1q_customer_source_mac_address">
    type: keyword
  </definition>
  <definition term="netflow.reverse_dot1q_customer_vlan_id">
    type: integer
  </definition>
  <definition term="netflow.reverse_dot1q_dei">
    type: short
  </definition>
  <definition term="netflow.reverse_dot1q_priority">
    type: short
  </definition>
  <definition term="netflow.reverse_dot1q_service_instance_id">
    type: long
  </definition>
  <definition term="netflow.reverse_dot1q_service_instance_priority">
    type: short
  </definition>
  <definition term="netflow.reverse_dot1q_service_instance_tag">
    type: keyword
  </definition>
  <definition term="netflow.reverse_dot1q_vlan_id">
    type: integer
  </definition>
  <definition term="netflow.reverse_dropped_layer2_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_dropped_layer2_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_dropped_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_dropped_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_dropped_packet_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_dropped_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_dst_traffic_index">
    type: long
  </definition>
  <definition term="netflow.reverse_egress_broadcast_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_egress_interface">
    type: long
  </definition>
  <definition term="netflow.reverse_egress_interface_type">
    type: long
  </definition>
  <definition term="netflow.reverse_egress_physical_interface">
    type: long
  </definition>
  <definition term="netflow.reverse_egress_unicast_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_egress_vrfid">
    type: long
  </definition>
  <definition term="netflow.reverse_encrypted_technology">
    type: keyword
  </definition>
  <definition term="netflow.reverse_engine_id">
    type: short
  </definition>
  <definition term="netflow.reverse_engine_type">
    type: short
  </definition>
  <definition term="netflow.reverse_ethernet_header_length">
    type: short
  </definition>
  <definition term="netflow.reverse_ethernet_payload_length">
    type: integer
  </definition>
  <definition term="netflow.reverse_ethernet_total_length">
    type: integer
  </definition>
  <definition term="netflow.reverse_ethernet_type">
    type: integer
  </definition>
  <definition term="netflow.reverse_export_sctp_stream_id">
    type: integer
  </definition>
  <definition term="netflow.reverse_exporter_certificate">
    type: keyword
  </definition>
  <definition term="netflow.reverse_exporting_process_id">
    type: long
  </definition>
  <definition term="netflow.reverse_firewall_event">
    type: short
  </definition>
  <definition term="netflow.reverse_first_non_empty_packet_size">
    type: integer
  </definition>
  <definition term="netflow.reverse_first_packet_banner">
    type: keyword
  </definition>
  <definition term="netflow.reverse_flags_and_sampler_id">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_active_timeout">
    type: integer
  </definition>
  <definition term="netflow.reverse_flow_attributes">
    type: integer
  </definition>
  <definition term="netflow.reverse_flow_delta_milliseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_direction">
    type: short
  </definition>
  <definition term="netflow.reverse_flow_duration_microseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_duration_milliseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_end_delta_microseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_end_microseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_end_milliseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_end_nanoseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_end_reason">
    type: short
  </definition>
  <definition term="netflow.reverse_flow_end_seconds">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_end_sys_up_time">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_idle_timeout">
    type: integer
  </definition>
  <definition term="netflow.reverse_flow_label_ipv6">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_sampling_time_interval">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_sampling_time_spacing">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_selected_flow_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_selected_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_selected_packet_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_selector_algorithm">
    type: integer
  </definition>
  <definition term="netflow.reverse_flow_start_delta_microseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_start_microseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_start_milliseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_start_nanoseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_start_seconds">
    type: long
  </definition>
  <definition term="netflow.reverse_flow_start_sys_up_time">
    type: long
  </definition>
  <definition term="netflow.reverse_forwarding_status">
    type: long
  </definition>
  <definition term="netflow.reverse_fragment_flags">
    type: short
  </definition>
  <definition term="netflow.reverse_fragment_identification">
    type: long
  </definition>
  <definition term="netflow.reverse_fragment_offset">
    type: integer
  </definition>
  <definition term="netflow.reverse_gre_key">
    type: long
  </definition>
  <definition term="netflow.reverse_hash_digest_output">
    type: short
  </definition>
  <definition term="netflow.reverse_hash_flow_domain">
    type: integer
  </definition>
  <definition term="netflow.reverse_hash_initialiser_value">
    type: long
  </definition>
  <definition term="netflow.reverse_hash_ip_payload_offset">
    type: long
  </definition>
  <definition term="netflow.reverse_hash_ip_payload_size">
    type: long
  </definition>
  <definition term="netflow.reverse_hash_output_range_max">
    type: long
  </definition>
  <definition term="netflow.reverse_hash_output_range_min">
    type: long
  </definition>
  <definition term="netflow.reverse_hash_selected_range_max">
    type: long
  </definition>
  <definition term="netflow.reverse_hash_selected_range_min">
    type: long
  </definition>
  <definition term="netflow.reverse_icmp_code_ipv4">
    type: short
  </definition>
  <definition term="netflow.reverse_icmp_code_ipv6">
    type: short
  </definition>
  <definition term="netflow.reverse_icmp_type_code_ipv4">
    type: integer
  </definition>
  <definition term="netflow.reverse_icmp_type_code_ipv6">
    type: integer
  </definition>
  <definition term="netflow.reverse_icmp_type_ipv4">
    type: short
  </definition>
  <definition term="netflow.reverse_icmp_type_ipv6">
    type: short
  </definition>
  <definition term="netflow.reverse_igmp_type">
    type: short
  </definition>
  <definition term="netflow.reverse_ignored_data_record_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_ignored_layer2_frame_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_ignored_layer2_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_information_element_data_type">
    type: short
  </definition>
  <definition term="netflow.reverse_information_element_description">
    type: keyword
  </definition>
  <definition term="netflow.reverse_information_element_id">
    type: integer
  </definition>
  <definition term="netflow.reverse_information_element_index">
    type: integer
  </definition>
  <definition term="netflow.reverse_information_element_name">
    type: keyword
  </definition>
  <definition term="netflow.reverse_information_element_range_begin">
    type: long
  </definition>
  <definition term="netflow.reverse_information_element_range_end">
    type: long
  </definition>
  <definition term="netflow.reverse_information_element_semantics">
    type: short
  </definition>
  <definition term="netflow.reverse_information_element_units">
    type: integer
  </definition>
  <definition term="netflow.reverse_ingress_broadcast_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_ingress_interface">
    type: long
  </definition>
  <definition term="netflow.reverse_ingress_interface_type">
    type: long
  </definition>
  <definition term="netflow.reverse_ingress_multicast_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_ingress_physical_interface">
    type: long
  </definition>
  <definition term="netflow.reverse_ingress_unicast_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_ingress_vrfid">
    type: long
  </definition>
  <definition term="netflow.reverse_initial_tcp_flags">
    type: short
  </definition>
  <definition term="netflow.reverse_initiator_octets">
    type: long
  </definition>
  <definition term="netflow.reverse_initiator_packets">
    type: long
  </definition>
  <definition term="netflow.reverse_interface_description">
    type: keyword
  </definition>
  <definition term="netflow.reverse_interface_name">
    type: keyword
  </definition>
  <definition term="netflow.reverse_intermediate_process_id">
    type: long
  </definition>
  <definition term="netflow.reverse_ip_class_of_service">
    type: short
  </definition>
  <definition term="netflow.reverse_ip_diff_serv_code_point">
    type: short
  </definition>
  <definition term="netflow.reverse_ip_header_length">
    type: short
  </definition>
  <definition term="netflow.reverse_ip_header_packet_section">
    type: keyword
  </definition>
  <definition term="netflow.reverse_ip_next_hop_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_ip_next_hop_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_ip_payload_length">
    type: long
  </definition>
  <definition term="netflow.reverse_ip_payload_packet_section">
    type: keyword
  </definition>
  <definition term="netflow.reverse_ip_precedence">
    type: short
  </definition>
  <definition term="netflow.reverse_ip_sec_spi">
    type: long
  </definition>
  <definition term="netflow.reverse_ip_total_length">
    type: long
  </definition>
  <definition term="netflow.reverse_ip_ttl">
    type: short
  </definition>
  <definition term="netflow.reverse_ip_version">
    type: short
  </definition>
  <definition term="netflow.reverse_ipv4_ihl">
    type: short
  </definition>
  <definition term="netflow.reverse_ipv4_options">
    type: long
  </definition>
  <definition term="netflow.reverse_ipv4_router_sc">
    type: ip
  </definition>
  <definition term="netflow.reverse_ipv6_extension_headers">
    type: long
  </definition>
  <definition term="netflow.reverse_is_multicast">
    type: short
  </definition>
  <definition term="netflow.reverse_large_packet_count">
    type: long
  </definition>
  <definition term="netflow.reverse_layer2_frame_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_layer2_frame_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_layer2_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_layer2_octet_delta_sum_of_squares">
    type: long
  </definition>
  <definition term="netflow.reverse_layer2_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_layer2_octet_total_sum_of_squares">
    type: long
  </definition>
  <definition term="netflow.reverse_layer2_segment_id">
    type: long
  </definition>
  <definition term="netflow.reverse_layer2packet_section_data">
    type: keyword
  </definition>
  <definition term="netflow.reverse_layer2packet_section_offset">
    type: integer
  </definition>
  <definition term="netflow.reverse_layer2packet_section_size">
    type: integer
  </definition>
  <definition term="netflow.reverse_line_card_id">
    type: long
  </definition>
  <definition term="netflow.reverse_lower_ci_limit">
    type: double
  </definition>
  <definition term="netflow.reverse_max_export_seconds">
    type: long
  </definition>
  <definition term="netflow.reverse_max_flow_end_microseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_max_flow_end_milliseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_max_flow_end_nanoseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_max_flow_end_seconds">
    type: long
  </definition>
  <definition term="netflow.reverse_max_packet_size">
    type: integer
  </definition>
  <definition term="netflow.reverse_maximum_ip_total_length">
    type: long
  </definition>
  <definition term="netflow.reverse_maximum_layer2_total_length">
    type: long
  </definition>
  <definition term="netflow.reverse_maximum_ttl">
    type: short
  </definition>
  <definition term="netflow.reverse_message_md5_checksum">
    type: keyword
  </definition>
  <definition term="netflow.reverse_message_scope">
    type: short
  </definition>
  <definition term="netflow.reverse_metering_process_id">
    type: long
  </definition>
  <definition term="netflow.reverse_metro_evc_id">
    type: keyword
  </definition>
  <definition term="netflow.reverse_metro_evc_type">
    type: short
  </definition>
  <definition term="netflow.reverse_min_export_seconds">
    type: long
  </definition>
  <definition term="netflow.reverse_min_flow_start_microseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_min_flow_start_milliseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_min_flow_start_nanoseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_min_flow_start_seconds">
    type: long
  </definition>
  <definition term="netflow.reverse_minimum_ip_total_length">
    type: long
  </definition>
  <definition term="netflow.reverse_minimum_layer2_total_length">
    type: long
  </definition>
  <definition term="netflow.reverse_minimum_ttl">
    type: short
  </definition>
  <definition term="netflow.reverse_monitoring_interval_end_milli_seconds">
    type: long
  </definition>
  <definition term="netflow.reverse_monitoring_interval_start_milli_seconds">
    type: long
  </definition>
  <definition term="netflow.reverse_mpls_label_stack_depth">
    type: long
  </definition>
  <definition term="netflow.reverse_mpls_label_stack_length">
    type: long
  </definition>
  <definition term="netflow.reverse_mpls_label_stack_section">
    type: keyword
  </definition>
  <definition term="netflow.reverse_mpls_label_stack_section10">
    type: keyword
  </definition>
  <definition term="netflow.reverse_mpls_label_stack_section2">
    type: keyword
  </definition>
  <definition term="netflow.reverse_mpls_label_stack_section3">
    type: keyword
  </definition>
  <definition term="netflow.reverse_mpls_label_stack_section4">
    type: keyword
  </definition>
  <definition term="netflow.reverse_mpls_label_stack_section5">
    type: keyword
  </definition>
  <definition term="netflow.reverse_mpls_label_stack_section6">
    type: keyword
  </definition>
  <definition term="netflow.reverse_mpls_label_stack_section7">
    type: keyword
  </definition>
  <definition term="netflow.reverse_mpls_label_stack_section8">
    type: keyword
  </definition>
  <definition term="netflow.reverse_mpls_label_stack_section9">
    type: keyword
  </definition>
  <definition term="netflow.reverse_mpls_payload_length">
    type: long
  </definition>
  <definition term="netflow.reverse_mpls_payload_packet_section">
    type: keyword
  </definition>
  <definition term="netflow.reverse_mpls_top_label_exp">
    type: short
  </definition>
  <definition term="netflow.reverse_mpls_top_label_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_mpls_top_label_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_mpls_top_label_prefix_length">
    type: short
  </definition>
  <definition term="netflow.reverse_mpls_top_label_stack_section">
    type: keyword
  </definition>
  <definition term="netflow.reverse_mpls_top_label_ttl">
    type: short
  </definition>
  <definition term="netflow.reverse_mpls_top_label_type">
    type: short
  </definition>
  <definition term="netflow.reverse_mpls_vpn_route_distinguisher">
    type: keyword
  </definition>
  <definition term="netflow.reverse_multicast_replication_factor">
    type: long
  </definition>
  <definition term="netflow.reverse_nat_event">
    type: short
  </definition>
  <definition term="netflow.reverse_nat_originating_address_realm">
    type: short
  </definition>
  <definition term="netflow.reverse_nat_pool_id">
    type: long
  </definition>
  <definition term="netflow.reverse_nat_pool_name">
    type: keyword
  </definition>
  <definition term="netflow.reverse_nat_type">
    type: short
  </definition>
  <definition term="netflow.reverse_new_connection_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_next_header_ipv6">
    type: short
  </definition>
  <definition term="netflow.reverse_non_empty_packet_count">
    type: long
  </definition>
  <definition term="netflow.reverse_not_sent_layer2_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_observation_domain_name">
    type: keyword
  </definition>
  <definition term="netflow.reverse_observation_point_id">
    type: long
  </definition>
  <definition term="netflow.reverse_observation_point_type">
    type: short
  </definition>
  <definition term="netflow.reverse_observation_time_microseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_observation_time_milliseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_observation_time_nanoseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_observation_time_seconds">
    type: long
  </definition>
  <definition term="netflow.reverse_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_octet_delta_sum_of_squares">
    type: long
  </definition>
  <definition term="netflow.reverse_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_octet_total_sum_of_squares">
    type: long
  </definition>
  <definition term="netflow.reverse_opaque_octets">
    type: keyword
  </definition>
  <definition term="netflow.reverse_original_exporter_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_original_exporter_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_original_flows_completed">
    type: long
  </definition>
  <definition term="netflow.reverse_original_flows_initiated">
    type: long
  </definition>
  <definition term="netflow.reverse_original_flows_present">
    type: long
  </definition>
  <definition term="netflow.reverse_original_observation_domain_id">
    type: long
  </definition>
  <definition term="netflow.reverse_os_finger_print">
    type: keyword
  </definition>
  <definition term="netflow.reverse_os_name">
    type: keyword
  </definition>
  <definition term="netflow.reverse_os_version">
    type: keyword
  </definition>
  <definition term="netflow.reverse_p2p_technology">
    type: keyword
  </definition>
  <definition term="netflow.reverse_packet_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_payload">
    type: keyword
  </definition>
  <definition term="netflow.reverse_payload_entropy">
    type: short
  </definition>
  <definition term="netflow.reverse_payload_length_ipv6">
    type: integer
  </definition>
  <definition term="netflow.reverse_port_id">
    type: long
  </definition>
  <definition term="netflow.reverse_port_range_end">
    type: integer
  </definition>
  <definition term="netflow.reverse_port_range_num_ports">
    type: integer
  </definition>
  <definition term="netflow.reverse_port_range_start">
    type: integer
  </definition>
  <definition term="netflow.reverse_port_range_step_size">
    type: integer
  </definition>
  <definition term="netflow.reverse_post_destination_mac_address">
    type: keyword
  </definition>
  <definition term="netflow.reverse_post_dot1q_customer_vlan_id">
    type: integer
  </definition>
  <definition term="netflow.reverse_post_dot1q_vlan_id">
    type: integer
  </definition>
  <definition term="netflow.reverse_post_ip_class_of_service">
    type: short
  </definition>
  <definition term="netflow.reverse_post_ip_diff_serv_code_point">
    type: short
  </definition>
  <definition term="netflow.reverse_post_ip_precedence">
    type: short
  </definition>
  <definition term="netflow.reverse_post_layer2_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_post_layer2_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_post_mcast_layer2_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_post_mcast_layer2_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_post_mcast_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_post_mcast_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_post_mcast_packet_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_post_mcast_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_post_mpls_top_label_exp">
    type: short
  </definition>
  <definition term="netflow.reverse_post_napt_destination_transport_port">
    type: integer
  </definition>
  <definition term="netflow.reverse_post_napt_source_transport_port">
    type: integer
  </definition>
  <definition term="netflow.reverse_post_nat_destination_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_post_nat_destination_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_post_nat_source_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_post_nat_source_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_post_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_post_octet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_post_packet_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_post_packet_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_post_source_mac_address">
    type: keyword
  </definition>
  <definition term="netflow.reverse_post_vlan_id">
    type: integer
  </definition>
  <definition term="netflow.reverse_private_enterprise_number">
    type: long
  </definition>
  <definition term="netflow.reverse_protocol_identifier">
    type: short
  </definition>
  <definition term="netflow.reverse_pseudo_wire_control_word">
    type: long
  </definition>
  <definition term="netflow.reverse_pseudo_wire_destination_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_pseudo_wire_id">
    type: long
  </definition>
  <definition term="netflow.reverse_pseudo_wire_type">
    type: integer
  </definition>
  <definition term="netflow.reverse_relative_error">
    type: double
  </definition>
  <definition term="netflow.reverse_responder_octets">
    type: long
  </definition>
  <definition term="netflow.reverse_responder_packets">
    type: long
  </definition>
  <definition term="netflow.reverse_rfc3550_jitter_microseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_rfc3550_jitter_milliseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_rfc3550_jitter_nanoseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_rtp_payload_type">
    type: short
  </definition>
  <definition term="netflow.reverse_rtp_sequence_number">
    type: integer
  </definition>
  <definition term="netflow.reverse_sampler_id">
    type: short
  </definition>
  <definition term="netflow.reverse_sampler_mode">
    type: short
  </definition>
  <definition term="netflow.reverse_sampler_name">
    type: keyword
  </definition>
  <definition term="netflow.reverse_sampler_random_interval">
    type: long
  </definition>
  <definition term="netflow.reverse_sampling_algorithm">
    type: short
  </definition>
  <definition term="netflow.reverse_sampling_flow_interval">
    type: long
  </definition>
  <definition term="netflow.reverse_sampling_flow_spacing">
    type: long
  </definition>
  <definition term="netflow.reverse_sampling_interval">
    type: long
  </definition>
  <definition term="netflow.reverse_sampling_packet_interval">
    type: long
  </definition>
  <definition term="netflow.reverse_sampling_packet_space">
    type: long
  </definition>
  <definition term="netflow.reverse_sampling_population">
    type: long
  </definition>
  <definition term="netflow.reverse_sampling_probability">
    type: double
  </definition>
  <definition term="netflow.reverse_sampling_size">
    type: long
  </definition>
  <definition term="netflow.reverse_sampling_time_interval">
    type: long
  </definition>
  <definition term="netflow.reverse_sampling_time_space">
    type: long
  </definition>
  <definition term="netflow.reverse_second_packet_banner">
    type: keyword
  </definition>
  <definition term="netflow.reverse_section_exported_octets">
    type: integer
  </definition>
  <definition term="netflow.reverse_section_offset">
    type: integer
  </definition>
  <definition term="netflow.reverse_selection_sequence_id">
    type: long
  </definition>
  <definition term="netflow.reverse_selector_algorithm">
    type: integer
  </definition>
  <definition term="netflow.reverse_selector_id">
    type: long
  </definition>
  <definition term="netflow.reverse_selector_id_total_flows_observed">
    type: long
  </definition>
  <definition term="netflow.reverse_selector_id_total_flows_selected">
    type: long
  </definition>
  <definition term="netflow.reverse_selector_id_total_pkts_observed">
    type: long
  </definition>
  <definition term="netflow.reverse_selector_id_total_pkts_selected">
    type: long
  </definition>
  <definition term="netflow.reverse_selector_name">
    type: keyword
  </definition>
  <definition term="netflow.reverse_session_scope">
    type: short
  </definition>
  <definition term="netflow.reverse_small_packet_count">
    type: long
  </definition>
  <definition term="netflow.reverse_source_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_source_ipv4_prefix">
    type: ip
  </definition>
  <definition term="netflow.reverse_source_ipv4_prefix_length">
    type: short
  </definition>
  <definition term="netflow.reverse_source_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_source_ipv6_prefix">
    type: ip
  </definition>
  <definition term="netflow.reverse_source_ipv6_prefix_length">
    type: short
  </definition>
  <definition term="netflow.reverse_source_mac_address">
    type: keyword
  </definition>
  <definition term="netflow.reverse_source_transport_port">
    type: integer
  </definition>
  <definition term="netflow.reverse_src_traffic_index">
    type: long
  </definition>
  <definition term="netflow.reverse_sta_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.reverse_sta_mac_address">
    type: keyword
  </definition>
  <definition term="netflow.reverse_standard_deviation_interarrival_time">
    type: long
  </definition>
  <definition term="netflow.reverse_standard_deviation_payload_length">
    type: integer
  </definition>
  <definition term="netflow.reverse_system_init_time_milliseconds">
    type: long
  </definition>
  <definition term="netflow.reverse_tcp_ack_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_tcp_acknowledgement_number">
    type: long
  </definition>
  <definition term="netflow.reverse_tcp_control_bits">
    type: integer
  </definition>
  <definition term="netflow.reverse_tcp_destination_port">
    type: integer
  </definition>
  <definition term="netflow.reverse_tcp_fin_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_tcp_header_length">
    type: short
  </definition>
  <definition term="netflow.reverse_tcp_options">
    type: long
  </definition>
  <definition term="netflow.reverse_tcp_psh_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_tcp_rst_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_tcp_sequence_number">
    type: long
  </definition>
  <definition term="netflow.reverse_tcp_source_port">
    type: integer
  </definition>
  <definition term="netflow.reverse_tcp_syn_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_tcp_urg_total_count">
    type: long
  </definition>
  <definition term="netflow.reverse_tcp_urgent_pointer">
    type: integer
  </definition>
  <definition term="netflow.reverse_tcp_window_scale">
    type: integer
  </definition>
  <definition term="netflow.reverse_tcp_window_size">
    type: integer
  </definition>
  <definition term="netflow.reverse_total_length_ipv4">
    type: integer
  </definition>
  <definition term="netflow.reverse_transport_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_transport_packet_delta_count">
    type: long
  </definition>
  <definition term="netflow.reverse_tunnel_technology">
    type: keyword
  </definition>
  <definition term="netflow.reverse_udp_destination_port">
    type: integer
  </definition>
  <definition term="netflow.reverse_udp_message_length">
    type: integer
  </definition>
  <definition term="netflow.reverse_udp_source_port">
    type: integer
  </definition>
  <definition term="netflow.reverse_union_tcp_flags">
    type: short
  </definition>
  <definition term="netflow.reverse_upper_ci_limit">
    type: double
  </definition>
  <definition term="netflow.reverse_user_name">
    type: keyword
  </definition>
  <definition term="netflow.reverse_value_distribution_method">
    type: short
  </definition>
  <definition term="netflow.reverse_virtual_station_interface_id">
    type: keyword
  </definition>
  <definition term="netflow.reverse_virtual_station_interface_name">
    type: keyword
  </definition>
  <definition term="netflow.reverse_virtual_station_name">
    type: keyword
  </definition>
  <definition term="netflow.reverse_virtual_station_uuid">
    type: keyword
  </definition>
  <definition term="netflow.reverse_vlan_id">
    type: integer
  </definition>
  <definition term="netflow.reverse_vr_fname">
    type: keyword
  </definition>
  <definition term="netflow.reverse_wlan_channel_id">
    type: short
  </definition>
  <definition term="netflow.reverse_wlan_ssid">
    type: keyword
  </definition>
  <definition term="netflow.reverse_wtp_mac_address">
    type: keyword
  </definition>
  <definition term="netflow.rfc3550_jitter_microseconds">
    type: long
  </definition>
  <definition term="netflow.rfc3550_jitter_milliseconds">
    type: long
  </definition>
  <definition term="netflow.rfc3550_jitter_nanoseconds">
    type: long
  </definition>
  <definition term="netflow.rtp_payload_type">
    type: short
  </definition>
  <definition term="netflow.rtp_sequence_number">
    type: integer
  </definition>
  <definition term="netflow.sampler_id">
    type: short
  </definition>
  <definition term="netflow.sampler_mode">
    type: short
  </definition>
  <definition term="netflow.sampler_name">
    type: keyword
  </definition>
  <definition term="netflow.sampler_random_interval">
    type: long
  </definition>
  <definition term="netflow.sampling_algorithm">
    type: short
  </definition>
  <definition term="netflow.sampling_flow_interval">
    type: long
  </definition>
  <definition term="netflow.sampling_flow_spacing">
    type: long
  </definition>
  <definition term="netflow.sampling_interval">
    type: long
  </definition>
  <definition term="netflow.sampling_packet_interval">
    type: long
  </definition>
  <definition term="netflow.sampling_packet_space">
    type: long
  </definition>
  <definition term="netflow.sampling_population">
    type: long
  </definition>
  <definition term="netflow.sampling_probability">
    type: double
  </definition>
  <definition term="netflow.sampling_size">
    type: long
  </definition>
  <definition term="netflow.sampling_time_interval">
    type: long
  </definition>
  <definition term="netflow.sampling_time_space">
    type: long
  </definition>
  <definition term="netflow.second_packet_banner">
    type: keyword
  </definition>
  <definition term="netflow.section_exported_octets">
    type: integer
  </definition>
  <definition term="netflow.section_offset">
    type: integer
  </definition>
  <definition term="netflow.selection_sequence_id">
    type: long
  </definition>
  <definition term="netflow.selector_algorithm">
    type: integer
  </definition>
  <definition term="netflow.selector_id">
    type: long
  </definition>
  <definition term="netflow.selector_id_total_flows_observed">
    type: long
  </definition>
  <definition term="netflow.selector_id_total_flows_selected">
    type: long
  </definition>
  <definition term="netflow.selector_id_total_pkts_observed">
    type: long
  </definition>
  <definition term="netflow.selector_id_total_pkts_selected">
    type: long
  </definition>
  <definition term="netflow.selector_name">
    type: keyword
  </definition>
  <definition term="netflow.service_name">
    type: keyword
  </definition>
  <definition term="netflow.session_scope">
    type: short
  </definition>
  <definition term="netflow.silk_app_label">
    type: integer
  </definition>
  <definition term="netflow.small_packet_count">
    type: long
  </definition>
  <definition term="netflow.source_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.source_ipv4_prefix">
    type: ip
  </definition>
  <definition term="netflow.source_ipv4_prefix_length">
    type: short
  </definition>
  <definition term="netflow.source_ipv6_address">
    type: ip
  </definition>
  <definition term="netflow.source_ipv6_prefix">
    type: ip
  </definition>
  <definition term="netflow.source_ipv6_prefix_length">
    type: short
  </definition>
  <definition term="netflow.source_mac_address">
    type: keyword
  </definition>
  <definition term="netflow.source_transport_port">
    type: integer
  </definition>
  <definition term="netflow.source_transport_ports_limit">
    type: integer
  </definition>
  <definition term="netflow.src_traffic_index">
    type: long
  </definition>
  <definition term="netflow.ssl_cert_serial_number">
    type: keyword
  </definition>
  <definition term="netflow.ssl_cert_signature">
    type: keyword
  </definition>
  <definition term="netflow.ssl_cert_validity_not_after">
    type: keyword
  </definition>
  <definition term="netflow.ssl_cert_validity_not_before">
    type: keyword
  </definition>
  <definition term="netflow.ssl_cert_version">
    type: short
  </definition>
  <definition term="netflow.ssl_certificate_hash">
    type: keyword
  </definition>
  <definition term="netflow.ssl_cipher">
    type: keyword
  </definition>
  <definition term="netflow.ssl_client_version">
    type: short
  </definition>
  <definition term="netflow.ssl_compression_method">
    type: short
  </definition>
  <definition term="netflow.ssl_object_type">
    type: keyword
  </definition>
  <definition term="netflow.ssl_object_value">
    type: keyword
  </definition>
  <definition term="netflow.ssl_public_key_algorithm">
    type: keyword
  </definition>
  <definition term="netflow.ssl_public_key_length">
    type: keyword
  </definition>
  <definition term="netflow.ssl_server_cipher">
    type: long
  </definition>
  <definition term="netflow.ssl_server_name">
    type: keyword
  </definition>
  <definition term="netflow.sta_ipv4_address">
    type: ip
  </definition>
  <definition term="netflow.sta_mac_address">
    type: keyword
  </definition>
  <definition term="netflow.standard_deviation_interarrival_time">
    type: long
  </definition>
  <definition term="netflow.standard_deviation_payload_length">
    type: short
  </definition>
  <definition term="netflow.system_init_time_milliseconds">
    type: date
  </definition>
  <definition term="netflow.tcp_ack_total_count">
    type: long
  </definition>
  <definition term="netflow.tcp_acknowledgement_number">
    type: long
  </definition>
  <definition term="netflow.tcp_control_bits">
    type: integer
  </definition>
  <definition term="netflow.tcp_destination_port">
    type: integer
  </definition>
  <definition term="netflow.tcp_fin_total_count">
    type: long
  </definition>
  <definition term="netflow.tcp_header_length">
    type: short
  </definition>
  <definition term="netflow.tcp_options">
    type: long
  </definition>
  <definition term="netflow.tcp_psh_total_count">
    type: long
  </definition>
  <definition term="netflow.tcp_rst_total_count">
    type: long
  </definition>
  <definition term="netflow.tcp_sequence_number">
    type: long
  </definition>
  <definition term="netflow.tcp_source_port">
    type: integer
  </definition>
  <definition term="netflow.tcp_syn_total_count">
    type: long
  </definition>
  <definition term="netflow.tcp_urg_total_count">
    type: long
  </definition>
  <definition term="netflow.tcp_urgent_pointer">
    type: integer
  </definition>
  <definition term="netflow.tcp_window_scale">
    type: integer
  </definition>
  <definition term="netflow.tcp_window_size">
    type: integer
  </definition>
  <definition term="netflow.template_id">
    type: integer
  </definition>
  <definition term="netflow.tftp_filename">
    type: keyword
  </definition>
  <definition term="netflow.tftp_mode">
    type: keyword
  </definition>
  <definition term="netflow.timestamp">
    type: long
  </definition>
  <definition term="netflow.timestamp_absolute_monitoring-interval">
    type: long
  </definition>
  <definition term="netflow.total_length_ipv4">
    type: integer
  </definition>
  <definition term="netflow.traffic_type">
    type: short
  </definition>
  <definition term="netflow.transport_octet_delta_count">
    type: long
  </definition>
  <definition term="netflow.transport_packet_delta_count">
    type: long
  </definition>
  <definition term="netflow.tunnel_technology">
    type: keyword
  </definition>
  <definition term="netflow.udp_destination_port">
    type: integer
  </definition>
  <definition term="netflow.udp_message_length">
    type: integer
  </definition>
  <definition term="netflow.udp_source_port">
    type: integer
  </definition>
  <definition term="netflow.union_tcp_flags">
    type: short
  </definition>
  <definition term="netflow.upper_ci_limit">
    type: double
  </definition>
  <definition term="netflow.user_name">
    type: keyword
  </definition>
  <definition term="netflow.username">
    type: keyword
  </definition>
  <definition term="netflow.value_distribution_method">
    type: short
  </definition>
  <definition term="netflow.viptela_vpn_id">
    type: long
  </definition>
  <definition term="netflow.virtual_station_interface_id">
    type: short
  </definition>
  <definition term="netflow.virtual_station_interface_name">
    type: keyword
  </definition>
  <definition term="netflow.virtual_station_name">
    type: keyword
  </definition>
  <definition term="netflow.virtual_station_uuid">
    type: short
  </definition>
  <definition term="netflow.vlan_id">
    type: integer
  </definition>
  <definition term="netflow.vmware_egress_interface_attr">
    type: integer
  </definition>
  <definition term="netflow.vmware_ingress_interface_attr">
    type: integer
  </definition>
  <definition term="netflow.vmware_tenant_dest_ipv4">
    type: ip
  </definition>
  <definition term="netflow.vmware_tenant_dest_ipv6">
    type: ip
  </definition>
  <definition term="netflow.vmware_tenant_dest_port">
    type: integer
  </definition>
  <definition term="netflow.vmware_tenant_protocol">
    type: short
  </definition>
  <definition term="netflow.vmware_tenant_source_ipv4">
    type: ip
  </definition>
  <definition term="netflow.vmware_tenant_source_ipv6">
    type: ip
  </definition>
  <definition term="netflow.vmware_tenant_source_port">
    type: integer
  </definition>
  <definition term="netflow.vmware_vxlan_export_role">
    type: short
  </definition>
  <definition term="netflow.vpn_identifier">
    type: short
  </definition>
  <definition term="netflow.vr_fname">
    type: keyword
  </definition>
  <definition term="netflow.waasoptimization_segment">
    type: short
  </definition>
  <definition term="netflow.wlan_channel_id">
    type: short
  </definition>
  <definition term="netflow.wlan_ssid">
    type: keyword
  </definition>
  <definition term="netflow.wtp_mac_address">
    type: keyword
  </definition>
  <definition term="netflow.xlate_destination_address_ip_v4">
    type: ip
  </definition>
  <definition term="netflow.xlate_destination_port">
    type: integer
  </definition>
  <definition term="netflow.xlate_source_address_ip_v4">
    type: ip
  </definition>
  <definition term="netflow.xlate_source_port">
    type: integer
  </definition>
</definitions>