﻿---
title: NATS fields
description: Module for parsing NATS log files. Fields from NATS logs. Nats log files Fields from NATS logs client. Fields from NATS logs message. 
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-nats
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Beta
---

# NATS fields
Module for parsing NATS log files.

## nats

Fields from NATS logs.

## log

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Nats log files

## client

Fields from NATS logs client.
<definitions>
  <definition term="nats.log.client.id">
    The id of the client
    type: integer
  </definition>
</definitions>


## msg

Fields from NATS logs message.
<definitions>
  <definition term="nats.log.msg.bytes">
    Size of the payload in bytes
    type: long
    format: bytes
  </definition>
  <definition term="nats.log.msg.type">
    The protocol message type
    type: keyword
  </definition>
  <definition term="nats.log.msg.subject">
    Subject name this message was received on
    type: keyword
  </definition>
  <definition term="nats.log.msg.sid">
    The unique alphanumeric subscription ID of the subject
    type: integer
  </definition>
  <definition term="nats.log.msg.reply_to">
    The inbox subject on which the publisher is listening for responses
    type: keyword
  </definition>
  <definition term="nats.log.msg.max_messages">
    An optional number of messages to wait for before automatically unsubscribing
    type: integer
  </definition>
  <definition term="nats.log.msg.error.message">
    Details about the error occurred
    type: text
  </definition>
  <definition term="nats.log.msg.queue_group">
    The queue group which subscriber will join
    type: text
  </definition>
</definitions>