﻿---
title: MISP fields
description: Module for handling threat information from MISP. Fields from MISP threat information. Fields provide support for specifying information about attack...
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-misp
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# MISP fields
Module for handling threat information from MISP.

## misp

Fields from MISP threat information.

## attack_pattern

Fields provide support for specifying information about attack patterns.
<definitions>
  <definition term="misp.attack_pattern.id">
    Identifier of the threat indicator.
    type: keyword
  </definition>
  <definition term="misp.attack_pattern.name">
    Name of the attack pattern.
    type: keyword
  </definition>
  <definition term="misp.attack_pattern.description">
    Description of the attack pattern.
    type: text
  </definition>
  <definition term="misp.attack_pattern.kill_chain_phases">
    The kill chain phase(s) to which this attack pattern corresponds.
    type: keyword
  </definition>
</definitions>


## campaign

Fields provide support for specifying information about campaigns.
<definitions>
  <definition term="misp.campaign.id">
    Identifier of the campaign.
    type: keyword
  </definition>
  <definition term="misp.campaign.name">
    Name of the campaign.
    type: keyword
  </definition>
  <definition term="misp.campaign.description">
    Description of the campaign.
    type: text
  </definition>
  <definition term="misp.campaign.aliases">
    Alternative names used to identify this campaign.
    type: text
  </definition>
  <definition term="misp.campaign.first_seen">
    The time that this Campaign was first seen, in RFC3339 format.
    type: date
  </definition>
  <definition term="misp.campaign.last_seen">
    The time that this Campaign was last seen, in RFC3339 format.
    type: date
  </definition>
  <definition term="misp.campaign.objective">
    This field defines the Campaign's primary goal, objective, desired outcome, or intended effect.
    type: keyword
  </definition>
</definitions>


## course_of_action

A Course of Action is an action taken either to prevent an attack or to respond to an attack that is in progress.
<definitions>
  <definition term="misp.course_of_action.id">
    Identifier of the Course of Action.
    type: keyword
  </definition>
  <definition term="misp.course_of_action.name">
    The name used to identify the Course of Action.
    type: keyword
  </definition>
  <definition term="misp.course_of_action.description">
    Description of the Course of Action.
    type: text
  </definition>
</definitions>


## identity

Identity can represent actual individuals, organizations, or groups, as well as classes of individuals, organizations, or groups.
<definitions>
  <definition term="misp.identity.id">
    Identifier of the Identity.
    type: keyword
  </definition>
  <definition term="misp.identity.name">
    The name used to identify the Identity.
    type: keyword
  </definition>
  <definition term="misp.identity.description">
    Description of the Identity.
    type: text
  </definition>
  <definition term="misp.identity.identity_class">
    The type of entity that this Identity describes, e.g., an individual or organization. Open Vocab - identity-class-ov
    type: keyword
  </definition>
  <definition term="misp.identity.labels">
    The list of roles that this Identity performs.
    type: keyword
    example: CEO
  </definition>
  <definition term="misp.identity.sectors">
    The list of sectors that this Identity belongs to. Open Vocab - industry-sector-ov
    type: keyword
  </definition>
  <definition term="misp.identity.contact_information">
    The contact information (e-mail, phone number, etc.) for this Identity.
    type: text
  </definition>
</definitions>


## intrusion_set

An Intrusion Set is a grouped set of adversary behavior and resources with common properties that is believed to be orchestrated by a single organization.
<definitions>
  <definition term="misp.intrusion_set.id">
    Identifier of the Intrusion Set.
    type: keyword
  </definition>
  <definition term="misp.intrusion_set.name">
    The name used to identify the Intrusion Set.
    type: keyword
  </definition>
  <definition term="misp.intrusion_set.description">
    Description of the Intrusion Set.
    type: text
  </definition>
  <definition term="misp.intrusion_set.aliases">
    Alternative names used to identify the Intrusion Set.
    type: text
  </definition>
  <definition term="misp.intrusion_set.first_seen">
    The time that this Intrusion Set was first seen, in RFC3339 format.
    type: date
  </definition>
  <definition term="misp.intrusion_set.last_seen">
    The time that this Intrusion Set was last seen, in RFC3339 format.
    type: date
  </definition>
  <definition term="misp.intrusion_set.goals">
    The high level goals of this Intrusion Set, namely, what are they trying to do.
    type: text
  </definition>
  <definition term="misp.intrusion_set.resource_level">
    This defines the organizational level at which this Intrusion Set typically works. Open Vocab - attack-resource-level-ov
    type: text
  </definition>
  <definition term="misp.intrusion_set.primary_motivation">
    The primary reason, motivation, or purpose behind this Intrusion Set. Open Vocab - attack-motivation-ov
    type: text
  </definition>
  <definition term="misp.intrusion_set.secondary_motivations">
    The secondary reasons, motivations, or purposes behind this Intrusion Set. Open Vocab - attack-motivation-ov
    type: text
  </definition>
</definitions>


## malware

Malware is a type of TTP that is also known as malicious code and malicious software, refers to a program that is inserted into a system, usually covertly, with the intent of compromising the confidentiality, integrity, or availability of the victim's data, applications, or operating system (OS) or of otherwise annoying or disrupting the victim.
<definitions>
  <definition term="misp.malware.id">
    Identifier of the Malware.
    type: keyword
  </definition>
  <definition term="misp.malware.name">
    The name used to identify the Malware.
    type: keyword
  </definition>
  <definition term="misp.malware.description">
    Description of the Malware.
    type: text
  </definition>
  <definition term="misp.malware.labels">
    The type of malware being described.  Open Vocab - malware-label-ov.  adware,backdoor,bot,ddos,dropper,exploit-kit,keylogger,ransomware, remote-access-trojan,resource-exploitation,rogue-security-software,rootkit, screen-capture,spyware,trojan,virus,worm
    type: keyword
  </definition>
  <definition term="misp.malware.kill_chain_phases">
    The list of kill chain phases for which this Malware instance can be used.
    type: keyword
    format: string
  </definition>
</definitions>


## note

A Note is a comment or note containing informative text to help explain the context of one or more STIX Objects (SDOs or SROs) or to provide additional analysis that is not contained in the original object.
<definitions>
  <definition term="misp.note.id">
    Identifier of the Note.
    type: keyword
  </definition>
  <definition term="misp.note.summary">
    A brief description used as a summary of the Note.
    type: keyword
  </definition>
  <definition term="misp.note.description">
    The content of the Note.
    type: text
  </definition>
  <definition term="misp.note.authors">
    The name of the author(s) of this Note.
    type: keyword
  </definition>
  <definition term="misp.note.object_refs">
    The STIX Objects (SDOs and SROs) that the note is being applied to.
    type: keyword
  </definition>
</definitions>


## threat_indicator

Fields provide support for specifying information about threat indicators, and related matching patterns.
<definitions>
  <definition term="misp.threat_indicator.labels">
    list of type open-vocab that specifies the type of indicator.
    type: keyword
    example: Domain Watchlist
  </definition>
  <definition term="misp.threat_indicator.id">
    Identifier of the threat indicator.
    type: keyword
  </definition>
  <definition term="misp.threat_indicator.version">
    Version of the threat indicator.
    type: keyword
  </definition>
  <definition term="misp.threat_indicator.type">
    Type of the threat indicator.
    type: keyword
  </definition>
  <definition term="misp.threat_indicator.description">
    Description of the threat indicator.
    type: text
  </definition>
  <definition term="misp.threat_indicator.feed">
    Name of the threat feed.
    type: text
  </definition>
  <definition term="misp.threat_indicator.valid_from">
    The time from which this Indicator should be considered valuable  intelligence, in RFC3339 format.
    type: date
  </definition>
  <definition term="misp.threat_indicator.valid_until">
    The time at which this Indicator should no longer be considered valuable intelligence. If the valid_until property is omitted, then there is no constraint on the latest time for which the indicator should be used, in RFC3339 format.
    type: date
  </definition>
  <definition term="misp.threat_indicator.severity">
    Threat severity to which this indicator corresponds.
    type: keyword
    example: high
    format: string
  </definition>
  <definition term="misp.threat_indicator.confidence">
    Confidence level to which this indicator corresponds.
    type: keyword
    example: high
  </definition>
  <definition term="misp.threat_indicator.kill_chain_phases">
    The kill chain phase(s) to which this indicator corresponds.
    type: keyword
    format: string
  </definition>
  <definition term="misp.threat_indicator.mitre_tactic">
    MITRE tactics to which this indicator corresponds.
    type: keyword
    example: Initial Access
    format: string
  </definition>
  <definition term="misp.threat_indicator.mitre_technique">
    MITRE techniques to which this indicator corresponds.
    type: keyword
    example: Drive-by Compromise
    format: string
  </definition>
  <definition term="misp.threat_indicator.attack_pattern">
    The attack_pattern for this indicator is a STIX Pattern as specified in STIX Version 2.0 Part 5 - STIX Patterning.
    type: keyword
    example: [destination:ip = '91.219.29.188/32']
  </definition>
  <definition term="misp.threat_indicator.attack_pattern_kql">
    The attack_pattern for this indicator is KQL query that matches the attack_pattern specified in the STIX Pattern format.
    type: keyword
    example: destination.ip: "91.219.29.188/32"
  </definition>
  <definition term="misp.threat_indicator.negate">
    When set to true, it specifies the absence of the attack_pattern.
    type: boolean
  </definition>
  <definition term="misp.threat_indicator.intrusion_set">
    Name of the intrusion set if known.
    type: keyword
  </definition>
  <definition term="misp.threat_indicator.campaign">
    Name of the attack campaign if known.
    type: keyword
  </definition>
  <definition term="misp.threat_indicator.threat_actor">
    Name of the threat actor if known.
    type: keyword
  </definition>
</definitions>


## observed_data

Observed data conveys information that was observed on systems and networks, such as log data or network traffic, using the Cyber Observable specification.
<definitions>
  <definition term="misp.observed_data.id">
    Identifier of the Observed Data.
    type: keyword
  </definition>
  <definition term="misp.observed_data.first_observed">
    The beginning of the time window that the data was observed, in RFC3339 format.
    type: date
  </definition>
  <definition term="misp.observed_data.last_observed">
    The end of the time window that the data was observed, in RFC3339 format.
    type: date
  </definition>
  <definition term="misp.observed_data.number_observed">
    The number of times the data represented in the objects property was observed. This MUST be an integer between 1 and 999,999,999 inclusive.
    type: integer
  </definition>
  <definition term="misp.observed_data.objects">
    A dictionary of Cyber Observable Objects that describes the single fact that was observed.
    type: keyword
  </definition>
</definitions>


## report

Reports are collections of threat intelligence focused on one or more topics, such as a description of a threat actor, malware, or attack technique, including context and related details.
<definitions>
  <definition term="misp.report.id">
    Identifier of the Report.
    type: keyword
  </definition>
  <definition term="misp.report.labels">
    This field is an Open Vocabulary that specifies the primary subject of this report.  Open Vocab - report-label-ov. threat-report,attack-pattern,campaign,identity,indicator,malware,observed-data,threat-actor,tool,vulnerability
    type: keyword
  </definition>
  <definition term="misp.report.name">
    The name used to identify the Report.
    type: keyword
  </definition>
  <definition term="misp.report.description">
    A description that provides more details and context about Report.
    type: text
  </definition>
  <definition term="misp.report.published">
    The date that this report object was officially published by the creator of this report, in RFC3339 format.
    type: date
  </definition>
  <definition term="misp.report.object_refs">
    Specifies the STIX Objects that are referred to by this Report.
    type: text
  </definition>
</definitions>


## threat_actor

Threat Actors are actual individuals, groups, or organizations believed to be operating with malicious intent.
<definitions>
  <definition term="misp.threat_actor.id">
    Identifier of the Threat Actor.
    type: keyword
  </definition>
  <definition term="misp.threat_actor.labels">
    This field specifies the type of threat actor.  Open Vocab - threat-actor-label-ov. activist,competitor,crime-syndicate,criminal,hacker,insider-accidental,insider-disgruntled,nation-state,sensationalist,spy,terrorist
    type: keyword
  </definition>
  <definition term="misp.threat_actor.name">
    The name used to identify this Threat Actor or Threat Actor group.
    type: keyword
  </definition>
  <definition term="misp.threat_actor.description">
    A description that provides more details and context about the Threat Actor.
    type: text
  </definition>
  <definition term="misp.threat_actor.aliases">
    A list of other names that this Threat Actor is believed to use.
    type: text
  </definition>
  <definition term="misp.threat_actor.roles">
    This is a list of roles the Threat Actor plays.  Open Vocab - threat-actor-role-ov. agent,director,independent,sponsor,infrastructure-operator,infrastructure-architect,malware-author
    type: text
  </definition>
  <definition term="misp.threat_actor.goals">
    The high level goals of this Threat Actor, namely, what are they trying to do.
    type: text
  </definition>
  <definition term="misp.threat_actor.sophistication">
    The skill, specific knowledge, special training, or expertise a Threat Actor  must have to perform the attack.  Open Vocab - threat-actor-sophistication-ov. none,minimal,intermediate,advanced,strategic,expert,innovator
    type: text
  </definition>
  <definition term="misp.threat_actor.resource_level">
    This defines the organizational level at which this Threat Actor typically works.  Open Vocab - attack-resource-level-ov. individual,club,contest,team,organization,government
    type: text
  </definition>
  <definition term="misp.threat_actor.primary_motivation">
    The primary reason, motivation, or purpose behind this Threat Actor.  Open Vocab - attack-motivation-ov. accidental,coercion,dominance,ideology,notoriety,organizational-gain,personal-gain,personal-satisfaction,revenge,unpredictable
    type: text
  </definition>
  <definition term="misp.threat_actor.secondary_motivations">
    The secondary reasons, motivations, or purposes behind this Threat Actor.  Open Vocab - attack-motivation-ov. accidental,coercion,dominance,ideology,notoriety,organizational-gain,personal-gain,personal-satisfaction,revenge,unpredictable
    type: text
  </definition>
  <definition term="misp.threat_actor.personal_motivations">
    The personal reasons, motivations, or purposes of the Threat Actor regardless of  organizational goals. Open Vocab - attack-motivation-ov. accidental,coercion,dominance,ideology,notoriety,organizational-gain,personal-gain,personal-satisfaction,revenge,unpredictable
    type: text
  </definition>
</definitions>


## tool

Tools are legitimate software that can be used by threat actors to perform attacks.
<definitions>
  <definition term="misp.tool.id">
    Identifier of the Tool.
    type: keyword
  </definition>
  <definition term="misp.tool.labels">
    The kind(s) of tool(s) being described.  Open Vocab - tool-label-ov. denial-of-service,exploitation,information-gathering,network-capture,credential-exploitation,remote-access,vulnerability-scanning
    type: keyword
  </definition>
  <definition term="misp.tool.name">
    The name used to identify the Tool.
    type: keyword
  </definition>
  <definition term="misp.tool.description">
    A description that provides more details and context about the Tool.
    type: text
  </definition>
  <definition term="misp.tool.tool_version">
    The version identifier associated with the Tool.
    type: keyword
  </definition>
  <definition term="misp.tool.kill_chain_phases">
    The list of kill chain phases for which this Tool instance can be used.
    type: text
  </definition>
</definitions>


## vulnerability

A Vulnerability is a mistake in software that can be directly used by a hacker to gain access to a system or network.
<definitions>
  <definition term="misp.vulnerability.id">
    Identifier of the Vulnerability.
    type: keyword
  </definition>
  <definition term="misp.vulnerability.name">
    The name used to identify the Vulnerability.
    type: keyword
  </definition>
  <definition term="misp.vulnerability.description">
    A description that provides more details and context about the Vulnerability.
    type: text
  </definition>
</definitions>