﻿---
title: Logstash fields
description: logstash Module Fields from the Logstash logs. slowlog 
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-logstash
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Logstash fields
logstash Module

## logstash


## log

Fields from the Logstash logs.
<definitions>
  <definition term="logstash.log.module">
    The module or class where the event originate.
    type: keyword
  </definition>
  <definition term="logstash.log.thread">
    Information about the running thread where the log originate.
    type: keyword
  </definition>
  <definition term="logstash.log.thread.text">
    type: text
  </definition>
  <definition term="logstash.log.log_event">
    key and value debugging information.
    type: object
  </definition>
  <definition term="logstash.log.log_event.action">
    type: keyword
  </definition>
  <definition term="logstash.log.pipeline_id">
    The ID of the pipeline.
    type: keyword
    example: main
  </definition>
  <definition term="logstash.log.message">
    type: alias
    alias to: message
  </definition>
  <definition term="logstash.log.level">
    type: alias
    alias to: log.level
  </definition>
</definitions>


## slowlog

slowlog
<definitions>
  <definition term="logstash.slowlog.module">
    The module or class where the event originate.
    type: keyword
  </definition>
  <definition term="logstash.slowlog.thread">
    Information about the running thread where the log originate.
    type: keyword
  </definition>
  <definition term="logstash.slowlog.thread.text">
    type: text
  </definition>
  <definition term="logstash.slowlog.event">
    Raw dump of the original event
    type: keyword
  </definition>
  <definition term="logstash.slowlog.event.text">
    type: text
  </definition>
  <definition term="logstash.slowlog.plugin_name">
    Name of the plugin
    type: keyword
  </definition>
  <definition term="logstash.slowlog.plugin_type">
    Type of the plugin: Inputs, Filters, Outputs or Codecs.
    type: keyword
  </definition>
  <definition term="logstash.slowlog.took_in_millis">
    Execution time for the plugin in milliseconds.
    type: long
  </definition>
  <definition term="logstash.slowlog.plugin_params">
    String value of the plugin configuration
    type: keyword
  </definition>
  <definition term="logstash.slowlog.plugin_params.text">
    type: text
  </definition>
  <definition term="logstash.slowlog.plugin_params_object">
    key -> value of the configuration used by the plugin.
    type: object
  </definition>
  <definition term="logstash.slowlog.level">
    type: alias
    alias to: log.level
  </definition>
  <definition term="logstash.slowlog.took_in_nanos">
    type: alias
    alias to: event.duration
  </definition>
</definitions>