﻿---
title: Log file content fields
description: Contains log file lines. 
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-log
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Log file content fields
Contains log file lines.
<definitions>
  <definition term="log.source.address">
    Source address from which the log event was read / sent from.
    type: keyword
    required: False
  </definition>
  <definition term="log.offset">
    The file offset the reported line starts at.
    type: long
    required: False
  </definition>
  <definition term="stream">
    Log stream when reading container logs, can be 'stdout' or 'stderr'
    type: keyword
    required: False
  </definition>
  <definition term="input.type">
    The input type from which the event was generated. This field is set to the value specified for the `type` option in the input section of the Filebeat config file.
    required: True
  </definition>
  <definition term="syslog.facility">
    The facility extracted from the priority.
    type: long
    required: False
  </definition>
  <definition term="syslog.priority">
    The priority of the syslog event.
    type: long
    required: False
  </definition>
  <definition term="syslog.severity_label">
    The human readable severity.
    type: keyword
    required: False
  </definition>
  <definition term="syslog.facility_label">
    The human readable facility.
    type: keyword
    required: False
  </definition>
  <definition term="process.program">
    The name of the program.
    type: keyword
    required: False
  </definition>
  <definition term="log.flags">
    This field contains the flags of the event.
  </definition>
  <definition term="http.response.content_length">
    type: alias
    alias to: http.response.body.bytes
  </definition>
  <definition term="user_agent.os.full_name">
    type: keyword
  </definition>
  <definition term="fileset.name">
    The Filebeat fileset that generated this event.
    type: keyword
  </definition>
  <definition term="fileset.module">
    type: alias
    alias to: event.module
  </definition>
  <definition term="read_timestamp">
    type: alias
    alias to: event.created
  </definition>
  <definition term="docker.attrs">
    docker.attrs contains labels and environment variables written by docker's JSON File logging driver. These fields are only available when they are configured in the logging driver options.
    type: object
  </definition>
  <definition term="icmp.code">
    ICMP code.
    type: keyword
  </definition>
  <definition term="icmp.type">
    ICMP type.
    type: keyword
  </definition>
  <definition term="igmp.type">
    IGMP type.
    type: keyword
  </definition>
  <definition term="azure.eventhub">
    Name of the eventhub.
    type: keyword
  </definition>
  <definition term="azure.offset">
    The offset.
    type: long
  </definition>
  <definition term="azure.enqueued_time">
    The enqueued time.
    type: date
  </definition>
  <definition term="azure.partition_id">
    The partition id.
    type: long
  </definition>
  <definition term="azure.consumer_group">
    The consumer group.
    type: keyword
  </definition>
  <definition term="azure.sequence_number">
    The sequence number.
    type: long
  </definition>
  <definition term="kafka.topic">
    Kafka topic
    type: keyword
  </definition>
  <definition term="kafka.partition">
    Kafka partition number
    type: long
  </definition>
  <definition term="kafka.offset">
    Kafka offset of this message
    type: long
  </definition>
  <definition term="kafka.key">
    Kafka key, corresponding to the Kafka value stored in the message
    type: keyword
  </definition>
  <definition term="kafka.block_timestamp">
    Kafka outer (compressed) block timestamp
    type: date
  </definition>
  <definition term="kafka.headers">
    An array of Kafka header strings for this message, in the form "<key>: <value>".
    type: array
  </definition>
</definitions>