﻿---
title: Kibana fields
description: kibana Module Module for parsing Kibana logs. Kibana log lines. 
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-kibana
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Kibana fields
kibana Module
<definitions>
  <definition term="service.node.roles">
    type: keyword
  </definition>
</definitions>


## kibana

Module for parsing Kibana logs.
<definitions>
  <definition term="kibana.session_id">
    The ID of the user session associated with this event. Each login attempt results in a unique session id.
    type: keyword
    example: 123e4567-e89b-12d3-a456-426614174000
  </definition>
  <definition term="kibana.space_id">
    The id of the space associated with this event.
    type: keyword
    example: default
  </definition>
  <definition term="kibana.saved_object.type">
    The type of the saved object associated with this event.
    type: keyword
    example: dashboard
  </definition>
  <definition term="kibana.saved_object.id">
    The id of the saved object associated with this event.
    type: keyword
    example: 6295bdd0-0a0e-11e7-825f-6748cda7d858
  </definition>
  <definition term="kibana.saved_object.name">
    The name of the saved object associated with this event.
    type: keyword
    example: my-saved-object
  </definition>
  <definition term="kibana.add_to_spaces">
    The set of space ids that a saved object was shared to.
    type: keyword
    example: ['default', 'marketing']
  </definition>
  <definition term="kibana.delete_from_spaces">
    The set of space ids that a saved object was removed from.
    type: keyword
    example: ['default', 'marketing']
  </definition>
  <definition term="kibana.authentication_provider">
    The authentication provider associated with a login event.
    type: keyword
    example: basic1
  </definition>
  <definition term="kibana.authentication_type">
    The authentication provider type associated with a login event.
    type: keyword
    example: basic
  </definition>
  <definition term="kibana.authentication_realm">
    The Elasticsearch authentication realm name which fulfilled a login event.
    type: keyword
    example: native
  </definition>
  <definition term="kibana.lookup_realm">
    The Elasticsearch lookup realm which fulfilled a login event.
    type: keyword
    example: native
  </definition>
</definitions>


## log

Kibana log lines.
<definitions>
  <definition term="kibana.log.tags">
    Kibana logging tags.
    type: keyword
  </definition>
  <definition term="kibana.log.state">
    Current state of Kibana.
    type: keyword
  </definition>
  <definition term="kibana.log.meta">
    type: object
  </definition>
  <definition term="kibana.log.meta.req.headers">
    type: flattened
  </definition>
  <definition term="kibana.log.meta.res.headers">
    type: flattened
  </definition>
</definitions>