﻿---
title: Iptables fields
description: Module for handling the iptables logs. Fields from the iptables logs. ICMP fields. TCP fields. UDP fields. Fields for Ubiquiti network devices. 
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-iptables
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Iptables fields
Module for handling the iptables logs.

## iptables

Fields from the iptables logs.
<definitions>
  <definition term="iptables.ether_type">
    Value of the ethernet type field identifying the network layer protocol.
    type: long
  </definition>
  <definition term="iptables.flow_label">
    IPv6 flow label.
    type: integer
  </definition>
  <definition term="iptables.fragment_flags">
    IP fragment flags. A combination of CE, DF and MF.
    type: keyword
  </definition>
  <definition term="iptables.fragment_offset">
    Offset of the current IP fragment.
    type: long
  </definition>
</definitions>


## icmp

ICMP fields.
<definitions>
  <definition term="iptables.icmp.code">
    ICMP code.
    type: long
  </definition>
  <definition term="iptables.icmp.id">
    ICMP ID.
    type: long
  </definition>
  <definition term="iptables.icmp.parameter">
    ICMP parameter.
    type: long
  </definition>
  <definition term="iptables.icmp.redirect">
    ICMP redirect address.
    type: ip
  </definition>
  <definition term="iptables.icmp.seq">
    ICMP sequence number.
    type: long
  </definition>
  <definition term="iptables.icmp.type">
    ICMP type.
    type: long
  </definition>
  <definition term="iptables.id">
    Packet identifier.
    type: long
  </definition>
  <definition term="iptables.incomplete_bytes">
    Number of incomplete bytes.
    type: long
  </definition>
  <definition term="iptables.input_device">
    Device that received the packet.
    type: keyword
  </definition>
  <definition term="iptables.precedence_bits">
    IP precedence bits.
    type: short
  </definition>
  <definition term="iptables.tos">
    IP Type of Service field.
    type: long
  </definition>
  <definition term="iptables.length">
    Packet length.
    type: long
  </definition>
  <definition term="iptables.output_device">
    Device that output the packet.
    type: keyword
  </definition>
</definitions>


## tcp

TCP fields.
<definitions>
  <definition term="iptables.tcp.flags">
    TCP flags.
    type: keyword
  </definition>
  <definition term="iptables.tcp.reserved_bits">
    TCP reserved bits.
    type: short
  </definition>
  <definition term="iptables.tcp.seq">
    TCP sequence number.
    type: long
  </definition>
  <definition term="iptables.tcp.ack">
    TCP Acknowledgment number.
    type: long
  </definition>
  <definition term="iptables.tcp.window">
    Advertised TCP window size.
    type: long
  </definition>
  <definition term="iptables.ttl">
    Time To Live field.
    type: integer
  </definition>
</definitions>


## udp

UDP fields.
<definitions>
  <definition term="iptables.udp.length">
    Length of the UDP header and payload.
    type: long
  </definition>
</definitions>


## ubiquiti

Fields for Ubiquiti network devices.
<definitions>
  <definition term="iptables.ubiquiti.input_zone">
    Input zone.
    type: keyword
  </definition>
  <definition term="iptables.ubiquiti.output_zone">
    Output zone.
    type: keyword
  </definition>
  <definition term="iptables.ubiquiti.rule_number">
    The rule number within the rule set.
    type: keyword
  </definition>
  <definition term="iptables.ubiquiti.rule_set">
    The rule set name.
    type: keyword
  </definition>
</definitions>