﻿---
title: IIS fields
description: Module for parsing IIS log files. Fields from IIS log files. Contains fields for IIS access logs. Contains fields for IIS error logs. 
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-iis
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# IIS fields
Module for parsing IIS log files.

## iis

Fields from IIS log files.

## access

Contains fields for IIS access logs.
<definitions>
  <definition term="iis.access.sub_status">
    The HTTP substatus code.
    type: long
  </definition>
  <definition term="iis.access.win32_status">
    The Windows status code.
    type: long
  </definition>
  <definition term="iis.access.site_name">
    The site name and instance number.
    type: keyword
  </definition>
  <definition term="iis.access.server_name">
    The name of the server on which the log file entry was generated.
    type: keyword
  </definition>
  <definition term="iis.access.cookie">
    The content of the cookie sent or received, if any.
    type: keyword
  </definition>
  <definition term="iis.access.body_received.bytes">
    type: alias
    alias to: http.request.body.bytes
  </definition>
  <definition term="iis.access.body_sent.bytes">
    type: alias
    alias to: http.response.body.bytes
  </definition>
  <definition term="iis.access.server_ip">
    type: alias
    alias to: destination.address
  </definition>
  <definition term="iis.access.method">
    type: alias
    alias to: http.request.method
  </definition>
  <definition term="iis.access.url">
    type: alias
    alias to: url.path
  </definition>
  <definition term="iis.access.query_string">
    type: alias
    alias to: url.query
  </definition>
  <definition term="iis.access.port">
    type: alias
    alias to: destination.port
  </definition>
  <definition term="iis.access.user_name">
    type: alias
    alias to: user.name
  </definition>
  <definition term="iis.access.remote_ip">
    type: alias
    alias to: source.address
  </definition>
  <definition term="iis.access.referrer">
    type: alias
    alias to: http.request.referrer
  </definition>
  <definition term="iis.access.response_code">
    type: alias
    alias to: http.response.status_code
  </definition>
  <definition term="iis.access.http_version">
    type: alias
    alias to: http.version
  </definition>
  <definition term="iis.access.hostname">
    type: alias
    alias to: host.hostname
  </definition>
  <definition term="iis.access.user_agent.device">
    type: alias
    alias to: user_agent.device.name
  </definition>
  <definition term="iis.access.user_agent.name">
    type: alias
    alias to: user_agent.name
  </definition>
  <definition term="iis.access.user_agent.os">
    type: alias
    alias to: user_agent.os.full_name
  </definition>
  <definition term="iis.access.user_agent.os_name">
    type: alias
    alias to: user_agent.os.name
  </definition>
  <definition term="iis.access.user_agent.original">
    type: alias
    alias to: user_agent.original
  </definition>
  <definition term="iis.access.geoip.continent_name">
    type: alias
    alias to: source.geo.continent_name
  </definition>
  <definition term="iis.access.geoip.country_iso_code">
    type: alias
    alias to: source.geo.country_iso_code
  </definition>
  <definition term="iis.access.geoip.location">
    type: alias
    alias to: source.geo.location
  </definition>
  <definition term="iis.access.geoip.region_name">
    type: alias
    alias to: source.geo.region_name
  </definition>
  <definition term="iis.access.geoip.city_name">
    type: alias
    alias to: source.geo.city_name
  </definition>
  <definition term="iis.access.geoip.region_iso_code">
    type: alias
    alias to: source.geo.region_iso_code
  </definition>
</definitions>


## error

Contains fields for IIS error logs.
<definitions>
  <definition term="iis.error.reason_phrase">
    The HTTP reason phrase.
    type: keyword
  </definition>
  <definition term="iis.error.queue_name">
    The IIS application pool name.
    type: keyword
  </definition>
  <definition term="iis.error.remote_ip">
    type: alias
    alias to: source.address
  </definition>
  <definition term="iis.error.remote_port">
    type: alias
    alias to: source.port
  </definition>
  <definition term="iis.error.server_ip">
    type: alias
    alias to: destination.address
  </definition>
  <definition term="iis.error.server_port">
    type: alias
    alias to: destination.port
  </definition>
  <definition term="iis.error.http_version">
    type: alias
    alias to: http.version
  </definition>
  <definition term="iis.error.method">
    type: alias
    alias to: http.request.method
  </definition>
  <definition term="iis.error.url">
    type: alias
    alias to: url.original
  </definition>
  <definition term="iis.error.response_code">
    type: alias
    alias to: http.response.status_code
  </definition>
  <definition term="iis.error.geoip.continent_name">
    type: alias
    alias to: source.geo.continent_name
  </definition>
  <definition term="iis.error.geoip.country_iso_code">
    type: alias
    alias to: source.geo.country_iso_code
  </definition>
  <definition term="iis.error.geoip.location">
    type: alias
    alias to: source.geo.location
  </definition>
  <definition term="iis.error.geoip.region_name">
    type: alias
    alias to: source.geo.region_name
  </definition>
  <definition term="iis.error.geoip.city_name">
    type: alias
    alias to: source.geo.city_name
  </definition>
  <definition term="iis.error.geoip.region_iso_code">
    type: alias
    alias to: source.geo.region_iso_code
  </definition>
</definitions>