﻿---
title: HAProxy fields
description: haproxy Module Contains various counts of connections active in the process. Information about the client doing the request Destination information Contains...
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-haproxy
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# HAProxy fields
haproxy Module

## haproxy

<definitions>
  <definition term="haproxy.frontend_name">
    Name of the frontend (or listener) which received and processed the connection.
  </definition>
  <definition term="haproxy.backend_name">
    Name of the backend (or listener) which was selected to manage the connection to the server.
  </definition>
  <definition term="haproxy.server_name">
    Name of the last server to which the connection was sent.
  </definition>
  <definition term="haproxy.total_waiting_time_ms">
    Total time in milliseconds spent waiting in the various queues
    type: long
  </definition>
  <definition term="haproxy.connection_wait_time_ms">
    Total time in milliseconds spent waiting for the connection to establish to the final server
    type: long
  </definition>
  <definition term="haproxy.bytes_read">
    Total number of bytes transmitted to the client when the log is emitted.
    type: long
  </definition>
  <definition term="haproxy.time_queue">
    Total time in milliseconds spent waiting in the various queues.
    type: long
  </definition>
  <definition term="haproxy.time_backend_connect">
    Total time in milliseconds spent waiting for the connection to establish to the final server, including retries.
    type: long
  </definition>
  <definition term="haproxy.server_queue">
    Total number of requests which were processed before this one in the server queue.
    type: long
  </definition>
  <definition term="haproxy.backend_queue">
    Total number of requests which were processed before this one in the backend's global queue.
    type: long
  </definition>
  <definition term="haproxy.bind_name">
    Name of the listening address which received the connection.
  </definition>
  <definition term="haproxy.error_message">
    Error message logged by HAProxy in case of error.
    type: text
  </definition>
  <definition term="haproxy.source">
    The HAProxy source of the log
    type: keyword
  </definition>
  <definition term="haproxy.termination_state">
    Condition the session was in when the session ended.
  </definition>
  <definition term="haproxy.mode">
    mode that the frontend is operating (TCP or HTTP)
    type: keyword
  </definition>
</definitions>


## connections

Contains various counts of connections active in the process.
<definitions>
  <definition term="haproxy.connections.active">
    Total number of concurrent connections on the process when the session was logged.
    type: long
  </definition>
  <definition term="haproxy.connections.frontend">
    Total number of concurrent connections on the frontend when the session was logged.
    type: long
  </definition>
  <definition term="haproxy.connections.backend">
    Total number of concurrent connections handled by the backend when the session was logged.
    type: long
  </definition>
  <definition term="haproxy.connections.server">
    Total number of concurrent connections still active on the server when the session was logged.
    type: long
  </definition>
  <definition term="haproxy.connections.retries">
    Number of connection retries experienced by this session when trying to connect to the server.
    type: long
  </definition>
</definitions>


## client

Information about the client doing the request
<definitions>
  <definition term="haproxy.client.ip">
    type: alias
    alias to: source.address
  </definition>
  <definition term="haproxy.client.port">
    type: alias
    alias to: source.port
  </definition>
  <definition term="haproxy.process_name">
    type: alias
    alias to: process.name
  </definition>
  <definition term="haproxy.pid">
    type: alias
    alias to: process.pid
  </definition>
</definitions>


## destination

Destination information
<definitions>
  <definition term="haproxy.destination.port">
    type: alias
    alias to: destination.port
  </definition>
  <definition term="haproxy.destination.ip">
    type: alias
    alias to: destination.ip
  </definition>
</definitions>


## geoip

Contains GeoIP information gathered based on the client.ip field. Only present if the GeoIP Elasticsearch plugin is available and used.
<definitions>
  <definition term="haproxy.geoip.continent_name">
    type: alias
    alias to: source.geo.continent_name
  </definition>
  <definition term="haproxy.geoip.country_iso_code">
    type: alias
    alias to: source.geo.country_iso_code
  </definition>
  <definition term="haproxy.geoip.location">
    type: alias
    alias to: source.geo.location
  </definition>
  <definition term="haproxy.geoip.region_name">
    type: alias
    alias to: source.geo.region_name
  </definition>
  <definition term="haproxy.geoip.city_name">
    type: alias
    alias to: source.geo.city_name
  </definition>
  <definition term="haproxy.geoip.region_iso_code">
    type: alias
    alias to: source.geo.region_iso_code
  </definition>
</definitions>


## http

Please add description

## response

Fields related to the HTTP response
<definitions>
  <definition term="haproxy.http.response.captured_cookie">
    Optional "name=value" entry indicating that the client had this cookie in the response.
  </definition>
  <definition term="haproxy.http.response.captured_headers">
    List of headers captured in the response due to the presence of the "capture response header" statement in the frontend.
    type: keyword
  </definition>
  <definition term="haproxy.http.response.status_code">
    type: alias
    alias to: http.response.status_code
  </definition>
</definitions>


## request

Fields related to the HTTP request
<definitions>
  <definition term="haproxy.http.request.captured_cookie">
    Optional "name=value" entry indicating that the server has returned a cookie with its request.
  </definition>
  <definition term="haproxy.http.request.captured_headers">
    List of headers captured in the request due to the presence of the "capture request header" statement in the frontend.
    type: keyword
  </definition>
  <definition term="haproxy.http.request.raw_request_line">
    Complete HTTP request line, including the method, request and HTTP version string.
    type: keyword
  </definition>
  <definition term="haproxy.http.request.time_wait_without_data_ms">
    Total time in milliseconds spent waiting for the server to send a full HTTP response, not counting data.
    type: long
  </definition>
  <definition term="haproxy.http.request.time_wait_ms">
    Total time in milliseconds spent waiting for a full HTTP request from the client (not counting body) after the first byte was received.
    type: long
  </definition>
</definitions>


## tcp

TCP log format
<definitions>
  <definition term="haproxy.tcp.connection_waiting_time_ms">
    Total time in milliseconds elapsed between the accept and the last close
    type: long
  </definition>
</definitions>