﻿---
title: Google Cloud Platform (GCP) fields
description: Module for handling logs from Google Cloud. Fields from Google Cloud logs. If the destination of the connection was a VM located on the same VPC, this...
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-gcp
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Google Cloud Platform (GCP) fields
Module for handling logs from Google Cloud.

## gcp

Fields from Google Cloud logs.

## destination.instance

If the destination of the connection was a VM located on the same VPC, this field is populated with VM instance details. In a Shared VPC configuration, project_id corresponds to the project that owns the instance, usually the service project.
<definitions>
  <definition term="gcp.destination.instance.project_id">
    ID of the project containing the VM.
    type: keyword
  </definition>
  <definition term="gcp.destination.instance.region">
    Region of the VM.
    type: keyword
  </definition>
  <definition term="gcp.destination.instance.zone">
    Zone of the VM.
    type: keyword
  </definition>
</definitions>


## destination.vpc

If the destination of the connection was a VM located on the same VPC, this field is populated with VPC network details. In a Shared VPC configuration, project_id corresponds to that of the host project.
<definitions>
  <definition term="gcp.destination.vpc.project_id">
    ID of the project containing the VM.
    type: keyword
  </definition>
  <definition term="gcp.destination.vpc.vpc_name">
    VPC on which the VM is operating.
    type: keyword
  </definition>
  <definition term="gcp.destination.vpc.subnetwork_name">
    Subnetwork on which the VM is operating.
    type: keyword
  </definition>
</definitions>


## source.instance

If the source of the connection was a VM located on the same VPC, this field is populated with VM instance details. In a Shared VPC configuration, project_id corresponds to the project that owns the instance, usually the service project.
<definitions>
  <definition term="gcp.source.instance.project_id">
    ID of the project containing the VM.
    type: keyword
  </definition>
  <definition term="gcp.source.instance.region">
    Region of the VM.
    type: keyword
  </definition>
  <definition term="gcp.source.instance.zone">
    Zone of the VM.
    type: keyword
  </definition>
</definitions>


## source.vpc

If the source of the connection was a VM located on the same VPC, this field is populated with VPC network details. In a Shared VPC configuration, project_id corresponds to that of the host project.
<definitions>
  <definition term="gcp.source.vpc.project_id">
    ID of the project containing the VM.
    type: keyword
  </definition>
  <definition term="gcp.source.vpc.vpc_name">
    VPC on which the VM is operating.
    type: keyword
  </definition>
  <definition term="gcp.source.vpc.subnetwork_name">
    Subnetwork on which the VM is operating.
    type: keyword
  </definition>
</definitions>


## audit

Fields for Google Cloud audit logs.
<definitions>
  <definition term="gcp.audit.type">
    Type property.
    type: keyword
  </definition>
</definitions>


## authentication_info

Authentication information.
<definitions>
  <definition term="gcp.audit.authentication_info.principal_email">
    The email address of the authenticated user making the request.
    type: keyword
  </definition>
  <definition term="gcp.audit.authentication_info.authority_selector">
    The authority selector specified by the requestor, if any. It is not guaranteed  that the principal was allowed to use this authority.
    type: keyword
  </definition>
  <definition term="gcp.audit.authorization_info">
    Authorization information for the operation.
    type: array
  </definition>
  <definition term="gcp.audit.method_name">
    The name of the service method or operation. For API calls, this  should be the name of the API method.  For example, 'google.datastore.v1.Datastore.RunQuery'.
    type: keyword
  </definition>
  <definition term="gcp.audit.num_response_items">
    The number of items returned from a List or Query API method, if applicable.
    type: long
  </definition>
</definitions>


## request

The operation request.
<definitions>
  <definition term="gcp.audit.request.proto_name">
    Type property of the request.
    type: keyword
  </definition>
  <definition term="gcp.audit.request.filter">
    Filter of the request.
    type: keyword
  </definition>
  <definition term="gcp.audit.request.name">
    Name of the request.
    type: keyword
  </definition>
  <definition term="gcp.audit.request.resource_name">
    Name of the request resource.
    type: keyword
  </definition>
</definitions>


## request_metadata

Metadata about the request.
<definitions>
  <definition term="gcp.audit.request_metadata.caller_ip">
    The IP address of the caller.
    type: ip
  </definition>
  <definition term="gcp.audit.request_metadata.caller_supplied_user_agent">
    The user agent of the caller. This information is not authenticated and  should be treated accordingly.
    type: keyword
  </definition>
</definitions>


## response

The operation response.
<definitions>
  <definition term="gcp.audit.response.proto_name">
    Type property of the response.
    type: keyword
  </definition>
</definitions>


## details

The details of the response.
<definitions>
  <definition term="gcp.audit.response.details.group">
    The name of the group.
    type: keyword
  </definition>
  <definition term="gcp.audit.response.details.kind">
    The kind of the response details.
    type: keyword
  </definition>
  <definition term="gcp.audit.response.details.name">
    The name of the response details.
    type: keyword
  </definition>
  <definition term="gcp.audit.response.details.uid">
    The uid of the response details.
    type: keyword
  </definition>
  <definition term="gcp.audit.response.status">
    Status of the response.
    type: keyword
  </definition>
  <definition term="gcp.audit.resource_name">
    The resource or collection that is the target of the operation.  The name is a scheme-less URI, not including the API service name.  For example, 'shelves/SHELF_ID/books'.
    type: keyword
  </definition>
</definitions>


## resource_location

The location of the resource.
<definitions>
  <definition term="gcp.audit.resource_location.current_locations">
    Current locations of the resource.
    type: keyword
  </definition>
  <definition term="gcp.audit.service_name">
    The name of the API service performing the operation.  For example, datastore.googleapis.com.
    type: keyword
  </definition>
</definitions>


## status

The status of the overall operation.
<definitions>
  <definition term="gcp.audit.status.code">
    The status code, which should be an enum value of google.rpc.Code.
    type: integer
  </definition>
  <definition term="gcp.audit.status.message">
    A developer-facing error message, which should be in English. Any user-facing  error message should be localized and sent in the google.rpc.Status.details  field, or localized by the client.
    type: keyword
  </definition>
</definitions>


## firewall

Fields for Google Cloud Firewall logs.

## rule_details

Description of the firewall rule that matched this connection.
<definitions>
  <definition term="gcp.firewall.rule_details.priority">
    The priority for the firewall rule.
    type: long
  </definition>
  <definition term="gcp.firewall.rule_details.action">
    Action that the rule performs on match.
    type: keyword
  </definition>
  <definition term="gcp.firewall.rule_details.direction">
    Direction of traffic that matches this rule.
    type: keyword
  </definition>
  <definition term="gcp.firewall.rule_details.reference">
    Reference to the firewall rule.
    type: keyword
  </definition>
  <definition term="gcp.firewall.rule_details.source_range">
    List of source ranges that the firewall rule applies to.
    type: keyword
  </definition>
  <definition term="gcp.firewall.rule_details.destination_range">
    List of destination ranges that the firewall applies to.
    type: keyword
  </definition>
  <definition term="gcp.firewall.rule_details.source_tag">
    List of all the source tags that the firewall rule applies to.
    type: keyword
  </definition>
  <definition term="gcp.firewall.rule_details.target_tag">
    List of all the target tags that the firewall rule applies to.
    type: keyword
  </definition>
  <definition term="gcp.firewall.rule_details.ip_port_info">
    List of ip protocols and applicable port ranges for rules.
    type: array
  </definition>
  <definition term="gcp.firewall.rule_details.source_service_account">
    List of all the source service accounts that the firewall rule applies to.
    type: keyword
  </definition>
  <definition term="gcp.firewall.rule_details.target_service_account">
    List of all the target service accounts that the firewall rule applies to.
    type: keyword
  </definition>
</definitions>


## vpcflow

Fields for Google Cloud VPC flow logs.
<definitions>
  <definition term="gcp.vpcflow.reporter">
    The side which reported the flow. Can be either 'SRC' or 'DEST'.
    type: keyword
  </definition>
  <definition term="gcp.vpcflow.rtt.ms">
    Latency as measured (for TCP flows only) during the time interval. This is the time elapsed between sending a SEQ and receiving a corresponding ACK and it contains the network RTT as well as the application related delay.
    type: long
  </definition>
</definitions>