﻿---
title: Fortinet fields
description: fortinet Module Fields from fortinet FortiOS Module for parsing Fortinet syslog. 
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-fortinet
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Fortinet fields
fortinet Module

## fortinet

Fields from fortinet FortiOS
<definitions>
  <definition term="fortinet.file.hash.crc32">
    CRC32 Hash of file
    type: keyword
  </definition>
</definitions>


## firewall

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Module for parsing Fortinet syslog.
<definitions>
  <definition term="fortinet.firewall.acct_stat">
    Accounting state (RADIUS)
    type: keyword
  </definition>
  <definition term="fortinet.firewall.acktime">
    Alarm Acknowledge Time
    type: keyword
  </definition>
  <definition term="fortinet.firewall.act">
    Action
    type: keyword
  </definition>
  <definition term="fortinet.firewall.action">
    Status of the session
    type: keyword
  </definition>
  <definition term="fortinet.firewall.activity">
    HA activity message
    type: keyword
  </definition>
  <definition term="fortinet.firewall.addr">
    IP Address
    type: ip
  </definition>
  <definition term="fortinet.firewall.addr_type">
    Address Type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.addrgrp">
    Address Group
    type: keyword
  </definition>
  <definition term="fortinet.firewall.adgroup">
    AD Group Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.admin">
    Admin User
    type: keyword
  </definition>
  <definition term="fortinet.firewall.age">
    Time in seconds - time passed since last seen
    type: integer
  </definition>
  <definition term="fortinet.firewall.agent">
    User agent - eg. agent="Mozilla/5.0"
    type: keyword
  </definition>
  <definition term="fortinet.firewall.alarmid">
    Alarm ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.alert">
    Alert
    type: keyword
  </definition>
  <definition term="fortinet.firewall.analyticscksum">
    The checksum of the file submitted for analytics
    type: keyword
  </definition>
  <definition term="fortinet.firewall.analyticssubmit">
    The flag for analytics submission
    type: keyword
  </definition>
  <definition term="fortinet.firewall.ap">
    Access Point
    type: keyword
  </definition>
  <definition term="fortinet.firewall.app-type">
    Address Type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.appact">
    The security action from app control
    type: keyword
  </definition>
  <definition term="fortinet.firewall.appid">
    Application ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.applist">
    Application Control profile
    type: keyword
  </definition>
  <definition term="fortinet.firewall.apprisk">
    Application Risk Level
    type: keyword
  </definition>
  <definition term="fortinet.firewall.apscan">
    The name of the AP, which scanned and detected the rogue AP
    type: keyword
  </definition>
  <definition term="fortinet.firewall.apsn">
    Access Point
    type: keyword
  </definition>
  <definition term="fortinet.firewall.apstatus">
    Access Point status
    type: keyword
  </definition>
  <definition term="fortinet.firewall.aptype">
    Access Point type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.assigned">
    Assigned IP Address
    type: ip
  </definition>
  <definition term="fortinet.firewall.assignip">
    Assigned IP Address
    type: ip
  </definition>
  <definition term="fortinet.firewall.attachment">
    The flag for email attachement
    type: keyword
  </definition>
  <definition term="fortinet.firewall.attack">
    Attack Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.attackcontext">
    The trigger patterns and the packetdata with base64 encoding
    type: keyword
  </definition>
  <definition term="fortinet.firewall.attackcontextid">
    Attack context id / total
    type: keyword
  </definition>
  <definition term="fortinet.firewall.attackid">
    Attack ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.auditid">
    Audit ID
    type: long
  </definition>
  <definition term="fortinet.firewall.auditscore">
    The Audit Score
    type: keyword
  </definition>
  <definition term="fortinet.firewall.audittime">
    The time of the audit
    type: long
  </definition>
  <definition term="fortinet.firewall.authgrp">
    Authorization Group
    type: keyword
  </definition>
  <definition term="fortinet.firewall.authid">
    Authentication ID
    type: keyword
  </definition>
  <definition term="fortinet.firewall.authproto">
    The protocol that initiated the authentication
    type: keyword
  </definition>
  <definition term="fortinet.firewall.authserver">
    Authentication server
    type: keyword
  </definition>
  <definition term="fortinet.firewall.bandwidth">
    Bandwidth
    type: keyword
  </definition>
  <definition term="fortinet.firewall.banned_rule">
    NAC quarantine Banned Rule Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.banned_src">
    NAC quarantine Banned Source IP
    type: keyword
  </definition>
  <definition term="fortinet.firewall.banword">
    Banned word
    type: keyword
  </definition>
  <definition term="fortinet.firewall.botnetdomain">
    Botnet Domain Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.botnetip">
    Botnet IP Address
    type: ip
  </definition>
  <definition term="fortinet.firewall.bssid">
    Service Set ID
    type: keyword
  </definition>
  <definition term="fortinet.firewall.call_id">
    Caller ID
    type: keyword
  </definition>
  <definition term="fortinet.firewall.carrier_ep">
    The FortiOS Carrier end-point identification
    type: keyword
  </definition>
  <definition term="fortinet.firewall.cat">
    DNS category ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.category">
    Authentication category
    type: keyword
  </definition>
  <definition term="fortinet.firewall.cc">
    CC Email Address
    type: keyword
  </definition>
  <definition term="fortinet.firewall.cdrcontent">
    Cdrcontent
    type: keyword
  </definition>
  <definition term="fortinet.firewall.centralnatid">
    Central NAT ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.cert">
    Certificate
    type: keyword
  </definition>
  <definition term="fortinet.firewall.cert-type">
    Certificate type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.certhash">
    Certificate hash
    type: keyword
  </definition>
  <definition term="fortinet.firewall.cfgattr">
    Configuration attribute
    type: keyword
  </definition>
  <definition term="fortinet.firewall.cfgobj">
    Configuration object
    type: keyword
  </definition>
  <definition term="fortinet.firewall.cfgpath">
    Configuration path
    type: keyword
  </definition>
  <definition term="fortinet.firewall.cfgtid">
    Configuration transaction ID
    type: keyword
  </definition>
  <definition term="fortinet.firewall.cfgtxpower">
    Configuration TX power
    type: integer
  </definition>
  <definition term="fortinet.firewall.channel">
    Wireless Channel
    type: integer
  </definition>
  <definition term="fortinet.firewall.channeltype">
    SSH channel type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.chassisid">
    Chassis ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.checksum">
    The checksum of the scanned file
    type: keyword
  </definition>
  <definition term="fortinet.firewall.chgheaders">
    HTTP Headers
    type: keyword
  </definition>
  <definition term="fortinet.firewall.cldobjid">
    Connector object ID
    type: keyword
  </definition>
  <definition term="fortinet.firewall.client_addr">
    Wifi client address
    type: keyword
  </definition>
  <definition term="fortinet.firewall.cloudaction">
    Cloud Action
    type: keyword
  </definition>
  <definition term="fortinet.firewall.clouduser">
    Cloud User
    type: keyword
  </definition>
  <definition term="fortinet.firewall.column">
    VOIP Column
    type: integer
  </definition>
  <definition term="fortinet.firewall.command">
    CLI Command
    type: keyword
  </definition>
  <definition term="fortinet.firewall.community">
    SNMP Community
    type: keyword
  </definition>
  <definition term="fortinet.firewall.configcountry">
    Configuration country
    type: keyword
  </definition>
  <definition term="fortinet.firewall.connection_type">
    FortiClient Connection Type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.conserve">
    Flag for conserve mode
    type: keyword
  </definition>
  <definition term="fortinet.firewall.constraint">
    WAF http protocol restrictions
    type: keyword
  </definition>
  <definition term="fortinet.firewall.contentdisarmed">
    Email scanned content
    type: keyword
  </definition>
  <definition term="fortinet.firewall.contenttype">
    Content Type from HTTP header
    type: keyword
  </definition>
  <definition term="fortinet.firewall.cookies">
    VPN Cookie
    type: keyword
  </definition>
  <definition term="fortinet.firewall.count">
    Counts of action type
    type: integer
  </definition>
  <definition term="fortinet.firewall.countapp">
    Number of App Ctrl logs associated with the session
    type: integer
  </definition>
  <definition term="fortinet.firewall.countav">
    Number of AV logs associated with the session
    type: integer
  </definition>
  <definition term="fortinet.firewall.countcifs">
    Number of CIFS logs associated with the session
    type: integer
  </definition>
  <definition term="fortinet.firewall.countdlp">
    Number of DLP logs associated with the session
    type: integer
  </definition>
  <definition term="fortinet.firewall.countdns">
    Number of DNS logs associated with the session
    type: integer
  </definition>
  <definition term="fortinet.firewall.countemail">
    Number of email logs associated with the session
    type: integer
  </definition>
  <definition term="fortinet.firewall.countff">
    Number of ff logs associated with the session
    type: integer
  </definition>
  <definition term="fortinet.firewall.countips">
    Number of IPS logs associated with the session
    type: integer
  </definition>
  <definition term="fortinet.firewall.countssh">
    Number of SSH logs associated with the session
    type: integer
  </definition>
  <definition term="fortinet.firewall.countssl">
    Number of SSL logs associated with the session
    type: integer
  </definition>
  <definition term="fortinet.firewall.countwaf">
    Number of WAF logs associated with the session
    type: integer
  </definition>
  <definition term="fortinet.firewall.countweb">
    Number of Web filter logs associated with the session
    type: integer
  </definition>
  <definition term="fortinet.firewall.cpu">
    CPU Usage
    type: integer
  </definition>
  <definition term="fortinet.firewall.craction">
    Client Reputation Action
    type: integer
  </definition>
  <definition term="fortinet.firewall.criticalcount">
    Number of critical ratings
    type: integer
  </definition>
  <definition term="fortinet.firewall.crl">
    Client Reputation Level
    type: keyword
  </definition>
  <definition term="fortinet.firewall.crlevel">
    Client Reputation Level
    type: keyword
  </definition>
  <definition term="fortinet.firewall.crscore">
    Some description
    type: integer
  </definition>
  <definition term="fortinet.firewall.cveid">
    CVE ID
    type: keyword
  </definition>
  <definition term="fortinet.firewall.daemon">
    Daemon name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.datarange">
    Data range for reports
    type: keyword
  </definition>
  <definition term="fortinet.firewall.date">
    Date
    type: keyword
  </definition>
  <definition term="fortinet.firewall.ddnsserver">
    DDNS server
    type: ip
  </definition>
  <definition term="fortinet.firewall.desc">
    Description
    type: keyword
  </definition>
  <definition term="fortinet.firewall.detectionmethod">
    Detection method
    type: keyword
  </definition>
  <definition term="fortinet.firewall.devcategory">
    Device category
    type: keyword
  </definition>
  <definition term="fortinet.firewall.devintfname">
    HA device Interface Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.devtype">
    Device type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.dhcp_msg">
    DHCP Message
    type: keyword
  </definition>
  <definition term="fortinet.firewall.dintf">
    Destination interface
    type: keyword
  </definition>
  <definition term="fortinet.firewall.disk">
    Assosciated disk
    type: keyword
  </definition>
  <definition term="fortinet.firewall.disklograte">
    Disk logging rate
    type: long
  </definition>
  <definition term="fortinet.firewall.dlpextra">
    DLP extra information
    type: keyword
  </definition>
  <definition term="fortinet.firewall.docsource">
    DLP fingerprint document source
    type: keyword
  </definition>
  <definition term="fortinet.firewall.domainctrlauthstate">
    CIFS domain auth state
    type: integer
  </definition>
  <definition term="fortinet.firewall.domainctrlauthtype">
    CIFS domain auth type
    type: integer
  </definition>
  <definition term="fortinet.firewall.domainctrldomain">
    CIFS domain auth domain
    type: keyword
  </definition>
  <definition term="fortinet.firewall.domainctrlip">
    CIFS Domain IP
    type: ip
  </definition>
  <definition term="fortinet.firewall.domainctrlname">
    CIFS Domain name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.domainctrlprotocoltype">
    CIFS Domain connection protocol
    type: integer
  </definition>
  <definition term="fortinet.firewall.domainctrlusername">
    CIFS Domain username
    type: keyword
  </definition>
  <definition term="fortinet.firewall.domainfilteridx">
    Domain filter ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.domainfilterlist">
    Domain filter name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.ds">
    Direction with distribution system
    type: keyword
  </definition>
  <definition term="fortinet.firewall.dst_int">
    Destination interface
    type: keyword
  </definition>
  <definition term="fortinet.firewall.dstintfrole">
    Destination interface role
    type: keyword
  </definition>
  <definition term="fortinet.firewall.dstcountry">
    Destination country
    type: keyword
  </definition>
  <definition term="fortinet.firewall.dstdevcategory">
    Destination device category
    type: keyword
  </definition>
  <definition term="fortinet.firewall.dstdevtype">
    Destination device type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.dstfamily">
    Destination OS family
    type: keyword
  </definition>
  <definition term="fortinet.firewall.dsthwvendor">
    Destination HW vendor
    type: keyword
  </definition>
  <definition term="fortinet.firewall.dsthwversion">
    Destination HW version
    type: keyword
  </definition>
  <definition term="fortinet.firewall.dstinetsvc">
    Destination interface service
    type: keyword
  </definition>
  <definition term="fortinet.firewall.dstosname">
    Destination OS name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.dstosversion">
    Destination OS version
    type: keyword
  </definition>
  <definition term="fortinet.firewall.dstserver">
    Destination server
    type: integer
  </definition>
  <definition term="fortinet.firewall.dstssid">
    Destination SSID
    type: keyword
  </definition>
  <definition term="fortinet.firewall.dstswversion">
    Destination software version
    type: keyword
  </definition>
  <definition term="fortinet.firewall.dstunauthusersource">
    Destination unauthenticated source
    type: keyword
  </definition>
  <definition term="fortinet.firewall.dstuuid">
    UUID of the Destination IP address
    type: keyword
  </definition>
  <definition term="fortinet.firewall.duid">
    DHCP UID
    type: keyword
  </definition>
  <definition term="fortinet.firewall.eapolcnt">
    EAPOL packet count
    type: integer
  </definition>
  <definition term="fortinet.firewall.eapoltype">
    EAPOL packet type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.encrypt">
    Whether the packet is encrypted or not
    type: integer
  </definition>
  <definition term="fortinet.firewall.encryption">
    Encryption method
    type: keyword
  </definition>
  <definition term="fortinet.firewall.epoch">
    Epoch used for locating file
    type: integer
  </definition>
  <definition term="fortinet.firewall.espauth">
    ESP Authentication
    type: keyword
  </definition>
  <definition term="fortinet.firewall.esptransform">
    ESP Transform
    type: keyword
  </definition>
  <definition term="fortinet.firewall.eventtype">
    UTM Event Type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.exch">
    Mail Exchanges from DNS response answer section
    type: keyword
  </definition>
  <definition term="fortinet.firewall.exchange">
    Mail Exchanges from DNS response answer section
    type: keyword
  </definition>
  <definition term="fortinet.firewall.expectedsignature">
    Expected SSL signature
    type: keyword
  </definition>
  <definition term="fortinet.firewall.expiry">
    FortiGuard override expiry timestamp
    type: keyword
  </definition>
  <definition term="fortinet.firewall.fams_pause">
    Fortinet Analysis and Management Service Pause
    type: integer
  </definition>
  <definition term="fortinet.firewall.fazlograte">
    FortiAnalyzer Logging Rate
    type: long
  </definition>
  <definition term="fortinet.firewall.fctemssn">
    FortiClient Endpoint SSN
    type: keyword
  </definition>
  <definition term="fortinet.firewall.fctuid">
    FortiClient UID
    type: keyword
  </definition>
  <definition term="fortinet.firewall.field">
    NTP status field
    type: keyword
  </definition>
  <definition term="fortinet.firewall.filefilter">
    The filter used to identify the affected file
    type: keyword
  </definition>
  <definition term="fortinet.firewall.filehashsrc">
    Filehash source
    type: keyword
  </definition>
  <definition term="fortinet.firewall.filtercat">
    DLP filter category
    type: keyword
  </definition>
  <definition term="fortinet.firewall.filteridx">
    DLP filter ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.filtername">
    DLP rule name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.filtertype">
    DLP filter type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.fortiguardresp">
    Antispam ESP value
    type: keyword
  </definition>
  <definition term="fortinet.firewall.forwardedfor">
    Email address forwarded
    type: keyword
  </definition>
  <definition term="fortinet.firewall.fqdn">
    FQDN
    type: keyword
  </definition>
  <definition term="fortinet.firewall.frametype">
    Wireless frametype
    type: keyword
  </definition>
  <definition term="fortinet.firewall.freediskstorage">
    Free disk integer
    type: integer
  </definition>
  <definition term="fortinet.firewall.from">
    From email address
    type: keyword
  </definition>
  <definition term="fortinet.firewall.from_vcluster">
    Source virtual cluster number
    type: integer
  </definition>
  <definition term="fortinet.firewall.fsaverdict">
    FSA verdict
    type: keyword
  </definition>
  <definition term="fortinet.firewall.fwserver_name">
    Web proxy server name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.gateway">
    Gateway ip address for PPPoE status report
    type: ip
  </definition>
  <definition term="fortinet.firewall.green">
    Memory status
    type: keyword
  </definition>
  <definition term="fortinet.firewall.groupid">
    User Group ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.ha-prio">
    HA Priority
    type: integer
  </definition>
  <definition term="fortinet.firewall.ha_group">
    HA Group
    type: keyword
  </definition>
  <definition term="fortinet.firewall.ha_role">
    HA Role
    type: keyword
  </definition>
  <definition term="fortinet.firewall.handshake">
    SSL Handshake
    type: keyword
  </definition>
  <definition term="fortinet.firewall.hash">
    Hash value of downloaded file
    type: keyword
  </definition>
  <definition term="fortinet.firewall.hbdn_reason">
    Heartbeat down reason
    type: keyword
  </definition>
  <definition term="fortinet.firewall.highcount">
    Highcount fabric summary
    type: integer
  </definition>
  <definition term="fortinet.firewall.host">
    Hostname
    type: keyword
  </definition>
  <definition term="fortinet.firewall.iaid">
    DHCPv6 id
    type: keyword
  </definition>
  <definition term="fortinet.firewall.icmpcode">
    Destination Port of the ICMP message
    type: keyword
  </definition>
  <definition term="fortinet.firewall.icmpid">
    Source port of the ICMP message
    type: keyword
  </definition>
  <definition term="fortinet.firewall.icmptype">
    The type of ICMP message
    type: keyword
  </definition>
  <definition term="fortinet.firewall.identifier">
    Network traffic identifier
    type: integer
  </definition>
  <definition term="fortinet.firewall.in_spi">
    IPSEC inbound SPI
    type: keyword
  </definition>
  <definition term="fortinet.firewall.incidentserialno">
    Incident serial number
    type: integer
  </definition>
  <definition term="fortinet.firewall.infected">
    Infected MMS
    type: integer
  </definition>
  <definition term="fortinet.firewall.infectedfilelevel">
    DLP infected file level
    type: integer
  </definition>
  <definition term="fortinet.firewall.informationsource">
    Information source
    type: keyword
  </definition>
  <definition term="fortinet.firewall.init">
    IPSEC init stage
    type: keyword
  </definition>
  <definition term="fortinet.firewall.initiator">
    Original login user name for Fortiguard override
    type: keyword
  </definition>
  <definition term="fortinet.firewall.interface">
    Related interface
    type: keyword
  </definition>
  <definition term="fortinet.firewall.intf">
    Related interface
    type: keyword
  </definition>
  <definition term="fortinet.firewall.invalidmac">
    The MAC address with invalid OUI
    type: keyword
  </definition>
  <definition term="fortinet.firewall.ip">
    Related IP
    type: ip
  </definition>
  <definition term="fortinet.firewall.iptype">
    Related IP type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.keyword">
    Keyword used for search
    type: keyword
  </definition>
  <definition term="fortinet.firewall.kind">
    VOIP kind
    type: keyword
  </definition>
  <definition term="fortinet.firewall.lanin">
    LAN incoming traffic in bytes
    type: long
  </definition>
  <definition term="fortinet.firewall.lanout">
    LAN outbound traffic in bytes
    type: long
  </definition>
  <definition term="fortinet.firewall.lease">
    DHCP lease
    type: integer
  </definition>
  <definition term="fortinet.firewall.license_limit">
    Maximum Number of FortiClients for the License
    type: keyword
  </definition>
  <definition term="fortinet.firewall.limit">
    Virtual Domain Resource Limit
    type: integer
  </definition>
  <definition term="fortinet.firewall.line">
    VOIP line
    type: keyword
  </definition>
  <definition term="fortinet.firewall.live">
    Time in seconds
    type: integer
  </definition>
  <definition term="fortinet.firewall.local">
    Local IP for a PPPD Connection
    type: ip
  </definition>
  <definition term="fortinet.firewall.log">
    Log message
    type: keyword
  </definition>
  <definition term="fortinet.firewall.login">
    SSH login
    type: keyword
  </definition>
  <definition term="fortinet.firewall.lowcount">
    Fabric lowcount
    type: integer
  </definition>
  <definition term="fortinet.firewall.mac">
    DHCP mac address
    type: keyword
  </definition>
  <definition term="fortinet.firewall.malform_data">
    VOIP malformed data
    type: integer
  </definition>
  <definition term="fortinet.firewall.malform_desc">
    VOIP malformed data description
    type: keyword
  </definition>
  <definition term="fortinet.firewall.manuf">
    Manufacturer name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.masterdstmac">
    Master mac address for a host with multiple network interfaces
    type: keyword
  </definition>
  <definition term="fortinet.firewall.mastersrcmac">
    The master MAC address for a host that has multiple network interfaces
    type: keyword
  </definition>
  <definition term="fortinet.firewall.mediumcount">
    Fabric medium count
    type: integer
  </definition>
  <definition term="fortinet.firewall.mem">
    Memory usage system statistics
    type: integer
  </definition>
  <definition term="fortinet.firewall.meshmode">
    Wireless mesh mode
    type: keyword
  </definition>
  <definition term="fortinet.firewall.message_type">
    VOIP message type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.method">
    HTTP method
    type: keyword
  </definition>
  <definition term="fortinet.firewall.mgmtcnt">
    The number of unauthorized client flooding managemet frames
    type: integer
  </definition>
  <definition term="fortinet.firewall.mode">
    IPSEC mode
    type: keyword
  </definition>
  <definition term="fortinet.firewall.module">
    PCI-DSS module
    type: keyword
  </definition>
  <definition term="fortinet.firewall.monitor-name">
    Health Monitor Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.monitor-type">
    Health Monitor Type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.mpsk">
    Wireless MPSK
    type: keyword
  </definition>
  <definition term="fortinet.firewall.msgproto">
    Message Protocol Number
    type: keyword
  </definition>
  <definition term="fortinet.firewall.mtu">
    Max Transmission Unit Value
    type: integer
  </definition>
  <definition term="fortinet.firewall.name">
    Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.nat">
    NAT IP Address
    type: keyword
  </definition>
  <definition term="fortinet.firewall.netid">
    Connector NetID
    type: keyword
  </definition>
  <definition term="fortinet.firewall.new_status">
    New status on user change
    type: keyword
  </definition>
  <definition term="fortinet.firewall.new_value">
    New Virtual Domain Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.newchannel">
    New Channel Number
    type: integer
  </definition>
  <definition term="fortinet.firewall.newchassisid">
    New Chassis ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.newslot">
    New Slot Number
    type: integer
  </definition>
  <definition term="fortinet.firewall.nextstat">
    Time interval in seconds for the next statistics.
    type: integer
  </definition>
  <definition term="fortinet.firewall.nf_type">
    Notification Type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.noise">
    Wifi Noise
    type: integer
  </definition>
  <definition term="fortinet.firewall.old_status">
    Original Status
    type: keyword
  </definition>
  <definition term="fortinet.firewall.old_value">
    Original Virtual Domain name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.oldchannel">
    Original channel
    type: integer
  </definition>
  <definition term="fortinet.firewall.oldchassisid">
    Original Chassis Number
    type: integer
  </definition>
  <definition term="fortinet.firewall.oldslot">
    Original Slot Number
    type: integer
  </definition>
  <definition term="fortinet.firewall.oldsn">
    Old Serial number
    type: keyword
  </definition>
  <definition term="fortinet.firewall.oldwprof">
    Old Web Filter Profile
    type: keyword
  </definition>
  <definition term="fortinet.firewall.onwire">
    A flag to indicate if the AP is onwire or not
    type: keyword
  </definition>
  <definition term="fortinet.firewall.opercountry">
    Operating Country
    type: keyword
  </definition>
  <definition term="fortinet.firewall.opertxpower">
    Operating TX power
    type: integer
  </definition>
  <definition term="fortinet.firewall.osname">
    Operating System name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.osversion">
    Operating System version
    type: keyword
  </definition>
  <definition term="fortinet.firewall.out_spi">
    Out SPI
    type: keyword
  </definition>
  <definition term="fortinet.firewall.outintf">
    Out interface
    type: keyword
  </definition>
  <definition term="fortinet.firewall.passedcount">
    Fabric passed count
    type: integer
  </definition>
  <definition term="fortinet.firewall.passwd">
    Changed user password information
    type: keyword
  </definition>
  <definition term="fortinet.firewall.path">
    Path of looped configuration for security fabric
    type: keyword
  </definition>
  <definition term="fortinet.firewall.peer">
    WAN optimization peer
    type: keyword
  </definition>
  <definition term="fortinet.firewall.peer_notif">
    VPN peer notification
    type: keyword
  </definition>
  <definition term="fortinet.firewall.phase2_name">
    VPN phase2 name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.phone">
    VOIP Phone
    type: keyword
  </definition>
  <definition term="fortinet.firewall.pid">
    Process ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.policytype">
    Policy Type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.poolname">
    IP Pool name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.port">
    Log upload error port
    type: integer
  </definition>
  <definition term="fortinet.firewall.portbegin">
    IP Pool port number to begin
    type: integer
  </definition>
  <definition term="fortinet.firewall.portend">
    IP Pool port number to end
    type: integer
  </definition>
  <definition term="fortinet.firewall.probeproto">
    Link Monitor Probe Protocol
    type: keyword
  </definition>
  <definition term="fortinet.firewall.process">
    URL Filter process
    type: keyword
  </definition>
  <definition term="fortinet.firewall.processtime">
    Process time for reports
    type: integer
  </definition>
  <definition term="fortinet.firewall.profile">
    Profile Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.profile_vd">
    Virtual Domain Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.profilegroup">
    Profile Group Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.profiletype">
    Profile Type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.qtypeval">
    DNS question type value
    type: integer
  </definition>
  <definition term="fortinet.firewall.quarskip">
    Quarantine skip explanation
    type: keyword
  </definition>
  <definition term="fortinet.firewall.quotaexceeded">
    If quota has been exceeded
    type: keyword
  </definition>
  <definition term="fortinet.firewall.quotamax">
    Maximum quota allowed - in seconds if time-based - in bytes if traffic-based
    type: long
  </definition>
  <definition term="fortinet.firewall.quotatype">
    Quota type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.quotaused">
    Quota used - in seconds if time-based - in bytes if trafficbased)
    type: long
  </definition>
  <definition term="fortinet.firewall.radioband">
    Radio band
    type: keyword
  </definition>
  <definition term="fortinet.firewall.radioid">
    Radio ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.radioidclosest">
    Radio ID on the AP closest the rogue AP
    type: integer
  </definition>
  <definition term="fortinet.firewall.radioiddetected">
    Radio ID on the AP which detected the rogue AP
    type: integer
  </definition>
  <definition term="fortinet.firewall.rate">
    Wireless rogue rate value
    type: keyword
  </definition>
  <definition term="fortinet.firewall.rawdata">
    Raw data value
    type: keyword
  </definition>
  <definition term="fortinet.firewall.rawdataid">
    Raw data ID
    type: keyword
  </definition>
  <definition term="fortinet.firewall.rcvddelta">
    Received bytes delta
    type: keyword
  </definition>
  <definition term="fortinet.firewall.reason">
    Alert reason
    type: keyword
  </definition>
  <definition term="fortinet.firewall.received">
    Server key exchange received
    type: integer
  </definition>
  <definition term="fortinet.firewall.receivedsignature">
    Server key exchange received signature
    type: keyword
  </definition>
  <definition term="fortinet.firewall.red">
    Memory information in red
    type: keyword
  </definition>
  <definition term="fortinet.firewall.referralurl">
    Web filter referralurl
    type: keyword
  </definition>
  <definition term="fortinet.firewall.remote">
    Remote PPP IP address
    type: ip
  </definition>
  <definition term="fortinet.firewall.remotewtptime">
    Remote Wifi Radius authentication time
    type: keyword
  </definition>
  <definition term="fortinet.firewall.reporttype">
    Report type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.reqtype">
    Request type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.request_name">
    VOIP request name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.result">
    VPN phase result
    type: keyword
  </definition>
  <definition term="fortinet.firewall.role">
    VPN Phase 2 role
    type: keyword
  </definition>
  <definition term="fortinet.firewall.rssi">
    Received signal strength indicator
    type: integer
  </definition>
  <definition term="fortinet.firewall.rsso_key">
    RADIUS SSO attribute value
    type: keyword
  </definition>
  <definition term="fortinet.firewall.ruledata">
    Rule data
    type: keyword
  </definition>
  <definition term="fortinet.firewall.ruletype">
    Rule type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.scanned">
    Number of Scanned MMSs
    type: integer
  </definition>
  <definition term="fortinet.firewall.scantime">
    Scanned time
    type: long
  </definition>
  <definition term="fortinet.firewall.scope">
    FortiGuard Override Scope
    type: keyword
  </definition>
  <definition term="fortinet.firewall.security">
    Wireless rogue security
    type: keyword
  </definition>
  <definition term="fortinet.firewall.sensitivity">
    Sensitivity for document fingerprint
    type: keyword
  </definition>
  <definition term="fortinet.firewall.sensor">
    NAC Sensor Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.sentdelta">
    Sent bytes delta
    type: keyword
  </definition>
  <definition term="fortinet.firewall.seq">
    Sequence number
    type: keyword
  </definition>
  <definition term="fortinet.firewall.serial">
    WAN optimisation serial
    type: keyword
  </definition>
  <definition term="fortinet.firewall.serialno">
    Serial number
    type: keyword
  </definition>
  <definition term="fortinet.firewall.server">
    AD server FQDN or IP
    type: keyword
  </definition>
  <definition term="fortinet.firewall.session_id">
    Session ID
    type: keyword
  </definition>
  <definition term="fortinet.firewall.sessionid">
    WAD Session ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.setuprate">
    Session Setup Rate
    type: long
  </definition>
  <definition term="fortinet.firewall.severity">
    Severity
    type: keyword
  </definition>
  <definition term="fortinet.firewall.shaperdroprcvdbyte">
    Received bytes dropped by shaper
    type: integer
  </definition>
  <definition term="fortinet.firewall.shaperdropsentbyte">
    Sent bytes dropped by shaper
    type: integer
  </definition>
  <definition term="fortinet.firewall.shaperperipdropbyte">
    Dropped bytes per IP by shaper
    type: integer
  </definition>
  <definition term="fortinet.firewall.shaperperipname">
    Traffic shaper name (per IP)
    type: keyword
  </definition>
  <definition term="fortinet.firewall.shaperrcvdname">
    Traffic shaper name for received traffic
    type: keyword
  </definition>
  <definition term="fortinet.firewall.shapersentname">
    Traffic shaper name for sent traffic
    type: keyword
  </definition>
  <definition term="fortinet.firewall.shapingpolicyid">
    Traffic shaper policy ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.signal">
    Wireless rogue API signal
    type: integer
  </definition>
  <definition term="fortinet.firewall.size">
    Email size in bytes
    type: long
  </definition>
  <definition term="fortinet.firewall.slot">
    Slot number
    type: integer
  </definition>
  <definition term="fortinet.firewall.sn">
    Security fabric serial number
    type: keyword
  </definition>
  <definition term="fortinet.firewall.snclosest">
    SN of the AP closest to the rogue AP
    type: keyword
  </definition>
  <definition term="fortinet.firewall.sndetected">
    SN of the AP which detected the rogue AP
    type: keyword
  </definition>
  <definition term="fortinet.firewall.snmeshparent">
    SN of the mesh parent
    type: keyword
  </definition>
  <definition term="fortinet.firewall.spi">
    IPSEC SPI
    type: keyword
  </definition>
  <definition term="fortinet.firewall.src_int">
    Source interface
    type: keyword
  </definition>
  <definition term="fortinet.firewall.srcintfrole">
    Source interface role
    type: keyword
  </definition>
  <definition term="fortinet.firewall.srccountry">
    Source country
    type: keyword
  </definition>
  <definition term="fortinet.firewall.srcfamily">
    Source family
    type: keyword
  </definition>
  <definition term="fortinet.firewall.srchwvendor">
    Source hardware vendor
    type: keyword
  </definition>
  <definition term="fortinet.firewall.srchwversion">
    Source hardware version
    type: keyword
  </definition>
  <definition term="fortinet.firewall.srcinetsvc">
    Source interface service
    type: keyword
  </definition>
  <definition term="fortinet.firewall.srcname">
    Source name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.srcserver">
    Source server
    type: integer
  </definition>
  <definition term="fortinet.firewall.srcssid">
    Source SSID
    type: keyword
  </definition>
  <definition term="fortinet.firewall.srcswversion">
    Source software version
    type: keyword
  </definition>
  <definition term="fortinet.firewall.srcuuid">
    Source UUID
    type: keyword
  </definition>
  <definition term="fortinet.firewall.sscname">
    SSC name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.ssid">
    Base Service Set ID
    type: keyword
  </definition>
  <definition term="fortinet.firewall.sslaction">
    SSL Action
    type: keyword
  </definition>
  <definition term="fortinet.firewall.ssllocal">
    WAD SSL local
    type: keyword
  </definition>
  <definition term="fortinet.firewall.sslremote">
    WAD SSL remote
    type: keyword
  </definition>
  <definition term="fortinet.firewall.stacount">
    Number of stations/clients
    type: integer
  </definition>
  <definition term="fortinet.firewall.stage">
    IPSEC stage
    type: keyword
  </definition>
  <definition term="fortinet.firewall.stamac">
    802.1x station mac
    type: keyword
  </definition>
  <definition term="fortinet.firewall.state">
    Admin login state
    type: keyword
  </definition>
  <definition term="fortinet.firewall.status">
    Status
    type: keyword
  </definition>
  <definition term="fortinet.firewall.stitch">
    Automation stitch triggered
    type: keyword
  </definition>
  <definition term="fortinet.firewall.subject">
    Email subject
    type: keyword
  </definition>
  <definition term="fortinet.firewall.submodule">
    Configuration Sub-Module Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.subservice">
    AV subservice
    type: keyword
  </definition>
  <definition term="fortinet.firewall.subtype">
    Log subtype
    type: keyword
  </definition>
  <definition term="fortinet.firewall.suspicious">
    Number of Suspicious MMSs
    type: integer
  </definition>
  <definition term="fortinet.firewall.switchproto">
    Protocol change information
    type: keyword
  </definition>
  <definition term="fortinet.firewall.sync_status">
    The sync status with the master
    type: keyword
  </definition>
  <definition term="fortinet.firewall.sync_type">
    The sync type with the master
    type: keyword
  </definition>
  <definition term="fortinet.firewall.sysuptime">
    System uptime
    type: keyword
  </definition>
  <definition term="fortinet.firewall.tamac">
    the MAC address of Transmitter, if none, then Receiver
    type: keyword
  </definition>
  <definition term="fortinet.firewall.threattype">
    WIDS threat type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.time">
    Time of the event
    type: keyword
  </definition>
  <definition term="fortinet.firewall.to">
    Email to field
    type: keyword
  </definition>
  <definition term="fortinet.firewall.to_vcluster">
    destination virtual cluster number
    type: integer
  </definition>
  <definition term="fortinet.firewall.total">
    Total memory
    type: integer
  </definition>
  <definition term="fortinet.firewall.totalsession">
    Total Number of Sessions
    type: integer
  </definition>
  <definition term="fortinet.firewall.trace_id">
    Session clash trace ID
    type: keyword
  </definition>
  <definition term="fortinet.firewall.trandisp">
    NAT translation type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.transid">
    HTTP transaction ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.translationid">
    DNS filter transaltion ID
    type: keyword
  </definition>
  <definition term="fortinet.firewall.trigger">
    Automation stitch trigger
    type: keyword
  </definition>
  <definition term="fortinet.firewall.trueclntip">
    File filter true client IP
    type: ip
  </definition>
  <definition term="fortinet.firewall.tunnelid">
    IPSEC tunnel ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.tunnelip">
    IPSEC tunnel IP
    type: ip
  </definition>
  <definition term="fortinet.firewall.tunneltype">
    IPSEC tunnel type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.type">
    Module type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.ui">
    Admin authentication UI type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.unauthusersource">
    Unauthenticated user source
    type: keyword
  </definition>
  <definition term="fortinet.firewall.unit">
    Power supply unit
    type: integer
  </definition>
  <definition term="fortinet.firewall.urlfilteridx">
    URL filter ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.urlfilterlist">
    URL filter list
    type: keyword
  </definition>
  <definition term="fortinet.firewall.urlsource">
    URL filter source
    type: keyword
  </definition>
  <definition term="fortinet.firewall.urltype">
    URL filter type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.used">
    Number of Used IPs
    type: integer
  </definition>
  <definition term="fortinet.firewall.used_for_type">
    Connection for the type
    type: integer
  </definition>
  <definition term="fortinet.firewall.utmaction">
    Security action performed by UTM
    type: keyword
  </definition>
  <definition term="fortinet.firewall.utmref">
    Reference to UTM
    type: keyword
  </definition>
  <definition term="fortinet.firewall.vap">
    Virtual AP
    type: keyword
  </definition>
  <definition term="fortinet.firewall.vapmode">
    Virtual AP mode
    type: keyword
  </definition>
  <definition term="fortinet.firewall.vcluster">
    virtual cluster id
    type: integer
  </definition>
  <definition term="fortinet.firewall.vcluster_member">
    Virtual cluster member
    type: integer
  </definition>
  <definition term="fortinet.firewall.vcluster_state">
    Virtual cluster state
    type: keyword
  </definition>
  <definition term="fortinet.firewall.vd">
    Virtual Domain Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.vdname">
    Virtual Domain Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.vendorurl">
    Vulnerability scan vendor name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.version">
    Version
    type: keyword
  </definition>
  <definition term="fortinet.firewall.vip">
    Virtual IP
    type: keyword
  </definition>
  <definition term="fortinet.firewall.virus">
    Virus name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.virusid">
    Virus ID (unique virus identifier)
    type: integer
  </definition>
  <definition term="fortinet.firewall.voip_proto">
    VOIP protocol
    type: keyword
  </definition>
  <definition term="fortinet.firewall.vpn">
    VPN description
    type: keyword
  </definition>
  <definition term="fortinet.firewall.vpntunnel">
    IPsec Vpn Tunnel Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.vpntype">
    The type of the VPN tunnel
    type: keyword
  </definition>
  <definition term="fortinet.firewall.vrf">
    VRF number
    type: integer
  </definition>
  <definition term="fortinet.firewall.vulncat">
    Vulnerability Category
    type: keyword
  </definition>
  <definition term="fortinet.firewall.vulnid">
    Vulnerability ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.vulnname">
    Vulnerability name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.vwlid">
    VWL ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.vwlquality">
    VWL quality
    type: keyword
  </definition>
  <definition term="fortinet.firewall.vwlservice">
    VWL service
    type: keyword
  </definition>
  <definition term="fortinet.firewall.vwpvlanid">
    VWP VLAN ID
    type: integer
  </definition>
  <definition term="fortinet.firewall.wanin">
    WAN incoming traffic in bytes
    type: long
  </definition>
  <definition term="fortinet.firewall.wanoptapptype">
    WAN Optimization Application type
    type: keyword
  </definition>
  <definition term="fortinet.firewall.wanout">
    WAN outgoing traffic in bytes
    type: long
  </definition>
  <definition term="fortinet.firewall.weakwepiv">
    Weak Wep Initiation Vector
    type: keyword
  </definition>
  <definition term="fortinet.firewall.xauthgroup">
    XAuth Group Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.xauthuser">
    XAuth User Name
    type: keyword
  </definition>
  <definition term="fortinet.firewall.xid">
    Wireless X ID
    type: integer
  </definition>
</definitions>