﻿---
title: Elasticsearch fields
description: elasticsearch Module GC fileset fields. Fields specific to GC phase. Process CPU time spent performing collections. Heap allocation and total size. Old...
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-elasticsearch
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Elasticsearch fields
elasticsearch Module

## elasticsearch

<definitions>
  <definition term="elasticsearch.component">
    Elasticsearch component from where the log event originated
    type: keyword
    example: o.e.c.m.MetaDataCreateIndexService
  </definition>
  <definition term="elasticsearch.cluster.uuid">
    UUID of the cluster
    type: keyword
    example: GmvrbHlNTiSVYiPf8kxg9g
  </definition>
  <definition term="elasticsearch.cluster.name">
    Name of the cluster
    type: keyword
    example: docker-cluster
  </definition>
  <definition term="elasticsearch.node.id">
    ID of the node
    type: keyword
    example: DSiWcTyeThWtUXLB9J0BMw
  </definition>
  <definition term="elasticsearch.node.name">
    Name of the node
    type: keyword
    example: vWNJsZ3
  </definition>
  <definition term="elasticsearch.index.name">
    Index name
    type: keyword
    example: filebeat-test-input
  </definition>
  <definition term="elasticsearch.index.id">
    Index id
    type: keyword
    example: aOGgDwbURfCV57AScqbCgw
  </definition>
  <definition term="elasticsearch.shard.id">
    Id of the shard
    type: keyword
    example: 0
  </definition>
  <definition term="elasticsearch.elastic_product_origin">
    Used by Elastic stack to identify which component of the stack sent the request
    type: keyword
    example: kibana
  </definition>
  <definition term="elasticsearch.http.request.x_opaque_id">
    Used by Elasticsearch to throttle and deduplicate deprecation warnings
    type: keyword
    example: v7app
  </definition>
  <definition term="elasticsearch.event.category">
    Category of the deprecation event
    type: keyword
    example: compatible_api
  </definition>
  <definition term="elasticsearch.audit.layer">
    The layer from which this event originated: rest, transport or ip_filter
    type: keyword
    example: rest
  </definition>
  <definition term="elasticsearch.audit.event_type">
    The type of event that occurred: anonymous_access_denied, authentication_failed, access_denied, access_granted, connection_granted, connection_denied, tampered_request, run_as_granted, run_as_denied
    type: keyword
    example: access_granted
  </definition>
  <definition term="elasticsearch.audit.origin.type">
    Where the request originated: rest (request originated from a REST API request), transport (request was received on the transport channel), local_node (the local node issued the request)
    type: keyword
    example: local_node
  </definition>
  <definition term="elasticsearch.audit.realm">
    The authentication realm the authentication was validated against
    type: keyword
  </definition>
  <definition term="elasticsearch.audit.user.realm">
    The user's authentication realm, if authenticated
    type: keyword
  </definition>
  <definition term="elasticsearch.audit.user.roles">
    Roles to which the principal belongs
    type: keyword
    example: ['kibana_admin', 'beats_admin']
  </definition>
  <definition term="elasticsearch.audit.user.run_as.name">
    type: keyword
  </definition>
  <definition term="elasticsearch.audit.user.run_as.realm">
    type: keyword
  </definition>
  <definition term="elasticsearch.audit.component">
    type: keyword
  </definition>
  <definition term="elasticsearch.audit.action">
    The name of the action that was executed
    type: keyword
    example: cluster:monitor/main
  </definition>
  <definition term="elasticsearch.audit.url.params">
    REST URI parameters
    example: {username=jacknich2}
  </definition>
  <definition term="elasticsearch.audit.indices">
    Indices accessed by action
    type: keyword
    example: ['foo-2019.01.04', 'foo-2019.01.03', 'foo-2019.01.06']
  </definition>
  <definition term="elasticsearch.audit.request.id">
    Unique ID of request
    type: keyword
    example: WzL_kb6VSvOhAq0twPvHOQ
  </definition>
  <definition term="elasticsearch.audit.request.name">
    The type of request that was executed
    type: keyword
    example: ClearScrollRequest
  </definition>
  <definition term="elasticsearch.audit.request_body">
    type: alias
    alias to: http.request.body.content
  </definition>
  <definition term="elasticsearch.audit.origin_address">
    type: alias
    alias to: source.ip
  </definition>
  <definition term="elasticsearch.audit.uri">
    type: alias
    alias to: url.original
  </definition>
  <definition term="elasticsearch.audit.principal">
    type: alias
    alias to: user.name
  </definition>
  <definition term="elasticsearch.audit.message">
    type: text
  </definition>
  <definition term="elasticsearch.audit.invalidate.apikeys.owned_by_authenticated_user">
    type: boolean
  </definition>
  <definition term="elasticsearch.audit.authentication.type">
    type: keyword
  </definition>
  <definition term="elasticsearch.audit.opaque_id">
    type: text
  </definition>
</definitions>


## deprecation


## gc

GC fileset fields.

## phase

Fields specific to GC phase.
<definitions>
  <definition term="elasticsearch.gc.phase.name">
    Name of the GC collection phase.
    type: keyword
  </definition>
  <definition term="elasticsearch.gc.phase.duration_sec">
    Collection phase duration according to the Java virtual machine.
    type: float
  </definition>
  <definition term="elasticsearch.gc.phase.scrub_symbol_table_time_sec">
    Pause time in seconds cleaning up symbol tables.
    type: float
  </definition>
  <definition term="elasticsearch.gc.phase.scrub_string_table_time_sec">
    Pause time in seconds cleaning up string tables.
    type: float
  </definition>
  <definition term="elasticsearch.gc.phase.weak_refs_processing_time_sec">
    Time spent processing weak references in seconds.
    type: float
  </definition>
  <definition term="elasticsearch.gc.phase.parallel_rescan_time_sec">
    Time spent in seconds marking live objects while application is stopped.
    type: float
  </definition>
  <definition term="elasticsearch.gc.phase.class_unload_time_sec">
    Time spent unloading unused classes in seconds.
    type: float
  </definition>
</definitions>


## cpu_time

Process CPU time spent performing collections.
<definitions>
  <definition term="elasticsearch.gc.phase.cpu_time.user_sec">
    CPU time spent outside the kernel.
    type: float
  </definition>
  <definition term="elasticsearch.gc.phase.cpu_time.sys_sec">
    CPU time spent inside the kernel.
    type: float
  </definition>
  <definition term="elasticsearch.gc.phase.cpu_time.real_sec">
    Total elapsed CPU time spent to complete the collection from start to finish.
    type: float
  </definition>
  <definition term="elasticsearch.gc.jvm_runtime_sec">
    The time from JVM start up in seconds, as a floating point number.
    type: float
  </definition>
  <definition term="elasticsearch.gc.threads_total_stop_time_sec">
    Garbage collection threads total stop time seconds.
    type: float
  </definition>
  <definition term="elasticsearch.gc.stopping_threads_time_sec">
    Time took to stop threads seconds.
    type: float
  </definition>
  <definition term="elasticsearch.gc.tags">
    GC logging tags.
    type: keyword
  </definition>
</definitions>


## heap

Heap allocation and total size.
<definitions>
  <definition term="elasticsearch.gc.heap.size_kb">
    Total heap size in kilobytes.
    type: integer
  </definition>
  <definition term="elasticsearch.gc.heap.used_kb">
    Used heap in kilobytes.
    type: integer
  </definition>
</definitions>


## old_gen

Old generation occupancy and total size.
<definitions>
  <definition term="elasticsearch.gc.old_gen.size_kb">
    Total size of old generation in kilobytes.
    type: integer
  </definition>
  <definition term="elasticsearch.gc.old_gen.used_kb">
    Old generation occupancy in kilobytes.
    type: integer
  </definition>
</definitions>


## young_gen

Young generation occupancy and total size.
<definitions>
  <definition term="elasticsearch.gc.young_gen.size_kb">
    Total size of young generation in kilobytes.
    type: integer
  </definition>
  <definition term="elasticsearch.gc.young_gen.used_kb">
    Young generation occupancy in kilobytes.
    type: integer
  </definition>
</definitions>


## server

Server log file
<definitions>
  <definition term="elasticsearch.server.stacktrace">
    Field is not indexed.
  </definition>
</definitions>


## gc

GC log

## young

Young GC
<definitions>
  <definition term="elasticsearch.server.gc.young.one">
    type: long
    example:
  </definition>
  <definition term="elasticsearch.server.gc.young.two">
    type: long
    example:
  </definition>
  <definition term="elasticsearch.server.gc.overhead_seq">
    Sequence number
    type: long
    example: 3449992
  </definition>
  <definition term="elasticsearch.server.gc.collection_duration.ms">
    Time spent in GC, in milliseconds
    type: float
    example: 1600
  </definition>
  <definition term="elasticsearch.server.gc.observation_duration.ms">
    Total time over which collection was observed, in milliseconds
    type: float
    example: 1800
  </definition>
</definitions>


## slowlog

Slowlog events from Elasticsearch
<definitions>
  <definition term="elasticsearch.slowlog.logger">
    Logger name
    type: keyword
    example: index.search.slowlog.fetch
  </definition>
  <definition term="elasticsearch.slowlog.took">
    Time it took to execute the query
    type: keyword
    example: 300ms
  </definition>
  <definition term="elasticsearch.slowlog.types">
    Types
    type: keyword
    example:
  </definition>
  <definition term="elasticsearch.slowlog.stats">
    Stats groups
    type: keyword
    example: group1
  </definition>
  <definition term="elasticsearch.slowlog.search_type">
    Search type
    type: keyword
    example: QUERY_THEN_FETCH
  </definition>
  <definition term="elasticsearch.slowlog.source_query">
    Slow query
    type: keyword
    example: {"query":{"match_all":{"boost":1.0}}}
  </definition>
  <definition term="elasticsearch.slowlog.extra_source">
    Extra source information
    type: keyword
    example:
  </definition>
  <definition term="elasticsearch.slowlog.total_hits">
    Total hits
    type: keyword
    example: 42
  </definition>
  <definition term="elasticsearch.slowlog.total_shards">
    Total queried shards
    type: keyword
    example: 22
  </definition>
  <definition term="elasticsearch.slowlog.routing">
    Routing
    type: keyword
    example: s01HZ2QBk9jw4gtgaFtn
  </definition>
  <definition term="elasticsearch.slowlog.id">
    Id
    type: keyword
    example:
  </definition>
  <definition term="elasticsearch.slowlog.type">
    Type
    type: keyword
    example: doc
  </definition>
  <definition term="elasticsearch.slowlog.source">
    Source of document that was indexed
    type: keyword
  </definition>
  <definition term="elasticsearch.slowlog.user.realm">
    The authentication realm the user was authenticated against
    type: keyword
    example: default_file
  </definition>
  <definition term="elasticsearch.slowlog.user.effective.realm">
    The authentication realm the effective user was authenticated against
    type: keyword
    example: default_file
  </definition>
  <definition term="elasticsearch.slowlog.auth.type">
    The authentication type used to authenticate the user. One of TOKEN  REALM  API_KEY
    type: keyword
    example: REALM
  </definition>
  <definition term="elasticsearch.slowlog.apikey.id">
    The id of the API key used
    type: keyword
    example: WzL_kb6VSvOhAq0twPvHOQ
  </definition>
  <definition term="elasticsearch.slowlog.apikey.name">
    The name of the API key used
    type: keyword
    example: my-api-key
  </definition>
</definitions>