﻿---
title: CrowdStrike fields
description: Module for collecting Crowdstrike events. Fields for Crowdstrike Falcon event and alert data. Meta data fields for each event that include type and timestamp...
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-crowdstrike
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Beta
---

# CrowdStrike fields
Module for collecting Crowdstrike events.

## crowdstrike

Fields for Crowdstrike Falcon event and alert data.

## metadata

Meta data fields for each event that include type and timestamp.
<definitions>
  <definition term="crowdstrike.metadata.eventType">
    DetectionSummaryEvent, FirewallMatchEvent, IncidentSummaryEvent, RemoteResponseSessionStartEvent, RemoteResponseSessionEndEvent, AuthActivityAuditEvent, or UserActivityAuditEvent
    type: keyword
  </definition>
  <definition term="crowdstrike.metadata.eventCreationTime">
    The time this event occurred on the endpoint in UTC UNIX_MS format.
    type: date
  </definition>
  <definition term="crowdstrike.metadata.offset">
    Offset number that tracks the location of the event in stream. This is used to identify unique detection events.
    type: integer
  </definition>
  <definition term="crowdstrike.metadata.customerIDString">
    Customer identifier
    type: keyword
  </definition>
  <definition term="crowdstrike.metadata.version">
    Schema version
    type: keyword
  </definition>
</definitions>


## event

Event data fields for each event and alert.
<definitions>
  <definition term="crowdstrike.event.ProcessStartTime">
    The process start time in UTC UNIX_MS format.
    type: date
  </definition>
  <definition term="crowdstrike.event.ProcessEndTime">
    The process termination time in UTC UNIX_MS format.
    type: date
  </definition>
  <definition term="crowdstrike.event.ProcessId">
    Process ID related to the detection.
    type: integer
  </definition>
  <definition term="crowdstrike.event.ParentProcessId">
    Parent process ID related to the detection.
    type: integer
  </definition>
  <definition term="crowdstrike.event.ComputerName">
    Name of the computer where the detection occurred.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.UserName">
    User name associated with the detection.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.DetectName">
    Name of the detection.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.DetectDescription">
    Description of the detection.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.Severity">
    Severity score of the detection.
    type: integer
  </definition>
  <definition term="crowdstrike.event.SeverityName">
    Severity score text.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.FileName">
    File name of the associated process for the detection.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.FilePath">
    Path of the executable associated with the detection.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.CommandLine">
    Executable path with command line arguments.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.SHA1String">
    SHA1 sum of the executable associated with the detection.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.SHA256String">
    SHA256 sum of the executable associated with the detection.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.MD5String">
    MD5 sum of the executable associated with the detection.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.MachineDomain">
    Domain for the machine associated with the detection.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.FalconHostLink">
    URL to view the detection in Falcon.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.SensorId">
    Unique ID associated with the Falcon sensor.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.DetectId">
    Unique ID associated with the detection.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.LocalIP">
    IP address of the host associated with the detection.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.MACAddress">
    MAC address of the host associated with the detection.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.Tactic">
    MITRE tactic category of the detection.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.Technique">
    MITRE technique category of the detection.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.Objective">
    Method of detection.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.PatternDispositionDescription">
    Action taken by Falcon.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.PatternDispositionValue">
    Unique ID associated with action taken.
    type: integer
  </definition>
  <definition term="crowdstrike.event.PatternDispositionFlags">
    Flags indicating actions taken.
    type: object
  </definition>
  <definition term="crowdstrike.event.State">
    Whether the incident summary is open and ongoing or closed.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.IncidentStartTime">
    Start time for the incident in UTC UNIX format.
    type: date
  </definition>
  <definition term="crowdstrike.event.IncidentEndTime">
    End time for the incident in UTC UNIX format.
    type: date
  </definition>
  <definition term="crowdstrike.event.FineScore">
    Score for incident.
    type: float
  </definition>
  <definition term="crowdstrike.event.UserId">
    Email address or user ID associated with the event.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.UserIp">
    IP address associated with the user.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.OperationName">
    Event subtype.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.ServiceName">
    Service associated with this event.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.Success">
    Indicator of whether or not this event was successful.
    type: boolean
  </definition>
  <definition term="crowdstrike.event.UTCTimestamp">
    Timestamp associated with this event in UTC UNIX format.
    type: date
  </definition>
  <definition term="crowdstrike.event.AuditKeyValues">
    Fields that were changed in this event.
    type: nested
  </definition>
  <definition term="crowdstrike.event.ExecutablesWritten">
    Detected executables written to disk by a process.
    type: nested
  </definition>
  <definition term="crowdstrike.event.SessionId">
    Session ID of the remote response session.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.HostnameField">
    Host name of the machine for the remote session.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.StartTimestamp">
    Start time for the remote session in UTC UNIX format.
    type: date
  </definition>
  <definition term="crowdstrike.event.EndTimestamp">
    End time for the remote session in UTC UNIX format.
    type: date
  </definition>
  <definition term="crowdstrike.event.LateralMovement">
    Lateral movement field for incident.
    type: long
  </definition>
  <definition term="crowdstrike.event.ParentImageFileName">
    Path to the parent process.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.ParentCommandLine">
    Parent process command line arguments.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.GrandparentImageFileName">
    Path to the grandparent process.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.GrandparentCommandLine">
    Grandparent process command line arguments.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.IOCType">
    CrowdStrike type for indicator of compromise.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.IOCValue">
    CrowdStrike value for indicator of compromise.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.CustomerId">
    Customer identifier.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.DeviceId">
    Device on which the event occurred.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.Ipv">
    Protocol for network request.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.ConnectionDirection">
    Direction for network connection.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.EventType">
    CrowdStrike provided event type.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.HostName">
    Host name of the local machine.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.ICMPCode">
    RFC2780 ICMP Code field.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.ICMPType">
    RFC2780 ICMP Type field.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.ImageFileName">
    File name of the associated process for the detection.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.PID">
    Associated process id for the detection.
    type: long
  </definition>
  <definition term="crowdstrike.event.LocalAddress">
    IP address of local machine.
    type: ip
  </definition>
  <definition term="crowdstrike.event.LocalPort">
    Port of local machine.
    type: long
  </definition>
  <definition term="crowdstrike.event.RemoteAddress">
    IP address of remote machine.
    type: ip
  </definition>
  <definition term="crowdstrike.event.RemotePort">
    Port of remote machine.
    type: long
  </definition>
  <definition term="crowdstrike.event.RuleAction">
    Firewall rule action.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.RuleDescription">
    Firewall rule description.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.RuleFamilyID">
    Firewall rule family id.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.RuleGroupName">
    Firewall rule group name.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.RuleName">
    Firewall rule name.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.RuleId">
    Firewall rule id.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.MatchCount">
    Number of firewall rule matches.
    type: long
  </definition>
  <definition term="crowdstrike.event.MatchCountSinceLastReport">
    Number of firewall rule matches since the last report.
    type: long
  </definition>
  <definition term="crowdstrike.event.Timestamp">
    Firewall rule triggered timestamp.
    type: date
  </definition>
  <definition term="crowdstrike.event.Flags.Audit">
    CrowdStrike audit flag.
    type: boolean
  </definition>
  <definition term="crowdstrike.event.Flags.Log">
    CrowdStrike log flag.
    type: boolean
  </definition>
  <definition term="crowdstrike.event.Flags.Monitor">
    CrowdStrike monitor flag.
    type: boolean
  </definition>
  <definition term="crowdstrike.event.Protocol">
    CrowdStrike provided protocol.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.NetworkProfile">
    CrowdStrike network profile.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.PolicyName">
    CrowdStrike policy name.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.PolicyID">
    CrowdStrike policy id.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.Status">
    CrowdStrike status.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.TreeID">
    CrowdStrike tree id.
    type: keyword
  </definition>
  <definition term="crowdstrike.event.Commands">
    Commands run in a remote session.
    type: keyword
  </definition>
</definitions>