﻿---
title: CEF fields
description: Module for receiving CEF logs over Syslog. The module adds vendor specific fields in addition to the fields the decode_cef processor provides. Fields...
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-cef-module
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# CEF fields
Module for receiving CEF logs over Syslog. The module adds vendor specific fields in addition to the fields the decode_cef processor provides.

## forcepoint

Fields for Forcepoint Custom String mappings
<definitions>
  <definition term="forcepoint.virus_id">
    Virus ID
    type: keyword
  </definition>
</definitions>


## checkpoint

Fields for Check Point custom string mappings.
<definitions>
  <definition term="checkpoint.app_risk">
    Application risk.
    type: keyword
  </definition>
  <definition term="checkpoint.app_severity">
    Application threat severity.
    type: keyword
  </definition>
  <definition term="checkpoint.app_sig_id">
    The signature ID which the application was detected by.
    type: keyword
  </definition>
  <definition term="checkpoint.auth_method">
    Password authentication protocol used.
    type: keyword
  </definition>
  <definition term="checkpoint.category">
    Category.
    type: keyword
  </definition>
  <definition term="checkpoint.confidence_level">
    Confidence level determined.
    type: integer
  </definition>
  <definition term="checkpoint.connectivity_state">
    Connectivity state.
    type: keyword
  </definition>
  <definition term="checkpoint.cookie">
    IKE cookie.
    type: keyword
  </definition>
  <definition term="checkpoint.dst_phone_number">
    Destination IP-Phone.
    type: keyword
  </definition>
  <definition term="checkpoint.email_control">
    Engine name.
    type: keyword
  </definition>
  <definition term="checkpoint.email_id">
    Internal email ID.
    type: keyword
  </definition>
  <definition term="checkpoint.email_recipients_num">
    Number of recipients.
    type: long
  </definition>
  <definition term="checkpoint.email_session_id">
    Internal email session ID.
    type: keyword
  </definition>
  <definition term="checkpoint.email_spool_id">
    Internal email spool ID.
    type: keyword
  </definition>
  <definition term="checkpoint.email_subject">
    Email subject.
    type: keyword
  </definition>
  <definition term="checkpoint.event_count">
    Number of events associated with the log.
    type: long
  </definition>
  <definition term="checkpoint.frequency">
    Scan frequency.
    type: keyword
  </definition>
  <definition term="checkpoint.icmp_type">
    ICMP type.
    type: long
  </definition>
  <definition term="checkpoint.icmp_code">
    ICMP code.
    type: long
  </definition>
  <definition term="checkpoint.identity_type">
    Identity type.
    type: keyword
  </definition>
  <definition term="checkpoint.incident_extension">
    Format of original data.
    type: keyword
  </definition>
  <definition term="checkpoint.integrity_av_invoke_type">
    Scan invoke type.
    type: keyword
  </definition>
  <definition term="checkpoint.malware_family">
    Malware family.
    type: keyword
  </definition>
  <definition term="checkpoint.peer_gateway">
    Main IP of the peer Security Gateway.
    type: ip
  </definition>
  <definition term="checkpoint.performance_impact">
    Protection performance impact.
    type: integer
  </definition>
  <definition term="checkpoint.protection_id">
    Protection malware ID.
    type: keyword
  </definition>
  <definition term="checkpoint.protection_name">
    Specific signature name of the attack.
    type: keyword
  </definition>
  <definition term="checkpoint.protection_type">
    Type of protection used to detect the attack.
    type: keyword
  </definition>
  <definition term="checkpoint.scan_result">
    Scan result.
    type: keyword
  </definition>
  <definition term="checkpoint.sensor_mode">
    Sensor mode.
    type: keyword
  </definition>
  <definition term="checkpoint.severity">
    Threat severity.
    type: keyword
  </definition>
  <definition term="checkpoint.spyware_name">
    Spyware name.
    type: keyword
  </definition>
  <definition term="checkpoint.spyware_status">
    Spyware status.
    type: keyword
  </definition>
  <definition term="checkpoint.subs_exp">
    The expiration date of the subscription.
    type: date
  </definition>
  <definition term="checkpoint.tcp_flags">
    TCP packet flags.
    type: keyword
  </definition>
  <definition term="checkpoint.termination_reason">
    Termination reason.
    type: keyword
  </definition>
  <definition term="checkpoint.update_status">
    Update status.
    type: keyword
  </definition>
  <definition term="checkpoint.user_status">
    User response.
    type: keyword
  </definition>
  <definition term="checkpoint.uuid">
    External ID.
    type: keyword
  </definition>
  <definition term="checkpoint.virus_name">
    Virus name.
    type: keyword
  </definition>
  <definition term="checkpoint.voip_log_type">
    VoIP log types.
    type: keyword
  </definition>
</definitions>


## cef.extensions

Extra vendor-specific extensions.
<definitions>
  <definition term="cef.extensions.cp_app_risk">
    type: keyword
  </definition>
  <definition term="cef.extensions.cp_severity">
    type: keyword
  </definition>
  <definition term="cef.extensions.ifname">
    type: keyword
  </definition>
  <definition term="cef.extensions.inzone">
    type: keyword
  </definition>
  <definition term="cef.extensions.layer_uuid">
    type: keyword
  </definition>
  <definition term="cef.extensions.layer_name">
    type: keyword
  </definition>
  <definition term="cef.extensions.logid">
    type: keyword
  </definition>
  <definition term="cef.extensions.loguid">
    type: keyword
  </definition>
  <definition term="cef.extensions.match_id">
    type: keyword
  </definition>
  <definition term="cef.extensions.nat_addtnl_rulenum">
    type: keyword
  </definition>
  <definition term="cef.extensions.nat_rulenum">
    type: keyword
  </definition>
  <definition term="cef.extensions.origin">
    type: keyword
  </definition>
  <definition term="cef.extensions.originsicname">
    type: keyword
  </definition>
  <definition term="cef.extensions.outzone">
    type: keyword
  </definition>
  <definition term="cef.extensions.parent_rule">
    type: keyword
  </definition>
  <definition term="cef.extensions.product">
    type: keyword
  </definition>
  <definition term="cef.extensions.rule_action">
    type: keyword
  </definition>
  <definition term="cef.extensions.rule_uid">
    type: keyword
  </definition>
  <definition term="cef.extensions.sequencenum">
    type: keyword
  </definition>
  <definition term="cef.extensions.service_id">
    type: keyword
  </definition>
  <definition term="cef.extensions.version">
    type: keyword
  </definition>
</definitions>