﻿---
title: Azure fields
description: Azure Module Resource Fields for Azure activity logs. Identity Claims initiated by user Authorization Evidence Fields for Azure audit logs. The audit...
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-azure
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Azure fields
Azure Module

## azure

<definitions>
  <definition term="azure.subscription_id">
    Azure subscription ID
    type: keyword
  </definition>
  <definition term="azure.correlation_id">
    Correlation ID
    type: keyword
  </definition>
  <definition term="azure.tenant_id">
    tenant ID
    type: keyword
  </definition>
</definitions>


## resource

Resource
<definitions>
  <definition term="azure.resource.id">
    Resource ID
    type: keyword
  </definition>
  <definition term="azure.resource.group">
    Resource group
    type: keyword
  </definition>
  <definition term="azure.resource.provider">
    Resource type/namespace
    type: keyword
  </definition>
  <definition term="azure.resource.namespace">
    Resource type/namespace
    type: keyword
  </definition>
  <definition term="azure.resource.name">
    Name
    type: keyword
  </definition>
  <definition term="azure.resource.authorization_rule">
    Authorization rule
    type: keyword
  </definition>
</definitions>


## activitylogs

Fields for Azure activity logs.
<definitions>
  <definition term="azure.activitylogs.identity_name">
    identity name
    type: keyword
  </definition>
</definitions>


## identity

Identity

## claims_initiated_by_user

Claims initiated by user
<definitions>
  <definition term="azure.activitylogs.identity.claims_initiated_by_user.name">
    Name
    type: keyword
  </definition>
  <definition term="azure.activitylogs.identity.claims_initiated_by_user.givenname">
    Givenname
    type: keyword
  </definition>
  <definition term="azure.activitylogs.identity.claims_initiated_by_user.surname">
    Surname
    type: keyword
  </definition>
  <definition term="azure.activitylogs.identity.claims_initiated_by_user.fullname">
    Fullname
    type: keyword
  </definition>
  <definition term="azure.activitylogs.identity.claims_initiated_by_user.schema">
    Schema
    type: keyword
  </definition>
  <definition term="azure.activitylogs.identity.claims.*">
    Claims
    type: object
  </definition>
</definitions>


## authorization

Authorization
<definitions>
  <definition term="azure.activitylogs.identity.authorization.scope">
    Scope
    type: keyword
  </definition>
  <definition term="azure.activitylogs.identity.authorization.action">
    Action
    type: keyword
  </definition>
</definitions>


## evidence

Evidence
<definitions>
  <definition term="azure.activitylogs.identity.authorization.evidence.role_assignment_scope">
    Role assignment scope
    type: keyword
  </definition>
  <definition term="azure.activitylogs.identity.authorization.evidence.role_definition_id">
    Role definition ID
    type: keyword
  </definition>
  <definition term="azure.activitylogs.identity.authorization.evidence.role">
    Role
    type: keyword
  </definition>
  <definition term="azure.activitylogs.identity.authorization.evidence.role_assignment_id">
    Role assignment ID
    type: keyword
  </definition>
  <definition term="azure.activitylogs.identity.authorization.evidence.principal_id">
    Principal ID
    type: keyword
  </definition>
  <definition term="azure.activitylogs.identity.authorization.evidence.principal_type">
    Principal type
    type: keyword
  </definition>
  <definition term="azure.activitylogs.tenant_id">
    Tenant ID
    type: keyword
  </definition>
  <definition term="azure.activitylogs.level">
    Level
    type: long
  </definition>
  <definition term="azure.activitylogs.operation_version">
    Operation version
    type: keyword
  </definition>
  <definition term="azure.activitylogs.operation_name">
    Operation name
    type: keyword
  </definition>
  <definition term="azure.activitylogs.result_type">
    Result type
    type: keyword
  </definition>
  <definition term="azure.activitylogs.result_signature">
    Result signature
    type: keyword
  </definition>
  <definition term="azure.activitylogs.category">
    Category
    type: keyword
  </definition>
  <definition term="azure.activitylogs.event_category">
    Event Category
    type: keyword
  </definition>
  <definition term="azure.activitylogs.properties">
    Properties
    type: flattened
  </definition>
</definitions>


## auditlogs

Fields for Azure audit logs.
<definitions>
  <definition term="azure.auditlogs.category">
    The category of the operation.  Currently, Audit is the only supported value.
    type: keyword
  </definition>
  <definition term="azure.auditlogs.operation_name">
    The operation name
    type: keyword
  </definition>
  <definition term="azure.auditlogs.operation_version">
    The operation version
    type: keyword
  </definition>
  <definition term="azure.auditlogs.identity">
    Identity
    type: keyword
  </definition>
  <definition term="azure.auditlogs.tenant_id">
    Tenant ID
    type: keyword
  </definition>
  <definition term="azure.auditlogs.result_signature">
    Result signature
    type: keyword
  </definition>
</definitions>


## properties

The audit log properties
<definitions>
  <definition term="azure.auditlogs.properties.result">
    Log result
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.activity_display_name">
    Activity display name
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.result_reason">
    Reason for the log result
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.correlation_id">
    Correlation ID
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.logged_by_service">
    Logged by service
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.operation_type">
    Operation type
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.id">
    ID
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.activity_datetime">
    Activity timestamp
    type: date
  </definition>
  <definition term="azure.auditlogs.properties.category">
    category
    type: keyword
  </definition>
</definitions>


## target_resources.*

Target resources
<definitions>
  <definition term="azure.auditlogs.properties.target_resources.*.display_name">
    Display name
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.target_resources.*.id">
    ID
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.target_resources.*.type">
    Type
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.target_resources.*.ip_address">
    ip Address
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.target_resources.*.user_principal_name">
    User principal name
    type: keyword
  </definition>
</definitions>


## modified_properties.*

Modified properties
<definitions>
  <definition term="azure.auditlogs.properties.target_resources.*.modified_properties.*.new_value">
    New value
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.target_resources.*.modified_properties.*.display_name">
    Display value
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.target_resources.*.modified_properties.*.old_value">
    Old value
    type: keyword
  </definition>
</definitions>


## initiated_by

Information regarding the initiator

## app

App
<definitions>
  <definition term="azure.auditlogs.properties.initiated_by.app.servicePrincipalName">
    Service principal name
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.initiated_by.app.displayName">
    Display name
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.initiated_by.app.appId">
    App ID
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.initiated_by.app.servicePrincipalId">
    Service principal ID
    type: keyword
  </definition>
</definitions>


## user

User
<definitions>
  <definition term="azure.auditlogs.properties.initiated_by.user.userPrincipalName">
    User principal name
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.initiated_by.user.displayName">
    Display name
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.initiated_by.user.id">
    ID
    type: keyword
  </definition>
  <definition term="azure.auditlogs.properties.initiated_by.user.ipAddress">
    ip Address
    type: keyword
  </definition>
</definitions>


## platformlogs

Fields for Azure platform logs.
<definitions>
  <definition term="azure.platformlogs.operation_name">
    Operation name
    type: keyword
  </definition>
  <definition term="azure.platformlogs.result_type">
    Result type
    type: keyword
  </definition>
  <definition term="azure.platformlogs.result_signature">
    Result signature
    type: keyword
  </definition>
  <definition term="azure.platformlogs.category">
    Category
    type: keyword
  </definition>
  <definition term="azure.platformlogs.event_category">
    Event Category
    type: keyword
  </definition>
  <definition term="azure.platformlogs.status">
    Status
    type: keyword
  </definition>
  <definition term="azure.platformlogs.ccpNamespace">
    ccpNamespace
    type: keyword
  </definition>
  <definition term="azure.platformlogs.Cloud">
    Cloud
    type: keyword
  </definition>
  <definition term="azure.platformlogs.Environment">
    Environment
    type: keyword
  </definition>
  <definition term="azure.platformlogs.EventTimeString">
    EventTimeString
    type: keyword
  </definition>
  <definition term="azure.platformlogs.Caller">
    Caller
    type: keyword
  </definition>
  <definition term="azure.platformlogs.ScaleUnit">
    ScaleUnit
    type: keyword
  </definition>
  <definition term="azure.platformlogs.ActivityId">
    ActivityId
    type: keyword
  </definition>
  <definition term="azure.platformlogs.identity_name">
    Identity name
    type: keyword
  </definition>
  <definition term="azure.platformlogs.properties">
    Event inner properties
    type: flattened
  </definition>
</definitions>


## signinlogs

Fields for Azure sign-in logs.
<definitions>
  <definition term="azure.signinlogs.operation_name">
    The operation name
    type: keyword
  </definition>
  <definition term="azure.signinlogs.operation_version">
    The operation version
    type: keyword
  </definition>
  <definition term="azure.signinlogs.tenant_id">
    Tenant ID
    type: keyword
  </definition>
  <definition term="azure.signinlogs.result_signature">
    Result signature
    type: keyword
  </definition>
  <definition term="azure.signinlogs.result_description">
    Result description
    type: keyword
  </definition>
  <definition term="azure.signinlogs.result_type">
    Result type
    type: keyword
  </definition>
  <definition term="azure.signinlogs.identity">
    Identity
    type: keyword
  </definition>
  <definition term="azure.signinlogs.category">
    Category
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.id">
    Unique ID representing the sign-in activity.
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.created_at">
    Date and time (UTC) the sign-in was initiated.
    type: date
  </definition>
  <definition term="azure.signinlogs.properties.user_display_name">
    User display name
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.correlation_id">
    Correlation ID
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.user_principal_name">
    User principal name
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.user_id">
    User ID
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.app_id">
    App ID
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.app_display_name">
    App display name
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.autonomous_system_number">
    Autonomous system number.
    type: long
  </definition>
  <definition term="azure.signinlogs.properties.client_app_used">
    Client app used
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.conditional_access_status">
    Conditional access status
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.original_request_id">
    Original request ID
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.is_interactive">
    Is interactive
    type: boolean
  </definition>
  <definition term="azure.signinlogs.properties.token_issuer_name">
    Token issuer name
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.token_issuer_type">
    Token issuer type
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.processing_time_ms">
    Processing time in milliseconds
    type: float
  </definition>
  <definition term="azure.signinlogs.properties.risk_detail">
    Risk detail
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.risk_level_aggregated">
    Risk level aggregated
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.risk_level_during_signin">
    Risk level during signIn
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.risk_state">
    Risk state
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.resource_display_name">
    Resource display name
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.status.error_code">
    Error code
    type: long
  </definition>
  <definition term="azure.signinlogs.properties.device_detail.device_id">
    Device ID
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.device_detail.operating_system">
    Operating system
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.device_detail.browser">
    Browser
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.device_detail.display_name">
    Display name
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.device_detail.trust_type">
    Trust type
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.device_detail.is_compliant">
    If the device is compliant
    type: boolean
  </definition>
  <definition term="azure.signinlogs.properties.device_detail.is_managed">
    If the device is managed
    type: boolean
  </definition>
  <definition term="azure.signinlogs.properties.applied_conditional_access_policies">
    A list of conditional access policies that are triggered by the corresponding sign-in activity.
    type: array
  </definition>
  <definition term="azure.signinlogs.properties.authentication_details">
    The result of the authentication attempt and additional details on the authentication method.
    type: array
  </definition>
  <definition term="azure.signinlogs.properties.authentication_processing_details">
    Additional authentication processing details, such as the agent name in case of PTA/PHS or Server/farm name in case of federated authentication.
    type: flattened
  </definition>
  <definition term="azure.signinlogs.properties.authentication_protocol">
    Authentication protocol type.
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.incoming_token_type">
    Incoming token type.
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.unique_token_identifier">
    Unique token identifier for the request.
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.authentication_requirement">
    This holds the highest level of authentication needed through all the sign-in steps, for sign-in to succeed.
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.authentication_requirement_policies">
    Set of CA policies that apply to this sign-in, each as CA: policy name, and/or MFA: Per-user
    type: flattened
  </definition>
  <definition term="azure.signinlogs.properties.flagged_for_review">
    type: boolean
  </definition>
  <definition term="azure.signinlogs.properties.home_tenant_id">
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.network_location_details">
    The network location details including the type of network used and its names.
    type: array
  </definition>
  <definition term="azure.signinlogs.properties.resource_id">
    The identifier of the resource that the user signed in to.
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.resource_tenant_id">
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.risk_event_types">
    The list of risk event types associated with the sign-in. Possible values: unlikelyTravel, anonymizedIPAddress, maliciousIPAddress, unfamiliarFeatures, malwareInfectedIPAddress, suspiciousIPAddress, leakedCredentials, investigationsThreatIntelligence, generic, or unknownFutureValue.
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.risk_event_types_v2">
    The list of risk event types associated with the sign-in. Possible values: unlikelyTravel, anonymizedIPAddress, maliciousIPAddress, unfamiliarFeatures, malwareInfectedIPAddress, suspiciousIPAddress, leakedCredentials, investigationsThreatIntelligence, generic, or unknownFutureValue.
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.service_principal_name">
    The application name used for sign-in. This field is populated when you are signing in using an application.
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.user_type">
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.service_principal_id">
    The application identifier used for sign-in. This field is populated when you are signing in using an application.
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.cross_tenant_access_type">
    type: keyword
  </definition>
  <definition term="azure.signinlogs.properties.is_tenant_restricted">
    type: boolean
  </definition>
  <definition term="azure.signinlogs.properties.sso_extension_version">
    type: keyword
  </definition>
</definitions>