﻿---
title: Auditd fields
description: Module for parsing auditd logs. Fields from the auditd logs. Fields from the Linux audit log. Not all fields are documented here because they are dynamic...
url: https://www.elastic.co/docs/reference/beats/filebeat/exported-fields-auditd
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Auditd fields
Module for parsing auditd logs.
<definitions>
  <definition term="user.terminal">
    Terminal or tty device on which the user is performing the observed activity.
    type: keyword
  </definition>
  <definition term="user.audit.id">
    One or multiple unique identifiers of the user.
    type: keyword
  </definition>
  <definition term="user.audit.name">
    Short name or login of the user.
    type: keyword
    example: albert
  </definition>
  <definition term="user.audit.group.id">
    Unique identifier for the group on the system/platform.
    type: keyword
  </definition>
  <definition term="user.audit.group.name">
    Name of the group.
    type: keyword
  </definition>
  <definition term="user.filesystem.id">
    One or multiple unique identifiers of the user.
    type: keyword
  </definition>
  <definition term="user.filesystem.name">
    Short name or login of the user.
    type: keyword
    example: albert
  </definition>
  <definition term="user.filesystem.group.id">
    Unique identifier for the group on the system/platform.
    type: keyword
  </definition>
  <definition term="user.filesystem.group.name">
    Name of the group.
    type: keyword
  </definition>
  <definition term="user.owner.id">
    One or multiple unique identifiers of the user.
    type: keyword
  </definition>
  <definition term="user.owner.name">
    Short name or login of the user.
    type: keyword
    example: albert
  </definition>
  <definition term="user.owner.group.id">
    Unique identifier for the group on the system/platform.
    type: keyword
  </definition>
  <definition term="user.owner.group.name">
    Name of the group.
    type: keyword
  </definition>
  <definition term="user.saved.id">
    One or multiple unique identifiers of the user.
    type: keyword
  </definition>
  <definition term="user.saved.name">
    Short name or login of the user.
    type: keyword
    example: albert
  </definition>
  <definition term="user.saved.group.id">
    Unique identifier for the group on the system/platform.
    type: keyword
  </definition>
  <definition term="user.saved.group.name">
    Name of the group.
    type: keyword
  </definition>
</definitions>


## auditd

Fields from the auditd logs.

## log

Fields from the Linux audit log. Not all fields are documented here because they are dynamic and vary by audit event type.
<definitions>
  <definition term="auditd.log.old_auid">
    For login events this is the old audit ID used for the user prior to this login.
  </definition>
  <definition term="auditd.log.new_auid">
    For login events this is the new audit ID. The audit ID can be used to trace future events to the user even if their identity changes (like becoming root).
  </definition>
  <definition term="auditd.log.old_ses">
    For login events this is the old session ID used for the user prior to this login.
  </definition>
  <definition term="auditd.log.new_ses">
    For login events this is the new session ID. It can be used to tie a user to future events by session ID.
  </definition>
  <definition term="auditd.log.sequence">
    The audit event sequence number.
    type: long
  </definition>
  <definition term="auditd.log.items">
    The number of items in an event.
  </definition>
  <definition term="auditd.log.item">
    The item field indicates which item out of the total number of items. This number is zero-based; a value of 0 means it is the first item.
  </definition>
  <definition term="auditd.log.tty">
    type: keyword
  </definition>
  <definition term="auditd.log.a0">
    The first argument to the system call.
  </definition>
  <definition term="auditd.log.addr">
    type: ip
  </definition>
  <definition term="auditd.log.rport">
    type: long
  </definition>
  <definition term="auditd.log.laddr">
    type: ip
  </definition>
  <definition term="auditd.log.lport">
    type: long
  </definition>
  <definition term="auditd.log.acct">
    type: alias
    alias to: user.name
  </definition>
  <definition term="auditd.log.pid">
    type: alias
    alias to: process.pid
  </definition>
  <definition term="auditd.log.ppid">
    type: alias
    alias to: process.parent.pid
  </definition>
  <definition term="auditd.log.res">
    type: alias
    alias to: event.outcome
  </definition>
  <definition term="auditd.log.record_type">
    type: alias
    alias to: event.action
  </definition>
  <definition term="auditd.log.geoip.continent_name">
    type: alias
    alias to: source.geo.continent_name
  </definition>
  <definition term="auditd.log.geoip.country_iso_code">
    type: alias
    alias to: source.geo.country_iso_code
  </definition>
  <definition term="auditd.log.geoip.location">
    type: alias
    alias to: source.geo.location
  </definition>
  <definition term="auditd.log.geoip.region_name">
    type: alias
    alias to: source.geo.region_name
  </definition>
  <definition term="auditd.log.geoip.city_name">
    type: alias
    alias to: source.geo.city_name
  </definition>
  <definition term="auditd.log.geoip.region_iso_code">
    type: alias
    alias to: source.geo.region_iso_code
  </definition>
  <definition term="auditd.log.arch">
    type: alias
    alias to: host.architecture
  </definition>
  <definition term="auditd.log.gid">
    type: alias
    alias to: user.group.id
  </definition>
  <definition term="auditd.log.uid">
    type: alias
    alias to: user.id
  </definition>
  <definition term="auditd.log.agid">
    type: alias
    alias to: user.audit.group.id
  </definition>
  <definition term="auditd.log.auid">
    type: alias
    alias to: user.audit.id
  </definition>
  <definition term="auditd.log.fsgid">
    type: alias
    alias to: user.filesystem.group.id
  </definition>
  <definition term="auditd.log.fsuid">
    type: alias
    alias to: user.filesystem.id
  </definition>
  <definition term="auditd.log.egid">
    type: alias
    alias to: user.effective.group.id
  </definition>
  <definition term="auditd.log.euid">
    type: alias
    alias to: user.effective.id
  </definition>
  <definition term="auditd.log.sgid">
    type: alias
    alias to: user.saved.group.id
  </definition>
  <definition term="auditd.log.suid">
    type: alias
    alias to: user.saved.id
  </definition>
  <definition term="auditd.log.ogid">
    type: alias
    alias to: user.owner.group.id
  </definition>
  <definition term="auditd.log.ouid">
    type: alias
    alias to: user.owner.id
  </definition>
  <definition term="auditd.log.comm">
    type: alias
    alias to: process.name
  </definition>
  <definition term="auditd.log.exe">
    type: alias
    alias to: process.executable
  </definition>
  <definition term="auditd.log.terminal">
    type: alias
    alias to: user.terminal
  </definition>
  <definition term="auditd.log.msg">
    type: alias
    alias to: message
  </definition>
  <definition term="auditd.log.src">
    type: alias
    alias to: source.address
  </definition>
  <definition term="auditd.log.dst">
    type: alias
    alias to: destination.address
  </definition>
</definitions>