﻿---
title: Decompress gzip fields
description: The decompress_gzip_field processor specifies a field to gzip decompress. The field key contains a from: old-key and a to: new-key pair. from is the origin...
url: https://www.elastic.co/docs/reference/beats/filebeat/decompress-gzip-field
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Decompress gzip fields
The `decompress_gzip_field` processor specifies a field to gzip decompress. The `field` key contains a `from: old-key` and a `to: new-key` pair. `from` is the origin and `to` the target name of the field.
To overwrite fields either first rename the target field or use the `drop_fields` processor to drop the field and then decompress the field.
```yaml
processors:
  - decompress_gzip_field:
      field:
        from: "field1"
        to: "field2"
      ignore_missing: false
      fail_on_error: true
```

In the example above:
- field1 is decoded in field2

The `decompress_gzip_field` processor has the following configuration settings:
<definitions>
  <definition term="ignore_missing">
    (Optional) If set to true, no error is logged in case a key which should be decompressed is missing. Default is `false`.
  </definition>
  <definition term="fail_on_error">
    (Optional) If set to true, in case of an error the decompression of fields is stopped and the original event is returned. If set to false, decompression continues also if an error happened during decoding. Default is `true`.
  </definition>
</definitions>

See [Conditions](/docs/reference/beats/filebeat/defining-processors#conditions) for a list of supported conditions.