﻿---
title: Configure the Console output
description: The Console output writes events in JSON format to stdout. To use this output, edit the Filebeat configuration file to disable the Elasticsearch output...
url: https://www.elastic.co/docs/reference/beats/filebeat/console-output
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Configure the Console output
The Console output writes events in JSON format to stdout.
<warning>
  The Console output should be used only for debugging issues as it can produce a large amount of logging data.
</warning>

To use this output, edit the Filebeat configuration file to disable the Elasticsearch output by commenting it out, and enable the console output by adding `output.console`.
Example configuration:
```yaml
output.console:
  pretty: true
```


## Configuration options

You can specify the following `output.console` options in the `filebeat.yml` config file:

### `enabled`

The enabled config is a boolean setting to enable or disable the output. If set to false, the output is disabled.
The default value is `true`.

### `pretty`

If `pretty` is set to true, events written to stdout will be nicely formatted. The default is false.

### `codec`

Output codec configuration. If the `codec` section is missing, events will be json encoded using the `pretty` option.
See [Change the output codec](https://www.elastic.co/docs/reference/beats/filebeat/configuration-output-codec) for more information.

### `bulk_max_size`

The maximum number of events to buffer internally during publishing. The default is 2048.
Specifying a larger batch size may add some latency and buffering during publishing. However, for Console output, this setting does not affect how events are published.
Setting `bulk_max_size` to values less than or equal to 0 disables the splitting of batches. When splitting is disabled, the queue decides on the number of events to be contained in a batch.

### `queue`

Configuration options for internal queue.
See [Internal queue](https://www.elastic.co/docs/reference/beats/filebeat/configuring-internal-queue) for more information.
Note:`queue` options can be set under `filebeat.yml` or the `output` section but not both.