﻿---
title: Secure communication with Logstash
description: You can use SSL mutual authentication to secure connections between Filebeat and Logstash. This ensures that Filebeat sends encrypted data to trusted...
url: https://www.elastic.co/docs/reference/beats/filebeat/configuring-ssl-logstash
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Secure communication with Logstash
You can use SSL mutual authentication to secure connections between Filebeat and Logstash. This ensures that Filebeat sends encrypted data to trusted Logstash servers only, and that the Logstash server receives data from trusted Filebeat clients only.
To use SSL mutual authentication:
1. Create a certificate authority (CA) and use it to sign the certificates that you plan to use for Filebeat and Logstash. Creating a correct SSL/TLS infrastructure is outside the scope of this document. There are many online resources available that describe how to create certificates.
   <tip>
   If you are using security features, you can use the [elasticsearch-certutil tool](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/certutil) to generate certificates.
   </tip>
2. Configure Filebeat to use SSL. In the `filebeat.yml` config file, specify these settings under `ssl`:
   - `certificate_authorities`. Configures Filebeat to trust any certificates signed by the specified CA. If `certificate_authorities` is empty or not set, the trusted certificate authorities of the host system are used.
- `certificate` and `key`. Specifies the certificate and key that Filebeat uses to authenticate with Logstash.
  For example:
  ```yaml
  output.logstash:
    hosts: ["<HOST_URL>:<PORT>"]
    ssl.certificate_authorities: ["/etc/ca.crt"]
    ssl.certificate: "/etc/client.crt"
    ssl.key: "/etc/client.key"
  ```
  For more information about these configuration options, see [SSL](https://www.elastic.co/docs/reference/beats/filebeat/configuration-ssl).
3. Configure Logstash to use SSL. In the Logstash config file, specify these settings for the [Beats input plugin for Logstash](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-beats):
   - `ssl`. When set to true, enables Logstash to use SSL/TLS.
- `ssl_certificate_authorities`. Configures Logstash to trust any certificates signed by the specified CA.
- `ssl_certificate` and `ssl_key`. Specifies the certificate and key that Logstash uses to authenticate with the client.
- `ssl_client_authentication`. Specifies whether the Logstash server verifies the client certificate against the CA. You need to specify either `required` or `optional` to make the server ask for the certificate and validate it. If you specify `required`, and Filebeat doesn’t provide a certificate, the Logstash connection will be closed. If you choose not to use [certutil](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/certutil), the certificates that you obtain must allow for both `clientAuth` and `serverAuth` if the extended key usage extension is present.
  For example:
  ```json
  input {
    beats {
      port => 5044
      ssl_enabled => true
      ssl_certificate_authorities => ["/etc/ca.crt"]
      ssl_certificate => "/etc/server.crt"
      ssl_key => "/etc/server.key"
      ssl_client_authentication => "required"
    }
  }
  ```
  For more information about these options, see the [documentation for the Beats input plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-beats).


## Validate the Logstash server’s certificate

Before running Filebeat, you should validate the Logstash server’s certificate. You can use `curl` to validate the certificate even though the protocol used to communicate with Logstash is not based on HTTP. For example:
```shell
curl -v --cacert ca.crt <HOST_URL>:<PORT>
```

If the test is successful, you’ll receive an empty response error. Here's an example response assuming the `HOST_URL` was `logs.example.com` and `PORT` was `5044`:
```shell
* Rebuilt URL to: https://logs.example.com:5044/
*   Trying 192.168.99.100...
* Connected to logs.example.com (192.168.99.100) port 5044 (#0)
* SSL connection using TLSv1.3 / TLS_AES_256_GCM_SHA384
* Server certificate: logs.example.com
* Server certificate: example.com
> GET / HTTP/1.1
> Host: logs.example.com:5044
> User-Agent: curl/7.43.0
> Accept: */*
>
* Empty reply from server
* Connection #0 to host logs.example.com left intact
curl: (52) Empty reply from server
```

This example uses the IP address rather than the hostname to validate the certificate:
```shell
curl -v --cacert ca.crt https://192.168.99.100:5044
```

Validation for this test fails because the certificate is not valid for the specified IP address. It’s only valid for the `logs.example.com`, the hostname that appears in the Subject field of the certificate.
```shell
* Rebuilt URL to: https://192.168.99.100:5044/
*   Trying 192.168.99.100...
* Connected to 192.168.99.100 (192.168.99.100) port 5044 (#0)
* WARNING: using IP address, SNI is being disabled by the OS.
* SSL: certificate verification failed (result: 5)
* Closing connection 0
curl: (51) SSL: certificate verification failed (result: 5)
```

See the [troubleshooting docs](https://www.elastic.co/docs/reference/beats/filebeat/ssl-client-fails) for info about resolving this issue.

## Test the Filebeat to Logstash connection

If you have Filebeat running as a service, first stop the service. Then test your setup by running Filebeat in the foreground so you can quickly see any errors that occur:
```sh
filebeat -c filebeat.yml -e -v
```

Any errors will be printed to the console. See the [troubleshooting docs](https://www.elastic.co/docs/reference/beats/filebeat/ssl-client-fails) for info about resolving common errors.