﻿---
title: Configure Filebeat
description: To configure Filebeat, edit the configuration file. The default configuration file is called  filebeat.yml. The location of the file varies by platform...
url: https://www.elastic.co/docs/reference/beats/filebeat/configuring-howto-filebeat
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Configure Filebeat
<tip>
  To get started quickly, read [Quick start: installation and configuration](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration).
</tip>

To configure Filebeat, edit the configuration file. The default configuration file is called  `filebeat.yml`. The location of the file varies by platform. To locate the file, see [Directory layout](https://www.elastic.co/docs/reference/beats/filebeat/directory-layout).
There’s also a full example configuration file called `filebeat.reference.yml` that shows all non-deprecated options.
<tip>
  See the [Config File Format](https://www.elastic.co/docs/reference/beats/libbeat/config-file-format) for more about the structure of the config file.
</tip>

The following topics describe how to configure Filebeat:
- [Inputs](https://www.elastic.co/docs/reference/beats/filebeat/configuration-filebeat-options)
- [Modules](https://www.elastic.co/docs/reference/beats/filebeat/configuration-filebeat-modules)
- [General settings](https://www.elastic.co/docs/reference/beats/filebeat/configuration-general-options)
- [Project paths](https://www.elastic.co/docs/reference/beats/filebeat/configuration-path)
- [Config file loading](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-configuration-reloading)
- [Output](https://www.elastic.co/docs/reference/beats/filebeat/configuring-output)
- [SSL](https://www.elastic.co/docs/reference/beats/filebeat/configuration-ssl)
- [Index lifecycle management (ILM)](https://www.elastic.co/docs/reference/beats/filebeat/ilm)
- [Elasticsearch index template](https://www.elastic.co/docs/reference/beats/filebeat/configuration-template)
- [Kibana endpoint](https://www.elastic.co/docs/reference/beats/filebeat/setup-kibana-endpoint)
- [Kibana dashboards](https://www.elastic.co/docs/reference/beats/filebeat/configuration-dashboards)
- [Processors](https://www.elastic.co/docs/reference/beats/filebeat/filtering-enhancing-data)
- [*Autodiscover*](https://www.elastic.co/docs/reference/beats/filebeat/configuration-autodiscover)
- [Internal queue](https://www.elastic.co/docs/reference/beats/filebeat/configuring-internal-queue)
- [Logging](https://www.elastic.co/docs/reference/beats/filebeat/configuration-logging)
- [HTTP endpoint](https://www.elastic.co/docs/reference/beats/filebeat/http-endpoint)
- [Regular expression support](https://www.elastic.co/docs/reference/beats/filebeat/regexp-support)
- [Instrumentation](https://www.elastic.co/docs/reference/beats/filebeat/configuration-instrumentation)
- [Feature flags](https://www.elastic.co/docs/reference/beats/filebeat/configuration-feature-flags)
- [*filebeat.reference.yml*](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-reference-yml)