﻿---
title: Configure inputs
description: To configure Filebeat manually (instead of using modules), you specify a list of inputs in the filebeat.inputs section of the filebeat.yml. Inputs specify...
url: https://www.elastic.co/docs/reference/beats/filebeat/configuration-filebeat-options
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Configure inputs
<tip>
  [Filebeat modules](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-modules-overview) provide the fastest getting started experience for common log formats. See [Quick start: installation and configuration](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration) to learn how to get started.
</tip>

To configure Filebeat manually (instead of using [modules](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-modules-overview)), you specify a list of inputs in the `filebeat.inputs` section of the `filebeat.yml`. Inputs specify how Filebeat locates and processes input data.
The list is a [YAML](http://yaml.org/) array, so each input begins with a dash (`-`). You can specify multiple inputs, and you can specify the same input type more than once. For example:
```yaml
filebeat.inputs:
- type: filestream
  id: my-filestream-id 
  paths:
    - /var/log/system.log
    - /var/log/wifi.log
- type: filestream
  id: apache-filestream-id
  paths:
    - "/var/log/apache2/*"
  fields:
    apache: true
  fields_under_root: true
```

For the most basic configuration, define a single input with a single path. For example:
```yaml
filebeat.inputs:
- type: filestream
  id: my-filestream-id
  paths:
    - /var/log/*.log
```

The input in this example harvests all files in the path `/var/log/*.log`, which means that Filebeat will harvest all files in the directory `/var/log/` that end with `.log`. All patterns supported by [Go Glob](https://golang.org/pkg/path/filepath/#Glob) are also supported here.
To fetch all files from a predefined level of subdirectories, use this pattern: `/var/log/*/*.log`. This fetches all `.log` files from the subfolders of `/var/log`. It does not fetch log files from the `/var/log` folder itself. Currently it is not possible to recursively fetch all files in all subdirectories of a directory.

## Input types

You can configure Filebeat to use the following inputs:
- [AWS CloudWatch](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-aws-cloudwatch)
- [AWS S3](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-aws-s3)
- [Azure Event Hub](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-azure-eventhub)
- [Azure Blob Storage](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-azure-blob-storage)
- [Benchmark](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-benchmark)
- [CEL](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-cel)
- [Cloud Foundry](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-cloudfoundry)
- [CometD](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-cometd)
- [Container](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-container)
- [Entity Analytics](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-entity-analytics)
- [ETW](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-etw)
- [filestream](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-filestream)
- [GCP Pub/Sub](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-gcp-pubsub)
- [Google Cloud Storage](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-gcs)
- [HTTP Endpoint](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-http_endpoint)
- [HTTP JSON](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-httpjson)
- [journald](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-journald)
- [Kafka](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-kafka)
- [Log](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-log) (deprecated in 7.16.0, use [filestream](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-filestream))
- [MQTT](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-mqtt)
- [NetFlow](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-netflow)
- [Office 365 Management Activity API](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-o365audit)
- [Redis](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-redis)
- [Salesforce](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-salesforce)
- [Stdin](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-stdin)
- [Streaming](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-streaming)
- [Syslog](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-syslog)
- [TCP](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-tcp)
- [UDP](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-udp)
- [Unified Logs](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-unifiedlogs)
- [Unix](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-unix)
- [winlog](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-winlog)